#version 330 core

// Input
in vec2 ex_TexCoord;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D colorSampler;

void main()
{
	// assume linear input
	vec3 color = pow(texture(colorSampler, ex_TexCoord).rgb, vec3(2.2));

	// Rec. 709
	float luminance = dot(vec3(0.2126, 0.7152, 0.0722), color);

	if (luminance > 0.0)
		out_FragColor = vec4(color, 1.);
	else
		out_FragColor = vec4(0.);
}
