#version 330 core

// Input
in vec3 ex_PositionInView;
in vec3 ex_NormalInView;

// Output
out vec4 out_FragColor;
out float out_FragDepth;

// Uniforms
uniform vec3 lightDirInView;

// DoF parameters
uniform float aperture;
uniform float focalLength;
uniform float planeInFocus;

// Camera parameters
uniform float nearPlane;
uniform float farPlane;

void main()
{
	vec3 n = normalize(ex_NormalInView);
	vec3 l = lightDirInView;
	vec3 v = normalize(-ex_PositionInView);

	float Kd = dot(n, l);
	float Ks = 0.;

	if (Kd > 0.)
	{
		vec3 h = normalize(l + v);
		Ks = pow(dot(n, h), 20.);
	}

	vec3 diffuseColor = .2 * Kd * vec3(0.1);
	vec3 specularColor = .8 * Ks * vec3(1.);

	// compute the circle of confusion
	float sceneDepth = -ex_PositionInView.z;

	//float CoC = abs(aperture * focalLength * (planeInFocus - sceneDepth) / (sceneDepth * (planeInFocus - focalLength)));
	// GPU Gems 3
	//float CoC = aperture * abs(focalLength / (planeInFocus - focalLength)) * abs(1.0 - (planeInFocus / sceneDepth));

	// wikipedia
	//float CoC = aperture * (abs(sceneDepth - planeInFocus) / sceneDepth) * (focalLength / (planeInFocus - focalLength));

	// clamp the diameter and convert it to a blur coefficient.
	//CoC = min(CoC, 8.0) / 8.0;//clamp(CoC, 0.0, 16.0) / 16.0;
	//CoC = min(CoC * 1000., 16.0) / 16.0;
	float CoC = (sceneDepth - planeInFocus) / (planeInFocus - focalLength);

	// scale and bias
	CoC = clamp(0.5 + 0.5 * CoC, 0., 1.);

	out_FragColor = vec4(diffuseColor + specularColor, CoC);
	out_FragDepth = sceneDepth / (farPlane - nearPlane);
}
