#version 330 core

//#include "cube_inc.glsl"

// Input
layout (location = 0) in vec4 in_Position;
layout (location = 1) in vec4 in_Normal;
layout (location = 4) in mat4 in_WorldMatrix;

// Output
out vec3 ex_PositionInView;
out vec3 ex_NormalInView;

// Uniforms
uniform mat4 worldViewMatrix;
uniform mat4 projMatrix;

void main()
{
	vec4 positionInView = worldViewMatrix * in_WorldMatrix * in_Position;
	vec4 normalInView = worldViewMatrix * in_WorldMatrix * in_Normal;

	gl_Position = projMatrix * positionInView;
	ex_PositionInView = positionInView.xyz;
	ex_NormalInView = normalInView.xyz;
}
