#version 330 core

#if USE_NORMAL_MAP
#define NEED_TANGENT_SPACE 1
#endif
#if USE_SHADOW_MAP || USE_COOKIE_MAP
#define NEED_LIGHT_SPACE 1
#endif

// Semantics
#define ATTR_POSITION	0
#define ATTR_NORMAL		1
#define ATTR_TANGENT	2
#define ATTR_COLOR		3
#define ATTR_TEXCOORD	4

// Inputs
layout (location = ATTR_POSITION) in vec4 in_Position;
layout (location = ATTR_NORMAL  ) in vec4 in_Normal;
layout (location = ATTR_TANGENT ) in vec4 in_Tangent;
layout (location = ATTR_TEXCOORD) in vec2 in_TexCoord;

// Outputs
out vec3 ex_PositionInView;
#if NEED_LIGHT_SPACE
out vec4 ex_PositionInLight;
#endif
out vec3 ex_NormalInView;
out vec2 ex_TexCoord;
#if NEED_TANGENT_SPACE
out vec3 ex_TangentInView;
out vec3 ex_BitangentInView;
//flat out mat3 ex_TangentMatrix;
#endif

// Uniforms
uniform mat4 worldMatrix;
#if NEED_LIGHT_SPACE
uniform mat4 lightMatrix;
#endif
uniform mat4 worldViewMatrix;
uniform mat4 projMatrix;
uniform mat4 worldViewProjMatrix;

void main()
{
#if NEED_LIGHT_SPACE
	vec4 positionInWorld = worldMatrix * in_Position;
	vec4 positionInLight = lightMatrix * positionInWorld;
#endif

	vec4 positionInView = worldViewMatrix * in_Position;
	vec4 normalInView = worldViewMatrix * in_Normal;

#if NEED_TANGENT_SPACE
	vec4 tangentInView = worldViewMatrix * in_Tangent;
	vec3 N = normalize(normalInView.xyz);
	vec3 T = normalize(tangentInView.xyz);
	vec3 B = cross(N, T);
	//ex_TangentMatrix = mat3(T.x, B.x, N.x, T.y, B.y, N.y, T.z, B.z, N.z);
	//ex_TangentMatrix = mat3(T, B, N);
	ex_TangentInView = T.xyz;
	ex_BitangentInView = B.xyz;
#endif

	gl_Position = worldViewProjMatrix * in_Position;
	ex_PositionInView = positionInView.xyz;
#if NEED_LIGHT_SPACE
	ex_PositionInLight = positionInLight;
#endif
	ex_NormalInView = normalInView.xyz;
	ex_TexCoord = in_TexCoord;
}
