#version 330 core

// Input
in vec2 ex_TexCoord;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D colorSampler;
uniform sampler2D depthSampler;
uniform sampler2D blurSampler;

uniform vec2 radiusLow;
uniform vec2 radiusHigh;

#if 1
// this version is not really correct, but it still looks good
// and is cheaper. (It basically just mix the center tap).
void main()
{
	// sample the depth at pixel's center
	float depth = texture(depthSampler, ex_TexCoord).r;

	// extract the blur factor
	float blurFactor = texture(colorSampler, ex_TexCoord).a;

	vec4 colorLow = texture(blurSampler, ex_TexCoord);
	vec4 colorHigh = texture(colorSampler, ex_TexCoord);

	// convert the bluriness factor
	float tapFactor = abs(-1. + 2. * colorHigh.a);

	// mix the samples
	vec4 tap = mix(colorHigh, colorLow, tapFactor);

	// ignore samples that contribute to leaking
	float tapDepth = texture(depthSampler, ex_TexCoord).r;
	float tapContrib = (tapDepth >= depth) ? 1.0 : abs(-1. + 2. * tap.a);

	// accumulate
	out_FragColor = vec4(tap.rgb, 1.);
}
#else
// Poisson
#define NUM_TAPS 16

const vec2 poisson[NUM_TAPS] = const vec2[NUM_TAPS]
(
	vec2(0.007937789, 0.73124397),
	vec2(-0.10177308, -0.6509396),
	vec2(-0.9906806, -0.63400936),
	vec2(-0.5583586, -0.3614012),
	vec2(0.7163085, 0.22836149),
	vec2(-0.65210974, 0.37117887),
	vec2(-0.12714535, 0.112056136),
	vec2(0.48898065, -0.66669613),
	vec2(-0.9744036, 0.9155904),
	vec2(0.9274436, -0.9896486),
	vec2(0.9782181, 0.90990245),
	vec2(0.96427417, -0.25506377),
	vec2(-0.5021933, -0.9712455),
	vec2(0.3091557, -0.17652994),
	vec2(0.4665941, 0.96454906),
	vec2(-0.461774, 0.9360856)
);

void main()
{
	// sample the depth at pixel's center
	float depth = texture(depthSampler, ex_TexCoord).r;

	// extract the blur factor
	float blurFactor = texture(colorSampler, ex_TexCoord).a;

	// convert it to a radius
	float diskRadius = abs(blurFactor * 10. - 5.);

	// extract the CoC size
	float cocHigh = diskRadius;

	// blurSampler is downsampled two times
	float cocLow = diskRadius * 0.25;

	// accumulated color
	vec4 color = vec4(0.);

	// accumulated weight
	float weight = 0.;

	for (int i = 0; i < 8; i++)
	{
		vec2 coordLow = ex_TexCoord + radiusLow * cocLow * poisson[i];
		vec2 coordHigh = ex_TexCoord + radiusHigh * cocHigh * poisson[i];

		//vec4 colorLow = texture(blurSampler, coordLow);
		//vec4 colorHigh = texture(colorSampler, coordHigh);

		//color.rgb += mix(colorHigh.rgb, colorLow.rgb, color.a);
		//weight += 1.0;

		//vec2 coordLow = ex_TexCoord + 0. * cocLow * poisson[i];
		//vec2 coordHigh = ex_TexCoord + 0. * cocHigh * poisson[i];

		vec4 colorLow = texture(blurSampler, coordLow);
		vec4 colorHigh = texture(colorSampler, coordHigh);

		// convert the bluriness factor
		float tapFactor = abs(-1. + 2. * colorHigh.a);

		// mix the samples
		vec4 tap = mix(colorHigh, colorLow, tapFactor);

		// ignore samples that contribute to leaking
		float tapDepth = texture(depthSampler, coordHigh).r;
		float tapContrib = (tapDepth >= depth) ? 1.0 : abs(-1. + 2. * tap.a);

		// accumulate
		color.rgb += tap.rgb * tapContrib;
		weight += tapContrib;

		//if ((tapDepth - depth) > 0.)
		//if (true)
		//{
		//	color += mix(color0, color1, color0.a);
		//	//color += color1;
		//	weight += 1.0;
		//}
	}

	//out_FragColor = vec4(color.a);
	//out_FragColor = vec4(weight / (NUM_TAPS + 1.0));
	//out_FragColor = vec4(color.rgb / (NUM_TAPS + 1.0), 1.0);
	out_FragColor = vec4(color.rgb / weight, 1.0);
	//out_FragColor = texture(blurSampler, ex_TexCoord);
}

/*
const vec2 poisson[] = const vec2[]
(
	vec2(0.007937789, 0.73124397),
	vec2(-0.10177308, -0.6509396),
	vec2(-0.9906806, -0.63400936),
	vec2(-0.5583586, -0.3614012),
	vec2(0.7163085, 0.22836149),
	vec2(-0.65210974, 0.37117887),
	vec2(-0.12714535, 0.112056136),
	vec2(0.48898065, -0.66669613),
	vec2(-0.9744036, 0.9155904),
	vec2(0.9274436, -0.9896486),
	vec2(0.9782181, 0.90990245),
	vec2(0.96427417, -0.25506377),
	vec2(-0.5021933, -0.9712455),
	vec2(0.3091557, -0.17652994),
	vec2(0.4665941, 0.96454906),
	vec2(-0.461774, 0.9360856)
);

void main()
{
	vec4 data = texture(colorSampler, ex_TexCoord);
	float depth = texture(depthSampler, ex_TexCoord).r;

	// extract the CoC
	//float CoC = data.a * 16.0;
	vec2 radius = vec2(data.a * 8.0) / vec2(1280., 720.);

	//
	vec4 color = vec4(data.rgb, 1.0);

	// sample
	for (int i = 0; i < 16; ++i)
	{
		float tapDepth = texture(depthSampler, ex_TexCoord + radius * poisson[i]).r;

		//if (depth <= tapDepth)
		if (tapDepth - depth >= -0.001)
		{
			color.rgb += texture(colorSampler, ex_TexCoord + radius * poisson[i]).rgb;
			color.a += 1.0;
		}
	}

	//out_FragColor = vec4(color.a / 17.);
	out_FragColor = vec4(color.rgb / color.a, 1.);
	//out_FragColor = texture(depthSampler, ex_TexCoord).rrrr;
}
*/
#endif