#version 330 core

// Input
layout (location = 0) in vec4 in_Position;
layout (location = 4) in vec3 in_TexCoord;

// Output
out block
{
	vec3 positionInWorld;
	vec3 texCoord;
}
Out;

// Uniforms
uniform mat4 worldMatrix;
//uniform mat4 viewMatrix;
//uniform mat4 projMatrix;
uniform mat4 worldViewProjMatrix;

void main()
{
	vec4 positionInWorld = worldMatrix * in_Position;

	gl_Position = worldViewProjMatrix * in_Position;
	Out.positionInWorld = positionInWorld.xyz;
	Out.texCoord = in_TexCoord;
}
