#version 330 core

in vec2 ex_TexCoord;

out vec4 out_FragColor;

uniform sampler2D colorTexture;
uniform float time;
uniform float noiseTime; // precomputed noise(time)

// chromatic aberration
uniform float chromaticStrength; // the displacement on x axis
uniform float chromaticVisibility; // 0..1 (texture space)
uniform vec2 chromaticVariation; // x is time variation, and y is screenspace Y variation

// noise
uniform sampler2D noiseTexture;
uniform float noiseCoef; // 0..1 

// Vignetting
uniform vec2 vignet; // 0..1

// Flash / fade
uniform vec4 flashColor; // w is the flash coef (used as the mix() param)

// overlay ?
uniform sampler2D overlayTex;
uniform float overlayCoef;

// Gamma
uniform float gammaCoef; // should be 2.2

void main()
{
	vec3 color;
	
	color = texture(colorTexture, ex_TexCoord).xyz;

	// 1. chromatic aberration
	float disp = chromaticStrength * 0.01;

	// we need variation along y axis and time
	disp *= texture(noiseTexture, vec2(noiseTime, ex_TexCoord.y) * chromaticVariation).r;
	disp = abs(disp);

	vec3 caColor =	vec3(
						texture(colorTexture, ex_TexCoord + vec2(disp * 3.0, 0.0)).r,
						texture(colorTexture, ex_TexCoord + vec2(disp * 2.0, 0.0)).g,
						texture(colorTexture, ex_TexCoord + vec2(disp * 1.8, 0.0)).b
						);
	
	color += caColor * vec3(chromaticVisibility);
	color = color / (1.0 + chromaticVisibility);

	// 2. noise
	// todo

	// 3. vignetting
	float dist = distance(ex_TexCoord, vec2(0.5,0.5));
	color *= smoothstep(vignet.x, vignet.y, dist);

	// 4. gamma correction
	color = pow(color, vec3(1.0 / gammaCoef));

	// 5. flash / fade
	color = color + (flashColor.xyz * flashColor.w); //mix(color, flashColor.xyz, flashColor.w);

	out_FragColor = vec4(color, 1.0);
}