#version 330 core

layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

// Input
in vec4 gm_Color[];
in float gm_Life[];

// Output
out vec3 ex_PositionInView;
out vec4 ex_Color;
out vec2 ex_TexCoord;
flat out float ex_Life;

// Uniforms
uniform mat4 projMatrix;
uniform float size;

void main()
{
	// transform the point in view view space
	vec4 posInView = gl_in[0].gl_Position;
	vec3 cornerPosInView;

	// emit a screen-aligned quad, with texture coordinates
	cornerPosInView = posInView.xyz + vec3(-size, -size, 0.);
	gl_Position = projMatrix * vec4(cornerPosInView, 1.);
	ex_PositionInView = cornerPosInView;
	ex_TexCoord = vec2(0.0, 0.0);
	ex_Color = gm_Color[0];
	ex_Life = gm_Life[0];
	EmitVertex();

	cornerPosInView = posInView.xyz + vec3(-size, +size, 0.);
	gl_Position = projMatrix * vec4(cornerPosInView, 1.);
	ex_PositionInView = cornerPosInView;
	ex_TexCoord = vec2(0.0, 1.0);
	ex_Color = gm_Color[0];
	ex_Life = gm_Life[0];
	EmitVertex();

	cornerPosInView = posInView.xyz + vec3(+size, -size, 0.);
	gl_Position = projMatrix * vec4(cornerPosInView, 1.);
	ex_PositionInView = cornerPosInView;
	ex_TexCoord = vec2(1.0, 0.0);
	ex_Color = gm_Color[0];
	ex_Life = gm_Life[0];
	EmitVertex();

	cornerPosInView = posInView.xyz + vec3(+size, +size, 0.);
	gl_Position = projMatrix * vec4(cornerPosInView, 1.);
	ex_PositionInView = cornerPosInView;
	ex_TexCoord = vec2(1.0, 1.0);
	ex_Color = gm_Color[0];
	ex_Life = gm_Life[0];
	EmitVertex();
}
