// mog
/*jslint devel: true, browser: true */
var Space = (function () {
    "use strict";
    var _duration = 0,
        _holder,
        _ctx,
        _images,
        _mayRender = false,
        _paraStars1,
        _paraStars2,
        _bunnyface = 'faceMeh';

    //bg: #292929
    function init(duration) {

        loadResources();

        _duration = duration;

        _holder = document.createElement('div');
        document.getElementById('root').appendChild(_holder);

        var canvas = document.createElement('canvas');
        _ctx = canvas.getContext('2d');
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(canvas);

        //--
    }

    function loadResources() {

        var _imgLoader,
            resourceURL = [
                {"vignette":'data/05_space_vignette.png'},
                {"bunny":'data/05_space_bunny.png'},
                {"blob":'data/dem_las_sein_blob.png'},
                {"penisteroid":'data/penisteroid.png'},
                {"banner":'data/05_space_banner.png'},
                {"stars1":'data/05_space_lame_stars2.png'},
                {"stars2":'data/05_space_lame_stars1.png'},
                {"faceMeh":'data/05_space_bunny_meh.png'},
                {"faceYay":'data/05_space_bunny_yay.png'},
                {"faceWah":'data/05_space_bunny_wah.png'},
                {"faceBeard":'data/05_space_bunny_suddenlyBeard.png'},
                {"obstTopf":"data/05_space_blummetopp.png"},
                {"obstFish":"data/05_space_fish.png"},
                {"obstPlanet1":"data/05_space_planet1.png"},
                {"obstPlanet2":"data/05_space_planet2.png"},
                {"obstPlanet3":"data/05_space_planet3.png"},
                {"obstSquid":"data/05_space_squid.png"}
            ];

        //--

        _imgLoader = ImgLoader();
        _imgLoader.load(resourceURL, resourcesLoaded);
    }

    function resourcesLoaded(images) {

        _images = images;

        _paraStars1 = -_images['stars1'].height / 2;
        _paraStars2 = -_images['stars2'].height / 2;

        _mayRender = true;
    }

    function render(msT, beat, frameDelta) {

        if (!_mayRender) {
            return;
        }

        _ctx.fillStyle = '#222222';
        _ctx.fillRect(0, 0, _ctx.canvas.width, _ctx.canvas.height);

        _paraStars1 += 0.5 * frameDelta;
        _paraStars2 += ( frameDelta);

        if (_paraStars1 >= 0) {
            _paraStars1 = -(_images['stars1'].height / 2);
        }

        if (_paraStars2 >= 0) {
            _paraStars2 = -(_images['stars2'].height / 2);
        }

        _ctx.drawImage(_images['stars1'], 0, _paraStars1);
        _ctx.drawImage(_images['stars2'], 0, _paraStars2);

        _obstacles.forEach(function(item) {

            _ctx.drawImage(item.img, item.x + (Math.sin(msT / (500 * item.speed)) * 5), item.y);

            item.y += frameDelta * item.speed;

            if(item.y <= _ctx.canvas.height) {
                item = null; //lazy delete :3
            }
        });


        var bunnyX = Math.round((_ctx.canvas.width - _images['bunny'].width) / 2 + Math.sin(Date.now() / 90) * 5);

        _ctx.drawImage(_images['bunny'], bunnyX, Math.round(_ctx.canvas.height - _images['bunny'].height - 50));

        if(msT <= 4000) {
            _ctx.drawImage(_images['banner'], Math.round((_ctx.canvas.width - _images['banner'].width) /
            2), Math.round((_ctx.canvas.height - _images['banner'].height) / 2) - 20);
        }


        _ctx.drawImage(_images['vignette'], 0, 0);

        _ctx.drawImage(_images[_bunnyface], _ctx.canvas.width - _images[_bunnyface].width - 40, _ctx.canvas.height -
            _images[_bunnyface].height - 30);
    }

    var _obstacles = [],
        _faceIndex = 0,
        _lasBlobShown = false,
        _penisteroid = false;

    function onBeat(beat) {

        var faces = ["faceMeh", "faceYay", "faceWah", "faceBeard"],
            obstacles = ["obstTopf","obstFish","obstPlanet1","obstPlanet2","obstPlanet3","obstSquid", "blob", "penisteroid"];

        if (beat % 2 === 0) {

            _bunnyface = faces[_faceIndex];

            _faceIndex++;
            if(_faceIndex >=  faces.length)
                _faceIndex = 0;
        }

        if (_mayRender) {
            if (beat % 2 === 0) {

                var speed = (Random.float() * 2) + .2;
                var tex = obstacles[getRand(0, obstacles.length - 2)];

                if((beat >= 220) && (_lasBlobShown  === false)) {
                    _lasBlobShown = true;
                    tex = obstacles[obstacles.length - 2];
                    speed = .3;
                } else if ((beat >= 251) && (_penisteroid  === false)) {
                    _penisteroid = true;
                    tex = obstacles[obstacles.length - 1];
                    speed = .3;
                }

                _obstacles.push({'img':_images[tex],
                    'x':getRand(0, _ctx.canvas.width - _images[tex].width / 2),
                    'y':-_images[tex].height,
                    'speed':speed})
                ;
            }
        }
    }

    //includes bottom, excludes top
    function getRand(bottom, top) {
        return Math.floor(Random.float() * (top - bottom)) + bottom;
    }

    function clear() {
        document.getElementById('root').removeChild(_holder);
    }

    function resize(w, h) {

    }

    return {
        init:init,
        render:render,
        onBeat:onBeat,
        clear:clear,
        resize:resize
    };
}());