from shortcrust.shader import ShaderProgram

from shortcrust.mesh import Mesh
from shortcrust.texture import Texture
from shortcrust.gl2 import *
from shortcrust.matrix import glmatrix, rotate_y, mul, translate, identity, rotate_x
import math
import pygame


class ToastShader(ShaderProgram):
	vertex_shader = """
		attribute vec4 vPosition;
		uniform mat4 viewMatrix;
		uniform mat4 motionMatrix;

		varying vec4 texPosition;

		void main()
		{
			gl_Position = vPosition * motionMatrix * viewMatrix;
			gl_Position.z /= 10.0;
			texPosition = vPosition;
		}
	"""

	fragment_shader = """
		/* precision mediump float; */

		uniform float time;
		uniform vec2 resolution;
		uniform sampler2D uSampler;

		varying vec4 texPosition;

		void main()
		{
			gl_FragColor = texture2D(uSampler, (texPosition.xy * 1.6) + vec2(0.5, 0.5));
		}
	"""

	def __init__(self):
		super(ToastShader, self).__init__()
		self.vertex_position_attr = glGetAttribLocation(self.program_object, 'vPosition')
		self.view_matrix_unif = glGetUniformLocation(self.program_object, 'viewMatrix')
		self.motion_matrix_unif = glGetUniformLocation(self.program_object, 'motionMatrix')
		self.time_unif = glGetUniformLocation(self.program_object, 'time')
		self.resolution_unif = glGetUniformLocation(self.program_object, 'resolution')
		self.sampler_unif = glGetUniformLocation(self.program_object, 'uSampler')


class ToastFaceMesh(Mesh):
	mode = GL_TRIANGLE_FAN

	def __init__(self, z=0.00):
		self.vertices = [
			(0.00, 0.28, z),
			(0.24, 0.30, z),
			(0.30, 0.26, z),
			(0.28, 0.24, z),
			(0.30, -0.30, z),
			(-0.30, -0.30, z),
			(-0.26, 0.24, z),
			(-0.30, 0.26, z),
			(-0.24, 0.30, z),
		]
		super(ToastFaceMesh, self).__init__()


class ToastLayer(object):
	def __init__(self, app):
		check_gl_error()
		self.app = app

		self.shader = ToastShader()
		self.front_mesh = ToastFaceMesh(0.03)
		self.back_mesh = ToastFaceMesh(-0.03)
		# self.view_matrix = perspective(70, 1.333, 0.0001, 10000)
		# print self.view_matrix
		self.view_matrix = [
			[1,0,0,0],
			[0,1.333,0,0],
			[0,0,1,0],
			[0,0,1,0]
		]

		self.view_matrix = [
			[1,0,0,0],
			[0,1.333,0,0],
			[0,0,1,0],
			[0,0,0,1]
		]

		self.toast_texture = Texture('data/toast.png')

	def draw(self, time):

		beat = time / self.app.beat_length
		if beat < 4:
			return

		self.shader.use()

		rota = beat * math.pi
		motion_matrix = mul(translate(0.0, 0.0, -1.0), rotate_y(rota))
		motion_matrix = mul(motion_matrix, rotate_x(0.2))
		#motion_matrix = [
		#	[1, 0, 0, 0],
		#	[0, 1, 0, 0],
		#	[0, 0, 1, 5],
		#	[0, 0, 0, 1]
		#]

		glUniformMatrix4fv(self.shader.view_matrix_unif, 16, GL_FALSE, glmatrix(self.view_matrix))
		glUniformMatrix4fv(self.shader.motion_matrix_unif, 16, GL_FALSE, glmatrix(motion_matrix))

		glUniform1f(self.shader.time_unif, time)
		glUniform2f(self.shader.resolution_unif, self.app.width, self.app.height)

		self.toast_texture.activate(GL_TEXTURE0)
		glUniform1i(self.shader.sampler_unif, 0)
		check_gl_error()

		self.front_mesh.draw(self.shader.vertex_position_attr)
		self.back_mesh.draw(self.shader.vertex_position_attr)
		check_gl_error()
