//basic.vert.c

varying vec3 normal, lightDir, eyeVec;
varying float ZValue, ZDepth;

//uniform float near;
//uniform float far;

const float near = 3.0;
const float far = 800.;

uniform vec2 resolution;

varying vec2 uv_treshold;
varying vec2 uv_clamp;

float getLinearDepth(float zz, float _near, float _far){
	float z = 2.*_far*_near/((_far-_near)*(zz-(_far+_near)/(_far-_near)));
	return -z;
}

void main()
{	
	normal = gl_NormalMatrix * gl_Normal;

	vec4 vVertex = gl_ModelViewMatrix * gl_Vertex;
	lightDir = gl_LightSource[0].position.xyz - vVertex.xyz;
	eyeVec = -vVertex.xyz;

	gl_Position = ftransform();
	
	//if (vVertex.z < near) //a jo budos kurva anyad bazd meg te rohadt zsido szar geci bazmdeg
		ZDepth = 1+getLinearDepth(gl_Position.z, near, far);
	//else 
		ZValue = vVertex.z /far;
	
	gl_FrontColor = gl_Color;
	
	gl_TexCoord[0]  = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	gl_TexCoord[1]  = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	gl_TexCoord[2]  = gl_TextureMatrix[2] * gl_MultiTexCoord2;
	gl_TexCoord[3]  = gl_TextureMatrix[3] * gl_MultiTexCoord3;
	gl_TexCoord[4]  = gl_TextureMatrix[4] * gl_MultiTexCoord4;
	gl_TexCoord[5]  = gl_TextureMatrix[5] * gl_MultiTexCoord5;
	gl_TexCoord[6]  = gl_TextureMatrix[6] * gl_MultiTexCoord6;
	
	uv_treshold = vec2(resolution.xy/2048.);
	uv_clamp = vec2(1.-1./resolution.xy);
}