#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform vec2 resolution;

uniform float blurRadius;
uniform float SSAORadius;

//uniform float textureSize;
const float textureSize = 2048.;

uniform sampler2D tex0;
uniform sampler2D illumMapSSAO;
uniform sampler2D illumMapPhong;

uniform float bias;
uniform float bloomLevel;
uniform float exposure;

#define BLOOM_PASSES 5

///////////
// predef
float selectMipLevel(float radius);
vec4 blurByLOD(float radius, sampler2D source, vec2 pos, float lod);
vec4 fastBlur(float radius, sampler2D source, vec2 pos);
vec4 preciseBlur(float radius, sampler2D source, vec2 pos);

vec3 HDRbloom (vec2 p, sampler2D source);
vec3 HDRbloom2(vec2 p, sampler2D source, float radius);

///
vec3 HDRbloom(vec2 p, sampler2D base, sampler2D illum){
	vec4 baseImage = textureLod(base, p.xy, 0);
	vec4 blurColor[BLOOM_PASSES], bloom = vec4(0);
    for (int i=0; i<BLOOM_PASSES; i++){
		blurColor[i].rgb = textureLod(base, p.xy, i).rgb * exp(textureLod(illum, p, i).rgb);
		blurColor[i].a = 1.;
		
		bloom += blurColor[i];
	}
	
	bloom /= float(BLOOM_PASSES);
    vec4 color = baseImage + bloomLevel * (bias+bloom);

    // Apply the exposure to this texel
    return (1.0 - exp2(-color * exposure)).rgb;
}

vec3 HDRbloom2(vec2 p, sampler2D base, sampler2D illum, float radius){
	vec4 baseImage = textureLod(base, p.xy, 0);
	vec4 blurColor[BLOOM_PASSES], bloom = vec4(0);
    for (int i=0; i<BLOOM_PASSES; i++){
		blurColor[i].rgb = preciseBlur(radius+exp2(i),base, p.xy) * exp(preciseBlur(radius+exp2(i),illum, p));
		blurColor[i].a = 1.;
		
		bloom += blurColor[i];
	}
	
	bloom /= float(BLOOM_PASSES);
    vec4 color = baseImage + bloomLevel * (bias+bloom);

    // Apply the exposure to this texel
    return (1.0 - exp2(-color * exposure)).rgb;
}

////////////////////////////
// MAIN
////////////////////////////

void main(){
	//vec3 ao = fastBlur(radius, illumMap, gl_TexCoord[0].xy).rgb;
	//gl_FragColor.rgb = texture2D(tex0, gl_TexCoord[0].xy).rgb * ao;
	
	vec3 bloom, ssao;
	
	if (blurRadius>0.){
		bloom = HDRbloom2(gl_TexCoord[0].xy, tex0, illumMapPhong, blurRadius);
	} else {
		bloom = HDRbloom(gl_TexCoord[0].xy, tex0, illumMapPhong);
	}
	
	ssao = HDRbloom2(gl_TexCoord[0].xy, illumMapSSAO, illumMapSSAO, SSAORadius + blurRadius);
	
	gl_FragColor.rgb = ssao;
	gl_FragColor.a = 1.;
}

////////////////////////////
// BLUR
////////////////////////////
float selectMipLevel(float radius){
	//float r = radius * resolution.y;
	float r = .5*radius * textureSize;
	return log2(r);
}

vec4 blurByLOD(float radius, sampler2D source, vec2 pos, float lod)
{
	vec2 newCoord;
	vec4 sum;
	
	vec2 samples00 = vec2(-0.326212, -0.405805);
	vec2 samples01 = vec2(-0.840144, -0.073580);
	vec2 samples02 = vec2(-0.695914,  0.457137);
	vec2 samples03 = vec2(-0.203345,  0.620716);
	vec2 samples04 = vec2( 0.962340, -0.194983);
	vec2 samples05 = vec2( 0.473434, -0.480026);
	vec2 samples06 = vec2( 0.519456,  0.767022);
	vec2 samples07 = vec2( 0.185461, -0.893124);
	vec2 samples08 = vec2( 0.507431,  0.064425);
	vec2 samples09 = vec2( 0.896420,  0.412458);
	vec2 samples10 = vec2(-0.321940, -0.932615);
	vec2 samples11 = vec2(-0.791559, -0.597705);
	
	sum = textureLod(source, pos, lod);

	newCoord = pos + radius * samples00; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples01; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples02; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples03; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples04; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples05; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples06; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples07; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples08; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples09; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples10; sum += textureLod(source, newCoord, lod);
	newCoord = pos + radius * samples11; sum += textureLod(source, newCoord, lod);

	sum /= 13.0;

	return sum;
}

vec4 fastBlur(float radius, sampler2D source, vec2 pos){
		int lod = int(floor(selectMipLevel(radius)));
		return blurByLOD(radius, source, pos, lod);
}

vec4 preciseBlur(float radius, sampler2D source, vec2 pos){
	float lodf = selectMipLevel(radius);
	float lod = int(floor(selectMipLevel(radius)));
	float interpol = fract(lodf);
	vec4 sample1 = blurByLOD(radius, source, pos, lod);
	vec4 sample2 = blurByLOD(radius, source, pos, lod+1);
	//vec4 sample1 = vec4(1,0,0,1);
	//vec4 sample2 = vec4(0,1,0,1);
	return mix(sample1, sample2, interpol);
}