#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif


#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform vec2 resolution;

uniform float SSAORadius;
uniform float blurRadius;

//uniform float textureSize;
const float textureSize = 2048.;

uniform sampler2D tex0;
uniform sampler2D illumMapPhong;
uniform sampler2D illumMapSSAO;

uniform float bias;
uniform float bloomLevel;
uniform float exposure;

#define USE_INVERTED_OCCLUSION
////////////////////////////////////////////////////////////////

void main(){
	vec3 ao; //occlusion value
	//ao = preciseBlur(SSAORadius + blurRadius, illumMapSSAO, gl_TexCoord[0].xy).rgb;
	ao = texture2D(illumMapSSAO, gl_TexCoord[0].xy).rgb;
	
	// when ssao turned off, the result image won't black in this case
#ifdef USE_INVERTED_OCCLUSION
	ao = vec3(1.) - ao;
#endif /*USE_INVERTED_OCCLUSION*/
	
	
	vec3 color, illum, illum2;
	{
		color = texture2D(tex0, gl_TexCoord[0].xy).rgb;
		illum = texture2D(illumMapPhong, gl_TexCoord[0].xy).rgb;
	}
	
	illum2 = -log(1.-illum);
	
	gl_FragColor.rgb = ao * color * illum2;
	//gl_FragColor.rgb = ao;
	
	//gl_FragColor.rgb = texture2D(illumMapPhong, gl_TexCoord[0].xy).rgb;
	//gl_FragColor.rgb = ao * clamp(illum2,0.,1.) * color;
	
	gl_FragColor.a = 1.;
}