// passthrough.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

// * Basic passthrough shader
// The following uniforms are comes from the shader API
uniform vec2 resolution;
uniform float time;
uniform sampler2D tex0;

#define USE_MULTI_OUTPUT
	
void main()
{	
	vec4 color = texture2D(tex0, gl_TexCoord[0].st);
	
#ifdef USE_MULTI_OUTPUT	
	gl_FragData[0] = color*gl_Color;
	gl_FragData[1] = vec4(vec3(0.0),1.0);
#else
	gl_FragColor = color*gl_Color;
#endif
}
