// ssao2.frag

// Screen Space Ambient Occlusion
//
// depth source -> opengl Z-map 
//
// Caiwan / IR 
// 2012

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

uniform sampler2D tex0;
uniform sampler2D normalTex;
uniform sampler2D depthTex;
uniform sampler2D noiseTex;

uniform vec2 resolution;

uniform float near;
uniform float far;
uniform float fov;

uniform float noiseSize;

uniform mat4 projectionMatrix;

uniform float aspectRatio;   
vec2 noiseScale;

uniform vec3 kernel[32];

const int kernelSize = 32;  
uniform float radius;
uniform float radius2;

//http://www.john-chapman.net/content.php?id=8

vec2 getTexcoord(vec2 uv){
	vec2 uv_ = uv * (resolution / vec2(2048.f));
	return uv_;
}

vec3 getNormalFromCoord(vec2 uv){
	return (2.*texture2D(normalTex, getTexcoord(uv)).xyz)-1.; // anyad geci
}

vec3 getNormalDirectly(){
	return 2.*texture2D(normalTex, gl_TexCoord[0].st).xyz-1.;
}

float getLinearDepth(float zz, float _near, float _far){
	float z = 2.*_far*_near/((_far-_near)*(zz-(_far+_near)/(_far-_near)));
	return -z / _near;
}

float unpackDepth(const in vec4 rgba_depth) {
	const vec4 bit_shift = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);
	float depth = dot(rgba_depth, bit_shift);
	return depth;
}

float getDepthFromPackedTexture(vec2 uv){
	return unpackDepth(texture2D(depthTex, getTexcoord(uv)));
}

float getDepthFromOpenGLZmap(vec2 uv){
	return getLinearDepth(float(texture2D(depthTex, getTexcoord(uv))), near, far);
}

// *************************** //
float getDepth(vec2 uv){
	return getDepthFromOpenGLZmap(uv);
}

vec3 getNormal(){
	return getNormalDirectly();
}

// *************************** //
vec3 getViewRay(vec2 tc) {
	float hfar = 2.0 * tan(fov/2.0) * far;
	float wfar = hfar * aspectRatio;    
	vec3 ray = vec3(wfar * (tc.x - 0.5), hfar * (tc.y - 0.5), -far);    
	return ray;
}   

// *************************** //
void main (){
	vec2 screenPos = gl_FragCoord.xy/resolution;
	
	noiseScale = resolution / noiseSize;
	
	float linearDepth = getDepth(screenPos);          
	vec3 origin = getViewRay(screenPos) * linearDepth;   
	
	vec3 normal = getNormal();   
	
	vec3 rvec = texture2D(noiseTex, screenPos.xy * noiseScale).xyz * 2.0 - 1.0;
	vec3 tangent = normalize(rvec - normal * dot(rvec, normal));
	vec3 bitangent = cross(normal, tangent);
	mat3 tbn = mat3(tangent, bitangent, normal);
	
	float occlusion = 0.0f;
	if (linearDepth < 0.999f) // a vegtelenben levo pontokra ne
	{
		int i=0;
		for(i=0; i<kernelSize; ++i) 
		{
			vec3 deltaRay = tbn * kernel[i];
			
			vec3 sample = origin + deltaRay * radius;
			vec4 offset = projectionMatrix * vec4(sample, 1.0);	
			offset.xy /= offset.w;
			offset.xy = offset.xy * 0.5 + 0.5; 

		    float sampleDepth = -sample.z / far;
			float depthBufferValue = getDepth(offset.xy);				              
			float range_check = abs(linearDepth - depthBufferValue);

			if (range_check < radius2 && depthBufferValue <= sampleDepth) {
				occlusion +=  1;
				//occlusion +=  range_check/radius; // ez nem tul jo, pedig optimalis lenne
			}
		}         
	}
	occlusion = 1.0 - occlusion / float(kernelSize);

	gl_FragData[0].rgb = vec3(occlusion);
	gl_FragData[0].a = 1;
	
	gl_FragData[1].rgb = vec3(1,0,0);
	gl_FragData[1].a = 1;
}