// 2011-2012 - rascy@dilemma.ws
// dilemma webgl demo system (based on threejs)
// version 0.2

var SKIP = 'skip';

$(document).ready(function() {

    $.extend(demo, {

        // demo params
        params : {

            height : window.innerHeight,
            width : window.innerWidth,

            devmode : false,
            sleep : 100,

            dev_defaults : {
                show_fps : true,
                show_gui : true,
                show_camposition : true,
                show_axis : true,
                trackball : true,
                show_time : true,
                sleep : 100,
                volume : 95,
                max_fps : 15,
                dof : false,
                shadows : false,
                shadow_cam : true,
                shadow_map_size_multiplier : 2, // *512
                renderer : {
                    antialias : false,
                    clearAlpha : 1,
                    //clearColor : 0x000000,
                    //preserveDrawingBuffer : false,
                    //maxLights : 4
                }
            },

            live_defaults : {
                show_fps : false,
                show_gui : false,
                show_camposition : false,
                show_axis : false,
                trackball : false,
                show_time : false,
                sleep : 1000, // don't touch
                volume : 95,
                max_fps : 50, // if you have a good video card increase this
                // value
                dof : true,
                shadows : true,
                shadow_cam : false,
                shadow_map_size_multiplier : 4, // *512
                renderer : {
                    antialias : true,
                    clearAlpha : 1,
                    //clearColor : 0x000000,
                    //preserveDrawingBuffer : false,
                    //maxLights : 4
                }
            },

            min_near : 1,
            max_far : 50000,
            axis_size : 10,
            timeline : false,
            usercolor : 0xfefefe,
            music : true,

            set : function(name, value) {
                demo.params[name] = value;
            },

            init : function() {

                var defaults;
                if (demo.params.devmode === true)
                    defaults = demo.params.dev_defaults
                else
                    defaults = demo.params.live_defaults;

                for (var key in defaults) {
                    demo.params[key] = defaults[key];
                }

            },
        },

        pi : 3.14159265,
        rad : function(degree) {
            return degree * (2 * demo.pi / 360);
        },

        round : function(num, dec) {

            if (!dec)
                dec = 2;
            var result = Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
            return result;

        },

        // current layers
        current : [],
        state : {
            cam : '-bytimeline',
            prevcam : '-bytimeline',
            scene : '-bytimeline',
            prevscene : '',
        },

        scene : {},
        texture : {},
        stats : {},
        controls : {},
        scene_loaded : 0,
        timeline_pos : 0,
        soundObj : false,

        music : {

            load : function(callback) {

                demo.osd.add('Music', '<span id="musicloaded"></span>');

                demo.soundObj = new buzz.sound(demo.musicfile.ogg, {
                    preload : true,
                    autoplay : false,
                    loop : false
                });

                demo.soundObj.setVolume(demo.params.volume);

                demo.soundObj.bind("ended", function(e) {
                    demo.stop();
                });

                demo.soundObj.bind("loadeddata", function(e) {
                    $("#musicloaded").html('ok');
                    callback();
                });

                demo.soundObj.load();

            }
        },

        // timer - i know requestAnimationFrame better, but i want to controll
        // the fps

        timer : function(callback) {
            setTimeout(callback, 1000 / demo.params.max_fps);
        },

        tio : {}, // for init timeouts
        time : 0, // standard time
        startTime : 0, // demo start time
        pauseTime : 0, // when pause
        seekTime : 0, // forward - backward
        pausedTime : 0, // elapsed time while start again
        systime : 0, // demosystem time if music not loaded
        position : 0, // position by music

        paused : false,
        stopped : false,

        // demo pause
        pause : function() {

            if (demo.soundObj)
                demo.soundObj.togglePlay();

            if (demo.paused == false) {
                demo.paused = true;
                demo.pauseTime = new Date().getTime();

                // copy main cam params to track cam
                var scn = demo.current[1][0];
                var cam_curr = demo.scene[scn]['cam_main'];
                var cam_track = demo.scene[scn]['cam_track'];

                cam_track.fov = cam_curr.fov;
                cam_track.scale.set(cam_curr.scale.x, cam_curr.scale.y, cam_curr.scale.z);
                cam_track.position.set(cam_curr.position.x, cam_curr.position.y, cam_curr.position.z);
                cam_track.rotation.set(cam_curr.rotation.x, cam_curr.rotation.y, cam_curr.rotation.z);

                console.log(demo);
                console.log(demo.renderer.info);
                if (demo.soundObj)
                    console.log(demo.soundObj);

            } else {

                demo.paused = false;
                demo.pausedTime = demo.pausedTime + (new Date().getTime() - demo.pauseTime);

            }
        },

        // demo start
        start : function() {
            demo.init.start();
        },

        // demo animate
        animate : function() {

            if (demo.stopped === true) {
                demo.pause();
                return false;
            }

            // if not paused increase demo time
            if (demo.paused === false) {

                demo.systime = (new Date().getTime() - demo.startTime - demo.pausedTime + demo.seekTime) - 125;

                if (demo.soundObj) {
                    demo.time = parseInt(demo.soundObj.sound.currentTime * 1000);
                } else {
                    demo.time = demo.systime;
                }

                $("#time").html(demo.systime);
                $("#musicpos").html(demo.time);

            }

            // demo animate
            demo.timer(demo.animate);

            // render scene
            demo.render();

        },

        // render current scene
        render : function() {

            if (demo.stats.update)
                demo.stats.update();

            for (var i = demo.timeline_pos; i < demo.timeline.length; i++) {

                var ttime = demo.timeline[i][0];

                if (ttime <= demo.time) {
                    demo.current = demo.timeline[i];
                    // if position seek is not available skip old positions
                    if (demo.params.show_gui === false)
                        demo.timeline_pos = i + 1;
                } else {
                    break;
                }
            }

            demo.renderer.clear();

            for (var layer in demo.current) {

                if (layer == 0)
                    continue;

                // override timeline scene if changed on gui
                if (demo.state.scene === '-bytimeline') {
                    var scn = demo.current[layer][0];
                } else {
                    var scn = demo.state.scene;
                }

                if (!demo.scene[scn])
                    continue;

                // calculate camera motions and scene animations
                if (demo.paused === false) {

                    if (demo.scene[scn].animate)
                        demo.scene[scn].animate();

                    cam = demo.motioncalc.run(scn);
                    demo.state.prevcam = cam;

                } else {
                    cam = demo.state.prevcam;
                }

                // override timeline cam if changed on gui
                if (demo.state.cam !== '-bytimeline') {
                    cam = demo.state.cam;
                }

                if (layer == 1 && demo.params.show_camposition) {
                    var scam = demo.scene[scn]['cam_' + cam];
                    var info = 'cam: ' + cam;
                    info += '<br />fov: ' + scam.fov;
                    info += '<br />posX: ' + parseInt(scam.position.x) + ' ' + 'posY: ' + parseInt(scam.position.y) + ' ' + 'posZ: ' + parseInt(scam.position.z);
                    info += '<br />rotX: ' + demo.round(scam.rotation.x) + ' ' + 'rotY: ' + demo.round(scam.rotation.y) + ' ' + 'rotZ: ' + demo.round(scam.rotation.z);
                    $("#camposition").html(info);
                }

                if (demo.params.trackball)
                    if (demo.controls[scn][cam])
                        demo.controls[scn][cam].update();

                if (layer === 2) {
                    demo.renderer.render(demo.scene[scn], demo.scene[scn]['cam_' + cam]);
                } else {

                    if (demo.params.dof) {

                        // Render scene into texture
                        demo.scene[scn].overrideMaterial = null;
                        demo.renderer.render(demo.scene[scn], demo.scene[scn]['cam_' + cam], demo.postprocessing.dof.rtTextureColor, true);

                        // Render depth into texture
                        demo.scene[scn].overrideMaterial = demo.postprocessing.dof.material_depth;
                        demo.renderer.render(demo.scene[scn], demo.scene[scn]['cam_' + cam], demo.postprocessing.dof.rtTextureDepth, true);

                        // Render bokeh composite
                        demo.renderer.render(demo.postprocessing.dof.scene, demo.postprocessing.dof.camera);

                    } else {

                        demo.renderer.render(demo.scene[scn], demo.scene[scn]['cam_' + cam]);
                    }
                }

            }

            demo.state.prevscene = scn;

        },

        // if window resize
        resize : function(event) {

            width = window.innerWidth;
            height = window.innerHeight;
            demo.renderer.setSize(width, height);

            for (var key in demo.scene) {

                for (var camkey in demo.cameras) {

                    demo.scene[key]['cam_' + camkey].aspect = width / height;
                    demo.scene[key]['cam_' + camkey].updateProjectionMatrix();

                }

                demo.controls[key]['track'].screen.width = width;
                demo.controls[key]['track'].screen.height = height;

            }

            if (demo.params.dof) {
                demo.postprocessing.dof.bokeh_uniforms["aspect"].value = width / height;
            }

        },

        osd : {

            init : function() {
                $('body').append('<div class="osd"></div>');

                $('.osd').css({
                    opacity : 0.3
                });

                $('.osd').on('click', function() {
                    demo.pause();
                });

                $(".osd").hover(function() {
                    $(this).stop().animate({
                        opacity : 0.8
                    });
                }, function() {
                    $(this).stop().animate({
                        opacity : 0.3
                    });
                });

            },
            add : function osd(label, event, sep) {
                if (!sep)
                    sep = '<br />';
                $(".osd").append('<label>' + label + '</label> ' + event + sep);
            }
        },

        // demo initialize
        init : {

            start : function() {

                $('body').append('<div id="three-container"></div>');

                var count = 0;
                for (var key in demo.init) {
                    if (key == 'start')
                        continue;

                    count++;
                    setTimeout('demo.init.' + key + '();', 100 * count);
                }

            },
            materials : function() {

                // init materials
                demo.osd.add('Materials', '<span id="material_percent"></span>');

                demo.texture.preload();

                var size = Object.keys(demo.material.config).length;
                var count = 0;
                for (var key in demo.material.config) {
                    count++;
                    demo.material.render(key);
                    $("#material_percent").html(parseInt((count / size) * 100) + '%');
                }

            },
            objects : function() {

                if (demo.texture.count != demo.texture.loaded) {
                    if (demo.tio.objects)
                        clearTimeout(demo.tio.objects);
                    demo.tio.objects = setTimeout('demo.init.objects()', 1000);
                    return;
                }

                // preload objects
                demo.osd.add('Objects', '<span id="objects"></span>');
                demo.objects_count = Object.keys(demo.object.files).length;

                for (var key in demo.object.files) {
                    //demo.objinit(demo.object.files[key]);
                    demo.objload(demo.object.files[key]);
                }

            },
            dof : function() {

                if (demo.params.dof) {
                    demo.postprocessing.dof.init();
                    demo.osd.add('DOF', 'ok');
                }

            },

            threejs : function() {

                demo.container = document.getElementById('three-container');

                demo.renderer = new THREE.WebGLRenderer(demo.params.renderer);
                demo.renderer.autoClear = false;

                demo.renderer.setSize(window.innerWidth, window.innerHeight);
                demo.container.appendChild(demo.renderer.domElement);
                demo.renderer.domElement.id = 'three-canvas';

                if (demo.params.shadows) {
                    demo.renderer.shadowMapEnabled = true;
                    demo.renderer.shadowMapSoft = true;
                }

                // set resize event
                window.addEventListener('resize', demo.resize, false);

                // esc exit
                $(document).keyup(function(e) {
                    if (e.keyCode == 27)
                        demo.stop();

                    if (e.keyCode == 32)
                        demo.pause();

                });

                demo.current = demo.timeline[0];
                demo.osd.add('ThreeJS', 'ok');

                // init Stats (fps counter)
                if (demo.params.show_fps == true) {

                    demo.stats = new Stats();
                    demo.stats.domElement.style.position = 'absolute';
                    demo.stats.domElement.style.top = '0px';
                    demo.stats.domElement.style.zIndex = 100;
                    demo.container.appendChild(demo.stats.domElement);
                    demo.osd.add('Stats', 'ok');

                }

            },

            scenes : function() {

                if (demo.objects_count != demo.objects_loaded) {
                    if (demo.tio.scenes)
                        clearTimeout(demo.tio.scenes);
                    demo.tio.scenes = setTimeout('demo.init.scenes()', 1000);
                    return;
                }

                // init scenes
                demo.osd.add('Initialize scenes', '', ' ');

                // adding scene startTime to scene obj from timeline
                for (var i = 0; i < demo.timeline.length; i++) {
                    var scn = demo.timeline[i][1];
                    if (demo.scene[scn])
                        demo.scene[scn].startTime = demo.timeline[i][0];
                }

                for (var key in demo.scene) {

                    demo.scene[key].objs = {};
                    if (demo.scene[key].init) {
                        demo.scene[key].init();
                    } else {
                        return;
                    }

                    if (demo.params.show_axis === true)
                        demo.scene[key].add(demo.object.axis(demo.params.axis_size));

                    // adding cameras
                    for (var camkey in demo.cameras) {

                        var cam = demo.cameras[camkey];
                        demo.scene[key]['cam_' + camkey] = new THREE.PerspectiveCamera(cam.fov, window.innerWidth / window.innerHeight, demo.params.min_near, demo.params.max_far);
                        demo.scene[key]['cam_' + camkey].name = camkey;
                        demo.scene[key]['cam_' + camkey].position.set(0, 0, 2000);
                        demo.scene[key].add(demo.scene[key]['cam_' + camkey]);

                        if (demo.params.trackball && camkey == 'track') {

                            if (!demo.controls[key])
                                demo.controls[key] = {};

                            // init trackball
                            demo.controls[key][camkey] = new THREE.TrackballControls(demo.scene[key]['cam_' + camkey], demo.renderer.domElement);
                            demo.controls[key][camkey].rotateSpeed = demo.trackball.rotateSpeed;
                            demo.controls[key][camkey].zoomSpeed = demo.trackball.zoomSpeed;
                            demo.controls[key][camkey].panSpeed = demo.trackball.panSpeed;
                            demo.controls[key][camkey].noZoom = demo.trackball.noZoom;
                            demo.controls[key][camkey].noPan = demo.trackball.noPan;
                            demo.controls[key][camkey].staticMoving = demo.trackball.staticMoving;
                            demo.controls[key][camkey].dynamicDampingFactor = demo.trackball.dynamicDampingFactor;
                            demo.controls[key][camkey].keys = demo.trackball.keys;

                        }

                    }

                    // init timeline first key default params
                    if (!demo.scene[key].timeline)
                        demo.scene[key].timeline = [];

                    demo.scene[key].timeline.reverse();
                    demo.scene[key].timeline.push([0, {
                        cam : [{
                            name : 'main',
                            fov : 95,
                            near : 1,
                            far : 50000,
                            position : [0, 2000, 2000],
                            lookat : SKIP,
                            rotation : SKIP,
                            scale : [1, 1, 1],
                            focus : 1,
                            aperture : 0,
                            maxblur : 0
                        }],
                        obj : {}
                    }]);
                    demo.scene[key].timeline.reverse();
                    demo.scene[key].timeline.push([9999999, {
                        cam : [{}],
                        obj : {}
                    }]);

                    demo.osd.add('', key, ' ');

                    // prerender scenes
                    demo.renderer.render(demo.scene[key], demo.scene[key].cam_main);

                }

            },

            gui : function() {

                if (!demo.params.show_gui)
                    return;

                var scenes = Object.keys(demo.scene).length;

                if (demo.scene_loaded != scenes) {
                    if (demo.tio.gui)
                        clearTimeout(demo.tio.gui);
                    demo.tio.gui = setTimeout('demo.init.gui();', 1000);
                    return;
                }

                demo.gui.obj = new dat.GUI();
                demo.gui.obj.add(demo, "pause");

                // set render and webgl params
                demo.gui.f1 = demo.gui.obj.addFolder('System - FPS / volume / time');
                demo.gui.f1.add(demo.params, "max_fps", 1, 100).step(1);
                demo.gui.f1.add(demo.params, "volume", 0, 100).step(1).onChange(function(v) {
                    if (demo.soundObj)
                        demo.soundObj.setVolume(v);
                });

                // set position
                if (demo.soundObj) {
                    var duration = demo.soundObj.getDuration() * 1000;
                } else {
                    var duration = demo.timeline[demo.timeline.length-1][0];
                }

                demo.gui.f1.add(demo, "time", 1, duration).step(1).listen().onChange(function(v) {

                    demo.startTime = new Date().getTime() - v;
                    if (demo.soundObj) {
                        demo.soundObj.setTime(v / 1000);
                    }

                });

                // dof
                if (demo.params.dof) {

                    var effectController = {
                        focus : 1.0,
                        aperture : 1.5,
                        maxblur : 0.02
                    };

                    var matChanger = function() {
                        demo.postprocessing.dof.bokeh_uniforms["focus"].value = effectController.focus;
                        demo.postprocessing.dof.bokeh_uniforms["aperture"].value = effectController.aperture;
                        demo.postprocessing.dof.bokeh_uniforms["maxblur"].value = effectController.maxblur;
                    };

                    // set DOF GUI
                    demo.gui.f2 = demo.gui.obj.addFolder('DOF - available if demo paused');
                    demo.gui.f2.add(effectController, "focus", 0.0, 3).onChange(matChanger);
                    demo.gui.f2.add(effectController, "aperture", 0.0, 3).onChange(matChanger);
                    demo.gui.f2.add(effectController, "maxblur", 0.0, 3).onChange(matChanger);

                }

                // cameras
                demo.gui.f4 = demo.gui.obj.addFolder('Cameras');
                var cameras = ['-bytimeline'];
                for (var key in demo.cameras) {
                    cameras.push(key);
                }
                demo.gui.f4.add(demo.state, 'cam', cameras);

                // scenes
                demo.gui.f5 = demo.gui.obj.addFolder('Scenes');
                var scenes = ['-bytimeline'];
                for (var key in demo.scene) {
                    scenes.push(key);
                }
                demo.gui.f5.add(demo.state, 'scene', scenes);

                demo.gui.f3 = demo.gui.obj.addFolder('Textures');

                // set default for texture editing
                var textures = [];
                demo.gui.texture.load('basic');

                // make an array form material config items
                for (var key in demo.material.config) {
                    textures.push(key);
                }

                // texture select by name and search objects
                demo.gui.f3.add(demo.gui.texture, "selected", textures).onChange(function(v) {
                    demo.gui.texture.load(v);
                    demo.gui.texture.display();
                });

                demo.gui.f3.addColor(demo.gui.texture.params, "color").onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].color = v;
                    demo.material[demo.gui.texture.selected].color = new THREE.Color(v);
                });
                demo.gui.f3.addColor(demo.gui.texture.params, "ambient").onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].ambient = v;
                    demo.material[demo.gui.texture.selected].ambient = new THREE.Color(v);
                });
                demo.gui.f3.addColor(demo.gui.texture.params, "specular").onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].specular = v;
                    demo.material[demo.gui.texture.selected].specular = new THREE.Color(v);
                });
                demo.gui.f3.add(demo.gui.texture.params, "shininess", 0, 15).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].shininess = v;
                    demo.material[demo.gui.texture.selected].shininess = v;
                });
                demo.gui.f3.add(demo.gui.texture.params, "reflectivity", 0, 1).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].reflectivity = v;
                    demo.material[demo.gui.texture.selected].reflectivity = v;
                });
                demo.gui.f3.add(demo.gui.texture.params, "refractionRatio", 0, 1).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].refractionRatio = v;
                    demo.material[demo.gui.texture.selected].refractionRatio = v;
                });
                demo.gui.f3.add(demo.gui.texture.params, "opacity", 0, 1).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].opacity = v;
                    demo.material[demo.gui.texture.selected].opacity = v;
                });

                demo.gui.f3.add(demo.gui.texture.params, "map_type", ["", "uv", "cubefake", "sphere"]).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    if (!mat.map)
                        mat.map = demo.material.config.basic.map;
                    mat.map.type = v;
                    demo.material[demo.gui.texture.selected].map = demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "map_file").onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    if (!mat.map)
                        mat.map = demo.material.config.basic.map;
                    mat.map.file = v;
                    demo.material[demo.gui.texture.selected].map = demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "map_repx", 0.5, 10).step(0.5).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    if (!mat.map)
                        mat.map = demo.material.config.basic.map;
                    mat.map.repx = v;
                    demo.material[demo.gui.texture.selected].map = demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "map_repy", 0.5, 10).step(0.5).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    if (!mat.map)
                        mat.map = demo.material.config.basic.map;
                    mat.map.repy = v;
                    demo.material[demo.gui.texture.selected].map = demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "envMap_type", ["", "uv", "cubefake", "sphere"]).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    mat.envMap.type = v;
                    demo.material[demo.gui.texture.selected].envMap = demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "envMap_file").onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    mat.envMap.file = v;
                    demo.material[demo.gui.texture.selected].envMap = demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "envMap_repx", 0.5, 10).step(0.5).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    mat.envMap.repx = v;
                    demo.material[demo.gui.texture.selected].envMap = demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "envMap_repy", 0.5, 10).step(0.5).onChange(function(v) {
                    var mat = demo.material.config[demo.gui.texture.selected];
                    mat.envMap.repy = v;
                    demo.material[demo.gui.texture.selected].envMap = demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy);
                });

                demo.gui.f3.add(demo.gui.texture.params, "combine", demo.material.defined.combine).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].combine = v;
                    demo.material[demo.gui.texture.selected].combine = v;
                });

                demo.gui.f3.add(demo.gui.texture.params, "blending", demo.material.defined.blending).onChange(function(v) {
                    demo.material.config[demo.gui.texture.selected].blending = v;
                    demo.material[demo.gui.texture.selected].blending = v;
                });

                demo.gui.obj.close();

                $('.dg.ac').css({
                    opacity : 0.25,
                    zIndex : 100
                });

                $(".dg.ac").hover(function() {
                    $(this).stop().animate({
                        opacity : 0.85
                    });
                }, function() {
                    $(this).stop().animate({
                        opacity : 0.25
                    });
                });

            },
            waiting : function() {

                var scenes = Object.keys(demo.scene).length;

                if (demo.scene_loaded != scenes) {
                    //if (demo.scene_loaded != scenes || !demo.init.ok.gui) {
                    if (demo.tio.waiting)
                        clearTimeout(demo.tio.waiting);
                    demo.tio.waiting = setTimeout('demo.init.waiting();', 1000);
                    return;
                }

                demo.renderer.clear();

                $('.osd').html('');
                
                /*
                $('body').append('<div id="overlay"></div>');

                $("overlay").css({
                    width : window.innerHeight,
                    height : window.innerWidth,
                    opacity: 0.6
                });
                */

                $(".loader").animate({
                    opacity : 0
                }, demo.params.sleep * 2, function() {

                    $(".loader").remove();
                    $(demo.container).fadeTo(demo.params.sleep, 1);

                    if (demo.params.show_gui == true) {
                        $('.osd').append('<div>Dilemma WebGL demosystem v0.2 by rascy</div>');
                    }

                    if (demo.params.show_time == true) {
                        $('.osd').append('<div id="time">0</div>');
                        $('.osd').append('<div id="scenetime">0</div>');

                        if (demo.params.music == true) {
                            $('.osd').append('<div id="musicpos">0</div>');
                        }
                    }

                    if (demo.params.show_camposition == true) {
                        $('.osd').append('<div id="camposition"></div>');
                    }

                    demo.params.height = window.innerHeight;
                    demo.params.width = window.innerWidth;

                    if (demo.soundObj)
                        demo.soundObj.play();

                    demo.startTime = new Date().getTime();
                    demo.animate();

                });

            }
        },
        gui : {
            obj : false,
            texture : {
                params : function() {
                },
                load : function(name) {

                    demo.gui.texture.selected = name;
                    var mat = demo.material.config[name];

                    var params = ["type", "color", "ambient", "specular", "shininess", "opacity", "reflectivity", "refractionRatio", "combine", "blending"];

                    for (var i in params) {
                        demo.gui.texture.params[params[i]] = mat[params[i]];
                    }

                    if (mat.map) {
                        demo.gui.texture.params.map_type = mat.map.type;
                        demo.gui.texture.params.map_file = mat.map.file;
                        demo.gui.texture.params.map_repx = mat.map.repx;
                        demo.gui.texture.params.map_repy = mat.map.repy;
                    }
                    if (mat.envMap) {
                        demo.gui.texture.params.envMap_type = mat.envMap.type;
                        demo.gui.texture.params.envMap_file = mat.envMap.file;
                        demo.gui.texture.params.envMap_repx = mat.envMap.repx;
                        demo.gui.texture.params.envMap_repy = mat.envMap.repy;
                    }

                },
                display : function() {
                    for (var i in demo.gui.f3.__controllers) {
                        demo.gui.f3.__controllers[i].updateDisplay();
                    }
                }
            }
        },

        postprocessing : {
            dof : {
                material_depth : new THREE.MeshDepthMaterial(),

                init : function() {

                    var dof = demo.postprocessing.dof;

                    dof.scene = new THREE.Scene();

                    dof.camera = new THREE.OrthographicCamera(window.innerWidth / -2, window.innerWidth / 2, window.innerHeight / 2, window.innerHeight / -2, -10000, 10000);
                    dof.camera.position.z = 100;

                    dof.scene.add(dof.camera);

                    var pars = {
                        minFilter : THREE.LinearFilter,
                        magFilter : THREE.LinearFilter,
                        format : THREE.RGBFormat
                    };
                    dof.rtTextureDepth = new THREE.WebGLRenderTarget(window.innerWidth, window.innerHeight, pars);
                    dof.rtTextureColor = new THREE.WebGLRenderTarget(window.innerWidth, window.innerHeight, pars);

                    var bokeh_shader = THREE.ShaderExtras["bokeh"];

                    dof.bokeh_uniforms = THREE.UniformsUtils.clone(bokeh_shader.uniforms);

                    dof.bokeh_uniforms["tColor"].value = dof.rtTextureColor;
                    dof.bokeh_uniforms["tDepth"].value = dof.rtTextureDepth;
                    dof.bokeh_uniforms["focus"].value = 1.0;
                    dof.bokeh_uniforms["aperture"].value = 1.5;
                    dof.bokeh_uniforms["maxblur"].value = 0.02;
                    dof.bokeh_uniforms["aspect"].value = window.innerWidth / window.innerHeight;

                    dof.materialBokeh = new THREE.ShaderMaterial({

                        uniforms : dof.bokeh_uniforms,
                        vertexShader : bokeh_shader.vertexShader,
                        fragmentShader : bokeh_shader.fragmentShader

                    });

                    dof.quad = new THREE.Mesh(new THREE.PlaneGeometry(window.innerWidth, window.innerHeight), dof.materialBokeh);
                    dof.quad.position.z = -500;
                    //dof.quad.rotation.x = Math.PI / 2;
                    dof.scene.add(dof.quad);

                }
            }
        },

        stop : function() {

            demo.stopped = true;

            var html = '<div class="endscreen">';
            html += '<h1>' + demo.text.title + '</h1>' + demo.text.description;
            html += '<br /><br />' + demo.text.group + '<br /><a href="http://' + demo.text.site + '">' + demo.text.site + '</a>';
            html += '<div>';

            $('body').hide();
            $('body').html(html);
            $('body').fadeTo(1000, 1);

        }
    });

});

