// 2011-12 - rascy@dilemma.ws

$(document).ready(function() {

    $.extend(demo, {

        material : {

            defined : {

                combine : {
                    multiply : THREE.MultiplyOperation,
                    mix : THREE.MixOperation
                },
                blending : {
                    no : THREE.NoBlending,
                    normal : THREE.NormalBlending,
                    assitive : THREE.AdditiveBlending,
                    subtractive : THREE.SubtractiveBlending,
                    multiply : THREE.MultiplyBlending,
                    additiveAlpha : THREE.AdditiveAlphaBlending,
                    custom : THREE.CustomBlending
                }

            },

            config : {

                basic : {
                    type : 'MeshPhong',
                    color : 0xffffff,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 7,
                    opacity : 1,
                    reflectivity : 0.5,
                    refractionRatio : 0.9,
                    doubleSided : true,
                    map : {
                        type : 'uv',
                        file : '13.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : 'clouds.jpg',
                        repx : 1,
                        repy : 1
                    },
                    lightMap : {
                        type : 'cubefake',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MultiplyOperation,
                    blending : THREE.AdditiveBlending
                },

                sky : {
                    type : 'MeshPhong',
                    color : 0x151515,
                    ambient : 0x000000,
                    specular : 0xffffff,
                    shininess : 14,
                    opacity : 1,
                    reflectivity : 0.1,
                    refractionRatio : 0.1,
                    doubleSided : true,
                    map : {
                        type : 'cube',
                        file : 'skybox',
                        repx : 1,
                        repy : 1
                    }
                },

                plane : {
                    type : 'MeshPhong',
                    color : 0xf1f1f1,
                    ambient : 0x101010,
                    specular : 0x303030,
                    shininess : 0,
                    opacity : 1,
                    reflectivity : 0,
                    refractionRatio : 0,
                    doubleSided : true
                },

                num0 : {
                    type : 'MeshPhong',
                    color : -1,
                    ambient : 0x000000,
                    specular : 0xffffff,
                    shininess : 15,
                    opacity : 1,
                    reflectivity : 0.25,
                    refractionRatio : 0.88,
                    doubleSided : true,
                    map : {
                        type : 'uv',
                        file : 'num0.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : 'clouds.jpg',
                        repx : 1,
                        repy : 1
                    },
                    blending : THREE.AdditiveAlphaBlending,
                    combine : THREE.MixOperation
                },

                num1 : {
                    type : 'MeshPhong',
                    color : 0x10aaff,
                    ambient : 0x000000,
                    specular : 0xffffff,
                    shininess : 15,
                    opacity : 1,
                    reflectivity : 0.25,
                    refractionRatio : 0.88,
                    doubleSided : true,
                    map : {
                        type : 'uv',
                        file : 'num1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : 'clouds.jpg',
                        repx : 1,
                        repy : 1
                    },
                    blending : THREE.AdditiveAlphaBlending,
                    combine : THREE.MixOperation
                },

                energie : {
                    type : 'MeshPhong',
                    color : -1,
                    ambient : 0x353535,
                    specular : -1,
                    shininess : 9,
                    reflectivity : 0.5,
                    refractionRatio : 0.93,
                    doubleSided : false,
                    map : {
                        type : 'uv',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : '13.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MixOperation
                },

                square_lines : {

                    type : 'MeshPhong',
                    color : 0xffffff,
                    ambient : 0x050505,
                    specular : 0xffffff,
                    shininess : 5,
                    reflectivity : 0.85,
                    refractionRatio : 0.95,
                    doubleSided : true,
                    map : {
                        type : 'uv',
                        file : 'square-lines-pattern.jpg',
                        repx : 3,
                        repy : 3
                    }

                },

                black_plastic : {
                    type : 'MeshPhong',
                    color : 0x101010,
                    ambient : 0x050505,
                    specular : 0xffffff,
                    shininess : 12,
                    opacity : 1,
                    reflectivity : 0.5,
                    refractionRatio : 0.9,
                    doubleSided : true,
                    combine : THREE.MultiplyOperation
                },
                
                polip_refbox : {
                    type : 'MeshPhong',
                    color : 0xffffff,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 12,
                    opacity : 1,
                    reflectivity : 0.5,
                    refractionRatio : 0.1,
                    doubleSided : false,                    
                    envMap : {
                        type : 'cubefake',
                        file : '13.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MultiplyOperation
                },                

                white_mirror : {
                    type : 'MeshPhong',
                    color : 0xffffff,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 3,
                    opacity : 1,
                    reflectivity : 1,
                    refractionRatio : 0.5,
                    doubleSided : false,
                    map : {
                        type : 'uv',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : '43.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MultiplyOperation
                },

                spikerball : {
                    type : 'MeshPhong',
                    color : 0xffffff,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 3,
                    opacity : 1,
                    reflectivity : 1,
                    refractionRatio : 0.5,
                    doubleSided : false,
                    map : {
                        type : 'uv',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : '43.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MultiplyOperation
                },

                sun_pattern : {

                    type : 'MeshPhong',
                    color : 0xf1f1f1,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 15,
                    reflectivity : 0.85,
                    refractionRatio : 0.95,
                    doubleSided : false,
                    map : {
                        type : 'uv',
                        file : 'sun-pattern.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : '13.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MixOperation,
                    blending : THREE.NormalBlending

                },

                silver : {

                    type : 'MeshLambert',
                    color : 0xf1f1f1,
                    ambient : 0x151515,
                    specular : 0xfefefe,
                    shininess : 10,
                    reflectivity : 0.8,
                    refractionRatio : 0.9,
                    doubleSided : false,
                    envMap : {
                        type : 'cubefake',
                        file : 'metal.jpg',
                        repx : 1,
                        repy : 1
                    },
                    //combine : THREE.MixOperation,
                    blending : THREE.MultiplyBlending
                },

                building_glass : {

                    type : 'MeshPhong',
                    color : 0xd1d1d1,
                    opacity : 0.4,
                    ambient : 0x202020,
                    specular : 0xffffff,
                    shininess : 0.8,
                    reflectivity : 0.65,
                    refractionRatio : 0.85,
                    transparent : true,
                    doubleSided : true,
                    envMap : {
                        type : 'cubefake',
                        file : 'clouds.jpg',
                        repx : 1,
                        repy : 1
                    }

                },

                building_column : {

                    type : 'MeshLambert',
                    map : {
                        type : 'uv',
                        file : 'paper.jpg',
                        repx : 1,
                        repy : 1
                    }

                },

                broken_mirror : {
                    type : 'MeshPhong',
                    color : 0x818384,
                    ambient : 0x101010,
                    specular : 0xffffff,
                    shininess : 15,
                    opacity : 1,
                    reflectivity : 0.86,
                    refractionRatio : 0.83,
                    doubleSided : true,
                    map : {
                        type : 'cubefake',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'uv',
                        file : '1.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MultiplyOperation,
                    blending : THREE.AdditiveBlending
                },

                test : {

                    type : 'MeshPhong',
                    color : 0xa1a1a1,
                    ambient : 0x303030,
                    specular : 0xffffff,
                    shininess : 0.2,
                    reflectivity : 0.35,
                    refractionRatio : 0.45,
                    doubleSided : false,
                    map : {
                        type : 'uv',
                        file : 'scifi6.jpg',
                        repx : 1,
                        repy : 1
                    },
                    envMap : {
                        type : 'cubefake',
                        file : 'metal.jpg',
                        repx : 1,
                        repy : 1
                    },
                    combine : THREE.MixOperation,
                    //blending : THREE.MultiplyBlending

                }

            },

            render : function(name) {

                if (!demo.material.config[name])
                    return;

                var mat = $.extend({}, demo.material.config[name]);

                if (mat.map)
                    mat.map = demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy);
                if (mat.envMap)
                    mat.envMap = demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy);

                if (mat.color == -1)
                    mat.color = demo.params.usercolor;
                if (mat.specular == -1)
                    mat.specular = demo.params.usercolor;

                if (mat.doubleSided)
                    mat.side = THREE.DoubleSide;

                mat.perPixel = true;
                mat.shading = THREE.SmoothShading;

                switch (mat.type) {

                    case 'MeshPhong':
                        demo.material[name] = new THREE.MeshPhongMaterial(mat);
                        break;

                    case 'MeshNormal':
                        demo.material[name] = new THREE.MeshNormalMaterial(mat)
                        break;

                    case 'MeshLambert':
                        demo.material[name] = new THREE.MeshLambertMaterial(mat)

                }

                demo.material[name].name = name;
                demo.material[name].needsUpdate = true;

                return demo.material[name];

            },

            update : function(material) {

                var config = demo.material.config[material];

                console.log(demo.material[material]);

                for (var param in config) {

                    if (param == 'type')
                        continue;

                    switch (param) {

                        case '-map':
                        case '-envMap':
                            if (demo.material[param])
                                demo.material[param] = demo.texture.quick(config[param].type, config[param].file, config[param].repx, config[param].repy);
                            break;

                        case 'color':
                            if (demo.material[param])
                                demo.material[param] = config[param];

                        case 'ambient':
                        case 'specular':
                        case 'shininess':
                        case 'doubleSided':
                        case 'reflectivity':
                        case 'refractionRatio':

                            if (demo.material[param])
                                demo.material[param] = config[param];

                    }

                }

                console.log(config);
                console.log(demo.material[material]);

            },

            text : function(text, size) {

                if (!size)
                    size = 256;

                var sprite = demo.texture.canvas.text(text, size);

                texture = new THREE.Texture(sprite);
                texture.mapping = THREE.CubeRefractionMapping();
                texture.wrapS = THREE.RepeatWrapping;
                texture.wrapT = THREE.RepeatWrapping;
                texture.repeat.set(1, 1);
                texture.needsUpdate = true;

                return new THREE.MeshPhongMaterial({
                    color : 0xf1f1f1,
                    ambient : 0x454545,
                    specular : 0xf1f1f1,
                    blending : THREE.AdditiveBlending,
                    shininess : 15,
                    map : texture,
                    opacity : 1,
                    transparent : false
                });

            },

            quick : function(map, envmap, name) {

                if (!name)
                    name = new Date().getTime();

                demo.material[name] = new THREE.MeshPhongMaterial({
                    color : 0xffffff,
                    ambient : 0x000000,
                    specular : 0xffffff,
                    shininess : 0.5,
                    refractionRatio : 0.85
                });

                if (map)
                    demo.material[name].map = map;
                if (envmap)
                    demo.material[name].envMap = envmap;

                return demo.material[name];

            },
        },

        texture : {

            dust : new THREE.ImageUtils.loadTexture("data/textures/balls/circle.png"),
            ball : new THREE.ImageUtils.loadTexture("data/textures/balls/ball.png"),
            star : new THREE.ImageUtils.loadTexture("data/textures/balls/star.png"),

            count : 0,
            loaded : 0,

            preload : function() {

                for (var key in demo.material.config) {

                    var mat = demo.material.config[key];
                    if (mat.map)
                        demo.texture.quick(mat.map.type, mat.map.file, mat.map.repx, mat.map.repy, true);
                    if (mat.envMap)
                        demo.texture.quick(mat.envMap.type, mat.envMap.file, mat.envMap.repx, mat.envMap.repy, true);
                }

            },

            quick : function(type, texture, repeatX, repeatY, getname) {

                demo.texture.count++;
                var name = demo.texture.count + '-' + type + '-' + texture;

                if (repeatX && repeatY)
                    name = name + '-' + repeatX + '-' + repeatY;

                name = name.replace(".", "");

                if (texture.length < 5) {
                    demo.texture[name] = false;
                    return false;
                }

                if (!demo.texture[name]) {

                    switch (type) {

                        case 'uv':
                            demo.texture[name] = new THREE.ImageUtils.loadTexture('data/textures/' + texture, new THREE.UVMapping, function() {
                                demo.texture.loaded++;
                            });
                            break;

                        case 'cubefake':
                            var file = "data/textures/" + texture;
                            var urls = [file, file, file, file, file, file];
                            demo.texture[name] = THREE.ImageUtils.loadTextureCube(urls, new THREE.CubeRefractionMapping(), function() {
                                demo.texture.loaded++;
                            });
                            break;

                        case 'sphere':
                            demo.texture[name] = THREE.ImageUtils.loadTexture('data/textures/' + texture, new THREE.SphericalReflectionMapping(), function() {
                                demo.texture.loaded++;
                            });
                            break;

                        case 'cube':
                            var path = "data/textures/" + texture + "/";
                            var format = '.jpg';
                            var urls = [path + 'px' + format, path + 'nx' + format, path + 'py' + format, path + 'ny' + format, path + 'pz' + format, path + 'nz' + format];
                            demo.texture[name] = new THREE.ImageUtils.loadTextureCube(urls, new THREE.CubeRefractionMapping(), function() {
                                demo.texture.loaded++;
                            });
                            break;

                    }

                    if (repeatX && repeatY) {
                        demo.texture[name].wrapS = THREE.RepeatWrapping;
                        demo.texture[name].wrapT = THREE.RepeatWrapping;
                        demo.texture[name].repeat.set(repeatX, repeatY);
                        demo.texture[name].needsUpdate = true;
                    }

                }

                if (getname)
                    return name;
                else
                    return demo.texture[name];

            },

            canvas : {

                sprite : function(w, h, text) {

                    var canvas = document.createElement('canvas');
                    canvas.width = w;
                    canvas.height = h;

                    var context = canvas.getContext('2d');

                    context.fillStyle = "white";
                    context.font = "12pt Arial";
                    context.fillText(text, 20, 20);

                    texture = new THREE.Texture(canvas);
                    texture.mapping = THREE.CubeRefractionMapping();
                    texture.wrapS = THREE.RepeatWrapping;
                    texture.wrapT = THREE.RepeatWrapping;
                    texture.repeat.set(1, 1);
                    texture.needsUpdate = true;

                    return texture;

                },

                text : function(text, size) {

                    function wrapText(context, text, x, y, maxWidth, lineHeight) {

                        var words = text.split(" ");
                        var line = "";

                        for (var n = 0; n < words.length; n++) {
                            var testLine = line + words[n] + " ";
                            var metrics = context.measureText(testLine);
                            var testWidth = metrics.width;
                            if (testWidth > maxWidth) {
                                context.fillText(line, x, y);
                                line = words[n] + " ";
                                y += lineHeight;
                            } else {
                                line = testLine;
                            }
                        }
                        context.fillText(line, x, y);
                    }

                    if (!size)
                        size = 256;
                    var w = size;
                    var h = size;

                    var canvas = document.createElement('canvas');
                    canvas.width = w;
                    canvas.height = h;
                    var context = canvas.getContext('2d');

                    //context.fillStyle = "white";
                    //context.strokeStyle = "white";
                    //context.fillRect(0, 0, w, h);

                    context.fillStyle = "white";
                    context.font = "40pt Arial";

                    var maxWidth = 320;
                    var lineHeight = 50;
                    var x = 5;
                    var y = 25;

                    //context.fillText(text, x, y);
                    wrapText(context, text, x, y, maxWidth, lineHeight);

                    return canvas;

                }
            }

        }

    });

});
