// 2011-2012 - rascy@dilemma.ws

$(document).ready(function() {

    $.extend(demo, {

        motioncalc : {

            getxyz : function(prev, next, percent) {

                var output = {};
                output.x = prev[0] + (next[0] - prev[0]) * percent;
                output.y = prev[1] + (next[1] - prev[1]) * percent;
                output.z = prev[2] + (next[2] - prev[2]) * percent;
                return output;

            },

            get : function(prev, next, percent) {
                return (prev + (next - prev) * percent);
            },

            inherit_params : function(prev, next) {

                if (!prev || !next)
                    return next;

                var cam_params = ['name', 'fov', 'near', 'far', 'rotation', 'position', 'scale', 'lookat', 'focus', 'aperture', 'maxblur'];

                for (var key in cam_params) {
                    if (!next[1].cam[0][cam_params[key]])
                        next[1].cam[0][cam_params[key]] = prev[1].cam[0][cam_params[key]];
                }

                var obj_params = ['rotation', 'position', 'scale', 'multi'];

                if (!prev[1].obj && next[1].obj)
                    prev[1].obj = next[1].obj;

                for (var key in obj_params) {

                    for (var objkey in prev[1].obj) {

                        if (!next[1].obj)
                            next[1].obj = prev[1].obj;

                        if (!next[1].obj[objkey]) {
                            next[1].obj[objkey] = prev[1].obj[objkey];
                            continue;
                        }

                        if (!prev[1].obj[objkey][obj_params[key]]) {
                            continue;
                        }

                        if (!next[1].obj[objkey][obj_params[key]])
                            next[1].obj[objkey][obj_params[key]] = prev[1].obj[objkey][obj_params[key]];
                    }
                }

                return next;

            },

            update : {

                cam : function(scene, prev, next, pospercent) {

                    // update camera
                    var camera = scene['cam_' + next.name];

                    // fov, far, near
                    if (next.fov instanceof Function) {
                        camera.fov = next.fov();
                        camera.aspect = window.innerWidth / window.innerHeight;
                        camera.updateProjectionMatrix();
                    } else if (prev.fov !== next.fov) {
                        camera.fov = demo.motioncalc.get(prev.fov, next.fov, pospercent);
                        camera.aspect = window.innerWidth / window.innerHeight;
                        camera.updateProjectionMatrix();
                    }

                    if (prev.far !== next.far) {
                        camera.far = demo.motioncalc.get(prev.far, next.far, pospercent);
                        camera.aspect = window.innerWidth / window.innerHeight;
                        camera.updateProjectionMatrix();
                    }

                    if (prev.near !== next.near) {
                        camera.near = demo.motioncalc.get(prev.near, next.near, pospercent);
                        camera.aspect = window.innerWidth / window.innerHeight;
                        camera.updateProjectionMatrix();
                    }

                    // scale
                    if (prev.scale !== next.scale) {
                        var newscale = demo.motioncalc.getxyz(prev.scale, next.scale, pospercent);
                        camera.scale.set(newscale.x, newscale.y, newscale.z);
                    }

                    // position
                    if (next.position !== SKIP) {
                        if (next.position instanceof Array) {
                            var newpos = demo.motioncalc.getxyz(prev.position, next.position, pospercent);
                        } else {
                            var newpos = next.position();
                        }
                        camera.position.set(newpos.x, newpos.y, newpos.z);
                    }

                    // lookat
                    if (next.lookat !== SKIP) {

                        if (next.lookat instanceof Array) {
                            var newlook = demo.motioncalc.getxyz(prev.lookat, next.lookat, pospercent);
                        } else {
                            var newlook = next.lookat();
                        }
                        var look = new THREE.Vector3(newlook.x, newlook.y, newlook.z);
                        camera.lookAt(look);
                    }

                    // rotation
                    if (next.rotation !== SKIP) {
                        var newrot = demo.motioncalc.getxyz(prev.rotation, next.rotation, pospercent);
                        camera.rotation.set(newrot.x, newrot.y, newrot.z);
                    }

                    // dof
                    if (demo.params.dof) {
                        demo.postprocessing.dof.bokeh_uniforms["focus"].value = demo.motioncalc.get(prev.focus, next.focus, pospercent);
                        demo.postprocessing.dof.bokeh_uniforms["aperture"].value = demo.motioncalc.get(prev.aperture, next.aperture, pospercent);
                        demo.postprocessing.dof.bokeh_uniforms["maxblur"].value = demo.motioncalc.get(prev.maxblur, next.maxblur, pospercent);
                    }
                },

                obj : function(scene, prev_objects, next_objects, pospercent) {

                    for (var objkey in next_objects) {

                        var next = next_objects[objkey];
                        var prev = prev_objects[objkey];

                        // if multi
                        if (objkey == 'multi') {
                            next.func(scene, next.params);
                        }

                        if (next.pad) {
                            var pad = next.pad;
                        } else {
                            var pad = 0;
                        }

                        var obj = scene.getChildByName(objkey);
                        if (!obj)
                            continue;

                        // rotation
                        if (next.rotation) {
                            if (next.rotation instanceof Array) {
                                var data = demo.motioncalc.getxyz(prev.rotation, next.rotation, pospercent);
                            } else {
                                var params = {
                                    scene : scene,
                                    percent : pospercent
                                };
                                var data = next.rotation(pad, params);
                            }
                            obj.rotation.set(data.x, data.y, data.z);
                        }

                        // position
                        if (next.position) {
                            if (next.position instanceof Array) {
                                var data = demo.motioncalc.getxyz(prev.position, next.position, pospercent);
                            } else {
                                var data = next.position(pad);
                            }
                            obj.position.set(data.x, data.y, data.z);
                        }

                    }

                }
            },

            run : function(scn) {

                var scene = demo.scene[scn];

                if (!scene.timeline)
                    return 'main';

                var tl = scene.timeline;
                var prev, next;

                if (!scene.timeline_pos)
                    scene.timeline_pos = 0;

                var scenetime = demo.time - demo.scene[scn].startTime;
                demo.scene[scn].currentTime = scenetime;

                $("#scenetime").html(scenetime);

                for (var i = scene.timeline_pos; i < scene.timeline.length; i++) {

                    var ttime = tl[i][0];

                    if (ttime <= scenetime) {

                        prev = demo.motioncalc.inherit_params(tl[i - 1], tl[i]);
                        next = demo.motioncalc.inherit_params(tl[i], tl[i + 1]);

                        if (demo.params.show_gui === false)
                            scene.timeline_pos = i;

                    } else {
                        break;
                    }
                }

                if (!next)
                    return 'main';

                var pospercent = (scenetime - prev[0]) / (next[0] - prev[0]);

                // update main camera
                demo.motioncalc.update.cam(scene, prev[1].cam[0], next[1].cam[0], pospercent);

                // update objects
                demo.motioncalc.update.obj(scene, prev[1].obj, next[1].obj, pospercent);

                return next[1].cam[0].name;
            }
        },

        motion : {

            byname : {

                polip : function(scene, params) {

                    var count = scene.children.length;

                    rotX = Math.sin(demo.time / 440) * 0.11;
                    rotY = Math.cos(demo.time / 380) * 0.12;
                    rotZ = Math.sin(demo.time / 390) * 0.13;

                    for ( i = 0; i < count; i++) {

                        var obj = scene.children[i];
                        var n = obj.name.indexOf(params.name);

                        if (n == 0) {
                            obj.rotation.x = rotX;
                            obj.rotation.y = rotY;
                            obj.rotation.z = rotZ;
                        }
                    }

                },

                polip2 : function(scene, params) {

                    rotX = Math.sin(demo.time / 740) * 0.11;
                    rotY = Math.cos(demo.time / 580) * 0.12;
                    rotZ = Math.sin(demo.time / 690) * 0.13;

                    for (var i = 0, l = objects.length; i < l; i++) {

                        var n = objects[i].name.indexOf(params.name);
                        if (n == 0) {
                            objects[i].rotation.x = rotX;
                            objects[i].rotation.y = rotY;
                            objects[i].rotation.z = rotZ;
                        }

                    }

                }
            },

            camera : {

                basic : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.sin(demo.time / 2100) * 2200;
                    scene['cam_' + cam].position.y = Math.cos(demo.time / 2200) * 200;
                    scene['cam_' + cam].position.z = Math.cos(demo.time / 2150) * 2330;

                    lookX = Math.sin(demo.time / 2210) * 220;
                    lookY = Math.cos(demo.time / 2220) * 240;
                    lookZ = Math.cos(demo.time / 2200) * 260;

                    var lookat = new THREE.Vector3(lookX, lookY, lookZ);
                    scene['cam_' + cam].lookAt(lookat);
                },

                title : {

                    pos : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 2100) * 2500;
                        value.y = Math.cos(demo.time / 2100) * 1200;
                        value.z = Math.cos(demo.time / 2100) * 2450;
                        return value;
                    },

                    lookat : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 1225) * 1690;
                        value.y = Math.cos(demo.time / 1222) * 1740;
                        value.z = Math.cos(demo.time / 725) * 860;
                        return value;
                    },

                    fov : function() {
                        return 110 + Math.sin(demo.time / 4025) * 30;
                    }
                },

                antenna : {

                    pos : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 2100) * 2500;
                        value.y = Math.cos(demo.time / 2100) * 1200;
                        value.z = Math.cos(demo.time / 2100) * 2450;
                        return value;
                    },

                    lookat : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 1225) * 1690;
                        value.y = Math.cos(demo.time / 1222) * 1740;
                        value.z = Math.cos(demo.time / 725) * 860;
                        return value;
                    },

                    fov : function() {
                        return 110 + Math.sin(demo.time / 4025) * 30;
                    }
                },

                sindots : {

                    pos : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 5700) * 2020;
                        value.y = Math.sin(demo.time / 5200) * 2100;
                        value.z = Math.sin(demo.time / 5000) * 1355;
                        return value;
                    },

                    lookat : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 1300) * 890;
                        value.y = Math.sin(demo.time / 1400) * 940;
                        value.z = Math.sin(demo.time / 1500) * 960;
                        return value;
                    }
                },

                polip_old : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.sin(demo.time / 1405) * 2290;
                    scene['cam_' + cam].position.y = Math.cos(demo.time / 1212) * 1780;
                    scene['cam_' + cam].position.z = Math.cos(demo.time / 1425) * 2160;

                    lookX = Math.sin(demo.time / 725) * 890;
                    lookY = Math.cos(demo.time / 722) * 840;
                    lookZ = Math.cos(demo.time / 725) * 860;

                    var lookat = new THREE.Vector3(lookX, lookY, lookZ);
                    scene['cam_' + cam].lookAt(lookat);
                },

                polip : {

                    pos : function(pad) {
                        var value = {};

                        if (!pad)
                            pad = 0;

                        value.x = Math.sin(demo.time / (1405 + pad)) * 2590;
                        value.y = Math.cos(demo.time / (1212 + pad)) * 2580;
                        value.z = 1900 + Math.cos(demo.time / 1425) * 500;
                        return value;
                    },

                    lookat : function() {
                        var value = {};
                        value.x = Math.sin(demo.time / 795) * 890;
                        value.y = Math.cos(demo.time / 722) * 840;
                        value.z = Math.cos(demo.time / 825) * 860;
                        return value;
                    },

                    fov : function() {
                        return 110 + Math.sin(demo.time / 4025) * 30;
                    }
                },

                polip2 : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.cos(demo.time / 29) * 1270;
                    scene['cam_' + cam].position.y = Math.sin(demo.time / 31) * 1220;
                    scene['cam_' + cam].position.z = -1450;
                },

                polip_dust : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.sin(demo.time / 27) * 450;
                    scene['cam_' + cam].position.y = Math.cos(demo.time / 30) * 420;
                    scene['cam_' + cam].position.z = -450;
                },

                polip_slow : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.cos(demo.time / 5) * 1270;
                    scene['cam_' + cam].position.y = Math.sin(demo.time / 6) * 1220;
                    scene['cam_' + cam].position.z = -1250;
                },
                intube : function(scene, cam) {
                    scene['cam_' + cam].position.x = Math.sin(demo.time / 2000) * 50;
                    scene['cam_' + cam].position.y = Math.cos(demo.time / 1200) * 50;
                    scene['cam_' + cam].position.z = Math.cos(demo.time / 2250) * 50;

                    lookX = Math.sin(demo.time / 1710) * 2220;
                    lookY = Math.cos(demo.time / 2220) * 1240;
                    lookZ = Math.sin(demo.time / 2200) * 2260;

                    var lookat = new THREE.Vector3(lookX, lookY, lookZ);
                    scene['cam_' + cam].lookAt(lookat);
                },
            },

            object : {

                rot : function(scene, objname, pad) {
                    var obj = scene.getChildByName(objname);
                    if (!obj)
                        return;
                    obj.rotation.x = Math.sin(demo.time / 637) * 0.9;
                    obj.rotation.y = Math.cos(demo.time / 623) * 0.2;
                    obj.rotation.z = Math.sin(demo.time / 612) * 0.5;
                },

                dust2 : function(scene, objname, pad) {
                    var obj = scene.getChildByName(objname);
                    if (!obj)
                        return;

                    //obj.rotation.x = Math.sin(demo.time / 4637) * 0.7;
                    obj.rotation.y = Math.cos(demo.time / 4823) * 1;
                    //obj.rotation.z = Math.sin(demo.time / 4812) * 0.5;

                },

                dust : function(pad) {

                    if (!pad)
                        pad = 0;

                    var value = {};
                    value.x = 0;
                    value.y = Math.cos(demo.time / 4823) * 1;
                    value.z = 0;
                    return value;

                },

                antenna_stars : {

                    rot : function(pad) {

                        if (!pad)
                            pad = 0;

                        var value = {};
                        value.x = Math.cos(demo.time / (1750 + pad)) * 2;
                        value.y = Math.cos(demo.time / (1550 + pad)) * 2;
                        value.z = 0;
                        return value;

                    }
                },

                antenna : {

                    rot : function(pad, params) {

                        if (!pad)
                            pad = 0;

                        var x = 40 * (params.scene.currentTime / 12700);

                        var value = {};
                        //value.x =  0;
                        //value.x = Math.cos(demo.time / (1150 + pad)) * 12;
                        value.x = (Math.random() * x) + Math.cos(demo.time / (1050 + pad)) * 13;
                        value.y = 0;
                        value.z = x;
                        return value;

                    }
                },

                twister : function(scene, objname) {

                    var count = scene.children.length;
                    for ( i = 0; i < count; i++) {
                        var obj = scene.children[i];
                        var n = obj.name.indexOf(objname);

                        if (n == 0) {
                            obj.rotation.x = Math.sin(demo.time / 1000) * (4 - Math.sin(i / 4));
                        }
                    }
                },

                flying_boxes : function(scene, params) {

                    var count = scene.children.length;

                    if (!this.stime)
                        this.stime = demo.time;
                    var dec = (demo.time - this.stime) / 3;

                    for ( i = 0; i < count; i++) {
                        var obj = scene.children[i];
                        var n = obj.name.indexOf(params.name);

                        if (n == 0) {

                            obj.rotation.x = (demo.time / 1120 + (i / 10));
                            obj.rotation.y = (demo.time / 2120 + (i / 10));
                            obj.rotation.z = (demo.time / 2120 + (i / 10));

                            //obj.position.x = obj.position.x - 20;
                            obj.position.x = obj.position.x - dec;
                            if (obj.position.x < -7000)
                                obj.position.x = obj.position.x + 14000;
                        }
                    }

                    this.stime = demo.time;

                },

                rolling_boxes : function(scene, objname) {

                    var count = scene.children.length;

                    if (!this.stime)
                        this.stime = demo.time;
                    var dec = (demo.time - this.stime);

                    for ( i = 0; i < count; i++) {
                        var obj = scene.children[i];
                        var n = obj.name.indexOf(objname);

                        if (n == 0) {
                            //obj.rotation.x = (demo.time / 1230);
                            //obj.rotation.y = (demo.time / 1220);
                            obj.rotation.z = (demo.time / 2000);

                            obj.position.y = obj.position.y = Math.sin(demo.time / 2000) * 0.1;

                            obj.position.x = obj.position.x - dec;
                            if (obj.position.x < -10000)
                                obj.position.x = 10000;
                        }
                    }
                },

                grass : function(scene, objname) {
                    var obj = scene.getChildByName(objname);
                    if (!obj)
                        return;
                    obj.rotation.x = Math.sin(demo.time / 37) * 0.9;
                    obj.rotation.y = Math.cos(demo.time / 23) * 0.2;
                    obj.rotation.z = Math.sin(demo.time / 12) * 0.5;
                },

                light1 : function(scene, objname) {
                    var obj = scene.getChildByName(objname);
                    if (!obj)
                        return;
                    obj.position.x = Math.sin(demo.time / 3225) * 2290;
                    obj.position.y = Math.cos(demo.time / 3222) * 1400;
                    obj.position.z = Math.cos(demo.time / 3225) * 2060;
                },

                light2 : function(scene, objname) {
                    var obj = scene.getChildByName(objname);
                    if (!obj)
                        return;

                    var pos = demo.motion.camera.polip.pos(150);
                    obj.position.x = pos.x;
                    obj.position.y = pos.y;
                    obj.position.z = pos.z;
                    ;

                },
            }
        }

    });

});
