// 2011-12 - rascy@dilemma.ws

var demo = {};

$(document).ready(function() {

    $(".startcreen").css({
        opacity : 0
    });

    $("#start").click(function() {

        // init demo osd display
        demo.osd.init();

        $("body").append('<div class="loader"></div>');

        $(".loader").css({
            height : window.innerHeight,
            width : window.innerWidth,
        });

        $(".startcreen").animate({
            height : 0,
            opacity : 0
        }, demo.params.sleep , function() {

            // get and set demo options
            demo.params.init();

            var options = ["show_fps", "show_gui", "shadows", "dof"];
            for (var key in options) {
                if ($("#" + options[key]).attr('checked')) {
                    demo.params.set(options[key], true);
                } else {
                    demo.params.set(options[key], false);
                }
            }
            
            if (demo.params.show_gui === true)
                demo.params.trackball = true;
                

            // detect webgl
            if (!Detector.webgl) {
                demo.osd.add('WebGL ERROR', Detector.getWebGLErrorMessage());
                return false;
            } else {
                demo.osd.add('WebGL', 'ok');
            }

            // if music enabled
            if (demo.params.music === true) {
                demo.music.load(demo.start);
            } else {
                demo.start();
            }

            $(".startcreen").hide();

        });

    });

    $(".startcreen").show().animate({
        opacity : 1
    }, demo.params.sleep);

});

