/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.App;
import gui.menus.PopupResource;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.swing.JPanel;
import javax.swing.UIManager;
import model.Resource;
import model.Resources;
import opengl.Renderer;
import scene.Camera;

public class ViewResources
extends JPanel {
    ViewResources view = this;
    Resources resources = Resources.getInstance();
    float opacity = 0.0f;
    float opacityMax = 1.0f;
    public Image off;
    public Graphics2D g2;
    public Resource selected = null;
    private Point2D startDrag;

    public ViewResources(Resources resources2) {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }

            @Override
            public void mouseDragged(MouseEvent arg0) {
                if (ViewResources.this.selected != null) {
                    double x = ViewResources.this.selected.getPosition().getX() + ((double)arg0.getX() - ViewResources.this.startDrag.getX());
                    double y = ViewResources.this.selected.getPosition().getY() + ((double)arg0.getY() - ViewResources.this.startDrag.getY());
                    ViewResources.this.selected.setPosition(new Point2D.Double(x, y));
                    ViewResources.this.updateUI();
                    ViewResources.this.startDrag = arg0.getPoint();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupResource popup = new PopupResource(ViewResources.this.view, ViewResources.this.selected);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                ViewResources.this.selected = ViewResources.this.getElementAt(event.getPoint());
                ViewResources.this.startDrag = event.getPoint();
                if (ViewResources.this.selected != null) {
                    if (ViewResources.this.selected.getTexture() != null) {
                        Renderer.getInstance().setCamera(null);
                        Renderer.getInstance().getGlu().gluPerspective(45.0f, 1.7777778f, 0.11f, 10.0f);
                        Renderer.getInstance().setGLobjectToDraw(ViewResources.this.selected.getTexture());
                    }
                    if (ViewResources.this.selected.getModel() != null) {
                        Renderer.getInstance().getGL2().getContext().makeCurrent();
                        Renderer.getInstance().getGlu().gluPerspective(45.0f, 1.7777778f, 0.11f, 10.0f);
                        Camera camModel = new Camera();
                        Renderer.getInstance().setCamera(camModel);
                        GL2 gl = Renderer.getInstance().getGL2();
                        gl.glDisable(3553);
                        gl.glEnable(2896);
                        gl.glEnable(16384);
                        gl.glEnable(2929);
                        Renderer.getInstance().setGLobjectToDraw(ViewResources.this.selected.getModel());
                    }
                    App.frame.paintAll(App.frame.getGraphics());
                    ViewResources.this.opacity = 0.0f;
                }
                ViewResources.this.updateUI();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
    }

    private Resource getElementAt(Point point) {
        FontMetrics metrics = this.g2.getFontMetrics();
        for (Resource r : this.resources.getResources()) {
            Point2D p = r.getPosition();
            int width = metrics.stringWidth(r.getName());
            Rectangle2D.Double s = new Rectangle2D.Double(p.getX(), p.getY(), width, 32.0);
            if (!s.contains(point)) continue;
            return r;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g != null) {
            Color backColor = UIManager.getColor("InternalFrame.background");
            backColor = Color.DARK_GRAY;
            this.g2 = (Graphics2D)g;
            this.g2.setBackground(backColor);
            this.g2.clearRect(0, 0, this.getWidth(), this.getHeight());
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics metrics = g.getFontMetrics();
            for (Resource r : this.resources.getResources()) {
                Point2D p = r.getPosition();
                int width = metrics.stringWidth(r.getName());
                Point2D startPoint = p;
                Point2D.Double endPoint = new Point2D.Double(p.getX() + (double)(width * 2), p.getY() + 32.0);
                Color back = null;
                if (r.getModel() != null) {
                    back = new Color(144, 188, 255);
                }
                if (r.getTexture() != null) {
                    back = new Color(144, 255, 188);
                }
                GradientPaint gradientPaint = new GradientPaint(startPoint, back, endPoint, this.getBackground(), false);
                this.g2.setPaint(gradientPaint);
                this.g2.fillRect((int)p.getX() - 3, (int)p.getY() - 3, width + 6, 38);
                this.g2.setColor(Color.black);
                this.g2.drawRect((int)p.getX() - 2, (int)p.getY() - 2, width + 4, 36);
                this.g2.drawString(r.getName(), (int)p.getX(), (int)p.getY() + metrics.getHeight());
            }
            if (this.selected != null) {
                Point2D p = this.selected.getPosition();
                int width = metrics.stringWidth(this.selected.getName());
                this.g2.setColor(Color.red);
                this.g2.drawRect((int)this.selected.getPosition().getX(), (int)this.selected.getPosition().getY(), width, 32);
            }
        }
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }
}

