/*
 * Decompiled with CFR 0.152.
 */
package sound;

import org.jouvieje.Fmod.Exceptions.InitException;
import org.jouvieje.Fmod.Fmod;
import org.jouvieje.Fmod.Init;
import org.jouvieje.Fmod.Structures.FSOUND_STREAM;

public class Audio {
    static FSOUND_STREAM masterStream = null;
    public int pos = 0;
    private static Audio instance = null;

    public static FSOUND_STREAM getMasterStream() {
        return masterStream;
    }

    public static void setMasterStream(FSOUND_STREAM masterStream) {
        Audio.masterStream = masterStream;
    }

    public Audio() {
        try {
            Init.loadLibraries();
        }
        catch (InitException e) {
            e.printStackTrace();
        }
        Fmod.FSOUND_Init((int)44100, (int)32, (int)0);
    }

    public static Audio getInstance() {
        if (instance == null) {
            instance = new Audio();
        }
        return instance;
    }

    public void loadMasterMusic(String filename) {
        if (masterStream == null) {
            masterStream = Fmod.FSOUND_Stream_Open((String)filename, (int)0, (int)0, (int)0);
        } else {
            Fmod.FSOUND_Stream_Stop((FSOUND_STREAM)masterStream);
            Fmod.FSOUND_Stream_Close((FSOUND_STREAM)masterStream);
            masterStream = Fmod.FSOUND_Stream_Open((String)filename, (int)0, (int)0, (int)0);
        }
    }

    public void playMasterMusic() {
        if (masterStream != null) {
            Fmod.FSOUND_Stream_SetPosition((FSOUND_STREAM)masterStream, (int)this.pos);
            Fmod.FSOUND_Stream_Play((int)0, (FSOUND_STREAM)masterStream);
        }
    }

    public void stopMasterMusic() {
        if (masterStream != null) {
            this.pos = Fmod.FSOUND_Stream_GetPosition((FSOUND_STREAM)masterStream);
            Fmod.FSOUND_Stream_Stop((FSOUND_STREAM)masterStream);
        }
    }

    public float getTime() {
        float f = Fmod.FSOUND_Stream_GetTime((FSOUND_STREAM)masterStream);
        return f / 100.0f;
    }

    public void setTime(double currentTime) {
        Fmod.FSOUND_Stream_SetTime((FSOUND_STREAM)masterStream, (int)((int)(currentTime * 100.0)));
    }

    public boolean isMasterPlaying() {
        return Fmod.FSOUND_IsPlaying((int)0);
    }

    public float getLength() {
        return (float)Fmod.FSOUND_Stream_GetLengthMs((FSOUND_STREAM)masterStream) / 100.0f;
    }

    public float getMasterFreQ() {
        return Fmod.FSOUND_GetFrequency((int)0);
    }
}

