/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import model.Project;
import opengl.Renderer;
import scene.Camera;
import scene.CameraLookat;
import scene.Entity;
import scene.Scene;
import timeline.TimeEntity;
import variables.CameraID;
import variables.MyLine;
import variables.SceneID;
import variables.Toggle;
import variables.Variable;

public class TimeEntitiyScene
extends TimeEntity {
    private SceneID sceneID = new SceneID();
    private CameraID cameraID = new CameraID();
    private MyLine cameraTime = new MyLine("Cam Time", 0.0, 1.0);
    private Toggle depthToggle = new Toggle("Depth pass");
    private Toggle normalToggle = new Toggle("Normal pass");
    private Toggle colorToggle = new Toggle("Color(OGL) pass");
    private Toggle ssaoToggle = new Toggle("SSAO pass");
    private MyLine ao_darken = new MyLine("AO.darken", 1.0, 3.0);
    private MyLine ao_min_depth = new MyLine("AO.min.depth", 0.26, 5.0);
    private MyLine ao_depth_mult = new MyLine("AO.depth.multiplier", 62.0, 110.0);
    private MyLine ao_min_normal = new MyLine("AO.min.normal", 0.25, 0.7);
    private MyLine ao_s = new MyLine("AO.direction", 0.12, 1.0);
    private MyLine ao_rad = new MyLine("AO.ray length", 0.014, 0.1);
    private MyLine ao_blur_strength = new MyLine("AO.blur strength", 0.025, 0.1);
    private MyLine ao_blur_min_normal = new MyLine("AO.blur.min.normal", 0.1, 2.0);

    public TimeEntitiyScene() {
        this.name = "Scene";
        this.cameraTime.points.add(new Point2D.Double(500.0, 0.0));
        this.cameraTime.points.get(0).setLocation(0.0, 250.0);
    }

    private void screenQuad(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl.glLoadIdentity();
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3d(-1.0, -1.0, 0.0);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3d(-1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3d(1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3d(1.0, -1.0, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glPopMatrix();
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        gl.glEnable(2977);
        gl.glPushAttrib(1048575);
        gl.glActiveTexture(33984);
        Scene scene = Project.getInstance().getSceneByID(this.sceneID.ID);
        float time2 = (float)(500.0 * ((double)poz - this.startTime) / (this.endTime - this.startTime));
        Renderer.getInstance().setCamera(null);
        Renderer.getInstance().currentShader = null;
        float time = (float)Math.abs(-this.cameraTime.getScaledValue(time2));
        if (time > 1.0f) {
            time = 1.0f;
        }
        time *= 500.0f;
        poz = time2;
        gl.glLoadIdentity();
        if (scene == null) {
            if (Project.getInstance().getScenes().size() > 0) {
                scene = Project.getInstance().getScenes().get(0);
                this.sceneID.ID = scene.getId();
            }
        } else {
            Entity cam = scene.getEntityByID(this.cameraID.ID);
            if (cam == null) {
                cam = scene.getCamera(0);
            }
            if (cam != null) {
                if (cam.getClass() == Camera.class) {
                    ((Camera)cam).Push(gl, time);
                }
                if (cam.getClass() == CameraLookat.class) {
                    ((CameraLookat)cam).Push(gl, time);
                }
            }
            scene.enableLights(gl, time);
            MyShaderProgram sceneShader = null;
            Renderer.getInstance().setUseShaders(true);
            Renderer.getInstance().renderLayer = Renderer.RENDER_LAYER.COLOR;
            if (this.colorToggle.getBool()) {
                sceneShader = null;
                scene.glDraw(gl, time);
                Renderer.getInstance().colorBuffer.renderToTexture();
            }
            Renderer.getInstance().setUseShaders(false);
            gl.glDisable(2896);
            gl.glDisable(3042);
            gl.glEnable(3553);
            gl.glDisable(2929);
            scene.disableLights(gl);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.normalToggle.getBool()) {
                Renderer.getInstance().currentShader = Renderer.getInstance().getAO_normal();
                Renderer.getInstance().renderLayer = Renderer.RENDER_LAYER.NORMAL;
                gl.glClear(16384);
                gl.glClear(256);
                sceneShader = Renderer.getInstance().getAO_normal();
                sceneShader.bind(true);
                scene.glDraw(gl, time);
                sceneShader.bind(false);
                Renderer.getInstance().normalBuffer.renderToTexture();
            }
            gl.glClear(16384);
            gl.glDisable(2896);
            gl.glDisable(3042);
            gl.glEnable(3553);
            gl.glDisable(2929);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glActiveTexture(33984);
            if (this.depthToggle.getBool()) {
                Renderer.getInstance().currentShader = Renderer.getInstance().getAO_depth();
                Renderer.getInstance().renderLayer = Renderer.RENDER_LAYER.DEPTH;
                gl.glClear(16384);
                gl.glClear(256);
                sceneShader = Renderer.getInstance().getAO_depth();
                sceneShader.bind(true);
                scene.glDraw(gl, time);
                sceneShader.bind(false);
                Renderer.getInstance().depthBuffer.renderToTexture();
            }
            gl.glClear(16384);
            gl.glClear(256);
            gl.glClear(16384);
            gl.glDisable(2896);
            gl.glDisable(3042);
            gl.glEnable(3553);
            gl.glDisable(2929);
            if (this.ssaoToggle.getBool()) {
                Renderer.getInstance().renderLayer = Renderer.RENDER_LAYER.SSAO;
                Renderer.getInstance().currentShader = Renderer.getInstance().getAO_Shader();
                sceneShader = Renderer.getInstance().getAO_Shader();
                sceneShader.bind(true);
                int uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "s");
                gl.glUniform1f(uloc, (float)(-this.ao_s.getScaledValue(poz)));
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "rad");
                gl.glUniform1f(uloc, (float)(-this.ao_rad.getScaledValue(poz)));
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "min_normaldist");
                gl.glUniform1f(uloc, (float)(-this.ao_min_normal.getScaledValue(poz)));
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "min_depthdist");
                gl.glUniform1f(uloc, (float)(-this.ao_min_depth.getScaledValue(poz)));
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "depth_mult");
                gl.glUniform1f(uloc, (float)(-this.ao_depth_mult.getScaledValue(poz)));
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "amount");
                gl.glUniform1f(uloc, 1.0f);
                gl.glActiveTexture(33984);
                Renderer.getInstance().depthBuffer.bind();
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "depthpacked");
                gl.glUniform1i(uloc, 0);
                gl.glActiveTexture(33985);
                Renderer.getInstance().normalBuffer.bind();
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "normal");
                gl.glUniform1i(uloc, 1);
                gl.glActiveTexture(33986);
                Renderer.getInstance().colorBuffer.bind();
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "colorMap");
                gl.glUniform1i(uloc, 2);
                this.screenQuad(gl);
                sceneShader.bind(false);
                gl.glActiveTexture(33984);
                Renderer.getInstance().ssaoBuffer.renderToTexture();
                int i = 0;
                while (i < 2) {
                    sceneShader = Renderer.getInstance().getAO_blur();
                    sceneShader.bind(true);
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "strength");
                    gl.glUniform1f(uloc, (float)(-this.ao_blur_strength.getScaledValue(poz)));
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "blur_min_normal");
                    gl.glUniform1f(uloc, (float)(-this.ao_blur_min_normal.getScaledValue(poz)));
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "direction");
                    gl.glUniform1i(uloc, i);
                    gl.glActiveTexture(33984);
                    Renderer.getInstance().depthBuffer.bind();
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "depthpacked");
                    gl.glUniform1i(uloc, 0);
                    gl.glActiveTexture(33985);
                    Renderer.getInstance().normalBuffer.bind();
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "normal");
                    gl.glUniform1i(uloc, 1);
                    gl.glActiveTexture(33986);
                    Renderer.getInstance().ssaoBuffer.bind();
                    uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "ao_tex");
                    gl.glUniform1i(uloc, 2);
                    this.screenQuad(gl);
                    sceneShader.bind(false);
                    gl.glActiveTexture(33984);
                    Renderer.getInstance().ssaoBuffer.renderToTexture();
                    ++i;
                }
                sceneShader = Renderer.getInstance().getAO_mix();
                sceneShader.bind(true);
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "amount");
                gl.glUniform1f(uloc, (float)(-this.ao_darken.getScaledValue(poz)));
                gl.glActiveTexture(33984);
                Renderer.getInstance().ssaoBuffer.bind();
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "ssaoMap");
                gl.glUniform1i(uloc, 0);
                gl.glActiveTexture(33985);
                Renderer.getInstance().colorBuffer.bind();
                uloc = gl.glGetUniformLocation(sceneShader.getProgramID(), "colorMap");
                gl.glUniform1i(uloc, 1);
                this.screenQuad(gl);
                sceneShader.bind(false);
                gl.glActiveTexture(33984);
            }
            gl.glUseProgram(0);
            if (!this.ssaoToggle.getBool() && this.normalToggle.getBool()) {
                Renderer.getInstance().normalBuffer.bind();
                this.screenQuad(gl);
            }
            if (!this.ssaoToggle.getBool() && !this.normalToggle.getBool() && this.depthToggle.getBool()) {
                Renderer.getInstance().depthBuffer.bind();
                this.screenQuad(gl);
            }
            if (!this.ssaoToggle.getBool() && !this.normalToggle.getBool() && !this.depthToggle.getBool() && this.colorToggle.getBool()) {
                Renderer.getInstance().colorBuffer.bind();
                this.screenQuad(gl);
            }
            if (cam != null) {
                if (cam.getClass() == Camera.class) {
                    ((Camera)cam).Pop(gl);
                }
                if (cam.getClass() == CameraLookat.class) {
                    ((CameraLookat)cam).Pop(gl);
                }
            }
            gl.glPopAttrib();
        }
        Renderer.getInstance().setUseShaders(true);
    }

    public SceneID getSceneID() {
        return this.sceneID;
    }

    public void setSceneID(SceneID sceneID) {
        this.name = "Scene " + sceneID.ID;
        this.sceneID = sceneID;
    }

    public CameraID getCameraID() {
        return this.cameraID;
    }

    public void setCameraID(CameraID cameraID) {
        this.cameraID = cameraID;
    }

    @Override
    public ArrayList<Variable> getAttributes() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.sceneID);
        var.add(this.cameraID);
        var.add(this.cameraTime);
        var.add(this.colorToggle);
        var.add(this.depthToggle);
        var.add(this.normalToggle);
        var.add(this.ssaoToggle);
        var.add(this.ao_darken);
        var.add(this.ao_min_normal);
        var.add(this.ao_min_depth);
        var.add(this.ao_depth_mult);
        var.add(this.ao_s);
        var.add(this.ao_rad);
        var.add(this.ao_blur_min_normal);
        var.add(this.ao_blur_strength);
        return var;
    }
}

