#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D Tex;
uniform float Time;
uniform float Distortion, Distortion2;
uniform float Flash;
uniform float Mix;
uniform float Invert;

varying vec2 TexCoord;

void main()
{
	vec2 skew = vec2(pow(sin(sin(TexCoord.y * 4.0 + Time * .4) * 6.0 + cos(TexCoord.x * 3.0 + Time * .2) * 4.0), 3.0) * .03, 0) * Distortion2;
	vec4 tmp = texture2D(Tex, TexCoord + (Distortion * .001 + skew) * .4);
	vec4 c = vec4(texture2D(Tex, TexCoord + skew).r, tmp.g, tmp.b, 1) - vec4(.1, .05, 0, 0); // Reduce r & g components (helps with the polaroid feel)

	ivec2 pixelCoord = ivec2(gl_FragCoord.xy);
	if (((pixelCoord.x | pixelCoord.y) & 3) == 0) c -= .2 * TexCoord.y * Mix; // Dots

	c.g -= .2 * abs(TexCoord.y - .5) * (.6 + .4 * TexCoord.x) * Mix; // Gradient
	c -= pow(length(TexCoord - .5) * 1.7, 2.0) * .4 * Mix; // Vignette

	c += Flash;
	gl_FragData[0] = mix(c, vec4(1.0 - c.xyz, c.w), Invert);
}
