float4x4 objectToWorldMatrix;
float4x4 worldToCameraMatrix;
float4x4 projMatrix;
Texture2D txDiffuse;

float4 multiplyR;
float4 multiplyG;
float4 multiplyB;
float4 multiplyA;
float4 addition;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

BlendState NoBlend 
{
    AlphaToCoverageEnable = FALSE;
    BlendEnable[0] = FALSE;
};

struct VS_IN
{
    float4 pos : POSITION;
    float2 texCoord : TEXCOORD;
};

struct PS_IN
{
    float4 pos : SV_POSITION;
    float2 texCoord: TEXCOORD0;
};

PS_IN VS( VS_IN input )
{
    PS_IN output = (PS_IN)0;

    output.pos = mul(input.pos, worldToCameraMatrix);
    output.pos = mul(output.pos, projMatrix);
    output.texCoord = input.texCoord;

    return output;
}

float4 PS( PS_IN input ) : SV_Target
{
    float4 col = txDiffuse.Sample(samLinear, input.texCoord);
    float r = dot(col, multiplyR) + addition.r;
    float g = dot(col, multiplyG) + addition.g;
    float b = dot(col, multiplyB) + addition.b;
    float a = dot(col, multiplyA) + addition.a;
    return float4(r, g, b, a);
}

technique10 Render
{
    pass P0
    {
//        SetBlendState( NoBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
        SetGeometryShader( 0 );
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}
