#version 330

noperspective in vec3 zplane;

uniform sampler2DRect N;
uniform vec3 dir, col;

out vec3 O0, O1;

float Specular(float rough_sq, float hdotn)
{
	if(rough_sq == 0.0 || hdotn == 0.0)
		return 0.0;
	else
	{
		float hdotn_sq = hdotn * hdotn;
		float A = 1.0 / (hdotn_sq * rough_sq);
		float B = A / hdotn_sq;
		return exp(A * hdotn_sq - A) * B;
	}
}

float Diffuse(float rough_sq, float vdotn, float ldotn, vec3 V, vec3 N, vec3 L)
{
	float A = 1.0 - 0.5 * rough_sq / (rough_sq + 0.57);
	float B = 0.45 * rough_sq / (rough_sq + 0.09);
	float g = dot(V - N * vdotn, L - N * ldotn);
	float C = sqrt((1.0 - vdotn * vdotn) * (1.0 - ldotn * ldotn)) / max(vdotn, ldotn);
	return ldotn * (A + B * g * C);
}

void main()
{
	vec4 t = texture(N, gl_FragCoord.xy);
	vec3 n = normalize(t.xyz * 2.0 - 1.0);

	float rough_sq = t.a * t.a;

	float ldotn = dot(dir, n);

	if(ldotn <= 0.0)
		discard;

	vec3 v = normalize(-zplane);
	vec3 h = normalize(v + dir);

	float vdotn = max(0.0, dot(v, n));
	float hdotn = max(0.0, dot(h, n));

	O0 = col * Diffuse(rough_sq, vdotn, ldotn, v, n, dir);
	O1 = col * Specular(rough_sq, hdotn);
}
