/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;

public class CollisionEvent {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_TARGET = 0;
    public static final int TYPE_SOURCE = 1;
    public static final int ALGORITHM_RAY = 0;
    public static final int ALGORITHM_SPHERE = 1;
    public static final int ALGORITHM_ELLIPSOID = 2;
    private Object3D obj = null;
    private Object3D source = null;
    private int type = 0;
    private int algorithm = 0;
    private int[] ids = null;
    private Object3D[] targets = null;
    private SimpleVector contact = null;
    private static final String[] TYPES = new String[]{"target", "source"};
    private static final String[] ALGOS = new String[]{"ray-polygon", "sphere-polygon", "ellipsoid-polygon"};

    CollisionEvent(Object3D object3D, Object3D object3D2, int n, int n2, Object3D[] object3DArray, SimpleVector simpleVector) {
        this.obj = object3D;
        this.type = n;
        this.algorithm = n2;
        this.source = object3D2;
        this.targets = object3DArray;
        this.contact = simpleVector;
    }

    public Object3D getObject() {
        return this.obj;
    }

    public Object3D[] getTargets() {
        return this.targets;
    }

    public Object3D getSource() {
        if (this.type == 1) {
            return this.obj;
        }
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int[] getPolygonIDs() {
        if (this.type == 1) {
            return null;
        }
        return this.ids;
    }

    public SimpleVector getFirstContact() {
        if (this.type == 1) {
            return null;
        }
        return this.contact;
    }

    public String toString() {
        return "Object: " + this.obj.getName() + "/" + TYPES[this.type] + "/" + ALGOS[this.algorithm];
    }

    void setPolygonIDs(int[] nArray, int n) {
        if (nArray != null) {
            this.ids = new int[n];
            System.arraycopy(nArray, 0, this.ids, 0, n);
        }
    }
}

