/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.GLBase;
import com.threed.jpct.GLSLShader;
import com.threed.jpct.GenericContainer;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IRenderHook;
import com.threed.jpct.IRenderer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.World;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;

class CompiledInstance
implements ICompiledInstance {
    private static final Object SYNC = new Object();
    private static final int NO_RENDERER = -999999999;
    private static final long serialVersionUID = 1L;
    public static Object3D lastObj = null;
    public static FloatBuffer lastVertexBuffer = null;
    public static int lastVertexBufferId = -1;
    public static double chkSum = 0.0;
    public static int lastLightCnt = 0;
    public static int lastGlobalRenderer = -1;
    public static boolean texGenEnabled = false;
    public boolean useDL = true;
    public boolean dynamic = false;
    protected static int[] stageMap = new int[]{33984, 33985, 33986, 33987};
    private static final float[] ALL_ONES = new float[]{1.0f, 1.0f, 1.0f};
    private static final int[] LIGHTS = new int[]{16384, 16385, 16386, 16387, 16388, 16389, 16390, 16391};
    private static float mpi = (float)Math.PI;
    private boolean mayShare = true;
    private FloatBuffer floatBuffer64 = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private FloatBuffer floatBuffer16_2 = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private FloatBuffer floatBuffer16_3 = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final FloatBuffer ZEROS_ONE = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    Object3D obj;
    private FloatBuffer normals;
    private FloatBuffer tangents;
    private FloatBuffer vertices;
    private FloatBuffer colors;
    private IntBuffer indices;
    private FloatBuffer[] multiTextures;
    private List tris;
    private int cnt;
    private int polyIndex;
    private int endStage;
    private boolean indexed;
    private boolean staticUV;
    private int treeID;
    private Matrix m3;
    private Matrix mat;
    private Matrix mo;
    private String key;
    private int listID;
    private int tex0;
    private int tex1;
    private int lastTex0;
    private int lastTex1;
    private Map vertex2index;
    private int rendererID;
    private IRenderer lastRenderer;
    private boolean filled;
    private float[] m3mat;
    private float[] dumpy;
    private boolean needsCoordMapper;
    private int[] coordMapper;
    private float[] vcoords;
    private float[] ncoords;
    private TextureManager tm;
    private boolean useVBO;
    private int normalsId;
    private int tangentsId;
    private int verticesId;
    private int colorsId;
    private int indicesId;
    private int[] multiTexturesIds;
    private boolean buffersCreated;
    private boolean vboPossible;
    private int indexCount;
    protected boolean hasBeenRefilled;
    private int useStrip;
    private int primitiveType;

    CompiledInstance(Object3D object3D, int n, int n2) {
        this.ZEROS_ONE.put(0.0f);
        this.ZEROS_ONE.put(0.0f);
        this.ZEROS_ONE.put(0.0f);
        this.ZEROS_ONE.put(1.0f);
        this.obj = null;
        this.normals = null;
        this.tangents = null;
        this.vertices = null;
        this.colors = null;
        this.indices = null;
        this.multiTextures = null;
        this.tris = new ArrayList();
        this.cnt = 0;
        this.polyIndex = 0;
        this.endStage = 0;
        this.indexed = true;
        this.staticUV = true;
        this.treeID = -1;
        this.m3 = new Matrix();
        this.mat = new Matrix();
        this.mo = new Matrix();
        this.key = null;
        this.listID = 0;
        this.tex0 = -1;
        this.tex1 = -1;
        this.lastTex0 = -99;
        this.lastTex1 = -99;
        this.vertex2index = null;
        this.rendererID = -999999999;
        this.lastRenderer = null;
        this.filled = false;
        this.m3mat = this.m3.mat[3];
        this.dumpy = new float[16];
        this.needsCoordMapper = true;
        this.coordMapper = null;
        this.vcoords = null;
        this.ncoords = null;
        this.tm = TextureManager.getInstance();
        this.useVBO = Config.glUseVBO;
        this.normalsId = 0;
        this.tangentsId = 0;
        this.verticesId = 0;
        this.colorsId = 0;
        this.indicesId = 0;
        this.multiTexturesIds = null;
        this.buffersCreated = false;
        this.vboPossible = true;
        this.indexCount = 0;
        this.hasBeenRefilled = false;
        this.useStrip = Config.glTriangleStrips ? 0 : 2;
        this.primitiveType = 4;
        this.obj = object3D;
        this.polyIndex = n;
        this.treeID = n2;
        this.dynamic = object3D.dynamic;
        this.useDL = (!this.dynamic || this.useVBO && Config.glUseDynamicVBO) && object3D.preferDLOrVBO;
        this.indexed = object3D.indexed;
        this.staticUV = object3D.staticUV;
    }

    void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public int getTreeID() {
        return this.treeID;
    }

    public int getPolyIndex() {
        return this.polyIndex;
    }

    public int getStageCount() {
        return this.endStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(IRenderer iRenderer) {
        Object object = SYNC;
        synchronized (object) {
            this.unloadDL(iRenderer);
            this.unloadVBO(iRenderer);
            if (this.obj.renderHook != null) {
                this.obj.renderHook.onDispose();
            }
        }
    }

    private void unloadVBO(IRenderer iRenderer) {
        if (this.buffersCreated) {
            try {
                if (iRenderer instanceof GLBase) {
                    if (this.obj.shareWith == null) {
                        GLBase gLBase = (GLBase)((Object)iRenderer);
                        gLBase.removeBuffer(this.normalsId);
                        gLBase.removeBuffer(this.verticesId);
                        gLBase.removeBuffer(this.tangentsId);
                        gLBase.removeBuffer(this.colorsId);
                        gLBase.removeBuffer(this.indicesId);
                        for (int i = 0; i < this.endStage; ++i) {
                            gLBase.removeBuffer(this.multiTexturesIds[i]);
                        }
                    }
                    this.buffersCreated = false;
                }
            }
            catch (Throwable throwable) {
                Logger.log("Failed to delete VBOs!", 1);
            }
        }
    }

    private void unloadDL(IRenderer iRenderer) {
        if (this.listID != 0) {
            try {
                if (iRenderer instanceof GLBase) {
                    if (this.obj.shareWith == null) {
                        ((GLBase)((Object)iRenderer)).remove(this.listID);
                    }
                    this.listID = 0;
                }
            }
            catch (Throwable throwable) {
                Logger.log("Failed to delete display list: " + this.listID, 1);
            }
        }
    }

    void copy(CompiledInstance compiledInstance) {
        this.listID = compiledInstance.listID;
        this.colors = compiledInstance.colors;
        this.tris = compiledInstance.tris;
        this.normals = compiledInstance.normals;
        this.indices = compiledInstance.indices;
        this.vertices = compiledInstance.vertices;
        this.multiTextures = compiledInstance.multiTextures;
        this.vertex2index = compiledInstance.vertex2index;
        this.polyIndex = compiledInstance.polyIndex;
        this.useDL = compiledInstance.useDL;
        this.dynamic = compiledInstance.dynamic;
        this.cnt = compiledInstance.cnt;
        this.endStage = compiledInstance.endStage;
        this.indexed = compiledInstance.indexed;
        this.staticUV = compiledInstance.staticUV;
        this.treeID = compiledInstance.treeID;
        this.key = compiledInstance.key;
        this.primitiveType = compiledInstance.primitiveType;
        this.buffersCreated = compiledInstance.buffersCreated;
        this.verticesId = compiledInstance.verticesId;
        this.normalsId = compiledInstance.normalsId;
        this.tangentsId = compiledInstance.tangentsId;
        this.indicesId = compiledInstance.indicesId;
        this.vboPossible = compiledInstance.vboPossible;
        this.colorsId = compiledInstance.colorsId;
        this.indexCount = compiledInstance.indexCount;
        this.useVBO = compiledInstance.useVBO;
        if (compiledInstance.multiTexturesIds != null) {
            this.multiTexturesIds = new int[compiledInstance.multiTexturesIds.length];
            for (int i = 0; i < compiledInstance.multiTexturesIds.length; ++i) {
                this.multiTexturesIds[i] = compiledInstance.multiTexturesIds[i];
            }
        }
        if (this.buffersCreated) {
            Logger.log("Object '" + this.obj.getName() + "' shares VBOs with object '" + this.obj.shareWith.getName() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render(int n, GLBase gLBase, FloatBuffer floatBuffer, float[] fArray, boolean bl, Camera camera, float[][] fArray2, boolean bl2, Object[] objectArray) {
        Object object = SYNC;
        synchronized (object) {
            IRenderHook iRenderHook;
            int n2;
            int n3;
            boolean bl3;
            Object object2;
            int n4;
            int n5;
            boolean bl4;
            if (n != lastGlobalRenderer) {
                lastObj = null;
                lastVertexBuffer = null;
                chkSum = 0.0;
                lastLightCnt = 0;
                lastGlobalRenderer = n;
            }
            Matrix matrix = null;
            World world = this.obj.myWorld;
            if (world == null) {
                return;
            }
            boolean bl5 = this.obj.reverseCulling ^ world.invertCulling;
            boolean bl6 = bl4 = this.tangents != null || this.tangentsId != 0;
            if (objectArray != null) {
                matrix = (Matrix)objectArray[0];
                bl5 = (Boolean)objectArray[1];
            }
            if (this.obj.shareWith != null && !this.obj.sharing) {
                if (this.obj.shareWith.compiled == null) {
                    Logger.log("Can't use an uncompiled object as a source for compiled data!", 0);
                    return;
                }
                n5 = ((CompiledInstance)this.obj.shareWith.compiled.get((int)0)).rendererID;
                if (n5 != -999999999 && n5 != n && this.useDL) {
                    Logger.log("Master object has been compiled within a different gl context...can't share data with it, skipping rendering!", 0);
                    return;
                }
                if (this.mayShare) {
                    this.obj.sharing = true;
                    if (this.obj.compiled.size() != this.obj.shareWith.compiled.size()) {
                        Logger.log("Number of compiled instances don't match...can't share data!", 0);
                        return;
                    }
                    for (n4 = 0; n4 < this.obj.compiled.size(); n4 += 1) {
                        object2 = (CompiledInstance)this.obj.compiled.get(n4);
                        CompiledInstance compiledInstance = (CompiledInstance)this.obj.shareWith.compiled.get(n4);
                        if (this.useVBO && this.vboPossible && !this.dynamic) {
                            compiledInstance.compileToVBO();
                        }
                        object2.copy(compiledInstance);
                        object2.filled = true;
                    }
                    this.floatBuffer16_3.put(ALL_ONES);
                    this.floatBuffer16_3.put(1.0f);
                    ((Buffer)this.floatBuffer16_3).rewind();
                    Logger.log("Object '" + this.obj.getName() + "' shares compiled data with object '" + this.obj.shareWith.getName() + "'", 2);
                }
            }
            if (!this.filled) {
                Logger.log("render() called on an uncompiled object (" + this.obj.getName() + ")!", 0);
                return;
            }
            if (world == null || this.useDL && this.listID == 0 && !this.buffersCreated) {
                return;
            }
            n5 = world.lights.lightCnt;
            n4 = this.obj.hasVertexAlpha();
            gLBase.endState();
            if (floatBuffer != null) {
                ((Buffer)floatBuffer).rewind();
            }
            if (this.rendererID == -999999999) {
                this.rendererID = n;
            } else if (this.rendererID != n && this.useDL && (this.listID != 0 || this.buffersCreated)) {
                if (this.lastRenderer != null && !this.obj.sharing) {
                    this.dispose(this.lastRenderer);
                }
                this.listID = 0;
                this.buffersCreated = false;
                Logger.log("OpenGL context has changed...trying to recover by reverting to normal VAs", 1);
            }
            this.lastRenderer = (IRenderer)((Object)gLBase);
            object2 = null;
            boolean bl7 = bl3 = this.obj.compiled.size() > 1;
            if (bl3) {
                object2 = (float[])gLBase.matrixCache.get(this.obj);
            }
            if (object2 == null) {
                if (matrix != null) {
                    this.mo.setTo(matrix);
                } else {
                    this.mo.setTo(this.obj.transBuffer);
                }
                this.mat.setTo(camera.getBack());
                this.mat.transformToGL();
                this.mo.translate(-camera.backBx, -camera.backBy, -camera.backBz);
                this.mo.matMul(this.mat);
                object2 = this.mo.fillDump(this.dumpy);
                if (bl3) {
                    gLBase.matrixCache.put(this.obj, object2);
                }
            }
            this.floatBuffer64.put((float[])object2);
            ((Buffer)this.floatBuffer64).rewind();
            GL11.glMatrixMode(5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            boolean bl8 = false;
            if (this.obj.doCulling) {
                if (bl5) {
                    GL11.glCullFace(1028);
                    bl8 = true;
                }
            } else {
                GL11.glDisable(2884);
            }
            if (!bl2) {
                float[] fArray3;
                if (n4) {
                    fArray[3] = 1.0f;
                }
                this.floatBuffer16_2.put(fArray);
                ((Buffer)this.floatBuffer16_2).rewind();
                GL11.glLightModel(2899, floatBuffer);
                GL11.glMaterial(1032, 5632, this.floatBuffer16_2);
                double d = 0.0;
                for (n3 = 0; n3 < n5 && n3 < 8 && (fArray3 = fArray2[n3])[0] != -9999.0f; ++n3) {
                    d += ((double)n3 + (double)0.7181f) * (double)fArray3[0];
                    d += ((double)n3 + (double)1.1f) * (double)fArray3[1];
                    d += ((double)n3 + (double)2.24f) * (double)fArray3[2];
                    d += ((double)n3 + (double)3.567f) * (double)fArray3[3];
                    d += ((double)n3 + (double)9.7272f) * (double)(fArray3[4] + 1.4f * fArray3[5] + 4.56f * fArray3[6]);
                }
                if (n4) {
                    GL11.glColorMaterial(1032, 4609);
                    GL11.glEnable(2903);
                }
                if (chkSum != d || lastObj != this.obj) {
                    GL11.glMaterial(1032, 4608, this.floatBuffer16_3);
                    this.floatBuffer16_2.put(ALL_ONES);
                    ((Buffer)this.floatBuffer16_2).rewind();
                    GL11.glMaterial(1032, 4609, this.floatBuffer16_2);
                    GL11.glMaterial(1032, 4610, this.floatBuffer16_2);
                    GL11.glLightModeli(2897, 1);
                    if (n5 < lastLightCnt) {
                        for (n3 = 0; n3 < lastLightCnt; ++n3) {
                            GL11.glDisable(LIGHTS[n3]);
                        }
                    }
                    lastLightCnt = 0;
                    for (n3 = 0; n3 < n5 && n3 < 8; ++n3) {
                        boolean bl9;
                        fArray3 = fArray2[n3];
                        int n6 = LIGHTS[n3];
                        if (fArray3[0] == -9999.0f) {
                            GL11.glDisable(n6);
                            continue;
                        }
                        ++lastLightCnt;
                        boolean bl10 = bl9 = chkSum != d || lastObj != this.obj;
                        if (bl9) {
                            GL11.glEnable(n6);
                            this.floatBuffer16_2.put(fArray3[1]);
                            this.floatBuffer16_2.put(fArray3[2]);
                            this.floatBuffer16_2.put(fArray3[3]);
                            this.floatBuffer16_2.put(1.0f);
                            ((Buffer)this.floatBuffer16_2).rewind();
                            GL11.glLight(n6, 4611, this.floatBuffer16_2);
                            this.floatBuffer16_2.put(fArray3[4]);
                            this.floatBuffer16_2.put(fArray3[5]);
                            this.floatBuffer16_2.put(fArray3[6]);
                            this.floatBuffer16_2.put(1.0f);
                            ((Buffer)this.floatBuffer16_2).rewind();
                            GL11.glLight(n6, 4609, this.floatBuffer16_2);
                            ((Buffer)this.ZEROS_ONE).rewind();
                            GL11.glLight(n6, 4608, this.ZEROS_ONE);
                            if (fArray3[0] >= 0.0f) {
                                float f = fArray3[0];
                                if (f == 0.0f) {
                                    f = 0.001f;
                                }
                                GL11.glLightf(n6, 4616, 4.0f / f);
                            } else {
                                GL11.glLightf(n6, 4616, 0.0f);
                            }
                        }
                        if (!this.obj.doSpecularLighting) {
                            ((Buffer)this.ZEROS_ONE).rewind();
                            GL11.glLight(n6, 4610, this.ZEROS_ONE);
                            continue;
                        }
                        GL11.glMateriali(1032, 5633, (int)(Config.specPow / 2.0f));
                        if (!bl9) {
                            this.floatBuffer16_2.put(fArray3[4]);
                            this.floatBuffer16_2.put(fArray3[5]);
                            this.floatBuffer16_2.put(fArray3[6]);
                            this.floatBuffer16_2.put(1.0f);
                            ((Buffer)this.floatBuffer16_2).rewind();
                        }
                        GL11.glLight(n6, 4610, this.floatBuffer16_2);
                    }
                    chkSum = d;
                    lastObj = this.obj;
                }
                if (this.obj.isFlatShaded) {
                    GL11.glShadeModel(7424);
                }
            } else {
                GL11.glDisable(2896);
            }
            GL11.glLoadMatrix(this.floatBuffer64);
            if (bl) {
                GL11.glMatrixMode(5889);
                GL11.glPushMatrix();
                GL11.glTranslatef(0.0f, 0.0f, -Config.glShadowZBias);
            }
            boolean bl11 = false;
            if (!this.useDL || this.listID == 0 && !this.buffersCreated) {
                if (lastVertexBuffer != this.vertices) {
                    lastVertexBuffer = this.vertices;
                    GL11.glNormalPointer(12, this.normals);
                    GL11.glVertexPointer(3, 12, this.vertices);
                    GL11.glEnableClientState(32885);
                    GL11.glEnableClientState(32884);
                    if (!n4) {
                        GL11.glDisableClientState(32886);
                        bl11 = true;
                    } else {
                        GL11.glColorPointer(4, 16, this.colors);
                        GL11.glEnableClientState(32886);
                        bl11 = false;
                    }
                    for (n2 = 0; n2 < this.endStage; ++n2) {
                        ARBMultitexture.glClientActiveTextureARB(stageMap[n2]);
                        GL11.glEnableClientState(32888);
                        GL11.glTexCoordPointer(2, 8, this.multiTextures[n2]);
                    }
                    if (!bl4) {
                        this.clearTangents(this.obj.renderHook);
                    } else {
                        this.setTangents(this.obj.renderHook);
                    }
                } else {
                    if (!n4) {
                        GL11.glDisableClientState(32886);
                        bl11 = true;
                    } else {
                        GL11.glEnableClientState(32886);
                        bl11 = false;
                    }
                    if (!bl4) {
                        this.clearTangents(this.obj.renderHook);
                    } else {
                        this.setTangents(this.obj.renderHook);
                    }
                }
            }
            if (!(bl2 || !this.obj.isEnvmapped || Config.glForceEnvMapToSecondStage && this.endStage <= 1)) {
                if (this.tex0 == -1 || this.obj.texture[this.polyIndex] != this.lastTex0) {
                    this.lastTex0 = this.obj.texture[this.polyIndex];
                    this.tex0 = this.tm.getTextureByID(this.lastTex0).getOpenGLID(n);
                }
                if (Config.glForceEnvMapToSecondStage && (this.tex1 == -1 || this.obj.multiTex[0][this.polyIndex] != this.lastTex1) && this.endStage > 1) {
                    this.lastTex1 = this.obj.multiTex[0][this.polyIndex];
                    this.tex1 = this.tm.getTextureByID(this.lastTex1).getOpenGLID(n);
                }
                n2 = this.tex0;
                n3 = 0;
                if (Config.glForceEnvMapToSecondStage) {
                    n2 = this.tex1;
                    n3 = 1;
                }
                if (gLBase.lastTextures[n3] != n2) {
                    gLBase.bindTexture(n3, n2, false);
                }
                if (!texGenEnabled) {
                    GL11.glTexGeni(8192, 9472, 9218);
                    GL11.glTexGeni(8193, 9472, 9218);
                    GL11.glEnable(3168);
                    GL11.glEnable(3169);
                    texGenEnabled = true;
                }
            } else if (texGenEnabled) {
                GL11.glDisable(3168);
                GL11.glDisable(3169);
                texGenEnabled = false;
            }
            if ((iRenderHook = this.obj.renderHook) != null) {
                iRenderHook.setCurrentObject3D(this.obj);
                iRenderHook.beforeRendering(this.polyIndex);
                gLBase.lastHook = iRenderHook;
            }
            if (this.useVBO && this.buffersCreated) {
                this.renderVBO(n4 != 0, iRenderHook);
            } else {
                do {
                    if (this.useDL && this.listID != 0) {
                        GL11.glCallList(this.listID);
                        continue;
                    }
                    if (this.indexed) {
                        GL11.glDrawElements(this.primitiveType, this.indices);
                        continue;
                    }
                    GL11.glDrawArrays(this.primitiveType, 0, this.cnt);
                } while (iRenderHook != null && iRenderHook.repeatRendering());
                lastVertexBufferId = -1;
            }
            if (iRenderHook != null) {
                iRenderHook.afterRendering(this.polyIndex);
            }
            GL11.glMatrixMode(5888);
            GL11.glPopMatrix();
            if (bl) {
                GL11.glMatrixMode(5889);
                GL11.glPopMatrix();
            }
            if (n4) {
                GL11.glDisable(2903);
            }
            if (bl11) {
                GL11.glEnableClientState(32886);
            }
            if (bl8) {
                GL11.glCullFace(1029);
            }
            if (this.obj.isFlatShaded) {
                GL11.glShadeModel(7425);
            }
            if (bl2) {
                GL11.glEnable(2896);
            }
            if (!this.obj.doCulling) {
                GL11.glEnable(2884);
            }
        }
    }

    private void renderVBO(boolean bl, IRenderHook iRenderHook) {
        boolean bl2;
        this.compileToVBO();
        boolean bl3 = bl2 = this.tangents != null || this.tangentsId != 0;
        if (lastVertexBufferId != this.verticesId) {
            lastVertexBufferId = this.verticesId;
            GL11.glEnableClientState(32885);
            GL15.glBindBuffer(34962, this.normalsId);
            GL11.glNormalPointer(5126, 0, 0L);
            GL11.glEnableClientState(32884);
            GL15.glBindBuffer(34962, this.verticesId);
            GL11.glVertexPointer(3, 5126, 0, 0L);
            if (!bl) {
                GL11.glDisableClientState(32886);
            } else {
                GL15.glBindBuffer(34962, this.colorsId);
                GL11.glEnableClientState(32886);
                GL11.glColorPointer(4, 5126, 0, 0L);
            }
            if (!bl2) {
                this.clearTangents(iRenderHook);
            } else {
                this.setTangents(iRenderHook);
            }
            for (int i = 0; i < this.endStage; ++i) {
                ARBMultitexture.glClientActiveTextureARB(stageMap[i]);
                GL11.glEnableClientState(32888);
                GL15.glBindBuffer(34962, this.multiTexturesIds[i]);
                GL11.glTexCoordPointer(2, 5126, 0, 0L);
            }
            GL15.glBindBuffer(34962, 0);
        } else {
            if (!bl) {
                GL11.glDisableClientState(32886);
            } else {
                GL15.glBindBuffer(34962, this.colorsId);
                GL11.glEnableClientState(32886);
                GL11.glColorPointer(4, 5126, 16, 0L);
                GL15.glBindBuffer(34962, 0);
            }
            if (!bl2) {
                this.clearTangents(iRenderHook);
            } else {
                this.setTangents(iRenderHook);
            }
        }
        do {
            if (this.indexed) {
                GL15.glBindBuffer(34963, this.indicesId);
                GL11.glDrawElements(this.primitiveType, this.indexCount, 5125, 0L);
                GL15.glBindBuffer(34963, 0);
                continue;
            }
            GL11.glDrawArrays(this.primitiveType, 0, this.cnt);
        } while (iRenderHook != null && iRenderHook.repeatRendering());
        lastVertexBuffer = null;
    }

    private void clearTangents(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            gLSLShader.clearTangents(this.tangents, this.tangentsId);
        }
    }

    private void setTangents(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            gLSLShader.setTangents(this.tangents, this.tangentsId);
        }
    }

    private void initShader(IRenderHook iRenderHook) {
        if (iRenderHook != null && iRenderHook instanceof GLSLShader) {
            GLSLShader gLSLShader = (GLSLShader)iRenderHook;
            gLSLShader.init();
        }
    }

    void add(int n) {
        this.tris.add(new Integer(n));
    }

    public void error(Exception exception) {
        Logger.log("Error while compiling instance!", 0);
        exception.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileToDL() {
        Object object = SYNC;
        synchronized (object) {
            int n;
            if (this.useVBO && !this.buffersCreated && this.useDL && this.listID == 0) {
                this.useVBO = GLContext.getCapabilities().OpenGL15;
            }
            if (this.useVBO && !this.buffersCreated) {
                this.compileToVBO();
                Logger.log("VBO created for object '" + this.obj.getName() + "'");
                return;
            }
            GL11.glNormalPointer(12, this.normals);
            GL11.glVertexPointer(3, 12, this.vertices);
            GL11.glEnableClientState(32885);
            GL11.glEnableClientState(32884);
            if (!this.obj.hasVertexAlpha()) {
                GL11.glDisableClientState(32886);
            } else {
                GL11.glColorPointer(4, 16, this.colors);
                GL11.glEnableClientState(32886);
            }
            for (n = 0; n < this.endStage; ++n) {
                ARBMultitexture.glClientActiveTextureARB(stageMap[n]);
                GL11.glEnableClientState(32888);
                GL11.glTexCoordPointer(2, 8, this.multiTextures[n]);
            }
            int n2 = n = this.tangents != null || this.tangentsId != 0 ? 1 : 0;
            if (n == 0) {
                this.clearTangents(this.obj.renderHook);
            } else {
                this.initShader(this.obj.renderHook);
                this.setTangents(this.obj.renderHook);
            }
            GL11.glFlush();
            GL11.glFinish();
            int n3 = GL11.glGenLists(1);
            GL11.glNewList(n3, 4864);
            if (this.indexed) {
                GL11.glDrawElements(this.primitiveType, this.indices);
            } else {
                GL11.glDrawArrays(this.primitiveType, 0, this.cnt);
            }
            GL11.glEndList();
            GL11.glFlush();
            GL11.glFinish();
            this.listID = n3;
            GL11.glEnableClientState(32886);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() {
        if (this.obj.shareWith != null && this.mayShare) {
            return;
        }
        Object object = SYNC;
        synchronized (object) {
            if (this.useStrip == 0) {
                this.checkStrips();
            }
            this.hasBeenRefilled = true;
            long l = System.currentTimeMillis();
            if (this.tris != null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = this.tris.size() * 3;
                boolean bl = false;
                if (this.normals == null) {
                    int n7;
                    bl = true;
                    this.normals = ByteBuffer.allocateDirect(n6 * 3 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    this.vertices = ByteBuffer.allocateDirect(n6 * 3 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    if (this.obj.hasVertexAlpha()) {
                        this.colors = ByteBuffer.allocateDirect(n6 * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    }
                    if (this.obj.objMesh.tangentVectors != null) {
                        this.tangents = ByteBuffer.allocateDirect(n6 * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    }
                    if (this.indexed) {
                        this.indices = ByteBuffer.allocateDirect(n6 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                        this.vertex2index = new HashMap();
                    }
                    int n8 = 1;
                    if (this.obj.multiTex != null) {
                        for (n7 = 0; n7 < this.obj.multiTex.length && this.obj.multiTex[n7][this.polyIndex] != -1; ++n7) {
                            ++n8;
                        }
                    }
                    this.endStage = n8;
                    if (Config.glOverrideStageCount != -1 && Config.glOverrideStageCount < this.endStage) {
                        this.endStage = Config.glOverrideStageCount;
                    }
                    if (this.endStage > Config.glStageCount) {
                        this.endStage = Config.glStageCount;
                    }
                    this.multiTextures = new FloatBuffer[this.endStage];
                    for (n7 = 0; n7 < this.endStage; ++n7) {
                        this.multiTextures[n7] = ByteBuffer.allocateDirect(n6 * 2 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    }
                }
                Vectors vectors = this.obj.objVectors;
                Mesh mesh = this.obj.objMesh;
                int[][] nArray = mesh.points;
                float[] fArray = mesh.xOrg;
                float[] fArray2 = mesh.yOrg;
                float[] fArray3 = mesh.zOrg;
                float[] fArray4 = mesh.nxOrg;
                float[] fArray5 = mesh.nyOrg;
                float[] fArray6 = mesh.nzOrg;
                float[] fArray7 = vectors.nuOrg;
                float[] fArray8 = vectors.nvOrg;
                this.cnt = 0;
                if (this.vertex2index != null) {
                    this.vertex2index.clear();
                }
                int n9 = this.tris.size();
                int n10 = 0;
                ArrayList<Integer> arrayList = null;
                if (this.dynamic && bl && this.colors == null && this.coordMapper == null) {
                    arrayList = new ArrayList<Integer>();
                }
                float[][] fArray9 = this.obj.objMesh.tangentVectors;
                if (this.coordMapper != null && this.staticUV) {
                    n9 = this.coordMapper.length;
                    if (this.vcoords != null) {
                        n5 = 0;
                        n4 = 0;
                        if (this.needsCoordMapper) {
                            for (n3 = 0; n3 < n9; ++n3) {
                                n4 = this.coordMapper[n3];
                                this.vcoords[n5] = fArray[n4];
                                this.ncoords[n5++] = fArray4[n4];
                                this.vcoords[n5] = fArray2[n4];
                                this.ncoords[n5++] = fArray5[n4];
                                this.vcoords[n5] = fArray3[n4];
                                this.ncoords[n5++] = fArray6[n4];
                            }
                            this.cnt = n9;
                        } else {
                            for (n4 = 0; n4 < n9; ++n4) {
                                this.vcoords[n5] = fArray[n4];
                                this.ncoords[n5++] = fArray4[n4];
                                this.vcoords[n5] = fArray2[n4];
                                this.ncoords[n5++] = fArray5[n4];
                                this.vcoords[n5] = fArray3[n4];
                                this.ncoords[n5++] = fArray6[n4];
                            }
                            this.cnt = n9;
                        }
                        this.vertices.put(this.vcoords);
                        this.normals.put(this.ncoords);
                    }
                } else {
                    for (n5 = 0; n5 < n9; ++n5) {
                        n10 = (Integer)this.tris.get(n5);
                        n4 = 0;
                        if (n5 > 0 && this.useStrip == 1) {
                            n4 = 2;
                        }
                        for (int i = n4; i < 3; ++i) {
                            Integer n11;
                            Object object2;
                            n2 = nArray[n10][i];
                            n = mesh.coords[n2];
                            if (!this.indexed) {
                                this.vertices.put(fArray[n]);
                                this.vertices.put(fArray2[n]);
                                this.vertices.put(fArray3[n]);
                                this.normals.put(fArray4[n]);
                                this.normals.put(fArray5[n]);
                                this.normals.put(fArray6[n]);
                                if (arrayList != null) {
                                    arrayList.add(IntegerC.valueOf(n));
                                }
                                if (this.colors != null) {
                                    this.colors.put(0.0f);
                                    this.colors.put(0.0f);
                                    this.colors.put(0.0f);
                                    this.colors.put(vectors.alpha[n2]);
                                }
                                if (bl && this.tangents != null) {
                                    object2 = fArray9[n];
                                    this.tangents.put((float)object2[0]);
                                    this.tangents.put((float)object2[1]);
                                    this.tangents.put((float)object2[2]);
                                    this.tangents.put((float)object2[3]);
                                }
                                if (!bl && this.staticUV) continue;
                                for (int j = 0; j < this.endStage; ++j) {
                                    if (j == 0) {
                                        fArray7 = vectors.nuOrg;
                                        fArray8 = vectors.nvOrg;
                                        this.multiTextures[j].put(fArray7[n2]);
                                        this.multiTextures[j].put(fArray8[n2]);
                                        continue;
                                    }
                                    if (this.obj.maxStagesUsed <= 1) continue;
                                    fArray7 = vectors.uMul[j - 1];
                                    fArray8 = vectors.vMul[j - 1];
                                    this.multiTextures[j].put(fArray7[n2]);
                                    this.multiTextures[j].put(fArray8[n2]);
                                }
                                continue;
                            }
                            object2 = new GenericContainer(8);
                            ((GenericContainer)object2).add(fArray[n]);
                            ((GenericContainer)object2).add(fArray2[n]);
                            ((GenericContainer)object2).add(fArray3[n]);
                            for (int j = 0; j < this.endStage; ++j) {
                                if (j == 0) {
                                    fArray7 = vectors.nuOrg;
                                    fArray8 = vectors.nvOrg;
                                    ((GenericContainer)object2).add(fArray7[n2]);
                                    ((GenericContainer)object2).add(fArray8[n2]);
                                    continue;
                                }
                                if (this.obj.maxStagesUsed <= 1) continue;
                                fArray7 = vectors.uMul[j - 1];
                                fArray8 = vectors.vMul[j - 1];
                                ((GenericContainer)object2).add(fArray7[n2]);
                                ((GenericContainer)object2).add(fArray8[n2]);
                            }
                            if (this.colors != null) {
                                ((GenericContainer)object2).add(vectors.alpha[n2]);
                            }
                            if ((n11 = (Integer)this.vertex2index.get(object2)) == null) {
                                this.vertices.put(fArray[n]);
                                this.vertices.put(fArray2[n]);
                                this.vertices.put(fArray3[n]);
                                this.normals.put(fArray4[n]);
                                this.normals.put(fArray5[n]);
                                this.normals.put(fArray6[n]);
                                if (arrayList != null) {
                                    arrayList.add(IntegerC.valueOf(n));
                                }
                                if (this.colors != null) {
                                    this.colors.put(0.0f);
                                    this.colors.put(0.0f);
                                    this.colors.put(0.0f);
                                    this.colors.put(vectors.alpha[n2]);
                                }
                                if (bl && this.tangents != null) {
                                    float[] fArray10 = fArray9[n];
                                    this.tangents.put(fArray10[0]);
                                    this.tangents.put(fArray10[1]);
                                    this.tangents.put(fArray10[2]);
                                    this.tangents.put(fArray10[3]);
                                }
                                if (bl || !this.staticUV) {
                                    for (int j = 0; j < this.endStage; ++j) {
                                        if (j == 0) {
                                            fArray7 = vectors.nuOrg;
                                            fArray8 = vectors.nvOrg;
                                            this.multiTextures[j].put(fArray7[n2]);
                                            this.multiTextures[j].put(fArray8[n2]);
                                            continue;
                                        }
                                        if (this.obj.maxStagesUsed <= 1) continue;
                                        fArray7 = vectors.uMul[j - 1];
                                        fArray8 = vectors.vMul[j - 1];
                                        this.multiTextures[j].put(fArray7[n2]);
                                        this.multiTextures[j].put(fArray8[n2]);
                                    }
                                }
                                int n12 = (this.vertices.position() - 3) / 3;
                                this.vertex2index.put(object2, IntegerC.valueOf(n12));
                                this.indices.put(n12);
                                continue;
                            }
                            this.indices.put(n11);
                        }
                        if (n5 == 0 || this.useStrip == 2) {
                            this.cnt += 3;
                            continue;
                        }
                        ++this.cnt;
                    }
                    if (this.indices != null) {
                        this.indexCount = this.indices.position();
                        if (this.indexCount != this.indices.limit()) {
                            this.indices = (IntBuffer)((Buffer)this.indices).flip();
                        }
                    }
                    if (arrayList != null) {
                        n5 = arrayList.size();
                        Logger.log("Remapping " + n5 + " vertex indices!", 2);
                        this.coordMapper = new int[n5];
                        if (this.dynamic) {
                            Logger.log("Creating vertex cache (" + n5 * 24 + " bytes)!", 2);
                            this.vcoords = new float[n5 * 3];
                            this.ncoords = new float[n5 * 3];
                        }
                        n4 = 0;
                        this.needsCoordMapper = false;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            this.coordMapper[n4] = (Integer)iterator.next();
                            if (this.coordMapper[n4] != n4) {
                                this.needsCoordMapper = true;
                            }
                            ++n4;
                        }
                        if (this.needsCoordMapper) {
                            Logger.log("Vertex indices will be mapped!", 2);
                        } else {
                            Logger.log("Vertex indices will be accessed directly!", 2);
                        }
                        arrayList = null;
                    }
                }
                n5 = this.vertices.position();
                n4 = this.multiTextures[0].position();
                n3 = 0;
                if (this.colors != null) {
                    n3 = this.colors.position();
                    ((Buffer)this.colors).rewind();
                }
                n2 = 0;
                if (this.tangents != null) {
                    n2 = this.tangents.position();
                    ((Buffer)this.tangents).rewind();
                }
                ((Buffer)this.vertices).rewind();
                ((Buffer)this.normals).rewind();
                this.floatBuffer16_3.put(ALL_ONES);
                this.floatBuffer16_3.put(1.0f);
                ((Buffer)this.floatBuffer16_3).rewind();
                for (n = 0; n < this.endStage; ++n) {
                    ((Buffer)this.multiTextures[n]).rewind();
                }
                if (this.indices != null) {
                    ((Buffer)this.indices).rewind();
                }
                if (bl) {
                    if (!this.dynamic) {
                        this.tris = null;
                        this.vertex2index = null;
                        if (this.indexed) {
                            this.normals = this.flip(this.normals, n5);
                            this.vertices = this.flip(this.vertices, n5);
                            if (this.colors != null) {
                                this.colors = this.flip(this.colors, n3);
                            }
                            if (this.tangents != null) {
                                this.tangents = this.flip(this.tangents, n2);
                            }
                            for (n = 0; n < this.endStage; ++n) {
                                this.multiTextures[n] = this.flip(this.multiTextures[n], n4);
                            }
                        }
                    }
                    Logger.log("Subobject of object " + this.obj.getID() + "/" + this.obj.getName() + " compiled using " + this.cnt + " vertices " + (this.useStrip == 1 ? "in a strip " : "") + "in " + (System.currentTimeMillis() - l) + "ms!", 2);
                }
            }
            this.filled = true;
        }
    }

    private void checkStrips() {
        int n;
        int n2;
        int n3;
        if (this.useStrip != 0) {
            Logger.log("Triangle strip checker has been called multiple times!", 1);
            return;
        }
        int n4 = this.tris.size();
        Vectors vectors = this.obj.objVectors;
        Mesh mesh = this.obj.objMesh;
        int[][] nArray = mesh.points;
        float[] fArray = mesh.xOrg;
        float[] fArray2 = mesh.yOrg;
        float[] fArray3 = mesh.zOrg;
        float[] fArray4 = vectors.nuOrg;
        float[] fArray5 = vectors.nvOrg;
        Logger.log("Checking for triangle strip...");
        float[][] fArrayArray = new float[3][];
        float[][] fArrayArray2 = new float[3][];
        if (n4 > 0) {
            n3 = (Integer)this.tris.get(0);
            for (n2 = 0; n2 < 3; ++n2) {
                n = mesh.coords[nArray[n3][n2]];
                fArrayArray[n2] = new float[]{fArray[n], fArray2[n], fArray3[n], fArray4[n], fArray5[n]};
                fArrayArray2[n2] = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
        } else {
            this.useStrip = 2;
            return;
        }
        n3 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            int n5;
            n = (Integer)this.tris.get(n2);
            for (n5 = 0; n5 < 3; ++n5) {
                int n6 = nArray[n][n5];
                int n7 = mesh.coords[n6];
                fArrayArray2[n5][0] = fArray[n7];
                fArrayArray2[n5][1] = fArray2[n7];
                fArrayArray2[n5][2] = fArray3[n7];
                fArrayArray2[n5][3] = fArray4[n7];
                fArrayArray2[n5][4] = fArray5[n7];
            }
            if (n3 == 0) {
                int n8 = n5 = this.compare(fArrayArray[1], fArrayArray2[1]) && this.compare(fArrayArray[2], fArrayArray2[0]) ? 1 : 0;
                if (n5 == 0) {
                    this.useStrip = 2;
                    Logger.log("Not a triangle strip at position " + n2 + "!");
                    return;
                }
                n3 = 1;
            } else {
                int n9 = n5 = this.compare(fArrayArray[0], fArrayArray2[0]) && this.compare(fArrayArray[2], fArrayArray2[1]) ? 1 : 0;
                if (n5 == 0) {
                    this.useStrip = 2;
                    Logger.log("Not a triangle strip at position " + n2 + "!");
                    return;
                }
                n3 = 0;
            }
            float[][] fArrayArray3 = fArrayArray;
            fArrayArray = fArrayArray2;
            fArrayArray2 = fArrayArray3;
        }
        this.useStrip = 1;
        this.primitiveType = 5;
        Logger.log("Triangle strip found!");
    }

    private boolean compare(float[] fArray, float[] fArray2) {
        for (int i = 0; i < 5; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilled() {
        Object object = SYNC;
        synchronized (object) {
            return this.filled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReFilled() {
        Object object = SYNC;
        synchronized (object) {
            return this.hasBeenRefilled;
        }
    }

    private FloatBuffer flip(FloatBuffer floatBuffer, int n) {
        FloatBuffer floatBuffer2 = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        ((Buffer)floatBuffer).rewind();
        for (int i = 0; i < n; ++i) {
            floatBuffer2.put(floatBuffer.get());
        }
        ((Buffer)floatBuffer2).rewind();
        return floatBuffer2;
    }

    protected void compileToVBO() {
        if (this.dynamic && this.obj.sharing) {
            Vector vector = this.obj.shareWith.compiled;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                CompiledInstance compiledInstance = (CompiledInstance)vector.elementAt(i);
                if (!compiledInstance.isReFilled()) continue;
                compiledInstance.compileToVBO();
            }
            return;
        }
        if (!(this.dynamic || !this.buffersCreated && this.useVBO)) {
            return;
        }
        if (this.dynamic && !this.hasBeenRefilled) {
            return;
        }
        this.hasBeenRefilled = false;
        this.buffersCreated = true;
        int n = 35044;
        if (this.dynamic) {
            n = 35048;
        }
        if (this.normalsId == 0) {
            IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
            GL15.glGenBuffers(intBuffer);
            this.normalsId = intBuffer.get(0);
            ((Buffer)intBuffer).rewind();
            GL15.glGenBuffers(intBuffer);
            this.verticesId = intBuffer.get(0);
            if (this.colors != null) {
                ((Buffer)intBuffer).rewind();
                GL15.glGenBuffers(intBuffer);
                this.colorsId = intBuffer.get(0);
            }
            this.multiTexturesIds = new int[this.endStage];
            for (int i = 0; i < this.endStage; ++i) {
                ((Buffer)intBuffer).rewind();
                GL15.glGenBuffers(intBuffer);
                this.multiTexturesIds[i] = intBuffer.get(0);
            }
            if (this.indexed) {
                ((Buffer)intBuffer).rewind();
                GL15.glGenBuffers(intBuffer);
                this.indicesId = intBuffer.get(0);
            }
            if (this.tangents != null) {
                ((Buffer)intBuffer).rewind();
                GL15.glGenBuffers(intBuffer);
                this.tangentsId = intBuffer.get(0);
            }
        }
        ((Buffer)this.normals).rewind();
        ((Buffer)this.vertices).rewind();
        GL15.glBindBuffer(34962, this.normalsId);
        GL15.glBufferData(34962, this.normals, n);
        GL15.glBindBuffer(34962, this.verticesId);
        GL15.glBufferData(34962, this.vertices, n);
        if (this.normalsId == 0 || this.verticesId == 0) {
            this.bufferError();
        }
        if (this.colors != null) {
            ((Buffer)this.colors).rewind();
            GL15.glBindBuffer(34962, this.colorsId);
            GL15.glBufferData(34962, this.colors, n);
            if (this.colorsId == 0) {
                this.bufferError();
            }
        }
        if (this.tangents != null) {
            ((Buffer)this.tangents).rewind();
            GL15.glBindBuffer(34962, this.tangentsId);
            GL15.glBufferData(34962, this.tangents, n);
        }
        for (int i = 0; i < this.endStage; ++i) {
            ((Buffer)this.multiTextures[i]).rewind();
            GL15.glBindBuffer(34962, this.multiTexturesIds[i]);
            GL15.glBufferData(34962, this.multiTextures[i], n);
            if (this.multiTexturesIds[i] != 0) continue;
            this.bufferError();
        }
        GL15.glBindBuffer(34962, 0);
        if (this.indexed) {
            ((Buffer)this.indices).rewind();
            GL15.glBindBuffer(34963, this.indicesId);
            GL15.glBufferData(34963, this.indices, n);
            GL15.glBindBuffer(34963, 0);
            if (this.indicesId == 0) {
                this.bufferError();
            }
        }
        if (!this.dynamic && this.useVBO) {
            this.normals = null;
            this.vertices = null;
            this.colors = null;
            this.multiTextures = null;
            this.indices = null;
        }
    }

    protected void bufferError() {
        new Exception().printStackTrace();
        if (this.useVBO) {
            Logger.log("Unable to initialize VBO!", 1);
        }
        this.useVBO = false;
    }

    public void finalize() {
        if (this.lastRenderer != null && !this.obj.sharing) {
            this.dispose(this.lastRenderer);
        }
    }
}

