/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.IRenderer;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.VideoMode;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import java.io.Serializable;

public final class LegacyRenderer
implements IRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ALPHA = -16777216;
    private static final int XORROR = 196608;
    private final int[] p = new int[3];
    private final TextureManager texMan = TextureManager.getInstance();
    private IPaintListener listener = null;
    private boolean listenerActive = true;

    LegacyRenderer() {
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        Logger.log("Software renderer (legacy mode) initialized", 2);
    }

    public void setPaintListener(IPaintListener iPaintListener) {
        this.listener = iPaintListener;
    }

    public void dispose() {
        this.listener = null;
        Logger.log("Software renderer disposed", 2);
    }

    public void execute(int n, Object[] objectArray) {
        if (this.listener != null) {
            if (n == 12 && this.listenerActive) {
                this.listener.startPainting();
            } else if (n == 13 && this.listenerActive) {
                this.listener.finishedPainting();
            }
        }
        if (n == 24) {
            boolean bl;
            this.listenerActive = bl = ((Boolean)objectArray[0]).booleanValue();
        }
    }

    public void drawStrip(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        for (int i = n; i <= n2 + n; ++i) {
            this.drawPolygon(visList, i, frameBuffer, world);
        }
    }

    public void drawVertexArray(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        for (int i = n; i <= n2; ++i) {
            this.drawPolygon(visList, i, frameBuffer, world);
        }
    }

    public void drawPolygon(VisList visList, int n, FrameBuffer frameBuffer, World world) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Vectors vectors;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n8;
        int n9 = visList.vnum[n];
        Object3D object3D = visList.vobj[n];
        if (visList.stageCnt[n] > 0) {
            return;
        }
        Texture texture = this.texMan.textures[object3D.texture[n9]];
        Texture texture2 = this.texMan.textures[object3D.basemap[n9]];
        Texture texture3 = null;
        texture2.updateUsage(world.drawCnt);
        texture.updateUsage(world.drawCnt);
        int n10 = visList.vorg[n].transValue;
        boolean bl = (visList.mode[n] & 2) == 2;
        boolean bl2 = (visList.mode[n] & 1) == 1;
        boolean bl3 = (visList.mode[n] & 4) == 4;
        boolean bl4 = (visList.mode[n] & 8) == 8;
        n = visList.portalNum[n];
        float f9 = 0.0f;
        float f10 = frameBuffer.width;
        float f11 = 0.0f;
        float f12 = frameBuffer.height;
        if (n != 99999999) {
            f9 = world.portals.lowx[n];
            f10 = world.portals.highx[n] + 1.0f;
            f11 = world.portals.lowy[n];
            f12 = world.portals.highy[n] + 1.0f;
        }
        int n11 = (int)f11;
        if (bl4 && object3D.bumpmap != null) {
            texture3 = this.texMan.textures[object3D.bumpmap[n9]];
            texture3.updateUsage(world.drawCnt);
        }
        int n12 = 0;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        float f24 = 0.0f;
        float f25 = 0.0f;
        float f26 = 0.0f;
        float f27 = 0.0f;
        float f28 = 0.0f;
        float f29 = 0.0f;
        float f30 = 0.0f;
        this.p[0] = object3D.objMesh.points[n9][0];
        this.p[1] = object3D.objMesh.points[n9][1];
        this.p[2] = object3D.objMesh.points[n9][2];
        int n13 = 99999;
        int n14 = 0;
        int n15 = 99999;
        int n16 = 0;
        boolean bl5 = object3D.alwaysFilter;
        if (frameBuffer.useBb && frameBuffer.getType() == 0) {
            for (n8 = 0; n8 < 3; ++n8) {
                if (object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]] < (float)n13) {
                    n13 = (int)object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]];
                    n12 = n8;
                }
                if (object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]] > (float)n14) {
                    n14 = (int)object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]];
                }
                if (object3D.objVectors.sx[object3D.objMesh.coords[this.p[n8]]] < (float)n15) {
                    n15 = (int)object3D.objVectors.sx[object3D.objMesh.coords[this.p[n8]]];
                }
                if (object3D.objVectors.sx[object3D.objMesh.coords[this.p[n8]]] > (float)n16) {
                    n16 = (int)object3D.objVectors.sx[object3D.objMesh.coords[this.p[n8]]];
                }
                if (!(object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]] < object3D.objVectors.sy[object3D.objMesh.coords[this.p[n12]]])) continue;
                n12 = n8;
            }
            if (n14 > frameBuffer.bbYu) {
                frameBuffer.bbYu = n14;
            }
            if (n13 < frameBuffer.bbYo) {
                frameBuffer.bbYo = n13;
            }
            if (n15 < frameBuffer.bbXl) {
                frameBuffer.bbXl = n15;
            }
            if (n16 > frameBuffer.bbXr) {
                frameBuffer.bbXr = n16;
            }
        } else {
            for (n8 = 1; n8 < 3; ++n8) {
                if (!(object3D.objVectors.sy[object3D.objMesh.coords[this.p[n8]]] < object3D.objVectors.sy[object3D.objMesh.coords[this.p[n12]]])) continue;
                n12 = n8;
            }
        }
        int n17 = n12 + 1;
        int n18 = n12 - 1;
        if (n17 > 2) {
            n17 = 0;
        }
        if (n18 < 0) {
            n18 = 2;
        }
        float f31 = object3D.objVectors.sy[object3D.objMesh.coords[this.p[n12]]];
        int n19 = (int)f31;
        float f32 = f8 = object3D.objVectors.sx[object3D.objMesh.coords[this.p[n12]]];
        float f33 = f7 = object3D.objVectors.su[this.p[n12]];
        float f34 = f6 = object3D.objVectors.sv[this.p[n12]];
        float f35 = f5 = object3D.objVectors.sz[object3D.objMesh.coords[this.p[n12]]];
        float f36 = 0.0f;
        float f37 = 0.0f;
        float f38 = 0.0f;
        float f39 = 0.0f;
        if (object3D.objVectors.bsu != null) {
            f37 = f36 = object3D.objVectors.bsu[this.p[n12]];
            f39 = f38 = object3D.objVectors.bsv[this.p[n12]];
        }
        float f40 = f4 = object3D.objVectors.sr[this.p[n12]];
        float f41 = f3 = object3D.objVectors.sg[this.p[n12]];
        float f42 = f2 = object3D.objVectors.sb[this.p[n12]];
        float f43 = object3D.objVectors.sy[object3D.objMesh.coords[this.p[n17]]];
        float f44 = object3D.objVectors.sy[object3D.objMesh.coords[this.p[n18]]];
        int n20 = (int)f43;
        int n21 = (int)f44;
        float f45 = f43 - f31 + 1.0f;
        float f46 = f44 - f31 + 1.0f;
        float f47 = (float)n19 - f31;
        if (f45 != 0.0f) {
            f = 1.0f / f45;
            vectors = object3D.objVectors;
            n7 = this.p[n17];
            f13 = (vectors.sx[object3D.objMesh.coords[n7]] - f8) * f;
            f15 = (vectors.su[n7] - f7) * f;
            f17 = (vectors.sv[n7] - f6) * f;
            f19 = (vectors.sz[object3D.objMesh.coords[n7]] - f5) * f;
            if (vectors.bsu != null) {
                f21 = (vectors.bsu[n7] - f36) * f;
                f23 = (vectors.bsv[n7] - f38) * f;
            }
            f27 = (vectors.sr[n7] - f4) * f;
            f29 = (vectors.sg[n7] - f3) * f;
            f25 = (vectors.sb[n7] - f2) * f;
        }
        if (f46 != 0.0f) {
            f = 1.0f / f46;
            vectors = object3D.objVectors;
            n7 = this.p[n18];
            f14 = (vectors.sx[object3D.objMesh.coords[n7]] - f8) * f;
            f16 = (vectors.su[n7] - f7) * f;
            f18 = (vectors.sv[n7] - f6) * f;
            f20 = (vectors.sz[object3D.objMesh.coords[n7]] - f5) * f;
            if (vectors.bsu != null) {
                f22 = (vectors.bsu[n7] - f36) * f;
                f24 = (vectors.bsv[n7] - f38) * f;
            }
            f28 = (vectors.sr[n7] - f4) * f;
            f30 = (vectors.sg[n7] - f3) * f;
            f26 = (vectors.sb[n7] - f2) * f;
        }
        int n22 = 2;
        int n23 = 0;
        float f48 = 0.0f;
        float f49 = 0.0f;
        float f50 = 0.0f;
        if ((float)n19 >= f12) {
            n22 = 0;
        } else if ((float)n19 < f11) {
            Mesh mesh;
            Vectors vectors2;
            n6 = n11 - n19;
            if ((float)n20 >= f11 && (float)n21 >= f11) {
                f8 += f13 * (float)n6;
                f32 += f14 * (float)n6;
                f7 += f15 * (float)n6;
                f33 += f16 * (float)n6;
                f6 += f17 * (float)n6;
                f34 += f18 * (float)n6;
                f5 += f19 * (float)n6;
                f35 += f20 * (float)n6;
                f36 += f21 * (float)n6;
                f37 += f22 * (float)n6;
                f38 += f23 * (float)n6;
                f39 += f24 * (float)n6;
                f2 += f25 * (float)n6;
                f42 += f26 * (float)n6;
                f4 += f27 * (float)n6;
                f40 += f28 * (float)n6;
                f3 += f29 * (float)n6;
                f41 += f30 * (float)n6;
                n19 = n11;
            } else if ((float)n20 < f11 && (float)n21 < f11) {
                n22 = 0;
            } else if ((float)n20 < f11) {
                n22 = 1;
                n5 = n17 + 1;
                if (n5 > 2) {
                    n5 = 0;
                }
                vectors2 = object3D.objVectors;
                mesh = object3D.objMesh;
                n4 = this.p[n17];
                n3 = this.p[n5];
                n20 = (int)vectors2.sy[mesh.coords[n3]];
                f45 = vectors2.sy[mesh.coords[n3]] - vectors2.sy[mesh.coords[n4]] + 1.0f;
                if (f45 != 0.0f) {
                    f13 = vectors2.sx[mesh.coords[n3]] - vectors2.sx[mesh.coords[n4]];
                    f15 = (vectors2.su[this.p[n5]] - vectors2.su[n4]) / f45;
                    f17 = (vectors2.sv[this.p[n5]] - vectors2.sv[n4]) / f45;
                    f19 = (vectors2.sz[mesh.coords[n3]] - vectors2.sz[mesh.coords[n4]]) / f45;
                    if (vectors2.bsu != null) {
                        f21 = (vectors2.bsu[n3] - vectors2.bsu[n4]) / f45;
                        f23 = (vectors2.bsv[n3] - vectors2.bsv[n4]) / f45;
                    }
                    f27 = (vectors2.sr[n3] - vectors2.sr[n4]) / f45;
                    f29 = (vectors2.sg[n3] - vectors2.sg[n4]) / f45;
                    f25 = (vectors2.sb[n3] - vectors2.sb[n4]) / f45;
                    f13 /= f45;
                }
                f8 = vectors2.sx[mesh.coords[n4]];
                f7 = vectors2.su[n4];
                f6 = vectors2.sv[n4];
                f5 = vectors2.sz[mesh.coords[n4]];
                if (vectors2.bsu != null) {
                    f36 = vectors2.bsu[n4];
                    f38 = vectors2.bsv[n4];
                }
                f4 = vectors2.sr[n4];
                f3 = vectors2.sg[n4];
                f2 = vectors2.sb[n4];
                n23 = 1;
                if (f11 == 0.0f) {
                    f48 = 0.0f;
                } else {
                    f31 = f11;
                    n2 = (int)f11;
                    f48 = (float)n2 - f31;
                }
                f32 += f14 * (float)n6;
                f33 += f16 * (float)n6;
                f34 += f18 * (float)n6;
                f35 += f20 * (float)n6;
                f37 += f22 * (float)n6;
                f39 += f24 * (float)n6;
                f42 += f26 * (float)n6;
                f40 += f28 * (float)n6;
                f41 += f30 * (float)n6;
                f50 = f11 - vectors2.sy[mesh.coords[n4]];
                n17 = n5;
                n19 = n11;
                f8 += f13 * f50;
                f7 += f15 * f50;
                f6 += f17 * f50;
                f5 += f19 * f50;
                f36 += f21 * f50;
                f38 += f23 * f50;
                f4 += f27 * f50;
                f3 += f29 * f50;
                f2 += f25 * f50;
            } else {
                n22 = 1;
                n5 = n18 - 1;
                if (n5 < 0) {
                    n5 = 2;
                }
                vectors2 = object3D.objVectors;
                mesh = object3D.objMesh;
                n4 = this.p[n18];
                n3 = this.p[n5];
                n21 = (int)vectors2.sy[mesh.coords[n3]];
                f46 = vectors2.sy[mesh.coords[n3]] - vectors2.sy[mesh.coords[n4]] + 1.0f;
                if (f46 != 0.0f) {
                    f14 = vectors2.sx[mesh.coords[n3]] - vectors2.sx[mesh.coords[n4]];
                    f16 = (vectors2.su[n3] - vectors2.su[n4]) / f46;
                    f18 = (vectors2.sv[n3] - vectors2.sv[n4]) / f46;
                    f20 = (vectors2.sz[mesh.coords[n3]] - vectors2.sz[mesh.coords[n4]]) / f46;
                    if (vectors2.bsu != null) {
                        f22 = (vectors2.bsu[n3] - vectors2.bsu[n4]) / f46;
                        f24 = (vectors2.bsv[n3] - vectors2.bsv[n4]) / f46;
                    }
                    f28 = (vectors2.sr[n3] - vectors2.sr[n4]) / f46;
                    f30 = (vectors2.sg[n3] - vectors2.sg[n4]) / f46;
                    f26 = (vectors2.sb[n3] - vectors2.sb[n4]) / f46;
                    f14 /= f46;
                }
                f32 = vectors2.sx[mesh.coords[n4]];
                f33 = vectors2.su[n4];
                f34 = vectors2.sv[n4];
                f35 = vectors2.sz[mesh.coords[n4]];
                if (vectors2.bsu != null) {
                    f37 = vectors2.bsu[n4];
                    f39 = vectors2.bsv[n4];
                }
                f40 = vectors2.sr[n4];
                f41 = vectors2.sg[n4];
                f42 = vectors2.sb[n4];
                n23 = 2;
                if (f11 == 0.0f) {
                    f49 = 0.0f;
                } else {
                    f31 = f11;
                    n2 = (int)f11;
                    f49 = (float)n2 - f31;
                }
                f8 += f13 * (float)n6;
                f7 += f15 * (float)n6;
                f6 += f17 * (float)n6;
                f5 += f19 * (float)n6;
                f36 += f21 * (float)n6;
                f38 += f23 * (float)n6;
                f4 += f27 * (float)n6;
                f3 += f29 * (float)n6;
                f2 += f25 * (float)n6;
                f50 = f11 - vectors2.sy[mesh.coords[n4]];
                n18 = n5;
                n19 = n11;
                f32 += f14 * f50;
                f33 += f16 * f50;
                f34 += f18 * f50;
                f35 += f20 * f50;
                f37 += f22 * f50;
                f39 += f24 * f50;
                f40 += f28 * f50;
                f41 += f30 * f50;
                f42 += f26 * f50;
            }
        }
        switch (n23) {
            case 0: {
                f8 += f13 * f47 + 0.5f;
                f5 += f19 * f47;
                f7 += f15 * f47;
                f6 += f17 * f47;
                f4 += f27 * f47;
                f3 += f29 * f47;
                f2 += f25 * f47;
                f36 += f21 * f47;
                f38 += f23 * f47;
                f32 += f14 * f47 + 0.5f;
                f35 += f20 * f47;
                f33 += f16 * f47;
                f34 += f18 * f47;
                f40 += f28 * f47;
                f41 += f30 * f47;
                f42 += f26 * f47;
                f37 += f22 * f47;
                f39 += f24 * f47;
                break;
            }
            case 1: {
                f8 += f13 * f48 + 0.5f;
                f32 += f14 * f47 + 0.5f;
                f5 += f19 * f48;
                f35 += f20 * f47;
                f7 += f15 * f48;
                f33 += f16 * f47;
                f6 += f17 * f48;
                f34 += f18 * f47;
                f4 += f27 * f48;
                f40 += f28 * f47;
                f3 += f29 * f48;
                f41 += f30 * f47;
                f2 += f25 * f48;
                f42 += f26 * f47;
                f36 += f21 * f48;
                f38 += f23 * f48;
                f37 += f22 * f47;
                f39 += f24 * f47;
                break;
            }
            case 2: {
                f8 += f13 * f47 + 0.5f;
                f32 += f14 * f49 + 0.5f;
                f5 += f19 * f47;
                f35 += f20 * f49;
                f7 += f15 * f47;
                f33 += f16 * f49;
                f6 += f17 * f47;
                f34 += f18 * f49;
                f4 += f27 * f47;
                f40 += f28 * f49;
                f3 += f29 * f47;
                f41 += f30 * f49;
                f2 += f25 * f47;
                f42 += f26 * f49;
                f36 += f21 * f47;
                f38 += f23 * f47;
                f37 += f22 * f49;
                f39 += f24 * f49;
            }
        }
        n6 = 0;
        n5 = Config.texelFilter & (!object3D.alwaysFilter ? 1 : 0);
        int n24 = n22;
        while (n24 > 0) {
            float f51;
            n6 = n20 < n21 ? n20 : n21;
            int n25 = (int)(f12 - 1.0f);
            while (n19 < n6 || n19 == n25) {
                f8 += f13;
                f32 += f14;
                f7 += f15;
                f6 += f17;
                f5 += f19;
                f36 += f21;
                f38 += f23;
                f4 += f27;
                f3 += f29;
                f2 += f25;
                f33 += f16;
                f34 += f18;
                f35 += f20;
                f37 += f22;
                f39 += f24;
                f40 += f28;
                f41 += f30;
                f42 += f26;
                if (n5 != 0) {
                    float f52;
                    float f53 = 1.0f / f5;
                    float f54 = f15 * f53;
                    if (f54 < 0.0f) {
                        f54 = -f54;
                    }
                    if ((f52 = f17 * f53) < 0.0f) {
                        f52 = -f52;
                    }
                    if (f54 <= 0.75f && f52 <= 0.75f) {
                        bl5 = true;
                    } else {
                        float f55;
                        f51 = 1.0f / f35;
                        float f56 = f16 * f51;
                        if (f56 < 0.0f) {
                            f56 = -f56;
                        }
                        if ((f55 = f18 * f51) < 0.0f) {
                            f55 = -f55;
                        }
                        bl5 = f56 <= 0.75f && f55 <= 0.75f;
                    }
                }
                if (!(!(f8 >= 0.0f) && !(f32 >= 0.0f) || f8 >= f10 && f32 >= f10)) {
                    if (!bl4 || !bl2) {
                        if (bl) {
                            this.drawShadedZbufferedFilteredTransparentScanline(f4, f40, f3, f41, f2, f42, f8, f32, f7, f33, f6, f34, f5, f35, n19, f9, f10, frameBuffer, texture, bl5, n10);
                        } else {
                            this.drawShadedZbufferedFilteredScanline(f4, f40, f3, f41, f2, f42, f8, f32, f7, f33, f6, f34, f5, f35, n19, f9, f10, frameBuffer, texture, bl5);
                        }
                    } else if (bl3) {
                        this.drawShadedZbufferedFilteredBumpmappedBlendedScanline(f4, f40, f3, f41, f2, f42, f8, f32, f7, f33, f6, f34, f5, f35, n19, f9, f10, frameBuffer, texture, bl5, f36, f37, f38, f39, texture3, texture2);
                    } else {
                        this.drawShadedZbufferedFilteredBumpmappedScanline(f4, f40, f3, f41, f2, f42, f8, f32, f7, f33, f6, f34, f5, f35, n19, f9, f10, frameBuffer, texture, bl5, f36, f37, f38, f39, texture3);
                    }
                } else if (f8 < 0.0f && f8 < f32 && f14 <= 0.0f) {
                    n24 = 0;
                    n19 = 99999999;
                } else if (f8 < 0.0f && f32 < f8 && f13 <= 0.0f) {
                    n24 = 0;
                    n19 = 99999999;
                } else if (f32 >= f10 && f8 < f32 && f13 >= 0.0f) {
                    n24 = 0;
                    n19 = 99999999;
                } else if (f32 >= f10 && f32 < f8 && f14 >= 0.0f) {
                    n24 = 0;
                    n19 = 99999999;
                }
                if (!((float)(++n19) >= f12)) continue;
                n24 = 0;
                n19 = 99999998;
                n20 = 99999999;
                n21 = 99999999;
            }
            if (n19 >= n20) {
                n4 = n17 + 1;
                if (n4 > 2) {
                    n4 = 0;
                }
                if (n24 == n22) {
                    n20 = (int)object3D.objVectors.sy[object3D.objMesh.coords[this.p[n4]]];
                    f45 = object3D.objVectors.sy[object3D.objMesh.coords[this.p[n4]]] - object3D.objVectors.sy[object3D.objMesh.coords[this.p[n17]]] + 1.0f;
                    n3 = this.p[n17];
                    n2 = this.p[n4];
                    if (f45 != 0.0f) {
                        f51 = 1.0f / f45;
                        f13 = (object3D.objVectors.sx[object3D.objMesh.coords[n2]] - object3D.objVectors.sx[object3D.objMesh.coords[n3]]) * f51;
                        f15 = (object3D.objVectors.su[n2] - object3D.objVectors.su[n3]) * f51;
                        f17 = (object3D.objVectors.sv[n2] - object3D.objVectors.sv[n3]) * f51;
                        f19 = (object3D.objVectors.sz[object3D.objMesh.coords[n2]] - object3D.objVectors.sz[object3D.objMesh.coords[n3]]) * f51;
                        if (object3D.objVectors.bsu != null) {
                            f21 = (object3D.objVectors.bsu[n2] - object3D.objVectors.bsu[n3]) * f51;
                            f23 = (object3D.objVectors.bsv[n2] - object3D.objVectors.bsv[n3]) * f51;
                        }
                        f27 = (object3D.objVectors.sr[n2] - object3D.objVectors.sr[n3]) * f51;
                        f29 = (object3D.objVectors.sg[n2] - object3D.objVectors.sg[n3]) * f51;
                        f25 = (object3D.objVectors.sb[n2] - object3D.objVectors.sb[n3]) * f51;
                    }
                    f8 = object3D.objVectors.sx[object3D.objMesh.coords[n3]];
                    f7 = object3D.objVectors.su[n3];
                    f6 = object3D.objVectors.sv[n3];
                    f5 = object3D.objVectors.sz[object3D.objMesh.coords[n3]];
                    if (object3D.objVectors.bsu != null) {
                        f36 = object3D.objVectors.bsu[n3];
                        f38 = object3D.objVectors.bsv[n3];
                    }
                    f4 = object3D.objVectors.sr[n3];
                    f3 = object3D.objVectors.sg[n3];
                    f2 = object3D.objVectors.sb[n3];
                    f31 = object3D.objVectors.sy[object3D.objMesh.coords[n3]];
                    f47 = (float)n19 - f31;
                    f8 += f13 * f47 + 0.5f;
                    f5 += f19 * f47;
                    f7 += f15 * f47;
                    f6 += f17 * f47;
                    f4 += f27 * f47;
                    f3 += f29 * f47;
                    f2 += f25 * f47;
                    f36 += f21 * f47;
                    f38 += f23 * f47;
                }
                --n24;
                n17 = n4;
            }
            if (n19 < n21) continue;
            n4 = n18 - 1;
            if (n4 < 0) {
                n4 = 2;
            }
            if (n24 == n22) {
                n21 = (int)object3D.objVectors.sy[object3D.objMesh.coords[this.p[n4]]];
                f46 = object3D.objVectors.sy[object3D.objMesh.coords[this.p[n4]]] - object3D.objVectors.sy[object3D.objMesh.coords[this.p[n18]]] + 1.0f;
                n3 = this.p[n18];
                n2 = this.p[n4];
                if (f46 != 0.0f) {
                    f51 = 1.0f / f46;
                    f14 = (object3D.objVectors.sx[object3D.objMesh.coords[n2]] - object3D.objVectors.sx[object3D.objMesh.coords[n3]]) * f51;
                    f16 = (object3D.objVectors.su[n2] - object3D.objVectors.su[n3]) * f51;
                    f18 = (object3D.objVectors.sv[n2] - object3D.objVectors.sv[n3]) * f51;
                    f20 = (object3D.objVectors.sz[object3D.objMesh.coords[n2]] - object3D.objVectors.sz[object3D.objMesh.coords[n3]]) * f51;
                    if (object3D.objVectors.bsu != null) {
                        f22 = (object3D.objVectors.bsu[n2] - object3D.objVectors.bsu[n3]) * f51;
                        f24 = (object3D.objVectors.bsv[n2] - object3D.objVectors.bsv[n3]) * f51;
                    }
                    f28 = (object3D.objVectors.sr[n2] - object3D.objVectors.sr[n3]) * f51;
                    f30 = (object3D.objVectors.sg[n2] - object3D.objVectors.sg[n3]) * f51;
                    f26 = (object3D.objVectors.sb[n2] - object3D.objVectors.sb[n3]) * f51;
                }
                f32 = object3D.objVectors.sx[object3D.objMesh.coords[n3]];
                f33 = object3D.objVectors.su[n3];
                f34 = object3D.objVectors.sv[n3];
                f35 = object3D.objVectors.sz[object3D.objMesh.coords[n3]];
                if (object3D.objVectors.bsu != null) {
                    f37 = object3D.objVectors.bsu[n3];
                    f39 = object3D.objVectors.bsv[n3];
                }
                f40 = object3D.objVectors.sr[n3];
                f41 = object3D.objVectors.sg[n3];
                f42 = object3D.objVectors.sb[n3];
                f31 = object3D.objVectors.sy[object3D.objMesh.coords[n3]];
                f47 = (float)n19 - f31;
                f32 += f14 * f47 + 0.5f;
                f35 += f20 * f47;
                f33 += f16 * f47;
                f34 += f18 * f47;
                f40 += f28 * f47;
                f41 += f30 * f47;
                f42 += f26 * f47;
                f37 += f22 * f47;
                f39 += f24 * f47;
            }
            --n24;
            n18 = n4;
        }
    }

    public void drawWireframe(VisList visList, int n, int n2, FrameBuffer frameBuffer, World world) {
        int n3 = visList.vnum[n];
        Object3D object3D = visList.vobj[n];
        int n4 = object3D.objMesh.coords[object3D.objMesh.points[n3][0]];
        int n5 = object3D.objMesh.coords[object3D.objMesh.points[n3][1]];
        int n6 = object3D.objMesh.coords[object3D.objMesh.points[n3][2]];
        float f = object3D.objVectors.sx[n4];
        float f2 = object3D.objVectors.sx[n5];
        float f3 = object3D.objVectors.sx[n6];
        float f4 = object3D.objVectors.sy[n4];
        float f5 = object3D.objVectors.sy[n5];
        float f6 = object3D.objVectors.sy[n6];
        frameBuffer.drawLine(f, f4, f2, f5, n2);
        frameBuffer.drawLine(f2, f5, f3, f6, n2);
        frameBuffer.drawLine(f, f4, f3, f6, n2);
    }

    private void drawShadedZbufferedFilteredScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl) {
        float f17;
        int[] nArray = texture.texels;
        int[] nArray2 = frameBuffer.pixels;
        int[] nArray3 = frameBuffer.zbuffer;
        int n2 = frameBuffer.xstart[n];
        int n3 = frameBuffer.xend[n];
        float f18 = frameBuffer.zhigh[n];
        int n4 = frameBuffer.exXstart[n];
        int n5 = frameBuffer.exXend[n];
        float f19 = frameBuffer.exZlow[n];
        int n6 = frameBuffer.exXstart2[n];
        int n7 = frameBuffer.exXend2[n];
        float f20 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n5 <= n7) {
                if (n5 >= n6) {
                    n5 = n7;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n6 < n4) {
                        n4 = n6;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f20 < f19) {
                        f19 = f20;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n6 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n7 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f20 = 2.1474836E9f;
                }
            } else if (n7 >= n4) {
                if (n6 < n4) {
                    n4 = n6;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f20 < f19) {
                        f19 = f20;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n6 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n7 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f20 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n4 <= f7 && (float)n5 >= f8 && f19 >= f13 && f19 >= f14 || (float)n6 <= f7 && (float)n7 >= f8 && f20 >= f13 && f20 >= f14)) {
                int n8;
                float f21;
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f27 = f8 - f7;
                if (f27 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f27 != 0.0f) {
                    float f28 = 1.0f / f27;
                    f26 = (f10 - f9) * f28;
                    f25 = (f12 - f11) * f28;
                    f24 = (f14 - f13) * f28;
                    f23 = (f2 - f) * f28;
                    f22 = (f4 - f3) * f28;
                    f21 = (f6 - f5) * f28;
                } else {
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f24 = 0.0f;
                    f21 = 0.0f;
                    f23 = 0.0f;
                    f22 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f23;
                    f3 += f7 * f22;
                    f5 += f7 * f21;
                    f9 += f7 * f26;
                    f11 += f7 * f25;
                    f13 += f7 * f24;
                    f7 = f15;
                }
                int n9 = n * frameBuffer.width;
                int n10 = n8 = (int)f7;
                int n11 = n8 - 1;
                int n12 = (int)f8;
                int n13 = 16;
                float f29 = 16384.0f;
                float f30 = 16384.0f;
                float f31 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f32 = 16.0f * f26;
                float f33 = 16.0f * f25;
                float f34 = 16.0f * f24;
                float f35 = 16.0f * f23;
                float f36 = 16.0f * f22;
                float f37 = 16.0f * f21;
                float f38 = 1.0f / f13;
                float f39 = f9 * f38;
                float f40 = f11 * f38;
                float f41 = f * f38;
                float f42 = f3 * f38;
                float f43 = f5 * f38;
                byte by = texture.shifter;
                int n14 = (int)((double)f41 * 262144.0);
                int n15 = (int)((double)f42 * 262144.0);
                int n16 = (int)((double)f43 * 262144.0);
                int n17 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n17 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n17 = -n17;
                        bl2 = true;
                    }
                } else {
                    n17 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                if (f39 > texture.xend) {
                    f39 = texture.xend;
                } else if (f39 < 0.0f) {
                    f39 = 0.0f;
                }
                if (f40 > texture.yend) {
                    f40 = texture.yend;
                } else if (f40 < 0.0f) {
                    f40 = 0.0f;
                }
                int n18 = (int)((double)f39 * 262144.0);
                int n19 = (int)((double)f40 * 262144.0);
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                int n23 = n & 1;
                int n24 = 1 - n23 << 17;
                int n25 = n23 << 17;
                do {
                    n8 = n11 + 1;
                    if ((n11 += n13) > n12) {
                        n13 -= n11 - n12;
                        n11 = n12;
                        f32 = (float)n13 * f26;
                        f33 = (float)n13 * f25;
                        f34 = (float)n13 * f24;
                        f35 = (float)n13 * f23;
                        f36 = (float)n13 * f22;
                        f37 = (float)n13 * f21;
                        if (n13 == 0) {
                            n13 = 1;
                        }
                        f29 = f30 = 262144.0f / (float)n13;
                        f31 = Config.zTrick ? 2.1474836E9f / (float)n13 : 4.2949673E9f / (float)n13;
                    }
                    if (n11 == n12 && f8 < f16 - 1.0f) {
                        f32 = f10 - f9;
                        f33 = f12 - f11;
                        f34 = f14 - f13;
                    }
                    float f44 = f13;
                    f9 += f32;
                    f11 += f33;
                    f += f35;
                    f3 += f36;
                    f5 += f37;
                    f38 = 1.0f / (f13 += f34);
                    float f45 = f9 * f38;
                    float f46 = f11 * f38;
                    float f47 = f * f38;
                    float f48 = f3 * f38;
                    float f49 = f5 * f38;
                    if (f45 > texture.xend) {
                        f45 = texture.xend;
                    } else if (f45 < 0.0f) {
                        f45 = 0.0f;
                    }
                    if (f46 > texture.yend) {
                        f46 = texture.yend;
                    } else if (f46 < 0.0f) {
                        f46 = 0.0f;
                    }
                    int n26 = (int)(f31 * (f13 - f44));
                    if (bl2) {
                        n26 = -n26;
                    }
                    int n27 = (int)(f29 * (f45 - f39));
                    int n28 = (int)(f29 * (f46 - f40));
                    n20 = (int)(f30 * (f47 - f41));
                    n21 = (int)(f30 * (f48 - f42));
                    n22 = (int)(f30 * (f49 - f43));
                    if (Config.spanBasedHsr && (n4 <= n8 && n5 >= n11 && f19 >= f44 && f19 >= f13 || n6 <= n8 && n7 >= n11 && f20 >= f44 && f20 >= f13)) {
                        if (n11 != n12) {
                            n17 += n13 * n26;
                            n18 += n13 * n27;
                            n19 += n13 * n28;
                            n14 += n13 * n20;
                            n15 += n13 * n21;
                            n16 += n13 * n22;
                        }
                    } else {
                        int n29;
                        int n30 = n11 + n9;
                        int n31 = 0;
                        int n32 = 0;
                        int n33 = 0;
                        int n34 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n27 < 196608 && n27 > -196608 && n28 <= 196608 && n28 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n35 = (n8 & 1) != 0 ? 65536 + n24 : n25;
                            if (Config.optiZ && (n2 > n11 || n3 < n8 || f44 >= f18 && f13 >= f18)) {
                                for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                    n31 = nArray[(n18 + n35 >> 18) + (n19 + (n35 ^ 0x10000) >> 18 << by)];
                                    n35 ^= 0x30000;
                                    n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                    n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                    n32 = (n31 & 0xFF) + (n16 >> 18);
                                    if ((n34 & 0xFFFFFF00) != 0) {
                                        n34 = 255 >> (n34 >> 28 & 8);
                                    }
                                    if ((n33 & 0xFFFFFF00) != 0) {
                                        n33 = 255 >> (n33 >> 28 & 8);
                                    }
                                    if ((n32 & 0xFFFFFF00) != 0) {
                                        n32 = 255 >> (n32 >> 28 & 8);
                                    }
                                    nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                    nArray3[n29] = n17;
                                    n18 += n27;
                                    n19 += n28;
                                    n14 += n20;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n26;
                                }
                            } else if (bl2) {
                                for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                    if (nArray3[n29] > n17) {
                                        n31 = nArray[(n18 + n35 >> 18) + (n19 + (n35 ^ 0x10000) >> 18 << by)];
                                        n35 ^= 0x30000;
                                        n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                        n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                        n32 = (n31 & 0xFF) + (n16 >> 18);
                                        if ((n34 & 0xFFFFFF00) != 0) {
                                            n34 = 255 >> (n34 >> 28 & 8);
                                        }
                                        if ((n33 & 0xFFFFFF00) != 0) {
                                            n33 = 255 >> (n33 >> 28 & 8);
                                        }
                                        if ((n32 & 0xFFFFFF00) != 0) {
                                            n32 = 255 >> (n32 >> 28 & 8);
                                        }
                                        nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                        nArray3[n29] = n17;
                                    }
                                    n18 += n27;
                                    n19 += n28;
                                    n14 += n20;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n26;
                                }
                            } else {
                                for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                    if (nArray3[n29] < n17) {
                                        n31 = nArray[(n18 + n35 >> 18) + (n19 + (n35 ^ 0x10000) >> 18 << by)];
                                        n35 ^= 0x30000;
                                        n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                        n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                        n32 = (n31 & 0xFF) + (n16 >> 18);
                                        if ((n34 & 0xFFFFFF00) != 0) {
                                            n34 = 255 >> (n34 >> 28 & 8);
                                        }
                                        if ((n33 & 0xFFFFFF00) != 0) {
                                            n33 = 255 >> (n33 >> 28 & 8);
                                        }
                                        if ((n32 & 0xFFFFFF00) != 0) {
                                            n32 = 255 >> (n32 >> 28 & 8);
                                        }
                                        nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                        nArray3[n29] = n17;
                                    }
                                    n18 += n27;
                                    n19 += n28;
                                    n14 += n20;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n26;
                                }
                            }
                        } else if (Config.optiZ && (n2 > n11 || n3 < n8 || f44 >= f18 && f13 >= f18)) {
                            for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                n31 = nArray[(n18 >> 18) + (n19 >> 18 << by)];
                                n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                n32 = (n31 & 0xFF) + (n16 >> 18);
                                if ((n34 & 0xFFFFFF00) != 0) {
                                    n34 = 255 >> (byte)(n34 >> 28 & 8);
                                }
                                if ((n33 & 0xFFFFFF00) != 0) {
                                    n33 = 255 >> (byte)(n33 >> 28 & 8);
                                }
                                if ((n32 & 0xFFFFFF00) != 0) {
                                    n32 = 255 >> (byte)(n32 >> 28 & 8);
                                }
                                nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                nArray3[n29] = n17;
                                n18 += n27;
                                n19 += n28;
                                n14 += n20;
                                n15 += n21;
                                n16 += n22;
                                n17 += n26;
                            }
                        } else if (bl2) {
                            for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                if (nArray3[n29] > n17) {
                                    n31 = nArray[(n18 >> 18) + (n19 >> 18 << by)];
                                    n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                    n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                    n32 = (n31 & 0xFF) + (n16 >> 18);
                                    if ((n34 & 0xFFFFFF00) != 0) {
                                        n34 = 255 >> (byte)(n34 >> 28 & 8);
                                    }
                                    if ((n33 & 0xFFFFFF00) != 0) {
                                        n33 = 255 >> (byte)(n33 >> 28 & 8);
                                    }
                                    if ((n32 & 0xFFFFFF00) != 0) {
                                        n32 = 255 >> (byte)(n32 >> 28 & 8);
                                    }
                                    nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                    nArray3[n29] = n17;
                                }
                                n18 += n27;
                                n19 += n28;
                                n14 += n20;
                                n15 += n21;
                                n16 += n22;
                                n17 += n26;
                            }
                        } else {
                            for (n29 = n8 + n9; n29 <= n30; ++n29) {
                                if (nArray3[n29] < n17) {
                                    n31 = nArray[(n18 >> 18) + (n19 >> 18 << by)];
                                    n34 = (n31 >> 16 & 0xFF) + (n14 >> 18);
                                    n33 = (n31 >> 8 & 0xFF) + (n15 >> 18);
                                    n32 = (n31 & 0xFF) + (n16 >> 18);
                                    if ((n34 & 0xFFFFFF00) != 0) {
                                        n34 = 255 >> (byte)(n34 >> 28 & 8);
                                    }
                                    if ((n33 & 0xFFFFFF00) != 0) {
                                        n33 = 255 >> (byte)(n33 >> 28 & 8);
                                    }
                                    if ((n32 & 0xFFFFFF00) != 0) {
                                        n32 = 255 >> (byte)(n32 >> 28 & 8);
                                    }
                                    nArray2[n29] = n32 | n33 << 8 | n34 << 16 | 0xFF000000;
                                    nArray3[n29] = n17;
                                }
                                n18 += n27;
                                n19 += n28;
                                n14 += n20;
                                n15 += n21;
                                n16 += n22;
                                n17 += n26;
                            }
                        }
                    }
                    f39 = f45;
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                } while (n11 < n12);
                boolean bl3 = false;
                if (n10 < n4 && n12 >= n4 || n4 == 99999999) {
                    frameBuffer.exXstart[n] = n10;
                    if (f19 > f17) {
                        frameBuffer.exZlow[n] = f17;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl3 = true;
                }
                if (n12 > n5 && f7 <= (float)n5 || n5 == -1) {
                    frameBuffer.exXend[n] = n12;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f17) {
                        frameBuffer.exZlow[n] = f17;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    if (n10 < n6 && n12 >= n6 || n6 == 99999999) {
                        frameBuffer.exXstart2[n] = n10;
                        if (f20 > f17) {
                            frameBuffer.exZlow2[n] = f17;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n12 > n7 && f7 <= (float)n7 || n7 == -1) {
                        frameBuffer.exXend2[n] = n12;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f17) {
                            frameBuffer.exZlow2[n] = f17;
                        }
                        bl3 = true;
                    }
                }
                if (f7 < (float)n2) {
                    frameBuffer.xstart[n] = n10;
                }
                if (n12 > n3) {
                    frameBuffer.xend[n] = n12;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f18) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private void drawShadedZbufferedFilteredBumpmappedBlendedScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2, Texture texture3) {
        float f21;
        int[] nArray = texture.texels;
        int[] nArray2 = texture2.texels;
        int[] nArray3 = texture3.texels;
        int[] nArray4 = frameBuffer.pixels;
        int[] nArray5 = frameBuffer.zbuffer;
        int n2 = frameBuffer.xstart[n];
        int n3 = frameBuffer.xend[n];
        float f22 = frameBuffer.zhigh[n];
        int n4 = frameBuffer.exXstart[n];
        int n5 = frameBuffer.exXend[n];
        float f23 = frameBuffer.exZlow[n];
        int n6 = frameBuffer.exXstart2[n];
        int n7 = frameBuffer.exXend2[n];
        float f24 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n5 <= n7) {
                if (n5 >= n6) {
                    n5 = n7;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n6 < n4) {
                        n4 = n6;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f24 < f23) {
                        f23 = f24;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n6 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n7 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f24 = 2.1474836E9f;
                }
            } else if (n7 >= n4) {
                if (n6 < n4) {
                    n4 = n6;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f24 < f23) {
                        f23 = f24;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n6 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n7 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f24 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n4 <= f7 && (float)n5 >= f8 && f23 >= f13 && f23 >= f14 || (float)n6 <= f7 && (float)n7 >= f8 && f24 >= f13 && f24 >= f14)) {
                int n8;
                float f25;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f33 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f34 = 1.0f / f21;
                    f32 = (f10 - f9) * f34;
                    f31 = (f12 - f11) * f34;
                    f30 = (f18 - f17) * f34;
                    f29 = (f20 - f19) * f34;
                    f28 = (f14 - f13) * f34;
                    f27 = (f2 - f) * f34;
                    f26 = (f4 - f3) * f34;
                    f25 = (f6 - f5) * f34;
                } else {
                    f32 = 0.0f;
                    f31 = 0.0f;
                    f28 = 0.0f;
                    f25 = 0.0f;
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f30 = 0.0f;
                    f29 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f27;
                    f3 += f7 * f26;
                    f5 += f7 * f25;
                    f9 += f7 * f32;
                    f11 += f7 * f31;
                    f17 += f7 * f30;
                    f19 += f7 * f29;
                    f13 += f7 * f28;
                    f7 = f15;
                }
                int n9 = n * frameBuffer.width;
                int n10 = n8 = (int)f7;
                int n11 = n8 - 1;
                int n12 = (int)f8;
                int n13 = 16;
                float f35 = 16384.0f;
                float f36 = 16384.0f;
                float f37 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f38 = 16.0f * f32;
                float f39 = 16.0f * f31;
                float f40 = 16.0f * f28;
                float f41 = 16.0f * f27;
                float f42 = 16.0f * f26;
                float f43 = 16.0f * f25;
                float f44 = 16.0f * f30;
                float f45 = 16.0f * f29;
                float f46 = 1.0f / f13;
                float f47 = f9 * f46;
                float f48 = f11 * f46;
                float f49 = f17 * f46;
                float f50 = f19 * f46;
                float f51 = f * f46;
                float f52 = f3 * f46;
                float f53 = f5 * f46;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n14 = (int)(f51 * 262144.0f);
                int n15 = (int)(f52 * 262144.0f);
                int n16 = (int)(f53 * 262144.0f);
                int n17 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n17 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n17 = -n17;
                        bl2 = true;
                    }
                } else {
                    n17 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                if (f47 > texture.xend) {
                    f47 = texture.xend;
                } else if (f47 < 0.0f) {
                    f47 = 0.0f;
                }
                if (f48 > texture.yend) {
                    f48 = texture.yend;
                } else if (f48 < 0.0f) {
                    f48 = 0.0f;
                }
                int n18 = (int)(f47 * 262144.0f);
                int n19 = (int)(f48 * 262144.0f);
                if (f49 > texture2.xend) {
                    f49 = texture2.xend;
                } else if (f49 < 0.0f) {
                    f49 = 0.0f;
                }
                if (f50 > texture2.yend) {
                    f50 = texture2.yend;
                } else if (f50 < 0.0f) {
                    f50 = 0.0f;
                }
                int n20 = (int)(f49 * 262144.0f);
                int n21 = (int)(f50 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n8 = n11 + 1;
                    if ((n11 += n13) > n12) {
                        n13 -= n11 - n12;
                        n11 = n12;
                        f38 = (float)n13 * f32;
                        f39 = (float)n13 * f31;
                        f44 = (float)n13 * f30;
                        f45 = (float)n13 * f29;
                        f40 = (float)n13 * f28;
                        f41 = (float)n13 * f27;
                        f42 = (float)n13 * f26;
                        f43 = (float)n13 * f25;
                        if (n13 == 0) {
                            n13 = 1;
                        }
                        f35 = f36 = (float)(262144 / n13);
                        f37 = Config.zTrick ? 2.1474836E9f / (float)n13 : 4.2949673E9f / (float)n13;
                    }
                    if (n11 == n12 && f8 < f16 - 1.0f) {
                        f38 = f10 - f9;
                        f39 = f12 - f11;
                        f40 = f14 - f13;
                        f44 = f18 - f17;
                        f45 = f20 - f19;
                    }
                    float f54 = f13;
                    f9 += f38;
                    f11 += f39;
                    f17 += f44;
                    f19 += f45;
                    f += f41;
                    f3 += f42;
                    f5 += f43;
                    f46 = 1.0f / (f13 += f40);
                    float f55 = f9 * f46;
                    float f56 = f11 * f46;
                    float f57 = f17 * f46;
                    float f58 = f19 * f46;
                    float f59 = f * f46;
                    float f60 = f3 * f46;
                    float f61 = f5 * f46;
                    if (f55 > texture.xend) {
                        f55 = texture.xend;
                    } else if (f55 < 0.0f) {
                        f55 = 0.0f;
                    }
                    if (f56 > texture.yend) {
                        f56 = texture.yend;
                    } else if (f56 < 0.0f) {
                        f56 = 0.0f;
                    }
                    if (f57 > texture2.xend) {
                        f57 = texture2.xend;
                    } else if (f57 < 0.0f) {
                        f57 = 0.0f;
                    }
                    if (f58 > texture2.yend) {
                        f58 = texture2.yend;
                    } else if (f58 < 0.0f) {
                        f58 = 0.0f;
                    }
                    int n28 = (int)(f37 * (f13 - f54));
                    if (bl2) {
                        n28 = -n28;
                    }
                    int n29 = (int)(f35 * (f55 - f47));
                    int n30 = (int)(f35 * (f56 - f48));
                    int n31 = (int)(f35 * (f57 - f49));
                    int n32 = (int)(f35 * (f58 - f50));
                    n22 = (int)(f36 * (f59 - f51));
                    n23 = (int)(f36 * (f60 - f52));
                    n24 = (int)(f36 * (f61 - f53));
                    if (Config.spanBasedHsr && (n4 <= n8 && n5 >= n11 && f23 >= f54 && f23 >= f13 || n6 <= n8 && n7 >= n11 && f24 >= f54 && f24 >= f13)) {
                        if (n11 != n12) {
                            n17 += n13 * n28;
                            n18 += n13 * n29;
                            n19 += n13 * n30;
                            n20 += n13 * n31;
                            n21 += n13 * n32;
                            n14 += n13 * n22;
                            n15 += n13 * n23;
                            n16 += n13 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        int n35;
                        int n36;
                        int n37;
                        int n38;
                        int n39;
                        int n40;
                        int n41 = n11 + n9;
                        int n42 = 0;
                        int n43 = 0;
                        int n44 = 0;
                        int n45 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n29 < 196608 && n29 > -196608 && n30 <= 196608 && n30 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n46 = (n8 & 1) != 0 ? 65536 + n26 : n27;
                            if (Config.optiZ && (n2 > n11 || n3 < n8 || f54 >= f22 && f13 >= f22)) {
                                for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                    n39 = (n20 + n46 >> 18) + (n21 + (n46 ^ 0x10000) >> 18 << by2);
                                    n38 = nArray2[n39];
                                    n37 = nArray3[n39];
                                    n36 = (n18 + n46 >> 18) - 128 + (n38 >> 8) + ((n19 + (n46 ^ 0x10000) >> 18) - 128 + (n38 & 0xFF) << by);
                                    n46 ^= 0x30000;
                                    if (n36 < 0) {
                                        n36 = 0;
                                    } else if (n36 >= texture.intSize) {
                                        n36 = texture.intSize - 1;
                                    }
                                    n42 = nArray[n36];
                                    n35 = n37 >> 16 & 0xFF;
                                    n34 = n37 >> 8 & 0xFF;
                                    n33 = n37 & 0xFF;
                                    n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                    n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                    n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (n43 >> 28 & 8);
                                    }
                                    nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray5[n40] = n17;
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            } else if (!bl2) {
                                for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                    if (nArray5[n40] < n17) {
                                        n39 = (n20 + n46 >> 18) + (n21 + (n46 ^ 0x10000) >> 18 << by2);
                                        n38 = nArray2[n39];
                                        n37 = nArray3[n39];
                                        n36 = (n18 + n46 >> 18) - 128 + (n38 >> 8) + ((n19 + (n46 ^ 0x10000) >> 18) - 128 + (n38 & 0xFF) << by);
                                        n46 ^= 0x30000;
                                        if (n36 < 0) {
                                            n36 = 0;
                                        } else if (n36 >= texture.intSize) {
                                            n36 = texture.intSize - 1;
                                        }
                                        n42 = nArray[n36];
                                        n35 = n37 >> 16 & 0xFF;
                                        n34 = n37 >> 8 & 0xFF;
                                        n33 = n37 & 0xFF;
                                        n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                        n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                        n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                        if ((n45 & 0xFFFFFF00) != 0) {
                                            n45 = 255 >> (n45 >> 28 & 8);
                                        }
                                        if ((n44 & 0xFFFFFF00) != 0) {
                                            n44 = 255 >> (n44 >> 28 & 8);
                                        }
                                        if ((n43 & 0xFFFFFF00) != 0) {
                                            n43 = 255 >> (n43 >> 28 & 8);
                                        }
                                        nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                        nArray5[n40] = n17;
                                    }
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            } else {
                                for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                    if (nArray5[n40] > n17) {
                                        n39 = (n20 + n46 >> 18) + (n21 + (n46 ^ 0x10000) >> 18 << by2);
                                        n38 = nArray2[n39];
                                        n37 = nArray3[n39];
                                        n36 = (n18 + n46 >> 18) - 128 + (n38 >> 8) + ((n19 + (n46 ^ 0x10000) >> 18) - 128 + (n38 & 0xFF) << by);
                                        n46 ^= 0x30000;
                                        if (n36 < 0) {
                                            n36 = 0;
                                        } else if (n36 >= texture.intSize) {
                                            n36 = texture.intSize - 1;
                                        }
                                        n42 = nArray[n36];
                                        n35 = n37 >> 16 & 0xFF;
                                        n34 = n37 >> 8 & 0xFF;
                                        n33 = n37 & 0xFF;
                                        n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                        n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                        n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                        if ((n45 & 0xFFFFFF00) != 0) {
                                            n45 = 255 >> (n45 >> 28 & 8);
                                        }
                                        if ((n44 & 0xFFFFFF00) != 0) {
                                            n44 = 255 >> (n44 >> 28 & 8);
                                        }
                                        if ((n43 & 0xFFFFFF00) != 0) {
                                            n43 = 255 >> (n43 >> 28 & 8);
                                        }
                                        nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                        nArray5[n40] = n17;
                                    }
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            }
                        } else if (Config.optiZ && (n2 > n11 || n3 < n8 || f54 >= f22 && f13 >= f22)) {
                            for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                n39 = (n20 >> 18) + (n21 >> 18 << by2);
                                n38 = nArray2[n39];
                                n37 = nArray3[n39];
                                n36 = (n18 >> 18) - 128 + (n38 >> 8) + ((n19 >> 18) - 128 + (n38 & 0xFF) << by);
                                if (n36 >= texture.intSize) {
                                    n36 = texture.intSize - 1;
                                } else if (n36 < 0) {
                                    n36 = 0;
                                }
                                n42 = nArray[n36];
                                n35 = n37 >> 16 & 0xFF;
                                n34 = n37 >> 8 & 0xFF;
                                n33 = n37 & 0xFF;
                                n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                if ((n45 & 0xFFFFFF00) != 0) {
                                    n45 = 255 >> (byte)(n45 >> 28 & 8);
                                }
                                if ((n44 & 0xFFFFFF00) != 0) {
                                    n44 = 255 >> (byte)(n44 >> 28 & 8);
                                }
                                if ((n43 & 0xFFFFFF00) != 0) {
                                    n43 = 255 >> (byte)(n43 >> 28 & 8);
                                }
                                nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                nArray5[n40] = n17;
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        } else if (!bl2) {
                            for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                if (nArray5[n40] < n17) {
                                    n39 = (n20 >> 18) + (n21 >> 18 << by2);
                                    n38 = nArray2[n39];
                                    n37 = nArray3[n39];
                                    n36 = (n18 >> 18) - 128 + (n38 >> 8) + ((n19 >> 18) - 128 + (n38 & 0xFF) << by);
                                    if (n36 >= texture.intSize) {
                                        n36 = texture.intSize - 1;
                                    } else if (n36 < 0) {
                                        n36 = 0;
                                    }
                                    n42 = nArray[n36];
                                    n35 = n37 >> 16 & 0xFF;
                                    n34 = n37 >> 8 & 0xFF;
                                    n33 = n37 & 0xFF;
                                    n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                    n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                    n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (byte)(n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (byte)(n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (byte)(n43 >> 28 & 8);
                                    }
                                    nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray5[n40] = n17;
                                }
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        } else {
                            for (n40 = n8 + n9; n40 <= n41; ++n40) {
                                if (nArray5[n40] > n17) {
                                    n39 = (n20 >> 18) + (n21 >> 18 << by2);
                                    n38 = nArray2[n39];
                                    n37 = nArray3[n39];
                                    n36 = (n18 >> 18) - 128 + (n38 >> 8) + ((n19 >> 18) - 128 + (n38 & 0xFF) << by);
                                    if (n36 >= texture.intSize) {
                                        n36 = texture.intSize - 1;
                                    } else if (n36 < 0) {
                                        n36 = 0;
                                    }
                                    n42 = nArray[n36];
                                    n35 = n37 >> 16 & 0xFF;
                                    n34 = n37 >> 8 & 0xFF;
                                    n33 = n37 & 0xFF;
                                    n45 = (n42 >> 16 & 0xFF) + (n14 >> 18) + n35;
                                    n44 = (n42 >> 8 & 0xFF) + (n15 >> 18) + n34;
                                    n43 = (n42 & 0xFF) + (n16 >> 18) + n33;
                                    if ((n45 & 0xFFFFFF00) != 0) {
                                        n45 = 255 >> (byte)(n45 >> 28 & 8);
                                    }
                                    if ((n44 & 0xFFFFFF00) != 0) {
                                        n44 = 255 >> (byte)(n44 >> 28 & 8);
                                    }
                                    if ((n43 & 0xFFFFFF00) != 0) {
                                        n43 = 255 >> (byte)(n43 >> 28 & 8);
                                    }
                                    nArray4[n40] = n43 | n44 << 8 | n45 << 16 | 0xFF000000;
                                    nArray5[n40] = n17;
                                }
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        }
                    }
                    f47 = f55;
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                } while (n11 < n12);
                boolean bl3 = false;
                if (n10 < n4 && n12 >= n4 || n4 == 99999999) {
                    frameBuffer.exXstart[n] = n10;
                    if (f23 > f33) {
                        frameBuffer.exZlow[n] = f33;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl3 = true;
                }
                if (n12 > n5 && f7 <= (float)n5 || n5 == -1) {
                    frameBuffer.exXend[n] = n12;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f33) {
                        frameBuffer.exZlow[n] = f33;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    if (n10 < n6 && n12 >= n6 || n6 == 99999999) {
                        frameBuffer.exXstart2[n] = n10;
                        if (f24 > f33) {
                            frameBuffer.exZlow2[n] = f33;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n12 > n7 && f7 <= (float)n7 || n7 == -1) {
                        frameBuffer.exXend2[n] = n12;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f33) {
                            frameBuffer.exZlow2[n] = f33;
                        }
                        bl3 = true;
                    }
                }
                if (f7 < (float)n2) {
                    frameBuffer.xstart[n] = n10;
                }
                if (n12 > n3) {
                    frameBuffer.xend[n] = n12;
                }
                if (f14 < f33) {
                    f14 = f33;
                }
                if (f14 > f22) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private void drawShadedZbufferedFilteredBumpmappedScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, float f17, float f18, float f19, float f20, Texture texture2) {
        float f21;
        int[] nArray = texture.texels;
        int[] nArray2 = texture2.texels;
        int[] nArray3 = frameBuffer.pixels;
        int[] nArray4 = frameBuffer.zbuffer;
        int n2 = frameBuffer.xstart[n];
        int n3 = frameBuffer.xend[n];
        float f22 = frameBuffer.zhigh[n];
        int n4 = frameBuffer.exXstart[n];
        int n5 = frameBuffer.exXend[n];
        float f23 = frameBuffer.exZlow[n];
        int n6 = frameBuffer.exXstart2[n];
        int n7 = frameBuffer.exXend2[n];
        float f24 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f21 = f7;
            f7 = f8;
            f8 = f21;
            f21 = f9;
            f9 = f10;
            f10 = f21;
            f21 = f11;
            f11 = f12;
            f12 = f21;
            f21 = f13;
            f13 = f14;
            f14 = f21;
            f21 = f17;
            f17 = f18;
            f18 = f21;
            f21 = f19;
            f19 = f20;
            f20 = f21;
            f21 = f;
            f = f2;
            f2 = f21;
            f21 = f3;
            f3 = f4;
            f4 = f21;
            f21 = f5;
            f5 = f6;
            f6 = f21;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n5 <= n7) {
                if (n5 >= n6) {
                    n5 = n7;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n6 < n4) {
                        n4 = n6;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f24 < f23) {
                        f23 = f24;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n6 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n7 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f24 = 2.1474836E9f;
                }
            } else if (n7 >= n4) {
                if (n6 < n4) {
                    n4 = n6;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f24 < f23) {
                        f23 = f24;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n6 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n7 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f24 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n4 <= f7 && (float)n5 >= f8 && f23 >= f13 && f23 >= f14 || (float)n6 <= f7 && (float)n7 >= f8 && f24 >= f13 && f24 >= f14)) {
                int n8;
                float f25;
                float f26;
                float f27;
                float f28;
                float f29;
                float f30;
                float f31;
                float f32;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f21 = f8 - f7;
                float f33 = f13;
                if (f21 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f21 != 0.0f) {
                    float f34 = 1.0f / f21;
                    f32 = (f10 - f9) * f34;
                    f31 = (f12 - f11) * f34;
                    f30 = (f18 - f17) * f34;
                    f29 = (f20 - f19) * f34;
                    f28 = (f14 - f13) * f34;
                    f27 = (f2 - f) * f34;
                    f26 = (f4 - f3) * f34;
                    f25 = (f6 - f5) * f34;
                } else {
                    f32 = 0.0f;
                    f31 = 0.0f;
                    f28 = 0.0f;
                    f25 = 0.0f;
                    f27 = 0.0f;
                    f26 = 0.0f;
                    f30 = 0.0f;
                    f29 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f27;
                    f3 += f7 * f26;
                    f5 += f7 * f25;
                    f9 += f7 * f32;
                    f11 += f7 * f31;
                    f17 += f7 * f30;
                    f19 += f7 * f29;
                    f13 += f7 * f28;
                    f7 = f15;
                }
                int n9 = n * frameBuffer.width;
                int n10 = n8 = (int)f7;
                int n11 = n8 - 1;
                int n12 = (int)f8;
                int n13 = 16;
                float f35 = 16384.0f;
                float f36 = 16384.0f;
                float f37 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f38 = 16.0f * f32;
                float f39 = 16.0f * f31;
                float f40 = 16.0f * f28;
                float f41 = 16.0f * f27;
                float f42 = 16.0f * f26;
                float f43 = 16.0f * f25;
                float f44 = 16.0f * f30;
                float f45 = 16.0f * f29;
                float f46 = 1.0f / f13;
                float f47 = f9 * f46;
                float f48 = f11 * f46;
                float f49 = f17 * f46;
                float f50 = f19 * f46;
                float f51 = f * f46;
                float f52 = f3 * f46;
                float f53 = f5 * f46;
                byte by = texture.shifter;
                byte by2 = texture2.shifter;
                int n14 = (int)(f51 * 262144.0f);
                int n15 = (int)(f52 * 262144.0f);
                int n16 = (int)(f53 * 262144.0f);
                int n17 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n17 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n17 = -n17;
                        bl2 = true;
                    }
                } else {
                    n17 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                if (f47 > texture.xend) {
                    f47 = texture.xend;
                } else if (f47 < 0.0f) {
                    f47 = 0.0f;
                }
                if (f48 > texture.yend) {
                    f48 = texture.yend;
                } else if (f48 < 0.0f) {
                    f48 = 0.0f;
                }
                int n18 = (int)(f47 * 262144.0f);
                int n19 = (int)(f48 * 262144.0f);
                if (f49 > texture2.xend) {
                    f49 = texture2.xend;
                } else if (f49 < 0.0f) {
                    f49 = 0.0f;
                }
                if (f50 > texture2.yend) {
                    f50 = texture2.yend;
                } else if (f50 < 0.0f) {
                    f50 = 0.0f;
                }
                int n20 = (int)(f49 * 262144.0f);
                int n21 = (int)(f50 * 262144.0f);
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                int n25 = n & 1;
                int n26 = 1 - n25 << 17;
                int n27 = n25 << 17;
                do {
                    n8 = n11 + 1;
                    if ((n11 += n13) > n12) {
                        n13 -= n11 - n12;
                        n11 = n12;
                        f38 = (float)n13 * f32;
                        f39 = (float)n13 * f31;
                        f44 = (float)n13 * f30;
                        f45 = (float)n13 * f29;
                        f40 = (float)n13 * f28;
                        f41 = (float)n13 * f27;
                        f42 = (float)n13 * f26;
                        f43 = (float)n13 * f25;
                        if (n13 == 0) {
                            n13 = 1;
                        }
                        f35 = f36 = (float)(262144 / n13);
                        f37 = Config.zTrick ? 2.1474836E9f / (float)n13 : 4.2949673E9f / (float)n13;
                    }
                    float f54 = f13;
                    if (n11 == n12 && f8 < f16 - 1.0f) {
                        f38 = f10 - f9;
                        f39 = f12 - f11;
                        f40 = f14 - f13;
                        f44 = f18 - f17;
                        f45 = f20 - f19;
                    }
                    f9 += f38;
                    f11 += f39;
                    f17 += f44;
                    f19 += f45;
                    f += f41;
                    f3 += f42;
                    f5 += f43;
                    f46 = 1.0f / (f13 += f40);
                    float f55 = f9 * f46;
                    float f56 = f11 * f46;
                    float f57 = f17 * f46;
                    float f58 = f19 * f46;
                    float f59 = f * f46;
                    float f60 = f3 * f46;
                    float f61 = f5 * f46;
                    if (f55 > texture.xend) {
                        f55 = texture.xend;
                    } else if (f55 < 0.0f) {
                        f55 = 0.0f;
                    }
                    if (f56 > texture.yend) {
                        f56 = texture.yend;
                    } else if (f56 < 0.0f) {
                        f56 = 0.0f;
                    }
                    if (f57 > texture2.xend) {
                        f57 = texture2.xend;
                    } else if (f57 < 0.0f) {
                        f57 = 0.0f;
                    }
                    if (f58 > texture2.yend) {
                        f58 = texture2.yend;
                    } else if (f58 < 0.0f) {
                        f58 = 0.0f;
                    }
                    int n28 = (int)(f37 * (f13 - f54));
                    if (bl2) {
                        n28 = -n28;
                    }
                    int n29 = (int)(f35 * (f55 - f47));
                    int n30 = (int)(f35 * (f56 - f48));
                    int n31 = (int)(f35 * (f57 - f49));
                    int n32 = (int)(f35 * (f58 - f50));
                    n22 = (int)(f36 * (f59 - f51));
                    n23 = (int)(f36 * (f60 - f52));
                    n24 = (int)(f36 * (f61 - f53));
                    if (Config.spanBasedHsr && (n4 <= n8 && n5 >= n11 && f23 >= f54 && f23 >= f13 || n6 <= n8 && n7 >= n11 && f24 >= f54 && f24 >= f13)) {
                        if (n11 != n12) {
                            n17 += n13 * n28;
                            n18 += n13 * n29;
                            n19 += n13 * n30;
                            n20 += n13 * n31;
                            n21 += n13 * n32;
                            n14 += n13 * n22;
                            n15 += n13 * n23;
                            n16 += n13 * n24;
                        }
                    } else {
                        int n33;
                        int n34;
                        int n35;
                        int n36 = n11 + n9;
                        int n37 = 0;
                        int n38 = 0;
                        int n39 = 0;
                        int n40 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n29 < 196608 && n29 > -196608 && n30 <= 196608 && n30 >= -196608) {
                                bl = true;
                            }
                            if (!bl && n31 < 196608 && n31 > -196608 && n32 <= 196608 && n32 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n41 = (n8 & 1) != 0 ? 65536 + n26 : n27;
                            if (Config.optiZ && (n2 > n11 || n3 < n8 || f54 >= f22 && f13 >= f22)) {
                                for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                    n34 = nArray2[(n20 + n41 >> 18) + (n21 + (n41 ^ 0x10000) >> 18 << by2)];
                                    n33 = (n18 + n41 >> 18) - 128 + (n34 >> 8) + ((n19 + (n41 ^ 0x10000) >> 18) - 128 + (n34 & 0xFF) << by);
                                    n41 ^= 0x30000;
                                    if (n33 < 0) {
                                        n33 = 0;
                                    } else if (n33 >= texture.intSize) {
                                        n33 = texture.intSize - 1;
                                    }
                                    n37 = nArray[n33];
                                    n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                    n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                    n38 = (n37 & 0xFF) + (n16 >> 18);
                                    if ((n40 & 0xFFFFFF00) != 0) {
                                        n40 = 255 >> (n40 >> 28 & 8);
                                    }
                                    if ((n39 & 0xFFFFFF00) != 0) {
                                        n39 = 255 >> (n39 >> 28 & 8);
                                    }
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (n38 >> 28 & 8);
                                    }
                                    nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                    nArray4[n35] = n17;
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            } else if (!bl2) {
                                for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                    if (nArray4[n35] < n17) {
                                        n34 = nArray2[(n20 + n41 >> 18) + (n21 + (n41 ^ 0x10000) >> 18 << by2)];
                                        n33 = (n18 + n41 >> 18) - 128 + (n34 >> 8) + ((n19 + (n41 ^ 0x10000) >> 18) - 128 + (n34 & 0xFF) << by);
                                        n41 ^= 0x30000;
                                        if (n33 < 0) {
                                            n33 = 0;
                                        } else if (n33 >= texture.intSize) {
                                            n33 = texture.intSize - 1;
                                        }
                                        n37 = nArray[n33];
                                        n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                        n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                        n38 = (n37 & 0xFF) + (n16 >> 18);
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                        nArray4[n35] = n17;
                                    }
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            } else {
                                for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                    if (nArray4[n35] > n17) {
                                        n34 = nArray2[(n20 + n41 >> 18) + (n21 + (n41 ^ 0x10000) >> 18 << by2)];
                                        n33 = (n18 + n41 >> 18) - 128 + (n34 >> 8) + ((n19 + (n41 ^ 0x10000) >> 18) - 128 + (n34 & 0xFF) << by);
                                        n41 ^= 0x30000;
                                        if (n33 < 0) {
                                            n33 = 0;
                                        } else if (n33 >= texture.intSize) {
                                            n33 = texture.intSize - 1;
                                        }
                                        n37 = nArray[n33];
                                        n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                        n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                        n38 = (n37 & 0xFF) + (n16 >> 18);
                                        if ((n40 & 0xFFFFFF00) != 0) {
                                            n40 = 255 >> (n40 >> 28 & 8);
                                        }
                                        if ((n39 & 0xFFFFFF00) != 0) {
                                            n39 = 255 >> (n39 >> 28 & 8);
                                        }
                                        if ((n38 & 0xFFFFFF00) != 0) {
                                            n38 = 255 >> (n38 >> 28 & 8);
                                        }
                                        nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                        nArray4[n35] = n17;
                                    }
                                    n18 += n29;
                                    n19 += n30;
                                    n20 += n31;
                                    n21 += n32;
                                    n14 += n22;
                                    n15 += n23;
                                    n16 += n24;
                                    n17 += n28;
                                }
                            }
                        } else if (Config.optiZ && (n2 > n11 || n3 < n8 || f54 >= f22 && f13 >= f22)) {
                            for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                n34 = nArray2[(n20 >> 18) + (n21 >> 18 << by2)];
                                n33 = (n18 >> 18) - 128 + (n34 >> 8) + ((n19 >> 18) - 128 + (n34 & 0xFF) << by);
                                if (n33 >= texture.intSize) {
                                    n33 = texture.intSize - 1;
                                } else if (n33 < 0) {
                                    n33 = 0;
                                }
                                n37 = nArray[n33];
                                n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                n38 = (n37 & 0xFF) + (n16 >> 18);
                                if ((n40 & 0xFFFFFF00) != 0) {
                                    n40 = 255 >> (byte)(n40 >> 28 & 8);
                                }
                                if ((n39 & 0xFFFFFF00) != 0) {
                                    n39 = 255 >> (byte)(n39 >> 28 & 8);
                                }
                                if ((n38 & 0xFFFFFF00) != 0) {
                                    n38 = 255 >> (byte)(n38 >> 28 & 8);
                                }
                                nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                nArray4[n35] = n17;
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        } else if (!bl2) {
                            for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                if (frameBuffer.zbuffer[n35] < n17) {
                                    n34 = nArray2[(n20 >> 18) + (n21 >> 18 << by2)];
                                    n33 = (n18 >> 18) - 128 + (n34 >> 8) + ((n19 >> 18) - 128 + (n34 & 0xFF) << by);
                                    if (n33 >= texture.intSize) {
                                        n33 = texture.intSize - 1;
                                    } else if (n33 < 0) {
                                        n33 = 0;
                                    }
                                    n37 = nArray[n33];
                                    n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                    n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                    n38 = (n37 & 0xFF) + (n16 >> 18);
                                    if ((n40 & 0xFFFFFF00) != 0) {
                                        n40 = 255 >> (byte)(n40 >> 28 & 8);
                                    }
                                    if ((n39 & 0xFFFFFF00) != 0) {
                                        n39 = 255 >> (byte)(n39 >> 28 & 8);
                                    }
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                    nArray4[n35] = n17;
                                }
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        } else {
                            for (n35 = n8 + n9; n35 <= n36; ++n35) {
                                if (frameBuffer.zbuffer[n35] > n17) {
                                    n34 = nArray2[(n20 >> 18) + (n21 >> 18 << by2)];
                                    n33 = (n18 >> 18) - 128 + (n34 >> 8) + ((n19 >> 18) - 128 + (n34 & 0xFF) << by);
                                    if (n33 >= texture.intSize) {
                                        n33 = texture.intSize - 1;
                                    } else if (n33 < 0) {
                                        n33 = 0;
                                    }
                                    n37 = nArray[n33];
                                    n40 = (n37 >> 16 & 0xFF) + (n14 >> 18);
                                    n39 = (n37 >> 8 & 0xFF) + (n15 >> 18);
                                    n38 = (n37 & 0xFF) + (n16 >> 18);
                                    if ((n40 & 0xFFFFFF00) != 0) {
                                        n40 = 255 >> (byte)(n40 >> 28 & 8);
                                    }
                                    if ((n39 & 0xFFFFFF00) != 0) {
                                        n39 = 255 >> (byte)(n39 >> 28 & 8);
                                    }
                                    if ((n38 & 0xFFFFFF00) != 0) {
                                        n38 = 255 >> (byte)(n38 >> 28 & 8);
                                    }
                                    nArray3[n35] = n38 | n39 << 8 | n40 << 16 | 0xFF000000;
                                    nArray4[n35] = n17;
                                }
                                n18 += n29;
                                n19 += n30;
                                n20 += n31;
                                n21 += n32;
                                n14 += n22;
                                n15 += n23;
                                n16 += n24;
                                n17 += n28;
                            }
                        }
                    }
                    f47 = f55;
                    f48 = f56;
                    f49 = f57;
                    f50 = f58;
                    f51 = f59;
                    f52 = f60;
                    f53 = f61;
                } while (n11 < n12);
                boolean bl3 = false;
                if (n10 < n4 && n12 >= n4 || n4 == 99999999) {
                    frameBuffer.exXstart[n] = n10;
                    if (f23 > f33) {
                        frameBuffer.exZlow[n] = f33;
                    }
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    bl3 = true;
                }
                if (n12 > n5 && f7 <= (float)n5 || n5 == -1) {
                    frameBuffer.exXend[n] = n12;
                    if (frameBuffer.exZlow[n] > f14) {
                        frameBuffer.exZlow[n] = f14;
                    }
                    if (frameBuffer.exZlow[n] > f33) {
                        frameBuffer.exZlow[n] = f33;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    if (n10 < n6 && n12 >= n6 || n6 == 99999999) {
                        frameBuffer.exXstart2[n] = n10;
                        if (f24 > f33) {
                            frameBuffer.exZlow2[n] = f33;
                        }
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                    }
                    if (n12 > n7 && f7 <= (float)n7 || n7 == -1) {
                        frameBuffer.exXend2[n] = n12;
                        if (frameBuffer.exZlow2[n] > f14) {
                            frameBuffer.exZlow2[n] = f14;
                        }
                        if (frameBuffer.exZlow2[n] > f33) {
                            frameBuffer.exZlow2[n] = f33;
                        }
                        bl3 = true;
                    }
                }
                if (f7 < (float)n2) {
                    frameBuffer.xstart[n] = n10;
                }
                if (n12 > n3) {
                    frameBuffer.xend[n] = n12;
                }
                if (f14 < f33) {
                    f14 = f33;
                }
                if (f14 > f22) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    private void drawShadedZbufferedFilteredTransparentScanline(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, int n, float f15, float f16, FrameBuffer frameBuffer, Texture texture, boolean bl, int n2) {
        float f17;
        int[] nArray = texture.texels;
        int[] nArray2 = frameBuffer.pixels;
        int[] nArray3 = frameBuffer.zbuffer;
        int n3 = 0;
        int n4 = frameBuffer.xstart[n];
        int n5 = frameBuffer.xend[n];
        float f18 = frameBuffer.zhigh[n];
        int n6 = frameBuffer.exXstart[n];
        int n7 = frameBuffer.exXend[n];
        float f19 = frameBuffer.exZlow[n];
        int n8 = frameBuffer.exXstart2[n];
        int n9 = frameBuffer.exXend2[n];
        float f20 = frameBuffer.exZlow2[n];
        if (f8 < f7) {
            f17 = f7;
            f7 = f8;
            f8 = f17;
            f17 = f9;
            f9 = f10;
            f10 = f17;
            f17 = f11;
            f11 = f12;
            f12 = f17;
            f17 = f13;
            f13 = f14;
            f14 = f17;
            f17 = f;
            f = f2;
            f2 = f17;
            f17 = f3;
            f3 = f4;
            f4 = f17;
            f17 = f5;
            f5 = f6;
            f6 = f17;
        }
        f8 -= 1.0f;
        if (f7 < f16 && f8 >= f15) {
            if (n7 <= n9) {
                if (n7 >= n8) {
                    n7 = n9;
                    frameBuffer.exXend[n] = frameBuffer.exXend2[n];
                    if (n8 < n6) {
                        n6 = n8;
                        frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    }
                    if (f20 < f19) {
                        f19 = f20;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                    frameBuffer.exXstart2[n] = 99999999;
                    n8 = 99999999;
                    frameBuffer.exXend2[n] = -1;
                    n9 = -1;
                    frameBuffer.exZlow2[n] = 2.1474836E9f;
                    f20 = 2.1474836E9f;
                }
            } else if (n9 >= n6) {
                if (n8 < n6) {
                    n6 = n8;
                    frameBuffer.exXstart[n] = frameBuffer.exXstart2[n];
                    if (f20 < f19) {
                        f19 = f20;
                        frameBuffer.exZlow[n] = frameBuffer.exZlow2[n];
                    }
                }
                frameBuffer.exXstart2[n] = 99999999;
                n8 = 99999999;
                frameBuffer.exXend2[n] = -1;
                n9 = -1;
                frameBuffer.exZlow2[n] = 2.1474836E9f;
                f20 = 2.1474836E9f;
            }
            if (!(Config.spanBasedHsr && (float)n6 <= f7 && (float)n7 >= f8 && f19 >= f13 && f19 >= f14 || (float)n8 <= f7 && (float)n9 >= f8 && f20 >= f13 && f20 >= f14)) {
                float f21;
                float f22;
                float f23;
                float f24;
                float f25;
                float f26;
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f14 > 1.0f) {
                    f14 = 1.0f;
                }
                f17 = f13;
                float f27 = f8 - f7;
                if (f27 < 1.0f) {
                    f2 = f;
                    f4 = f3;
                    f6 = f5;
                }
                if (f27 != 0.0f) {
                    float f28 = 1.0f / f27;
                    f26 = (f10 - f9) * f28;
                    f25 = (f12 - f11) * f28;
                    f24 = (f14 - f13) * f28;
                    f23 = (f2 - f) * f28;
                    f22 = (f4 - f3) * f28;
                    f21 = (f6 - f5) * f28;
                } else {
                    f26 = 0.0f;
                    f25 = 0.0f;
                    f24 = 0.0f;
                    f21 = 0.0f;
                    f23 = 0.0f;
                    f22 = 0.0f;
                }
                if (f8 >= f16) {
                    f8 = f16 - 1.0f;
                }
                if (f7 < f15) {
                    f7 = f15 - f7;
                    f += f7 * f23;
                    f3 += f7 * f22;
                    f5 += f7 * f21;
                    f9 += f7 * f26;
                    f11 += f7 * f25;
                    f13 += f7 * f24;
                    f7 = f15;
                }
                int n10 = n * frameBuffer.width;
                int n11 = (int)f7;
                int n12 = n11 - 1;
                int n13 = (int)f8;
                int n14 = 16;
                float f29 = 16384.0f;
                float f30 = 16384.0f;
                float f31 = Config.zTrick ? 1.3421773E8f : 2.6843546E8f;
                float f32 = 16.0f * f26;
                float f33 = 16.0f * f25;
                float f34 = 16.0f * f24;
                float f35 = 16.0f * f23;
                float f36 = 16.0f * f22;
                float f37 = 16.0f * f21;
                float f38 = 1.0f / f13;
                float f39 = f9 * f38;
                float f40 = f11 * f38;
                float f41 = f * f38;
                float f42 = f3 * f38;
                float f43 = f5 * f38;
                byte by = texture.shifter;
                int n15 = (int)(f41 * 262144.0f);
                int n16 = (int)(f42 * 262144.0f);
                int n17 = (int)(f43 * 262144.0f);
                int n18 = 0;
                boolean bl2 = false;
                if (Config.zTrick) {
                    n18 = (int)(f13 * 2.1474836E9f);
                    if ((frameBuffer.frameCount & 1L) == 1L) {
                        n18 = -n18;
                        bl2 = true;
                    }
                } else {
                    n18 = (int)(f13 * 4.2949673E9f + -2.1474836E9f);
                }
                if (f39 > texture.xend) {
                    f39 = texture.xend;
                } else if (f39 < 0.0f) {
                    f39 = 0.0f;
                }
                if (f40 > texture.yend) {
                    f40 = texture.yend;
                } else if (f40 < 0.0f) {
                    f40 = 0.0f;
                }
                int n19 = (int)(f39 * 262144.0f);
                int n20 = (int)(f40 * 262144.0f);
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                int n24 = n & 1;
                int n25 = 1 - n24 << 17;
                int n26 = n24 << 17;
                do {
                    n11 = n12 + 1;
                    if ((n12 += n14) > n13) {
                        n14 -= n12 - n13;
                        n12 = n13;
                        f32 = (float)n14 * f26;
                        f33 = (float)n14 * f25;
                        f34 = (float)n14 * f24;
                        f35 = (float)n14 * f23;
                        f36 = (float)n14 * f22;
                        f37 = (float)n14 * f21;
                        if (n14 == 0) {
                            n14 = 1;
                        }
                        f29 = f30 = (float)(262144 / n14);
                        f31 = Config.zTrick ? 2.1474836E9f / (float)n14 : 4.2949673E9f / (float)n14;
                    }
                    float f44 = f13;
                    if (n12 == n13 && f8 < f16 - 1.0f) {
                        f32 = f10 - f9;
                        f33 = f12 - f11;
                        f34 = f14 - f13;
                    }
                    f9 += f32;
                    f11 += f33;
                    f += f35;
                    f3 += f36;
                    f5 += f37;
                    f38 = 1.0f / (f13 += f34);
                    float f45 = f9 * f38;
                    float f46 = f11 * f38;
                    float f47 = f * f38;
                    float f48 = f3 * f38;
                    float f49 = f5 * f38;
                    if (f45 > texture.xend) {
                        f45 = texture.xend;
                    } else if (f45 < 0.0f) {
                        f45 = 0.0f;
                    }
                    if (f46 > texture.yend) {
                        f46 = texture.yend;
                    } else if (f46 < 0.0f) {
                        f46 = 0.0f;
                    }
                    int n27 = (int)(f31 * (f13 - f44));
                    if (bl2) {
                        n27 = -n27;
                    }
                    int n28 = (int)(f29 * (f45 - f39));
                    int n29 = (int)(f29 * (f46 - f40));
                    n21 = (int)(f30 * (f47 - f41));
                    n22 = (int)(f30 * (f48 - f42));
                    n23 = (int)(f30 * (f49 - f43));
                    if (Config.spanBasedHsr && (n6 <= n11 && n7 >= n12 && f19 >= f44 && f19 >= f13 || n8 <= n11 && n9 >= n12 && f20 >= f44 && f20 >= f13)) {
                        if (n12 != n13) {
                            n18 += n14 * n27;
                            n19 += n14 * n28;
                            n20 += n14 * n29;
                            n15 += n14 * n21;
                            n16 += n14 * n22;
                            n17 += n14 * n23;
                        }
                    } else {
                        int n30;
                        int n31;
                        n3 = n12 + n10;
                        int n32 = 0;
                        int n33 = 0;
                        int n34 = 0;
                        int n35 = 0;
                        if (Config.texelFilter) {
                            if (!bl && n28 < 196608 && n28 > -196608 && n29 <= 196608 && n29 >= -196608) {
                                bl = true;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            int n36 = (n11 & 1) != 0 ? 65536 + n25 : n26;
                            if (!bl2) {
                                for (n31 = n11 + n10; n31 <= n3; ++n31) {
                                    if (n18 > frameBuffer.zbuffer[n31]) {
                                        n32 = nArray[(n19 + n36 >> 18) + (n20 + (n36 ^ 0x10000) >> 18 << by)];
                                        n36 ^= 0x30000;
                                        if ((n32 & 0xF0F0F0) != 0) {
                                            n30 = nArray2[n31];
                                            n35 = (n32 >> 15 & 0x1FE) + (n15 >> 17) + ((n30 >> 16 & 0xFF) >> n2) >> 1;
                                            n34 = (n32 >> 7 & 0x1FE) + (n16 >> 17) + ((n30 >> 8 & 0xFF) >> n2) >> 1;
                                            n33 = ((n32 & 0xFF) + (n17 >> 18) << 1) + ((n30 & 0xFF) >> n2) >> 1;
                                            if ((n35 & 0xFFFFFF00) != 0) {
                                                n35 = 255 >> (n35 >> 28 & 8);
                                            }
                                            if ((n34 & 0xFFFFFF00) != 0) {
                                                n34 = 255 >> (n34 >> 28 & 8);
                                            }
                                            if ((n33 & 0xFFFFFF00) != 0) {
                                                n33 = 255 >> (n33 >> 28 & 8);
                                            }
                                            nArray2[n31] = n33 | n34 << 8 | n35 << 16 | 0xFF000000;
                                        }
                                    }
                                    n19 += n28;
                                    n20 += n29;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n27;
                                }
                            } else {
                                for (n31 = n11 + n10; n31 <= n3; ++n31) {
                                    if (n18 < frameBuffer.zbuffer[n31]) {
                                        n32 = nArray[(n19 + n36 >> 18) + (n20 + (n36 ^ 0x10000) >> 18 << by)];
                                        n36 ^= 0x30000;
                                        if ((n32 & 0xF0F0F0) != 0) {
                                            n30 = nArray2[n31];
                                            n35 = (n32 >> 15 & 0x1FE) + (n15 >> 17) + ((n30 >> 16 & 0xFF) >> n2) >> 1;
                                            n34 = (n32 >> 7 & 0x1FE) + (n16 >> 17) + ((n30 >> 8 & 0xFF) >> n2) >> 1;
                                            n33 = ((n32 & 0xFF) + (n17 >> 18) << 1) + ((n30 & 0xFF) >> n2) >> 1;
                                            if ((n35 & 0xFFFFFF00) != 0) {
                                                n35 = 255 >> (n35 >> 28 & 8);
                                            }
                                            if ((n34 & 0xFFFFFF00) != 0) {
                                                n34 = 255 >> (n34 >> 28 & 8);
                                            }
                                            if ((n33 & 0xFFFFFF00) != 0) {
                                                n33 = 255 >> (n33 >> 28 & 8);
                                            }
                                            nArray2[n31] = n33 | n34 << 8 | n35 << 16 | 0xFF000000;
                                        }
                                    }
                                    n19 += n28;
                                    n20 += n29;
                                    n15 += n21;
                                    n16 += n22;
                                    n17 += n23;
                                    n18 += n27;
                                }
                            }
                        } else if (!bl2) {
                            for (n31 = n11 + n10; n31 <= n3; ++n31) {
                                if (nArray3[n31] < n18 && ((n32 = nArray[(n19 >> 18) + (n20 >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n30 = nArray2[n31];
                                    n35 = (n32 >> 15 & 0x1FE) + (n15 >> 17) + ((n30 >> 16 & 0xFF) >> n2) >> 1;
                                    n34 = (n32 >> 7 & 0x1FE) + (n16 >> 17) + ((n30 >> 8 & 0xFF) >> n2) >> 1;
                                    n33 = ((n32 & 0xFF) + (n17 >> 18) << 1) + ((n30 & 0xFF) >> n2) >> 1;
                                    if ((n35 & 0xFFFFFF00) != 0) {
                                        n35 = 255 >> (byte)(n35 >> 28 & 8);
                                    }
                                    if ((n34 & 0xFFFFFF00) != 0) {
                                        n34 = 255 >> (byte)(n34 >> 28 & 8);
                                    }
                                    if ((n33 & 0xFFFFFF00) != 0) {
                                        n33 = 255 >> (byte)(n33 >> 28 & 8);
                                    }
                                    nArray2[n31] = n33 | n34 << 8 | n35 << 16 | 0xFF000000;
                                }
                                n19 += n28;
                                n20 += n29;
                                n15 += n21;
                                n16 += n22;
                                n17 += n23;
                                n18 += n27;
                            }
                        } else {
                            for (n31 = n11 + n10; n31 <= n3; ++n31) {
                                if (nArray3[n31] > n18 && ((n32 = nArray[(n19 >> 18) + (n20 >> 18 << by)]) & 0xF0F0F0) != 0) {
                                    n30 = nArray2[n31];
                                    n35 = (n32 >> 15 & 0x1FE) + (n15 >> 17) + ((n30 >> 16 & 0xFF) >> n2) >> 1;
                                    n34 = (n32 >> 7 & 0x1FE) + (n16 >> 17) + ((n30 >> 8 & 0xFF) >> n2) >> 1;
                                    n33 = ((n32 & 0xFF) + (n17 >> 18) << 1) + ((n30 & 0xFF) >> n2) >> 1;
                                    if ((n35 & 0xFFFFFF00) != 0) {
                                        n35 = 255 >> (byte)(n35 >> 28 & 8);
                                    }
                                    if ((n34 & 0xFFFFFF00) != 0) {
                                        n34 = 255 >> (byte)(n34 >> 28 & 8);
                                    }
                                    if ((n33 & 0xFFFFFF00) != 0) {
                                        n33 = 255 >> (byte)(n33 >> 28 & 8);
                                    }
                                    nArray2[n31] = n33 | n34 << 8 | n35 << 16 | 0xFF000000;
                                }
                                n19 += n28;
                                n20 += n29;
                                n15 += n21;
                                n16 += n22;
                                n17 += n23;
                                n18 += n27;
                            }
                        }
                    }
                    f39 = f45;
                    f40 = f46;
                    f41 = f47;
                    f42 = f48;
                    f43 = f49;
                } while (n12 < n13);
                if (f7 < (float)n4) {
                    frameBuffer.xstart[n] = (int)f7;
                }
                if (n13 > n5) {
                    frameBuffer.xend[n] = n13;
                }
                if (f14 < f17) {
                    f14 = f17;
                }
                if (f14 > f18) {
                    frameBuffer.zhigh[n] = f14;
                }
            }
        }
    }

    public VideoMode[] getAvailableVideoModes() {
        return new VideoMode[0];
    }

    public boolean isInitialized() {
        return true;
    }
}

