/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Animation;
import com.threed.jpct.Config;
import com.threed.jpct.DeSerializer;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.Portals;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.World;
import com.threed.jpct.util.XMLFactory;
import com.threed.jpct.util.XMLNode;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Loader {
    private static final int DEFAULT_BUFFER = 500000;
    private static final int MAX_CACHE_SIZE = 1000000;
    private static String lastFilename = "";
    private static String lastFileData = "";
    private static boolean optimize = true;

    private Loader() {
    }

    public static void setVertexOptimization(boolean bl) {
        optimize = bl;
    }

    public static String loadTextFile(String string) {
        return Loader.loadTextFile(null, string, null);
    }

    public static String loadTextFile(URL uRL, String string) {
        return Loader.loadTextFile(uRL, string, null);
    }

    public static String loadTextFile(InputStream inputStream) {
        return Loader.loadTextFile(null, null, inputStream);
    }

    private static String loadTextFile(URL uRL, String string, InputStream inputStream) {
        if (string != null && lastFilename != null && lastFilename.equals(string)) {
            Logger.log("Reading file " + string + " from cache", 2);
            return lastFileData;
        }
        Loader.clearCache();
        String[] stringArray = new String[1];
        Loader.loadBinaryFile(uRL, string, inputStream, 500000, stringArray);
        if (stringArray != null && stringArray[0] != null) {
            if (stringArray[0].length() <= 1000000 && string != null) {
                lastFilename = string;
                lastFileData = stringArray[0];
            }
            return stringArray[0];
        }
        Logger.log("Couldn't load text-file!", 0);
        return "";
    }

    public static Object3D loadSerializedObject(InputStream inputStream) {
        return new DeSerializer().deserialize(inputStream);
    }

    public static Object3D[] loadSerializedObjectArray(InputStream inputStream) {
        return new DeSerializer().deserializeArray(inputStream);
    }

    public static Object3D loadMD2(String string, float f) {
        return Loader.loadMD2(null, string, null, f);
    }

    public static Object3D loadMD2(URL uRL, String string, float f) {
        return Loader.loadMD2(uRL, string, null, f);
    }

    public static Object3D loadMD2(InputStream inputStream, float f) {
        return Loader.loadMD2(null, null, inputStream, f);
    }

    public static void loadSceneFromXML(String string, World world) {
        Loader.loadSceneFromXML(null, string, null, world);
    }

    public static void loadSceneFromXML(URL uRL, String string, World world) {
        Loader.loadSceneFromXML(uRL, string, null, world);
    }

    public static void loadSceneFromXML(InputStream inputStream, World world) {
        Loader.loadSceneFromXML(null, null, inputStream, world);
    }

    public static Object3D[] load3DS(String string, float f) {
        return Loader.load3DS(null, string, null, f);
    }

    public static Object3D[] load3DS(URL uRL, String string, float f) {
        return Loader.load3DS(uRL, string, null, f);
    }

    public static Object3D[] load3DS(InputStream inputStream, float f) {
        return Loader.load3DS(null, null, inputStream, f);
    }

    public static String[] readTextureNames3DS(String string) {
        return Loader.readTextureNames3DS(null, string, null);
    }

    public static String[] readTextureNames3DS(URL uRL, String string) {
        return Loader.readTextureNames3DS(uRL, string, null);
    }

    public static String[] readTextureNames3DS(InputStream inputStream) {
        return Loader.readTextureNames3DS(null, null, inputStream);
    }

    public static Object3D loadASC(String string, float f, boolean bl) {
        return Loader.loadASC(null, string, null, f, bl);
    }

    public static Object3D loadASC(URL uRL, String string, float f, boolean bl) {
        return Loader.loadASC(uRL, string, null, f, bl);
    }

    public static Object3D loadASC(InputStream inputStream, float f, boolean bl) {
        return Loader.loadASC(null, null, inputStream, f, bl);
    }

    public static Object3D[] loadOBJ(String string, String string2, float f) {
        return Loader.loadOBJ(null, string, string2, null, null, f);
    }

    public static Object3D[] loadOBJ(URL uRL, String string, String string2, float f) {
        return Loader.loadOBJ(uRL, string, string2, null, null, f);
    }

    public static Object3D[] loadOBJ(InputStream inputStream, InputStream inputStream2, float f) {
        return Loader.loadOBJ(null, null, null, inputStream, inputStream2, f);
    }

    private static Object3D[] loadOBJ(URL uRL, String string, String string2, InputStream inputStream, InputStream inputStream2, float f) {
        Object object;
        int n;
        String string3;
        String string4 = null;
        if (string2 != null || inputStream2 != null) {
            string4 = Loader.loadTextFile(uRL, string2, inputStream2);
            string4 = string4.replace('\t', ' ');
        } else {
            string4 = "";
        }
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
        String string5 = null;
        Color color = null;
        String string6 = null;
        String string7 = null;
        float[] fArray = new float[3];
        boolean bl = true;
        String string8 = null;
        Float f2 = null;
        TextureManager textureManager = TextureManager.getInstance();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                string8 = stringTokenizer.nextToken().trim();
            }
            switch (n2) {
                case 0: {
                    if (!string8.startsWith("newmtl ")) break;
                    string5 = string8.substring(7).trim();
                    n2 = 1;
                    bl = true;
                    color = null;
                    string6 = null;
                    string7 = null;
                    f2 = null;
                    Logger.log("Processing new material " + string5 + "!", 2);
                    break;
                }
                case 1: {
                    string3 = string8.toLowerCase();
                    if (string3.startsWith("kd ")) {
                        String string9 = string3.substring(3).trim();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string9, " ");
                        for (n = 0; stringTokenizer2.hasMoreTokens() && n < 3; ++n) {
                            object = stringTokenizer2.nextToken();
                            try {
                                fArray[n] = Float.valueOf((String)object).floatValue();
                                continue;
                            }
                            catch (Exception exception) {
                                fArray[n] = 1.0f;
                                Logger.log("Error in MTL-file near: " + string8, 0);
                            }
                        }
                        color = new Color((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
                        break;
                    }
                    if ((string3.startsWith("map_kd") || string3.startsWith("map_ka")) && string8.length() > 7) {
                        if (string3.startsWith("map_kd")) {
                            string6 = string8.substring(7).trim();
                            if (textureManager.containsTexture(string6)) break;
                            textureManager.addTexture(string6);
                            Logger.log("Texture named " + string6 + " added to TextureManager!", 2);
                            break;
                        }
                        string7 = string8.substring(7).trim();
                        if (textureManager.containsTexture(string7)) break;
                        textureManager.addTexture(string7);
                        Logger.log("Texture named " + string7 + " added to TextureManager!", 2);
                        break;
                    }
                    if (string3.startsWith("d ")) {
                        float f3 = -1.0f;
                        try {
                            f3 = Float.parseFloat(string8.substring(2).trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (f3 == -1.0f || f3 == 1.0f) break;
                        f2 = new Float(f3);
                        break;
                    }
                    if (!string3.startsWith("newmtl")) break;
                    n2 = 0;
                    bl = false;
                }
            }
            if (bl && stringTokenizer.hasMoreTokens()) continue;
            hashtable.put(string5, new Object[]{color, string6, f2, string7});
        }
        string3 = Loader.loadTextFile(uRL, string, inputStream);
        if ((string3 = string3.replace('\t', ' ')).indexOf("o ") == -1 && string3.indexOf("g ") == -1 && string3.indexOf("g\n") == -1 && string3.indexOf("o\n") == -1) {
            string3 = "o jPCT_generated\n" + string3;
        }
        int n3 = Loader.countOcc(string3, "v ");
        int n4 = Loader.countOcc(string3, "vt ");
        n = Loader.countOcc(string3, "f ");
        object = new float[n3][3];
        float[][] fArray2 = new float[n4][2];
        int[][][] nArray = new int[n][4][2];
        String[] stringArray = new String[n];
        n = 0;
        n3 = 0;
        n4 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (!optimize) {
            nArray2 = new int[((float[][])object).length];
            nArray3 = new int[3];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1;
            }
        }
        stringTokenizer = new StringTokenizer(string3, "\n");
        String string10 = null;
        string2 = null;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Object3D> vector = new Vector<Object3D>();
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer3;
            string8 = stringTokenizer.nextToken().trim();
            bl = false;
            if (string8.startsWith("v ")) {
                String string11 = string8.substring(2).trim();
                stringTokenizer3 = new StringTokenizer(string11, " ");
                for (int i = 0; stringTokenizer3.hasMoreTokens() && i < 3; ++i) {
                    String string12 = stringTokenizer3.nextToken();
                    try {
                        object[n3][i] = Float.valueOf(string12).floatValue() * f;
                        continue;
                    }
                    catch (Exception exception) {
                        object[n3][i] = 0.0f;
                    }
                }
                ++n3;
            } else if (string8.startsWith("vt ")) {
                String string13 = string8.substring(3).trim();
                stringTokenizer3 = new StringTokenizer(string13, " ");
                fArray2[n4][1] = 0.0f;
                for (int i = 0; stringTokenizer3.hasMoreTokens() && i < 2; ++i) {
                    String string14 = stringTokenizer3.nextToken();
                    try {
                        fArray2[n4][i] = Float.valueOf(string14).floatValue();
                        continue;
                    }
                    catch (Exception exception) {
                        fArray2[n4][i] = 0.0f;
                        Logger.log("Error in OBJ-file near: " + string8, 0);
                    }
                }
                ++n4;
            } else if (string8.startsWith("usemtl")) {
                string2 = string8.substring(7).trim();
            } else if (string8.startsWith("f ")) {
                String string15 = string8.substring(2).trim();
                stringTokenizer3 = new StringTokenizer(string15, " ");
                int n7 = 0;
                while (stringTokenizer3.hasMoreTokens() && n7 < 4) {
                    if (n7 == 3) {
                        ++n5;
                    }
                    String string16 = stringTokenizer3.nextToken();
                    int n8 = string16.indexOf("/");
                    int n9 = -1;
                    if (n8 == -1) {
                        n8 = string16.length();
                    } else {
                        n9 = string16.indexOf("/", n8 + 1);
                    }
                    if (n9 == -1) {
                        n9 = string16.length();
                    }
                    String string17 = string16.substring(0, n8);
                    String string18 = null;
                    if (n8 + 1 < n9) {
                        string18 = string16.substring(n8 + 1, n9);
                    }
                    try {
                        nArray[n][n7][0] = Integer.valueOf(string17);
                        if (string18 == null) {
                            string18 = "1";
                        }
                        nArray[n][n7][1] = Integer.valueOf(string18);
                    }
                    catch (Exception exception) {
                        nArray[n][n7][0] = 1;
                        nArray[n][n7][1] = 1;
                        Logger.log("Error in OBJ-file near: " + string8, 0);
                    }
                    if (++n7 != 4 || !stringTokenizer3.hasMoreTokens()) continue;
                    bl2 = true;
                }
                for (int i = n7; i < 4; ++i) {
                    nArray[n][n7][0] = -9999;
                    nArray[n][n7][1] = -9999;
                }
                stringArray[n] = string2;
                ++n;
            } else {
                boolean bl4 = string8.startsWith("o");
                if (bl4 || string8.startsWith("g")) {
                    stringTokenizer3 = string10;
                    String string19 = string8.substring(1).trim();
                    if (string19.length() == 0 && (string10 == null || string10.length() == 0)) {
                        string10 = "noname";
                    } else if (string19.length() > 0) {
                        string10 = string19;
                    }
                    if (n - n6 > 0) {
                        vector.addElement(Loader.createOBJObject(hashtable, nArray, object, fArray2, (String)(stringTokenizer3 != null ? stringTokenizer3 : string10), stringArray, n, n6, n4, n5, nArray2, nArray3));
                    }
                    if (bl4) {
                        for (int i = n6; i < n; ++i) {
                            stringArray[i] = null;
                        }
                    }
                    Logger.log("Processing object from OBJ-file: " + string10, 2);
                    n6 = n;
                    n5 = 0;
                } else if (!bl3 && (string8.startsWith("p ") || string8.startsWith("l ") || string8.startsWith("curv") || string8.startsWith("surf"))) {
                    bl3 = true;
                }
            }
            if (stringTokenizer.hasMoreTokens() || n - n6 <= 0) continue;
            vector.addElement(Loader.createOBJObject(hashtable, nArray, object, fArray2, string10, stringArray, n, n6, n4, n5, nArray2, nArray3));
        }
        if (bl3) {
            Logger.log("This OBJ-file contains unsupported geometry data. This data has been skipped!", 1);
        }
        if (bl2) {
            Logger.log("This OBJ-file contains n-polygons with n>4! These polygons wont be displayed correctly!", 1);
        }
        Object3D[] object3DArray = new Object3D[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object3DArray[i] = (Object3D)vector.elementAt(i);
        }
        if (string4 != null) {
            Loader.clearCache();
        }
        return object3DArray;
    }

    private static Object3D createOBJObject(Hashtable hashtable, int[][][] nArray, float[][] fArray, float[][] fArray2, String string, String[] stringArray, int n, int n2, int n3, int n4, int[] nArray2, int[] nArray3) {
        Object3D object3D = new Object3D(n - n2 + n4);
        if (string == null) {
            string = "noname";
        }
        boolean bl = false;
        if (n3 == 0) {
            bl = true;
            fArray2 = new float[1][2];
        }
        boolean bl2 = false;
        TextureManager textureManager = TextureManager.getInstance();
        int n5 = -1;
        int n6 = -1;
        if (!optimize) {
            object3D.disableVertexSharing();
        }
        String string2 = "jkkjkljdldld----";
        for (int i = n2; i < n; ++i) {
            Object object;
            Object object2;
            String string3 = stringArray[i];
            if (string3 != null && !string3.equals(string2)) {
                n5 = -1;
                n6 = -1;
                string2 = string3;
                object2 = (Object[])hashtable.get(string3);
                object = null;
                if (object2 == null) {
                    n5 = textureManager.getTextureID(string3);
                } else {
                    if (object2[1] != null) {
                        n5 = textureManager.getTextureID((String)object2[1]);
                    }
                    if (object2[3] != null) {
                        n6 = textureManager.getTextureID((String)object2[3]);
                    }
                    if (n5 == -1 && (object = (Color)object2[0]) != null) {
                        String string4 = "__obj-Color:" + ((Color)object).getRed() + "/" + ((Color)object).getGreen() + "/" + ((Color)object).getBlue();
                        if (textureManager.containsTexture(string4)) {
                            n5 = textureManager.getTextureID(string4);
                        } else {
                            Texture texture = Texture.createSingleColoredTexture((Color)object);
                            textureManager.addTexture(string4, texture);
                            n5 = textureManager.getTextureID(string4);
                        }
                    }
                    if (object2[2] != null) {
                        bl2 = true;
                        object3D.setTransparency((int)(10.0f * ((Float)object2[2]).floatValue()));
                    } else if (bl2) {
                        object3D.setTransparency(-1);
                    }
                }
            }
            object2 = null;
            object = null;
            int n7 = nArray[i][0][0] - 1;
            int n8 = nArray[i][1][0] - 1;
            int n9 = nArray[i][2][0] - 1;
            int n10 = nArray[i][3][0] - 1;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            if (!bl) {
                n11 = Math.max(0, nArray[i][0][1] - 1);
                n12 = Math.max(0, nArray[i][1][1] - 1);
                n13 = Math.max(0, nArray[i][2][1] - 1);
                n14 = Math.max(0, nArray[i][3][1] - 1);
            }
            if (n9 < 0 || n8 < 0) continue;
            if (n5 != -1 && n6 != -1) {
                object2 = new TextureInfo(n5, fArray2[n11][0], 1.0f - fArray2[n11][1], fArray2[n12][0], 1.0f - fArray2[n12][1], fArray2[n13][0], 1.0f - fArray2[n13][1]);
                ((TextureInfo)object2).add(n6, fArray2[n11][0], 1.0f - fArray2[n11][1], fArray2[n12][0], 1.0f - fArray2[n12][1], fArray2[n13][0], 1.0f - fArray2[n13][1], 1);
                object = new TextureInfo(n5, fArray2[n11][0], 1.0f - fArray2[n11][1], fArray2[n13][0], 1.0f - fArray2[n13][1], fArray2[n14][0], 1.0f - fArray2[n14][1]);
                ((TextureInfo)object).add(n6, fArray2[n11][0], 1.0f - fArray2[n11][1], fArray2[n13][0], 1.0f - fArray2[n13][1], fArray2[n14][0], 1.0f - fArray2[n14][1], 1);
            }
            if (optimize) {
                object3D.addTriangle(fArray[n7][0], fArray[n7][1], fArray[n7][2], fArray2[n11][0], 1.0f - fArray2[n11][1], fArray[n8][0], fArray[n8][1], fArray[n8][2], fArray2[n12][0], 1.0f - fArray2[n12][1], fArray[n9][0], fArray[n9][1], fArray[n9][2], fArray2[n13][0], 1.0f - fArray2[n13][1], n5, 0, false, null, (TextureInfo)object2);
                if (n10 < 0) continue;
                object3D.addTriangle(fArray[n7][0], fArray[n7][1], fArray[n7][2], fArray2[n11][0], 1.0f - fArray2[n11][1], fArray[n9][0], fArray[n9][1], fArray[n9][2], fArray2[n13][0], 1.0f - fArray2[n13][1], fArray[n10][0], fArray[n10][1], fArray[n10][2], fArray2[n14][0], 1.0f - fArray2[n14][1], n5, 0, false, null, (TextureInfo)object);
                continue;
            }
            nArray3[0] = nArray2[n7];
            nArray3[1] = nArray2[n8];
            nArray3[2] = nArray2[n9];
            object3D.addTriangle(fArray[n7][0], fArray[n7][1], fArray[n7][2], fArray2[n11][0], 1.0f - fArray2[n11][1], fArray[n8][0], fArray[n8][1], fArray[n8][2], fArray2[n12][0], 1.0f - fArray2[n12][1], fArray[n9][0], fArray[n9][1], fArray[n9][2], fArray2[n13][0], 1.0f - fArray2[n13][1], n5, 0, false, nArray3, (TextureInfo)object2);
            if (nArray2[n7] == -1) {
                nArray2[n7] = nArray3[0];
            }
            if (nArray2[n8] == -1) {
                nArray2[n8] = nArray3[1];
            }
            if (nArray2[n9] == -1) {
                nArray2[n9] = nArray3[2];
            }
            if (n10 < 0) continue;
            nArray3[0] = nArray2[n7];
            nArray3[1] = nArray2[n9];
            nArray3[2] = nArray2[n10];
            object3D.addTriangle(fArray[n7][0], fArray[n7][1], fArray[n7][2], fArray2[n11][0], 1.0f - fArray2[n11][1], fArray[n9][0], fArray[n9][1], fArray[n9][2], fArray2[n13][0], 1.0f - fArray2[n13][1], fArray[n10][0], fArray[n10][1], fArray[n10][2], fArray2[n14][0], 1.0f - fArray2[n14][1], n5, 0, false, nArray3, (TextureInfo)object);
            if (nArray2[n7] == -1) {
                nArray2[n7] = nArray3[0];
            }
            if (nArray2[n9] == -1) {
                nArray2[n9] = nArray3[1];
            }
            if (nArray2[n10] != -1) continue;
            nArray2[n10] = nArray3[2];
        }
        object3D.setName(string + "_jPCT" + object3D.getID());
        object3D.getMesh().compress();
        Logger.log("Object '" + object3D.getName() + "' created using " + object3D.getMesh().anzTri + " polygons and " + object3D.getMesh().anzCoords + " vertices.", 2);
        return object3D;
    }

    private static int countOcc(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        do {
            if ((n2 = string.indexOf(string2, n2 + n3)) == -1) continue;
            ++n;
        } while (n2 != -1);
        return n;
    }

    private static Object3D loadASC(URL uRL, String string, InputStream inputStream, float f, boolean bl) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        Object3D object3D = new Object3D(-1);
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        float[] fArray = new float[Config.loadMaxVerticesASC];
        float[] fArray2 = new float[Config.loadMaxVerticesASC];
        float[] fArray3 = new float[Config.loadMaxVerticesASC];
        int[] nArray = new int[Config.loadMaxTrianglesASC];
        int[] nArray2 = new int[Config.loadMaxTrianglesASC];
        int[] nArray3 = new int[Config.loadMaxTrianglesASC];
        float[] fArray4 = new float[1];
        float[] fArray5 = new float[1];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = Loader.loadTextFile(uRL, string, inputStream);
        if (!string5.endsWith("\n")) {
            string5 = string5 + "\n";
        }
        if (!string5.equals("error")) {
            int n9;
            Logger.log("Parsing Objectfile!", 2);
            if (string5.indexOf("U:") != -1) {
                bl2 = true;
                fArray4 = new float[Config.loadMaxTrianglesASC];
                fArray5 = new float[Config.loadMaxTrianglesASC];
                Logger.log("Objectfile contains additional Texture coordinates!", 2);
            }
            String string6 = "";
            int n10 = 0;
            int n11 = 0;
            int n12 = string5.indexOf("Vertex list");
            n12 = string5.indexOf("\n", n12 + 10);
            while (n12 != -1) {
                Number number;
                Number number2;
                Number number3;
                int n13;
                String string7;
                int n14;
                String string8;
                int n15;
                n4 = n3;
                while (n12 != -1) {
                    n9 = string5.indexOf("\n", ++n12);
                    n10 = n9 + 1;
                    n11 = n12;
                    string6 = string5.substring(n12, n10);
                    if (string6.indexOf("X:") != -1) {
                        n15 = string6.indexOf("X:", 8);
                        n12 = string6.indexOf("Y:", n15 += 2);
                        string8 = string6.substring(n15, n12).trim();
                        n14 = string6.indexOf("Z:", n12 + 2);
                        string7 = string6.substring(n12 + 2, n14).trim();
                        n13 = string6.indexOf("U:", n14 + 2);
                        bl2 = false;
                        if (n13 != -1) {
                            string4 = string6.substring(n14 + 2, n13).trim();
                            n6 = string6.indexOf("V:", n13 + 2);
                            string3 = string6.substring(n13 + 2, n6).trim();
                            n7 = string6.indexOf("\n", n6 + 2);
                            string2 = string6.substring(n6 + 2, n7).trim();
                            n13 = n7;
                            bl2 = true;
                        } else {
                            n13 = string6.indexOf("\n", n14 + 2);
                            string4 = string6.substring(n14 + 2, n13).trim();
                        }
                        if (bl) {
                            number3 = Float.valueOf(string8);
                            number2 = Float.valueOf(string7);
                            number = Float.valueOf(string4);
                            fArray[n3] = ((Float)number3).floatValue() * f;
                            fArray2[n3] = -((Float)number).floatValue() * f;
                            fArray3[n3] = ((Float)number2).floatValue() * f;
                        } else {
                            number3 = Float.valueOf(string8);
                            number2 = Float.valueOf(string7);
                            number = Float.valueOf(string4);
                            fArray[n3] = ((Float)number3).floatValue() * f;
                            fArray2[n3] = -((Float)number2).floatValue() * f;
                            fArray3[n3] = -((Float)number).floatValue() * f;
                        }
                        if (bl2) {
                            fArray4[n3] = Float.valueOf(string3).floatValue();
                            fArray5[n3] = Float.valueOf(string2).floatValue();
                        }
                        ++n3;
                        n12 = n9;
                        continue;
                    }
                    n12 = n9;
                    if (string6.indexOf("Face list") == -1) continue;
                    n12 = -1;
                }
                n12 = n10 - 1;
                while (n12 != -1) {
                    n9 = string5.indexOf("\n", ++n12);
                    n10 = n9 + 1;
                    n11 = n12;
                    string6 = string5.substring(n12, n10);
                    if (string6.indexOf("A:") != -1) {
                        n15 = string6.indexOf("A:", 5);
                        n12 = string6.indexOf("B:", n15 += 2);
                        string8 = string6.substring(n15, n12).trim();
                        n14 = string6.indexOf("C:", n12 + 2);
                        string7 = string6.substring(n12 + 2, n14).trim();
                        n13 = 0;
                        n13 = string6.indexOf("AB:", n14 + 2);
                        string4 = string6.substring(n14 + 2, n13).trim();
                        number3 = Integer.valueOf(string8);
                        number2 = Integer.valueOf(string7);
                        number = Integer.valueOf(string4);
                        nArray[n5] = (Integer)number3 + n4;
                        nArray2[n5] = (Integer)number2 + n4;
                        nArray3[n5] = (Integer)number + n4;
                        ++n5;
                        n12 = n9;
                        continue;
                    }
                    n12 = n9;
                    if (string6.indexOf("Vertex list") != -1) {
                        n12 = -1;
                    }
                    if (n10 < string5.length()) continue;
                    n12 = -1;
                }
                Logger.log("Part: " + n8 + " / Faces: " + n5 + " / Vertices: " + n3, 2);
                ++n8;
                n12 = string5.indexOf("Vertex list", n11);
            }
            object3D.objMesh = new Mesh((n5 * 2 + 1) * 3 + 8);
            object3D.objVectors = new Vectors((n5 + 1) * 3 + 8, object3D.objMesh);
            object3D.texture = new int[n5 + 1];
            object3D.basemap = new int[n5 + 1];
            if (!optimize) {
                object3D.disableVertexSharing();
            }
            if (!Config.saveMemory) {
                object3D.bumpmap = new int[n5 + 1];
                object3D.sector = new int[n5 + 1];
            }
            for (n9 = 0; n9 < n5; ++n9) {
                float f8 = 1.0f;
                float f9 = 1.0f;
                float f10 = f8;
                float f11 = f9;
                if (!bl2) {
                    if ((n9 & 1) == 1) {
                        f2 = 0.0f;
                        f3 = 0.0f;
                        f4 = f8;
                        f5 = 0.0f;
                        f6 = 0.0f;
                        f7 = f9;
                    } else {
                        f2 = f8;
                        f3 = 0.0f;
                        f4 = f8;
                        f5 = f9;
                        f6 = 0.0f;
                        f7 = f9;
                    }
                } else {
                    f2 = f10 * fArray4[nArray[n9]];
                    f3 = f11 - f11 * fArray5[nArray[n9]];
                    f4 = f10 * fArray4[nArray2[n9]];
                    f5 = f11 - f11 * fArray5[nArray2[n9]];
                    f6 = f10 * fArray4[nArray3[n9]];
                    f7 = f11 - f11 * fArray5[nArray3[n9]];
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    if (f2 > f8) {
                        f2 = f8;
                    }
                    if (f3 < 0.0f) {
                        f3 = 0.0f;
                    }
                    if (f3 > f9) {
                        f3 = f9;
                    }
                    if (f4 < 0.0f) {
                        f4 = 0.0f;
                    }
                    if (f4 > f8) {
                        f4 = f8;
                    }
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    if (f5 > f9) {
                        f5 = f9;
                    }
                    if (f6 < 0.0f) {
                        f6 = 0.0f;
                    }
                    if (f6 > f8) {
                        f6 = f8;
                    }
                    if (f7 < 0.0f) {
                        f7 = 0.0f;
                    }
                    if (f7 > f9) {
                        f7 = f9;
                    }
                }
                n2 = object3D.addTriangle(fArray[nArray[n9]], fArray2[nArray[n9]], fArray3[nArray[n9]], f2, f3, fArray[nArray2[n9]], fArray2[nArray2[n9]], fArray3[nArray2[n9]], f4, f5, fArray[nArray3[n9]], fArray2[nArray3[n9]], fArray3[nArray3[n9]], f6, f7, n, 0, false);
            }
            Logger.log("Loaded Object3D: Faces: " + n5 + " / Vertices: " + n3, 2);
            Logger.log("Optimized Object3D: Faces: " + (n2 + 1) + " / Vertices: " + object3D.objMesh.anzCoords, 2);
            return object3D;
        }
        return null;
    }

    public static Object3D loadJAW(String string, float f, boolean bl) {
        return Loader.loadJAW(null, string, null, f, bl);
    }

    public static Object3D loadJAW(URL uRL, String string, float f, boolean bl) {
        return Loader.loadJAW(uRL, string, null, f, bl);
    }

    public static Object3D loadJAW(InputStream inputStream, float f, boolean bl) {
        return Loader.loadJAW(null, null, inputStream, f, bl);
    }

    public static void clearCache() {
        lastFileData = null;
        lastFilename = null;
    }

    private static Object3D loadJAW(URL uRL, String string, InputStream inputStream, float f, boolean bl) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        int n = 0;
        Object3D object3D = new Object3D(-1);
        TextureManager textureManager = TextureManager.getInstance();
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = Loader.loadTextFile(uRL, string, inputStream);
        if (!string4.endsWith("\n")) {
            string4 = string4 + "\n";
        }
        int n4 = Loader.getCharCount(string4, ':') * 3;
        int n5 = Loader.getCharCount(string4, 't');
        float[] fArray = new float[n4];
        float[] fArray2 = new float[n4];
        float[] fArray3 = new float[n4];
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        String[] stringArray = new String[n5];
        int n6 = 0;
        if (!string4.equals("error")) {
            Logger.log("Parsing Objectfile!", 2);
            n6 = string4.indexOf(":");
            while (n6 != -1) {
                Number number;
                Number number2;
                Number number3;
                int n7;
                String string5;
                int n8;
                String string6;
                int n9;
                while (n6 != -1) {
                    n9 = n6 + 2;
                    n6 = string4.indexOf(" ", n9);
                    string6 = string4.substring(n9, n6).trim();
                    n8 = string4.indexOf(" ", n6 + 1);
                    string5 = string4.substring(n6, n8).trim();
                    n7 = string4.indexOf("\n", n8 + 1);
                    string3 = string4.substring(n8, n7).trim();
                    n6 = string4.indexOf(":", n7 + 1);
                    number3 = Float.valueOf(string6);
                    number2 = Float.valueOf(string5);
                    number = Float.valueOf(string3);
                    fArray[n2] = ((Float)number3).floatValue() * f;
                    fArray2[n2] = -((Float)number2).floatValue() * f;
                    fArray3[n2] = -((Float)number).floatValue() * f;
                    ++n2;
                }
                n6 = string4.indexOf("tri");
                while (n6 != -1) {
                    n9 = n6 + 4;
                    n6 = string4.indexOf(",", n9);
                    string6 = string4.substring(n9, n6).trim();
                    n8 = string4.indexOf(",", n6 + 1);
                    string5 = string4.substring(n6 + 1, n8).trim();
                    n7 = 0;
                    if (!bl) {
                        n7 = string4.indexOf("\n", n8 + 1);
                        string3 = string4.substring(n8 + 1, n7).trim();
                        string2 = null;
                    } else {
                        n7 = string4.indexOf(",", n8 + 1);
                        string3 = string4.substring(n8 + 1, n7).trim();
                        int n10 = string4.indexOf("\n", n7 + 1);
                        string2 = string4.substring(n7 + 1, n10).trim();
                        n7 = n10;
                    }
                    n6 = string4.indexOf("tri", n7 + 1);
                    number3 = Integer.valueOf(string6);
                    number2 = Integer.valueOf(string5);
                    number = Integer.valueOf(string3);
                    nArray[n3] = (Integer)number3;
                    nArray2[n3] = (Integer)number2;
                    nArray3[n3] = (Integer)number;
                    stringArray[n3] = string2;
                    ++n3;
                }
                object3D.objMesh = new Mesh((n3 * 2 + 1) * 3 + 8);
                object3D.objVectors = new Vectors((n3 + 1) * 3 + 8, object3D.objMesh);
                object3D.texture = new int[n3 + 1];
                object3D.basemap = new int[n3 + 1];
                if (!Config.saveMemory) {
                    object3D.bumpmap = new int[n3 + 1];
                    object3D.sector = new int[n3 + 1];
                }
                for (n9 = 0; n9 < n3; ++n9) {
                    int n11 = 0;
                    if (stringArray[n9] != null) {
                        n11 = textureManager.getTextureID(stringArray[n9]);
                    }
                    n8 = n11;
                    float f8 = 1.0f;
                    float f9 = 1.0f;
                    if ((n9 & 1) == 1) {
                        f2 = f8;
                        f3 = f9;
                        f4 = f8;
                        f5 = 0.0f;
                        f6 = 0.0f;
                        f7 = 0.0f;
                    } else {
                        f2 = 0.0f;
                        f3 = f9;
                        f4 = f8;
                        f5 = f9;
                        f6 = 0.0f;
                        f7 = 0.0f;
                    }
                    n = object3D.addTriangle(fArray[nArray[n9]], fArray2[nArray[n9]], fArray3[nArray[n9]], f2, f3, fArray[nArray2[n9]], fArray2[nArray2[n9]], fArray3[nArray2[n9]], f4, f5, fArray[nArray3[n9]], fArray2[nArray3[n9]], fArray3[nArray3[n9]], f6, f7, n8, 0, false);
                }
            }
            Logger.log("Loaded Object3D: Faces: " + n3 + " / Vertices: " + n2, 2);
            Logger.log("Optimized Object3D: Faces: " + (n + 1) + " / Vertices: " + object3D.objMesh.anzCoords, 2);
            return object3D;
        }
        return null;
    }

    private static int getInt(byte[] byArray, int n) {
        if (n + 3 < byArray.length) {
            int n2 = Loader.unsignedByteToInt(byArray[n]);
            int n3 = Loader.unsignedByteToInt(byArray[n + 1]);
            int n4 = Loader.unsignedByteToInt(byArray[n + 2]);
            int n5 = Loader.unsignedByteToInt(byArray[n + 3]);
            return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
        }
        return -1;
    }

    private static int getShortInt(byte[] byArray, int n) {
        if (n + 1 < byArray.length) {
            int n2 = Loader.unsignedByteToInt(byArray[n]);
            int n3 = Loader.unsignedByteToInt(byArray[n + 1]);
            return n2 + (n3 << 8);
        }
        return -1;
    }

    private static int getUnsignedByte(byte[] byArray, int n) {
        if (n < byArray.length) {
            return Loader.unsignedByteToInt(byArray[n]);
        }
        return -1;
    }

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private static String getSequenceName(String string) {
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer(16);
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c < 97 || c > 122) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static byte[] loadBinaryFile(URL uRL, String string, InputStream inputStream, int n) {
        return Loader.loadBinaryFile(uRL, string, inputStream, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static byte[] loadBinaryFile(URL var0, String var1_1, InputStream var2_2, int var3_3, String[] var4_4) {
        block22: {
            var5_5 /* !! */  = new byte[var3_3];
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = var3_3;
            var9_9 = 0;
            if (var1_1 == null) {
                var1_1 = "from InputStream";
            }
            try {
                block21: {
                    Logger.log("Loading file " + var1_1, 2);
                    if (var2_2 == null) {
                        if (var0 == null) {
                            var2_2 = new FileInputStream(new File(var1_1));
                        } else {
                            var10_10 = new URL(var0, var1_1);
                            var2_2 = var10_10.openStream();
                        }
                    }
                    if (var4_4 == null) {
                        do {
                            if ((var6_6 = var2_2.read(var5_5 /* !! */ , var7_7, var8_8 - var7_7)) > 0) {
                                var7_7 += var6_6;
                            }
                            if (var6_6 == -1 || var7_7 < var8_8) continue;
                            if (++var9_9 == 10) {
                                var3_3 *= 10;
                            }
                            var10_10 = new byte[var8_8 += var3_3];
                            System.arraycopy(var5_5 /* !! */ , 0, var10_10, 0, var8_8 - var3_3);
                            var5_5 /* !! */  = (byte[])var10_10;
                            Logger.log("Expanding buffers..." + var8_8 + " bytes", 2);
                        } while (var6_6 > 0);
                        Logger.log("File " + var1_1 + " loaded..." + var7_7 + " bytes", 2);
                        break block21;
                    }
                    var10_10 = new StringBuffer();
                    do {
                        if ((var6_6 = var2_2.read(var5_5 /* !! */ , 0, var8_8)) <= 0) continue;
                        var10_10.append(new String(var5_5 /* !! */ , 0, var6_6));
                    } while (var6_6 > 0);
                    var4_4[0] = var10_10.toString();
                    Logger.log("Text file " + var1_1 + " loaded..." + var10_10.length() + " bytes", 2);
                }
                var13_12 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var12_19) {
                var13_14 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var14_17) {
                        // empty catch block
                    }
                }
                throw var12_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (Exception var14_15) {}
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (Exception var10_11) {
                    Logger.log("Couldn't read file " + var1_1, 0);
                    var11_18 = new byte[]{};
                    var13_13 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var14_16) {
                            // empty catch block
                        }
                    }
                    return var11_18;
                }
            }
        }
        if (var4_4 == null) {
            var10_10 = new byte[var7_7];
            System.arraycopy(var5_5 /* !! */ , 0, var10_10, 0, var7_7);
            return var10_10;
        }
        return null;
    }

    private static void loadSceneFromXML(URL uRL, String string, InputStream inputStream, World world) {
        try {
            Serializable serializable;
            boolean bl;
            int n;
            Object object;
            String string2 = Loader.loadTextFile(uRL, string, inputStream);
            Loader.clearCache();
            XMLFactory xMLFactory = XMLFactory.getInstance();
            Logger.log("Building XML-tree...", 2);
            XMLNode xMLNode = xMLFactory.parseXML(string2);
            string2 = null;
            Logger.log("Building scene...", 2);
            Vector vector = xMLFactory.getMatchingNodes("/jpct/light_list/light/", xMLNode);
            for (int i = 0; i < vector.size(); ++i) {
                XMLNode xMLNode2 = (XMLNode)vector.elementAt(i);
                float f = Float.valueOf(xMLNode2.getAttributeValue("x")).floatValue();
                float f2 = Float.valueOf(xMLNode2.getAttributeValue("y")).floatValue();
                float f3 = Float.valueOf(xMLNode2.getAttributeValue("z")).floatValue();
                float f4 = Float.valueOf(xMLNode2.getAttributeValue("r")).floatValue();
                float f5 = Float.valueOf(xMLNode2.getAttributeValue("g")).floatValue();
                float f6 = Float.valueOf(xMLNode2.getAttributeValue("b")).floatValue();
                world.addLight(new SimpleVector(f, f2, f3), f4, f5, f6);
            }
            Vector vector2 = xMLFactory.getMatchingNodes("/jpct/texture_list/texture/", xMLNode);
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < vector2.size(); ++i) {
                XMLNode xMLNode3 = (XMLNode)vector2.elementAt(i);
                n3 = Integer.parseInt(xMLNode3.getAttributeValue("id"));
                if (n3 <= n2) continue;
                n2 = n3;
            }
            int[] nArray = new int[n2 + 1];
            TextureManager textureManager = TextureManager.getInstance();
            for (int i = 0; i < vector2.size(); ++i) {
                int n4;
                XMLNode xMLNode4 = (XMLNode)vector2.elementAt(i);
                n3 = Integer.parseInt(xMLNode4.getAttributeValue("id"));
                String string3 = xMLNode4.getAttributeValue("name");
                if (string3 == null) {
                    string3 = "!missing!";
                }
                if ((n4 = textureManager.getTextureID(string3)) == -1) {
                    textureManager.addTexture(string3);
                    n4 = textureManager.getTextureID(string3);
                    Logger.log("Texture named '" + string3 + "' added to TextureManager!", 2);
                }
                nArray[n3] = n4;
            }
            vector2 = null;
            vector = null;
            Vector vector3 = xMLFactory.getMatchingNodes("/jpct/object_list/object/", xMLNode);
            for (int i = 0; i < vector3.size(); ++i) {
                float f;
                XMLNode xMLNode5;
                int n5;
                Vector vector4;
                Object object2;
                int n6;
                XMLNode xMLNode6 = (XMLNode)vector3.elementAt(i);
                String string4 = xMLNode6.getAttributeValue("triangles");
                object = xMLNode6.getAttributeValue("name");
                String string5 = xMLNode6.getAttributeValue("insector");
                n = 0;
                if (string4.length() > 0) {
                    n = Integer.parseInt(string4);
                } else {
                    Logger.log("Missing triangle count for object " + i + "!", 0);
                }
                bl = false;
                string4 = xMLNode6.getAttributeValue("main");
                if (string4.length() > 0) {
                    int n7 = Integer.parseInt(string4);
                    bl = n7 == 1;
                }
                serializable = new Object3D(n);
                Vector vector5 = xMLFactory.getMatchingNodes("object/triangle_list/", xMLNode6);
                for (n6 = 0; n6 < vector5.size(); ++n6) {
                    object2 = (XMLNode)vector5.elementAt(n6);
                    String string6 = ((XMLNode)object2).getAttributeValue("sector");
                    int n8 = -1;
                    if (string6.length() > 0) {
                        n8 = Integer.parseInt(string6);
                    }
                    vector4 = xMLFactory.getMatchingNodes("triangle_list/triangle/", (XMLNode)object2);
                    for (n5 = 0; n5 < vector4.size(); ++n5) {
                        xMLNode5 = (XMLNode)vector4.elementAt(n5);
                        Vector vector6 = xMLFactory.getMatchingNodes("triangle/coord/", xMLNode5);
                        if (vector6.size() == 3) {
                            XMLNode xMLNode7 = (XMLNode)vector6.elementAt(0);
                            f = Float.valueOf(xMLNode7.getAttributeValue("x")).floatValue();
                            float f7 = Float.valueOf(xMLNode7.getAttributeValue("y")).floatValue();
                            float f8 = Float.valueOf(xMLNode7.getAttributeValue("z")).floatValue();
                            float f9 = Float.valueOf(xMLNode7.getAttributeValue("u")).floatValue();
                            float f10 = Float.valueOf(xMLNode7.getAttributeValue("v")).floatValue();
                            xMLNode7 = (XMLNode)vector6.elementAt(1);
                            float f11 = Float.valueOf(xMLNode7.getAttributeValue("x")).floatValue();
                            float f12 = Float.valueOf(xMLNode7.getAttributeValue("y")).floatValue();
                            float f13 = Float.valueOf(xMLNode7.getAttributeValue("z")).floatValue();
                            float f14 = Float.valueOf(xMLNode7.getAttributeValue("u")).floatValue();
                            float f15 = Float.valueOf(xMLNode7.getAttributeValue("v")).floatValue();
                            xMLNode7 = (XMLNode)vector6.elementAt(2);
                            float f16 = Float.valueOf(xMLNode7.getAttributeValue("x")).floatValue();
                            float f17 = Float.valueOf(xMLNode7.getAttributeValue("y")).floatValue();
                            float f18 = Float.valueOf(xMLNode7.getAttributeValue("z")).floatValue();
                            float f19 = Float.valueOf(xMLNode7.getAttributeValue("u")).floatValue();
                            float f20 = Float.valueOf(xMLNode7.getAttributeValue("v")).floatValue();
                            int n9 = 0;
                            Vector vector7 = xMLFactory.getMatchingNodes("triangle/textures/", xMLNode5);
                            if (vector7.size() == 1) {
                                XMLNode xMLNode8 = (XMLNode)vector7.elementAt(0);
                                Vector vector8 = xMLFactory.getMatchingNodes("textures/texturemap/", xMLNode8);
                                if (vector8.size() > 0) {
                                    XMLNode xMLNode9 = (XMLNode)vector8.elementAt(0);
                                    n9 = nArray[Integer.parseInt(xMLNode9.getAttributeValue("texid"))];
                                } else {
                                    n9 = textureManager.getTextureID("--dummy--");
                                }
                            } else {
                                if (vector7.size() > 1) {
                                    Logger.log("Only one texture block is allowed per triangle!", 0);
                                }
                                n9 = textureManager.getTextureID("--dummy--");
                            }
                            if (n8 != -1) {
                                ((Object3D)serializable).addTriangle(f, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, n9, n8, false);
                                continue;
                            }
                            ((Object3D)serializable).addTriangle(f, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, n9);
                            continue;
                        }
                        Logger.log("Corrupted triangle found in XML-file!", 0);
                    }
                }
                if (object != null && ((String)object).length() > 0) {
                    ((Object3D)serializable).setName((String)object);
                }
                n6 = world.addObject((Object3D)serializable);
                if (bl) {
                    world.setMainObjectID(n6);
                }
                if (string5.length() > 0) {
                    object2 = string5.toLowerCase();
                    if (((String)object2).equals("auto")) {
                        ((Object3D)serializable).setSectorDetectionMode(true);
                    } else if (!((String)object2).equals("all")) {
                        try {
                            ((Object3D)serializable).setSectorDetectionMode(false);
                            ((Object3D)serializable).setSector(Integer.parseInt(string5));
                        }
                        catch (Exception exception) {
                            Logger.log("Number format error in XML: " + (String)object2, 1);
                        }
                    }
                }
                ((Object3D)serializable).build();
                object2 = xMLFactory.getMatchingNodes("object/attributes/", xMLNode6);
                for (int j = 0; j < ((Vector)object2).size(); ++j) {
                    XMLNode xMLNode10 = (XMLNode)((Vector)object2).elementAt(j);
                    vector4 = xMLNode10.getSubNodes();
                    if (vector4 == null) continue;
                    for (n5 = 0; n5 < vector4.size(); ++n5) {
                        xMLNode5 = (XMLNode)vector4.elementAt(n5);
                        float f21 = Float.valueOf(xMLNode5.getAttributeValue("x")).floatValue();
                        float f22 = Float.valueOf(xMLNode5.getAttributeValue("y")).floatValue();
                        f = Float.valueOf(xMLNode5.getAttributeValue("z")).floatValue();
                        if (xMLNode5.getName().equals("pivot")) {
                            ((Object3D)serializable).setRotationPivot(new SimpleVector(f21, f22, f));
                        }
                        if (xMLNode5.getName().equals("center")) {
                            ((Object3D)serializable).setCenter(new SimpleVector(f21, f22, f));
                        }
                        if (!xMLNode5.getName().equals("origin")) continue;
                        ((Object3D)serializable).setOrigin(new SimpleVector(f21, f22, f));
                    }
                }
            }
            Vector vector9 = xMLFactory.getMatchingNodes("/jpct/portal_list/portal/", xMLNode);
            Portals portals = world.getPortals();
            for (int i = 0; i < vector9.size(); ++i) {
                float f;
                float f23;
                float f24;
                XMLNode xMLNode11;
                int n10;
                object = (XMLNode)vector9.elementAt(i);
                int n11 = Integer.parseInt(((XMLNode)object).getAttributeValue("from"));
                n = Integer.parseInt(((XMLNode)object).getAttributeValue("to"));
                bl = ((XMLNode)object).getAttributeValue("type").charAt(0) == 's';
                serializable = xMLFactory.getMatchingNodes("portal/coord/", (XMLNode)object);
                portals.startNewPortal();
                for (n10 = 0; n10 < ((Vector)serializable).size(); ++n10) {
                    xMLNode11 = (XMLNode)((Vector)serializable).elementAt(n10);
                    f24 = Float.valueOf(xMLNode11.getAttributeValue("x")).floatValue();
                    f23 = Float.valueOf(xMLNode11.getAttributeValue("y")).floatValue();
                    f = Float.valueOf(xMLNode11.getAttributeValue("z")).floatValue();
                    portals.addPortalCoord(f24, f23, f);
                }
                portals.setPortalAttributes(n11, n);
                portals.completePortal();
                if (bl) continue;
                portals.startNewPortal();
                for (n10 = ((Vector)serializable).size() - 1; n10 >= 0; --n10) {
                    xMLNode11 = (XMLNode)((Vector)serializable).elementAt(n10);
                    f24 = Float.valueOf(xMLNode11.getAttributeValue("x")).floatValue();
                    f23 = Float.valueOf(xMLNode11.getAttributeValue("y")).floatValue();
                    f = Float.valueOf(xMLNode11.getAttributeValue("z")).floatValue();
                    portals.addPortalCoord(f24, f23, f);
                }
                portals.setPortalAttributes(n, n11);
                portals.completePortal();
            }
        }
        catch (Exception exception) {
            Logger.log("Incorrect XML-file!", 0);
            exception.printStackTrace();
        }
    }

    private static Object3D loadMD2(URL uRL, String string, InputStream inputStream, float f) {
        Vector[] vectorArray = null;
        boolean bl = false;
        byte[] byArray = Loader.loadBinaryFile(uRL, string, inputStream, 500000);
        if (byArray == null) {
            bl = true;
        }
        if (!bl) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = Loader.getInt(byArray, 0);
            if (n8 != 844121161) {
                Logger.log("Not a valid MD2-file!", 0);
            }
            int n9 = Loader.getInt(byArray, 4);
            int n10 = Loader.getInt(byArray, 8);
            int n11 = Loader.getInt(byArray, 12);
            int n12 = Loader.getInt(byArray, 16);
            int n13 = Loader.getInt(byArray, 20);
            int n14 = Loader.getInt(byArray, 24);
            int n15 = Loader.getInt(byArray, 28);
            int n16 = Loader.getInt(byArray, 32);
            int n17 = Loader.getInt(byArray, 36);
            int n18 = Loader.getInt(byArray, 40);
            int n19 = Loader.getInt(byArray, 48);
            int n20 = Loader.getInt(byArray, 52);
            int n21 = Loader.getInt(byArray, 56);
            Logger.log("Magic number: " + n8, 2);
            Logger.log("Version: " + n9, 2);
            Logger.log("Skin width: " + n10, 2);
            Logger.log("Skin height: " + n11, 2);
            Logger.log("Frame size: " + n12, 2);
            Logger.log("Number of skins: " + n13, 2);
            Logger.log("Number of Vertices: " + n14, 2);
            Logger.log("Number of Texture coordinates: " + n15, 2);
            Logger.log("Number of triangles: " + n16, 2);
            Logger.log("Number of GL-commands: " + n17, 2);
            Logger.log("Number of Frames: " + n18, 2);
            int[][] nArray = new int[n15][2];
            int[][] nArray2 = new int[n16][3];
            int[][] nArray3 = new int[n16][3];
            Logger.log("Reading Texture coordinates...", 2);
            int n22 = n19;
            for (n7 = 0; n7 < n15; ++n7) {
                n6 = Loader.getShortInt(byArray, n22 + n7 * 4);
                n5 = Loader.getShortInt(byArray, n22 + n7 * 4 + 2);
                nArray[n7][0] = n6;
                nArray[n7][1] = n5;
            }
            Logger.log("Done!", 2);
            Logger.log("Reading polygonal data...", 2);
            n22 = n20;
            for (n7 = 0; n7 < n16; ++n7) {
                n6 = n22 + n7 * 12;
                n5 = Loader.getShortInt(byArray, n6);
                int n23 = Loader.getShortInt(byArray, n6 + 2);
                n4 = Loader.getShortInt(byArray, n6 + 4);
                int n24 = Loader.getShortInt(byArray, n6 + 6);
                int n25 = Loader.getShortInt(byArray, n6 + 8);
                int n26 = Loader.getShortInt(byArray, n6 + 10);
                nArray2[n7][0] = n5;
                nArray2[n7][1] = n23;
                nArray2[n7][2] = n4;
                nArray3[n7][0] = n24;
                nArray3[n7][1] = n25;
                nArray3[n7][2] = n26;
            }
            Logger.log("Done!", 2);
            float[][] fArray = new float[n18][3];
            float[][] fArray2 = new float[n18][3];
            String[] stringArray = new String[n18];
            int[][][] nArray4 = new int[n18][n14][3];
            Logger.log("Reading keyframes...", 2);
            for (n4 = 0; n4 < n18; ++n4) {
                n22 = n4 * n12 + n21;
                float f2 = Float.intBitsToFloat(Loader.getInt(byArray, n22));
                float f3 = Float.intBitsToFloat(Loader.getInt(byArray, n22 + 4));
                float f4 = Float.intBitsToFloat(Loader.getInt(byArray, n22 + 8));
                float f5 = Float.intBitsToFloat(Loader.getInt(byArray, n22 + 12));
                float f6 = Float.intBitsToFloat(Loader.getInt(byArray, n22 + 16));
                float f7 = Float.intBitsToFloat(Loader.getInt(byArray, n22 + 20));
                String string2 = new String(byArray, n22 + 24, 16);
                fArray[n4][0] = f2;
                fArray[n4][1] = f3;
                fArray[n4][2] = f4;
                fArray2[n4][0] = f5;
                fArray2[n4][1] = f6;
                fArray2[n4][2] = f7;
                stringArray[n4] = string2;
                n22 += 40;
                for (int i = 0; i < n14; ++i) {
                    int n27 = n22 + i * 4;
                    n3 = Loader.getUnsignedByte(byArray, n27);
                    n2 = Loader.getUnsignedByte(byArray, n27 + 1);
                    n = Loader.getUnsignedByte(byArray, n27 + 2);
                    nArray4[n4][i][0] = n3;
                    nArray4[n4][i][1] = n2;
                    nArray4[n4][i][2] = n;
                }
            }
            Logger.log("Done!", 2);
            Logger.log("Coverting MD2-format into jPCT-format...", 2);
            Object3D object3D = new Object3D(n16 + 1);
            Object3D object3D2 = new Object3D(n16 + 1);
            Animation animation = new Animation(n18);
            String string3 = "dummy";
            for (int i = 0; i < n18; ++i) {
                int n28;
                object3D2.clearObject();
                int n29 = i;
                for (n28 = 0; n28 < n14; ++n28) {
                    float f8 = (float)nArray4[n29][n28][0] * fArray[n29][0] + fArray2[n29][0];
                    float f9 = (float)nArray4[n29][n28][1] * fArray[n29][1] + fArray2[n29][1];
                    float f10 = (float)nArray4[n29][n28][2] * fArray[n29][2] + fArray2[n29][2];
                    object3D2.objVectors.addVertex(f8 *= f, -(f10 *= f), f9 *= f);
                    if (i != 0) continue;
                    object3D.objVectors.addVertex(f8, -f10, f9);
                }
                for (n28 = 0; n28 < n16; ++n28) {
                    int n30 = nArray2[n28][0];
                    int n31 = nArray2[n28][2];
                    int n32 = nArray2[n28][1];
                    n3 = nArray3[n28][0];
                    n2 = nArray3[n28][2];
                    n = nArray3[n28][1];
                    float f11 = (float)nArray[n3][0] / (float)n10;
                    float f12 = (float)nArray[n3][1] / (float)n11;
                    float f13 = (float)nArray[n2][0] / (float)n10;
                    float f14 = (float)nArray[n2][1] / (float)n11;
                    float f15 = (float)nArray[n][0] / (float)n10;
                    float f16 = (float)nArray[n][1] / (float)n11;
                    if (i == 0) {
                        object3D.addMD2Triangle(n30, f11, f12, n31, f13, f14, n32, f15, f16);
                    }
                    object3D2.addMD2Triangle(n30, f11, f12, n31, f13, f14, n32, f15, f16);
                }
                object3D2.calcBoundingBox();
                vectorArray = object3D2.objMesh.calcNormalsMD2(vectorArray);
                String string4 = Loader.getSequenceName(stringArray[i]);
                if (!string4.equals(string3)) {
                    Logger.log("Processing: " + string4 + "...", 2);
                    string3 = string4;
                    animation.createSubSequence(string4);
                }
                animation.addKeyFrame(object3D2.getMesh().cloneMesh(true));
            }
            object3D.calcBoundingBox();
            object3D.setAnimationSequence(animation);
            Logger.log("Done!", 2);
            return object3D;
        }
        return null;
    }

    private static String[] readTextureNames3DS(URL uRL, String string, InputStream inputStream) {
        int n;
        byte[] byArray = Loader.loadBinaryFile(uRL, string, inputStream, 500000);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = null;
        if (byArray != null) {
            Loader.getChunkHeader(byArray, n2, nArray);
            n2 += 6;
            n3 = nArray[0];
            n4 = nArray[1];
            if (n3 != 19789) {
                Logger.log("Not a valid 3DS file!", 0);
            } else {
                boolean bl = true;
                while (n3 >= 0 && n2 < byArray.length) {
                    bl = false;
                    Loader.getChunkHeader(byArray, n2, nArray);
                    n3 = nArray[0];
                    n4 = nArray[1];
                    if (n3 < 0 || (n2 += 6) >= byArray.length) continue;
                    if (n3 == 45055) {
                        int n5;
                        for (n = n2; n < n2 + n4 - 6 && n < byArray.length; n += n5 - 6) {
                            int n6;
                            Loader.getChunkHeader(byArray, n, nArray2);
                            n += 6;
                            int n7 = nArray2[0];
                            n5 = nArray2[1];
                            if (n7 != 41472) continue;
                            for (int i = n; i < n + n4 - 6 && i < byArray.length; i += n6 - 6) {
                                Loader.getChunkHeader(byArray, i, nArray2);
                                i += 6;
                                int n8 = nArray2[0];
                                n6 = nArray2[1];
                                if (n8 != 41728) continue;
                                stringBuffer = new StringBuffer(40);
                                int n9 = 0;
                                int n10 = i;
                                do {
                                    n9 = Loader.getUnsignedByte(byArray, n10);
                                    ++n10;
                                    if (n9 > 0) {
                                        stringBuffer.append((char)n9);
                                    }
                                    if (n10 < byArray.length) continue;
                                    n9 = -1;
                                } while (n9 > 0);
                                String string2 = stringBuffer.toString();
                                if (vector.contains(string2)) continue;
                                vector.addElement(string2);
                            }
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    if (n2 + n4 - 6 >= byArray.length) {
                        n2 = byArray.length;
                        continue;
                    }
                    n2 += n4 - 6;
                }
            }
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private static Object3D[] load3DS(URL uRL, String string, InputStream inputStream, float f) {
        CharSequence charSequence;
        int n;
        int n2;
        byte[] byArray = Loader.loadBinaryFile(uRL, string, inputStream, 500000);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        Vector<Object3D> vector = new Vector<Object3D>();
        StringBuffer stringBuffer = null;
        float[][] fArray = null;
        int[][] nArray3 = null;
        String[] stringArray = null;
        float[][] fArray2 = new float[10][4];
        String[] stringArray2 = new String[10];
        String[] stringArray3 = new String[10];
        Color[] colorArray = new Color[10];
        int[] nArray4 = new int[10];
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            fArray2[n2][0] = 1.0f;
            fArray2[n2][1] = 1.0f;
            fArray2[n2][2] = 0.0f;
            fArray2[n2][3] = 0.0f;
            nArray4[n2] = 1000;
        }
        n2 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable<String, SimpleVector> hashtable = new Hashtable<String, SimpleVector>();
        if (byArray != null) {
            Loader.getChunkHeader(byArray, n3, nArray);
            n3 += 6;
            n4 = nArray[0];
            n5 = nArray[1];
            if (n4 != 19789) {
                Logger.log("Not a valid 3DS file!", 0);
            } else {
                n = 1;
                while (n4 >= 0 && n3 < byArray.length && n3 >= 0) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    float f2;
                    n = 1;
                    Loader.getChunkHeader(byArray, n3, nArray);
                    n4 = nArray[0];
                    n5 = nArray[1];
                    if (n4 < 0 || (n3 += 6) >= byArray.length) continue;
                    if (n4 == 16640) {
                        if (n7 != 0) {
                            vector.addElement(Loader.create3DSObject(string3, fArray, n2, nArray3, n7, stringArray2, stringArray3, fArray2, stringArray, colorArray, nArray4, n8));
                        }
                        Logger.log("Processing object from 3DS-file: " + string2, 2);
                        n2 = 0;
                        n6 = 0;
                        n7 = 0;
                        n = 0;
                    }
                    if (n4 == 45072) {
                        int n14 = 0;
                        charSequence = new StringBuffer(40);
                        do {
                            n14 = Loader.getUnsignedByte(byArray, n3);
                            ++n3;
                            if (n14 > 0) {
                                ((StringBuffer)charSequence).append((char)n14);
                            }
                            if (n3 < byArray.length) continue;
                            n14 = -1;
                        } while (n14 > 0);
                        string4 = ((StringBuffer)charSequence).toString();
                        Logger.log("Name in hierarchy found: " + string4, 2);
                        n3 += 6;
                        n = 0;
                    }
                    if (n4 == 45088) {
                        float f3 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 20));
                        float f4 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 4));
                        f2 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 4));
                        n3 += 4;
                        hashtable.put(string4, new SimpleVector(f3, f4, f2));
                        n = 0;
                    }
                    if (n4 == 16384) {
                        int n15 = 0;
                        stringBuffer = new StringBuffer(40);
                        do {
                            n15 = Loader.getUnsignedByte(byArray, n3);
                            ++n3;
                            if (n15 > 0) {
                                stringBuffer.append((char)n15);
                            }
                            if (n3 < byArray.length) continue;
                            n15 = -1;
                        } while (n15 > 0);
                        string3 = string2;
                        string2 = stringBuffer.toString();
                        n = 0;
                    }
                    if (n4 == 16656) {
                        n13 = Loader.getShortInt(byArray, n3);
                        if (fArray == null || fArray.length < n13) {
                            fArray = new float[n13][5];
                        }
                        n3 += 2;
                        for (n12 = 0; n12 < n13; ++n12) {
                            float f5 = Float.intBitsToFloat(Loader.getInt(byArray, n3)) * f;
                            float f6 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 4)) * f;
                            f2 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 4)) * f;
                            n3 += 4;
                            fArray[n2][0] = f5;
                            fArray[n2][1] = f6;
                            fArray[n2][2] = f2;
                            ++n2;
                        }
                        n = 0;
                    }
                    if (n4 == 16672) {
                        int n16 = n3;
                        n12 = Loader.getShortInt(byArray, n16);
                        if (nArray3 == null || nArray3.length < n12) {
                            nArray3 = new int[n12][3];
                            stringArray = new String[n12];
                        }
                        n16 += 2;
                        for (n11 = 0; n11 < n12; ++n11) {
                            int n17 = Loader.getShortInt(byArray, n16);
                            int n18 = Loader.getShortInt(byArray, n16 += 2);
                            n13 = Loader.getShortInt(byArray, n16 += 2);
                            n16 += 2;
                            n16 += 2;
                            nArray3[n7][0] = n17;
                            nArray3[n7][1] = n18;
                            nArray3[n7][2] = n13;
                            ++n7;
                        }
                        while (n16 < n3 + n5 - 6 && n16 < byArray.length) {
                            Loader.getChunkHeader(byArray, n16, nArray2);
                            n16 += 6;
                            n11 = nArray2[0];
                            n10 = nArray2[1];
                            if (n11 == 16688) {
                                n9 = 0;
                                int n19 = n16;
                                stringBuffer = new StringBuffer(40);
                                do {
                                    n9 = Loader.getUnsignedByte(byArray, n19);
                                    ++n19;
                                    if (n9 > 0) {
                                        stringBuffer.append((char)n9);
                                    }
                                    if (n19 < byArray.length) continue;
                                    n9 = -1;
                                } while (n9 > 0);
                                int n20 = Loader.getShortInt(byArray, n19);
                                n19 += 2;
                                String string5 = stringBuffer.toString();
                                for (n9 = 0; n9 < n20; ++n9) {
                                    int n21 = Loader.getShortInt(byArray, n19);
                                    n19 += 2;
                                    stringArray[n21] = string5;
                                }
                            }
                            n16 += n10 - 6;
                        }
                        n = 1;
                    }
                    if (n4 == 16704) {
                        int n22 = Loader.getShortInt(byArray, n3);
                        n3 += 2;
                        for (n13 = 0; n13 < n22; ++n13) {
                            float f7 = Float.intBitsToFloat(Loader.getInt(byArray, n3));
                            float f8 = Float.intBitsToFloat(Loader.getInt(byArray, n3 += 4));
                            n3 += 4;
                            fArray[n6][3] = f7;
                            fArray[n6][4] = f8;
                            ++n6;
                        }
                        n = 0;
                    }
                    if (n4 == 45055) {
                        int n23;
                        for (int i = n3; i < n3 + n5 - 6 && i < byArray.length; i += n23 - 6) {
                            Loader.getChunkHeader(byArray, i, nArray2);
                            i += 6;
                            int n24 = nArray2[0];
                            n23 = nArray2[1];
                            if (n24 == 40960) {
                                stringBuffer = new StringBuffer(40);
                                n13 = 0;
                                n12 = i;
                                do {
                                    n13 = Loader.getUnsignedByte(byArray, n12);
                                    ++n12;
                                    if (n13 > 0) {
                                        stringBuffer.append((char)n13);
                                    }
                                    if (n12 < byArray.length) continue;
                                    n13 = -1;
                                } while (n13 > 0);
                                stringArray2[n8] = stringBuffer.toString();
                                Logger.log("Processing new material " + stringArray2[n8] + "!", 2);
                            }
                            if (n24 == 40992) {
                                n13 = i + 6;
                                if (n23 != 24 || Config.oldStyle3DSLoader) {
                                    n12 = Loader.getUnsignedByte(byArray, n13);
                                    n11 = Loader.getUnsignedByte(byArray, ++n13);
                                    n10 = Loader.getUnsignedByte(byArray, ++n13);
                                    ++n13;
                                    colorArray[n8] = new Color(n12, n11, n10);
                                } else {
                                    n12 = (int)(Float.intBitsToFloat(Loader.getInt(byArray, n13)) * 255.0f);
                                    n11 = (int)(Float.intBitsToFloat(Loader.getInt(byArray, n13 += 4)) * 255.0f);
                                    n10 = (int)(Float.intBitsToFloat(Loader.getInt(byArray, n13 += 4)) * 255.0f);
                                    n13 += 4;
                                    n9 = 0;
                                    if (n12 < 0) {
                                        n12 = 0;
                                        n9 = 1;
                                    }
                                    if (n11 < 0) {
                                        n11 = 0;
                                        n9 = 1;
                                    }
                                    if (n10 < 0) {
                                        n10 = 0;
                                        n9 = 1;
                                    }
                                    if (n12 > 255) {
                                        n12 = 255;
                                        n9 = 1;
                                    }
                                    if (n11 > 255) {
                                        n11 = 255;
                                        n9 = 1;
                                    }
                                    if (n10 > 255) {
                                        n10 = 255;
                                        n9 = 1;
                                    }
                                    if (n9 != 0) {
                                        Logger.log("Error reading material's diffuse color...try Config.oldStyle3DSLoader=true!", 1);
                                    }
                                    colorArray[n8] = new Color(n12, n11, n10);
                                }
                            }
                            if (n24 == 41040) {
                                n13 = i + 6;
                                n12 = 100 - Loader.getShortInt(byArray, n13);
                                if (n12 < 0) {
                                    n12 = 0;
                                }
                                if (n12 > 100) {
                                    n12 = 100;
                                }
                                n12 = n12 == 100 ? -1 : (n12 /= 10);
                                nArray4[n8] = n12;
                            }
                            if (n24 != 41472) continue;
                            for (n13 = i; n13 < i + n5 - 6 && n13 < byArray.length; n13 += n11 - 6) {
                                Loader.getChunkHeader(byArray, n13, nArray2);
                                n13 += 6;
                                n12 = nArray2[0];
                                n11 = nArray2[1];
                                if (n12 == 41728) {
                                    stringBuffer = new StringBuffer(40);
                                    n10 = 0;
                                    n9 = n13;
                                    do {
                                        n10 = Loader.getUnsignedByte(byArray, n9);
                                        ++n9;
                                        if (n10 > 0) {
                                            stringBuffer.append((char)n10);
                                        }
                                        if (n9 < byArray.length) continue;
                                        n10 = -1;
                                    } while (n10 > 0);
                                    String string6 = stringBuffer.toString();
                                    if (!TextureManager.getInstance().containsTexture(string6)) {
                                        TextureManager.getInstance().addTexture(string6);
                                        Logger.log("Texture named " + string6 + " added to TextureManager!", 2);
                                    }
                                    stringArray3[n8] = string6;
                                }
                                if (n12 == 41812) {
                                    fArray2[n8][0] = Float.intBitsToFloat(Loader.getInt(byArray, n13));
                                }
                                if (n12 == 41814) {
                                    fArray2[n8][1] = Float.intBitsToFloat(Loader.getInt(byArray, n13));
                                }
                                if (n12 == 41816) {
                                    fArray2[n8][2] = Float.intBitsToFloat(Loader.getInt(byArray, n13));
                                }
                                if (n12 != 41818) continue;
                                fArray2[n8][3] = Float.intBitsToFloat(Loader.getInt(byArray, n13));
                            }
                        }
                        if (++n8 >= stringArray2.length) {
                            int n25 = stringArray2.length + 10;
                            String[] stringArray4 = new String[n25];
                            String[] stringArray5 = new String[n25];
                            Color[] colorArray2 = new Color[n25];
                            int[] nArray5 = new int[n25];
                            float[][] fArray3 = new float[n25][4];
                            System.arraycopy(stringArray2, 0, stringArray4, 0, n8);
                            System.arraycopy(stringArray3, 0, stringArray5, 0, n8);
                            System.arraycopy(colorArray, 0, colorArray2, 0, n8);
                            System.arraycopy(nArray4, 0, nArray5, 0, n8);
                            for (n9 = 0; n9 < fArray2.length; ++n9) {
                                System.arraycopy(fArray2[n9], 0, fArray3[n9], 0, 4);
                            }
                            stringArray2 = stringArray4;
                            stringArray3 = stringArray5;
                            colorArray = colorArray2;
                            nArray4 = nArray5;
                            fArray2 = fArray3;
                            for (n9 = n8; n9 < fArray2.length; ++n9) {
                                fArray2[n9][0] = 1.0f;
                                fArray2[n9][1] = 1.0f;
                                fArray2[n9][2] = 0.0f;
                                fArray2[n9][3] = 0.0f;
                                nArray4[n9] = 1000;
                            }
                        }
                        n = 1;
                    }
                    if (n4 == 15677 || n4 == 45056 || n4 == 45058) {
                        n = 0;
                    }
                    if (n == 0) continue;
                    if (n3 + n5 - 6 >= byArray.length) {
                        n3 = byArray.length;
                        continue;
                    }
                    n3 += n5 - 6;
                }
            }
        }
        if (n2 != 0) {
            if (n7 != 0) {
                vector.addElement(Loader.create3DSObject(string2, fArray, n2, nArray3, n7, stringArray2, stringArray3, fArray2, stringArray, colorArray, nArray4, n8));
            }
            n2 = 0;
            n6 = 0;
            n7 = 0;
        }
        if (Config.useRotationPivotFrom3DS) {
            for (n = 0; n < vector.size(); ++n) {
                SimpleVector simpleVector;
                Object3D object3D = (Object3D)vector.elementAt(n);
                charSequence = object3D.getName();
                String string7 = charSequence;
                int n26 = ((String)charSequence).indexOf("_jPCT");
                if (n26 == -1 || (simpleVector = (SimpleVector)hashtable.get(charSequence = ((String)charSequence).substring(0, n26))) == null) continue;
                object3D.setRotationPivot(simpleVector);
                object3D.skipPivot = true;
                Logger.log("Setting rotation pivot of object " + string7 + " to " + simpleVector, 2);
            }
        }
        Object3D[] object3DArray = new Object3D[vector.size()];
        for (int i = 0; i < object3DArray.length; ++i) {
            object3DArray[i] = (Object3D)vector.elementAt(i);
        }
        return object3DArray;
    }

    private static Object3D create3DSObject(String string, float[][] fArray, int n, int[][] nArray, int n2, String[] stringArray, String[] stringArray2, float[][] fArray2, String[] stringArray3, Color[] colorArray, int[] nArray2, int n3) {
        int n4 = n2;
        int[] nArray3 = null;
        int[] nArray4 = null;
        if (!optimize) {
            nArray3 = new int[fArray.length];
            nArray4 = new int[3];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = -1;
            }
        }
        Object3D object3D = new Object3D(n4);
        if (!optimize) {
            object3D.disableVertexSharing();
        }
        TextureManager textureManager = TextureManager.getInstance();
        int n5 = textureManager.getTextureID("--dummy--");
        int n6 = 100;
        int n7 = -1;
        String string2 = "**hurzigurzi**";
        for (int i = 0; i < n2; ++i) {
            int n8 = nArray[i][0];
            int n9 = nArray[i][1];
            int n10 = nArray[i][2];
            float f = fArray[n8][0];
            float f2 = fArray[n8][1];
            float f3 = fArray[n8][2];
            float f4 = fArray[n9][0];
            float f5 = fArray[n9][1];
            float f6 = fArray[n9][2];
            float f7 = fArray[n10][0];
            float f8 = fArray[n10][1];
            float f9 = fArray[n10][2];
            int n11 = n5;
            float f10 = 1.0f;
            float f11 = 1.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            if (stringArray3[i] != null) {
                if (stringArray3[i].equals(string2)) {
                    n11 = textureManager.getTextureID(stringArray2[n7]);
                    f10 = fArray2[n7][0];
                    f11 = fArray2[n7][1];
                    f12 = fArray2[n7][2];
                    f13 = fArray2[n7][3];
                } else {
                    for (int j = 0; j < n3; ++j) {
                        if (stringArray[j] == null || !stringArray[j].equals(stringArray3[i])) continue;
                        n6 = nArray2[j] != 1000 && n6 != -1 ? nArray2[j] : -1;
                        if (stringArray2[j] != null) {
                            string2 = stringArray[j];
                            n7 = j;
                            n11 = textureManager.getTextureID(stringArray2[j]);
                            f10 = fArray2[j][0];
                            f11 = fArray2[j][1];
                            f12 = fArray2[j][2];
                            f13 = fArray2[j][3];
                            break;
                        }
                        String string3 = "__3ds-Color:" + colorArray[j].getRed() + "/" + colorArray[j].getGreen() + "/" + colorArray[j].getBlue();
                        if (textureManager.containsTexture(string3)) {
                            n11 = textureManager.getTextureID(string3);
                            break;
                        }
                        Texture texture = Texture.createSingleColoredTexture(colorArray[j]);
                        textureManager.addTexture(string3, texture);
                        n11 = textureManager.getTextureID(string3);
                        stringArray2[j] = string3;
                        n7 = j;
                        string2 = stringArray[j];
                        break;
                    }
                }
            }
            float f14 = fArray[n8][3] * f10 + f12;
            float f15 = fArray[n8][4] * f11 + f13;
            float f16 = fArray[n9][3] * f10 + f12;
            float f17 = fArray[n9][4] * f11 + f13;
            float f18 = fArray[n10][3] * f10 + f12;
            float f19 = fArray[n10][4] * f11 + f13;
            if (optimize) {
                object3D.addTriangle(f, f2, f3, f14, 1.0f - f15, f4, f5, f6, f16, 1.0f - f17, f7, f8, f9, f18, 1.0f - f19, n11);
                continue;
            }
            nArray4[0] = nArray3[n8];
            nArray4[1] = nArray3[n9];
            nArray4[2] = nArray3[n10];
            object3D.addTriangle(f, f2, f3, f14, 1.0f - f15, f4, f5, f6, f16, 1.0f - f17, f7, f8, f9, f18, 1.0f - f19, n11, 0, false, nArray4);
            if (nArray3[n8] == -1) {
                nArray3[n8] = nArray4[0];
            }
            if (nArray3[n9] == -1) {
                nArray3[n9] = nArray4[1];
            }
            if (nArray3[n10] != -1) continue;
            nArray3[n10] = nArray4[2];
        }
        object3D.setName(string + "_jPCT" + object3D.getID());
        object3D.getMesh().compress();
        if (n6 != 1000 && n6 != -1) {
            object3D.setTransparency(n6);
        }
        Logger.log("Object '" + object3D.name + "' created using " + object3D.getMesh().anzTri + " polygons and " + object3D.getMesh().anzCoords + " vertices.", 2);
        return object3D;
    }

    private static void getChunkHeader(byte[] byArray, int n, int[] nArray) {
        nArray[0] = Loader.getShortInt(byArray, n);
        nArray[1] = Loader.getInt(byArray, n + 2);
    }

    private static int getCharCount(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }
}

