/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Animation;
import com.threed.jpct.Camera;
import com.threed.jpct.CollisionEvent;
import com.threed.jpct.CollisionInfo;
import com.threed.jpct.CollisionListener;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLSLShader;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IRenderHook;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Lights;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.OcTree;
import com.threed.jpct.OcTreeNode;
import com.threed.jpct.Plane;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import com.threed.jpct.VisList;
import com.threed.jpct.World;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Object3D
implements Serializable {
    private static final long serialVersionUID = 6L;
    public static final boolean ENVMAP_WORLDSPACE = false;
    public static final boolean ENVMAP_CAMERASPACE = true;
    public static final boolean ENVMAP_ENABLED = true;
    public static final boolean ENVMAP_DISABLED = false;
    public static final boolean BUMPMAPPING_ENABLED = true;
    public static final boolean BUMPMAPPING_DISABLED = false;
    public static final boolean BLENDING_ENABLED = true;
    public static final boolean BLENDING_DISABLED = false;
    public static final int TRANSPARENCY_MODE_DEFAULT = 0;
    public static final int TRANSPARENCY_MODE_ADD = 1;
    public static final boolean BILLBOARDING_ENABLED = true;
    public static final boolean BILLBOARDING_DISABLED = false;
    public static final boolean MOUSE_SELECTABLE = true;
    public static final boolean MOUSE_UNSELECTABLE = false;
    public static final boolean FILTERING_ENABLED = true;
    public static final boolean FILTERING_DISABLED = false;
    public static final boolean CULLING_ENABLED = true;
    public static final boolean CULLING_DISABLED = false;
    public static final boolean SPECULAR_ENABLED = true;
    public static final boolean SPECULAR_DISABLED = false;
    public static final int FINALIZE_DEFAULT = 1;
    public static final int FINALIZE_PRESORTZ = 2;
    public static final int FINALIZE_PRESORTY = 3;
    public static final int FINALIZE_PRESORTX = 4;
    public static final int ENVMAP_XY = 1;
    public static final int ENVMAP_XZ = 2;
    public static final int ENVMAP_YZ = 3;
    public static final boolean OBJ_VISIBLE = true;
    public static final boolean OBJ_INVISIBLE = false;
    public static final boolean SECTOR_AUTODETECT = true;
    public static final boolean SECTOR_PRECALCULATED = false;
    public static final int COLLISION_CHECK_NONE = 0;
    public static final int COLLISION_CHECK_OTHERS = 1;
    public static final int COLLISION_CHECK_SELF = 2;
    public static final float COLLISION_NONE = 1.0E12f;
    public static final float RAY_MISSES_BOX = 1.0E12f;
    public static final boolean COLLISION_DETECTION_OPTIMIZED = true;
    public static final boolean COLLISION_DETECTION_NOT_OPTIMIZED = false;
    public static final int SHADING_GOURAUD = 0;
    public static final int SHADING_FAKED_FLAT = 1;
    public static final int LIGHTING_ALL_ENABLED = 0;
    public static final int LIGHTING_NO_LIGHTS = 1;
    public static final int ELLIPSOID_ALIGNED = 0;
    public static final int ELLIPSOID_TRANSFORMED = 1;
    public static final int UNKNOWN_OBJECTSIZE = -1;
    public static final int NO_OBJECT = -100;
    private static final Lights DUMMY_LIGHTS = new Lights(0);
    private static final double INSIDE_POLYGON_CONST = 6.220353454107791;
    private static final float EPSILON = 1.0E-9f;
    private static final float DIVER = 0.33333334f;
    static int nextID = 0;
    static int globalListenerCount = 0;
    static long cullCount = 0L;
    boolean isTrans;
    int transMode = 0;
    boolean isEnvmapped;
    boolean useCSEnvmapping;
    int envMapDir;
    boolean isBlended;
    boolean isBumpmapped;
    boolean isVisible;
    boolean isLit;
    boolean isPotentialCollider;
    boolean mayCollide;
    boolean dynSectorDetect;
    boolean wasCollider;
    float sortOffset = 0.0f;
    boolean isSelectable;
    boolean someSectorVisible;
    Vectors objVectors;
    Mesh objMesh;
    World myWorld;
    int number = 0;
    String name = "";
    int clipAtPortal;
    int[] texture;
    int[][] multiTex;
    int[][] multiMode;
    int maxStagesUsed = 0;
    boolean usesMultiTexturing = false;
    int[] sector;
    Object3D[] parent;
    int parentCnt = 0;
    int[] sectorStartPoint;
    int[] sectorEndPoint;
    int[] sectorStartPoly;
    int[] sectorEndPoly;
    int[] bumpmap;
    int[] basemap;
    int[] dynSectorList;
    int sectorCnt;
    int transValue;
    boolean isMainWorld;
    boolean oneSectorOnly;
    int singleSectorNumber;
    boolean hasPortals;
    boolean alwaysFilter;
    float centerX;
    float centerY;
    float centerZ;
    boolean hasBoundingBox;
    boolean isFlatShaded;
    boolean object3DRendered;
    transient Vector compiled = null;
    boolean dynamic = false;
    boolean modified = false;
    boolean indexed = true;
    int batchSize = -1;
    boolean preferDLOrVBO = true;
    boolean staticUV = true;
    transient float[][] nearestLights = null;
    boolean toStrip = false;
    transient IRenderHook renderHook = null;
    boolean isSharingSource = false;
    boolean sharing = false;
    Object3D shareWith = null;
    transient Matrix transBuffer = new Matrix();
    boolean cullingInvertedBuffer = false;
    boolean stripped = false;
    private Vector collisionListener = null;
    private boolean disableListeners = false;
    private int[] polygonIDs = null;
    private int pIDCount = 0;
    private int lastAddedID = -1;
    private int lowestPos;
    private int highestPos;
    float xRotationCenter;
    float yRotationCenter;
    float zRotationCenter;
    private int addColorR;
    private int addColorG;
    private int addColorB;
    private Matrix rotationMatrix = new Matrix();
    private Matrix translationMatrix = new Matrix();
    private Matrix originMatrix = new Matrix();
    private transient Matrix mat2 = new Matrix();
    private transient Matrix mat3 = new Matrix();
    private transient Matrix mat5 = new Matrix();
    private transient Matrix mat6 = new Matrix();
    private transient float[] xWs;
    private transient float[] yWs;
    private transient float[] zWs;
    private transient float[] pvecPoint;
    boolean doCulling;
    boolean doSpecularLighting;
    boolean writeToZbuffer = false;
    Matrix textureMatrix = null;
    boolean skipPivot = false;
    private Animation anim;
    private boolean neverOptimize = false;
    private float scaleFactor;
    private float invScaleFactor;
    private boolean isBillBoard;
    private OcTree ocTree;
    private boolean lazyTransforms;
    private transient Matrix transCache = null;
    private transient Matrix invCache = null;
    private boolean visComplete = false;
    private boolean optimizeColDet = false;
    private float largestPolygonSize = -1.0f;
    private transient PolygonManager polyManager = null;
    private int ellipsoidMode = 0;
    private Object userObj = null;
    boolean reverseCulling = false;
    boolean hasBeenBuild = false;
    private boolean useMatrixCache = true;
    private transient Hashtable matrixCache = new Hashtable(3);
    private Color addColorInstance = Color.black;
    private transient Hashtable sectors = null;
    private boolean reNormalize = false;

    public static Object3D createDummyObj() {
        return new Object3D(0);
    }

    public void setUserObject(Object object) {
        this.userObj = object;
    }

    public Object getUserObject() {
        return this.userObj;
    }

    public void setSortOffset(float f) {
        this.sortOffset = f;
    }

    public static Object3D mergeObjects(Object3D object3D, Object3D object3D2) {
        if (object3D != null && object3D2 != null) {
            int n = Math.max(object3D.objMesh.anzTri + object3D2.objMesh.anzTri, (object3D.objMesh.anzVectors + object3D2.objMesh.anzVectors) / 3);
            Object3D object3D3 = new Object3D(n);
            object3D.appendToObject(object3D3);
            object3D2.appendToObject(object3D3);
            return object3D3;
        }
        Logger.log("Can't merge null!", 0);
        return null;
    }

    public static Object3D mergeAll(Object3D[] object3DArray) {
        Object3D object3D;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < object3DArray.length; ++n) {
            object3D = object3DArray[n];
            n2 += object3D.objMesh.anzTri;
            n3 += object3D.objMesh.anzVectors;
        }
        n = Math.max(n2, n3 /= 3);
        object3D = new Object3D(n);
        for (int i = 0; i < object3DArray.length; ++i) {
            object3DArray[i].appendToObject(object3D);
            object3DArray[i] = null;
        }
        return object3D;
    }

    public static void resetNextID() {
        nextID = 0;
    }

    public static int getNextID() {
        return nextID;
    }

    public static void setNextID(int n) {
        if (n >= nextID) {
            nextID = n;
        } else {
            Logger.log("The next ID can't be lower than the current one", 0);
        }
    }

    public Object3D(int n) {
        this.init(n);
    }

    public Object3D(Object3D object3D) {
        this(object3D, false);
    }

    public Object3D(Object3D object3D, boolean bl) {
        int n = 0;
        if (object3D != null && object3D.texture != null) {
            n = object3D.texture.length;
        }
        this.init(n + 8);
        if (n != 0) {
            this.copy(object3D, bl);
        }
    }

    public Object3D(float[] fArray, float[] fArray2, int[] nArray, int n) {
        int n2;
        if (nArray == null) {
            nArray = new int[fArray.length / 3];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n2;
            }
        }
        this.init((nArray.length + 3) / 2);
        this.objMesh.anzCoords = 0;
        n2 = 0;
        for (int i = 0; i < fArray.length; i += 3) {
            int n3 = i / 3;
            this.objMesh.xOrg[n3] = fArray[i];
            this.objMesh.yOrg[n3] = fArray[i + 1];
            this.objMesh.zOrg[n3] = fArray[i + 2];
        }
        this.objMesh.anzCoords = fArray.length / 3;
        TextureManager textureManager = TextureManager.getInstance();
        float f = 2.0f;
        float f2 = 2.0f;
        if (n != -1) {
            f = textureManager.textures[n].width;
            f2 = textureManager.textures[n].height;
        } else {
            n = 0;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < nArray.length; i += 3) {
            for (int j = 0; j < 3; ++j) {
                if (fArray2 != null) {
                    float f3 = fArray2[2 * nArray[i + j]];
                    float f4 = fArray2[2 * nArray[i + j] + 1];
                    this.objVectors.uOrg[n4] = f3 * f;
                    this.objVectors.vOrg[n4] = f4 * f2;
                    this.objVectors.buOrg[n4] = f3 * f;
                    this.objVectors.bvOrg[n4] = f4 * f2;
                    this.objVectors.nuOrg[n4] = f3;
                    this.objVectors.nvOrg[n4] = f4;
                }
                this.objMesh.coords[n4] = nArray[i + j];
                this.objMesh.points[n5][j] = n4++;
                ++this.objMesh.anzVectors;
            }
            if (this.sector != null) {
                this.sector[n5] = n2;
            }
            this.texture[n5] = n;
            this.basemap[n5] = n;
            if (this.bumpmap != null) {
                this.bumpmap[n5] = n;
            }
            ++n5;
            ++this.objMesh.anzTri;
        }
        this.objMesh.compress();
    }

    private void copy(Object3D object3D, boolean bl) {
        int n;
        this.objMesh = bl ? object3D.objMesh : object3D.objMesh.cloneMesh(true);
        if (this.objMesh.anzVectors > 0 && object3D.objVectors.eu != null) {
            this.objVectors.createEnvmapCoords();
        }
        if (object3D.hasVertexAlpha() && object3D.objVectors.alpha != null) {
            this.objVectors.createAlpha();
            System.arraycopy(object3D.objVectors.alpha, 0, this.objVectors.alpha, 0, object3D.objVectors.alpha.length);
        }
        for (n = 0; n < object3D.objVectors.maxVectors; ++n) {
            this.objVectors.sbOrg[n] = object3D.objVectors.sbOrg[n];
            this.objVectors.srOrg[n] = object3D.objVectors.srOrg[n];
            this.objVectors.sgOrg[n] = object3D.objVectors.sgOrg[n];
            this.objVectors.nuOrg[n] = object3D.objVectors.nuOrg[n];
            this.objVectors.nvOrg[n] = object3D.objVectors.nvOrg[n];
            this.objVectors.uOrg[n] = object3D.objVectors.uOrg[n];
            this.objVectors.vOrg[n] = object3D.objVectors.vOrg[n];
            if (this.objVectors.eu != null) {
                this.objVectors.eu[n] = object3D.objVectors.eu[n];
                this.objVectors.ev[n] = object3D.objVectors.ev[n];
            }
            this.objVectors.buOrg[n] = object3D.objVectors.buOrg[n];
            this.objVectors.bvOrg[n] = object3D.objVectors.bvOrg[n];
            this.objVectors.vertexSector[n] = object3D.objVectors.vertexSector[n];
        }
        if (object3D.objVectors.uMul != null) {
            this.objVectors.createMultiCoords();
            for (n = 0; n < Config.maxTextureLayers - 1; ++n) {
                for (int i = 0; i < object3D.objVectors.maxVectors; ++i) {
                    this.objVectors.uMul[n][i] = object3D.objVectors.uMul[n][i];
                    this.objVectors.vMul[n][i] = object3D.objVectors.vMul[n][i];
                }
            }
        }
        this.maxStagesUsed = object3D.maxStagesUsed;
        this.usesMultiTexturing = object3D.usesMultiTexturing;
        this.objVectors.setMesh(this.objMesh);
        this.isTrans = object3D.isTrans;
        this.transMode = object3D.transMode;
        this.isEnvmapped = object3D.isEnvmapped;
        this.useCSEnvmapping = object3D.useCSEnvmapping;
        this.envMapDir = object3D.envMapDir;
        this.isBlended = object3D.isBlended;
        this.isBumpmapped = object3D.isBumpmapped;
        this.isVisible = object3D.isVisible;
        this.isSelectable = object3D.isSelectable;
        this.myWorld = object3D.myWorld;
        this.lowestPos = object3D.lowestPos;
        this.highestPos = object3D.highestPos;
        this.lazyTransforms = object3D.lazyTransforms;
        this.optimizeColDet = object3D.optimizeColDet;
        this.largestPolygonSize = object3D.largestPolygonSize;
        this.isBillBoard = object3D.isBillBoard;
        this.skipPivot = object3D.skipPivot;
        this.writeToZbuffer = object3D.writeToZbuffer;
        if (object3D.multiTex != null) {
            for (n = 0; n < Config.maxTextureLayers - 1; ++n) {
                if (this.multiTex == null) {
                    this.multiTex = new int[Config.maxTextureLayers - 1][this.texture.length];
                    this.multiMode = new int[Config.maxTextureLayers - 1][this.texture.length];
                }
                System.arraycopy(object3D.multiTex[n], 0, this.multiTex[n], 0, object3D.multiTex[n].length);
                System.arraycopy(object3D.multiMode[n], 0, this.multiMode[n], 0, object3D.multiMode[n].length);
            }
        }
        System.arraycopy(object3D.texture, 0, this.texture, 0, object3D.texture.length);
        System.arraycopy(object3D.basemap, 0, this.basemap, 0, object3D.basemap.length);
        if (object3D.sector != null) {
            if (this.sector == null) {
                this.sector = new int[object3D.texture.length];
            }
            System.arraycopy(object3D.sector, 0, this.sector, 0, object3D.sector.length);
        }
        if (object3D.bumpmap != null) {
            if (this.bumpmap == null) {
                this.bumpmap = new int[object3D.texture.length];
            }
            System.arraycopy(object3D.bumpmap, 0, this.bumpmap, 0, object3D.bumpmap.length);
        }
        System.arraycopy(object3D.parent, 0, this.parent, 0, object3D.parent.length);
        System.arraycopy(object3D.sectorStartPoint, 0, this.sectorStartPoint, 0, object3D.sectorStartPoint.length);
        System.arraycopy(object3D.sectorEndPoint, 0, this.sectorEndPoint, 0, object3D.sectorEndPoint.length);
        System.arraycopy(object3D.sectorStartPoly, 0, this.sectorStartPoly, 0, object3D.sectorStartPoly.length);
        System.arraycopy(object3D.sectorEndPoly, 0, this.sectorEndPoly, 0, object3D.sectorEndPoly.length);
        this.transValue = object3D.transValue;
        this.oneSectorOnly = object3D.oneSectorOnly;
        this.alwaysFilter = object3D.alwaysFilter;
        this.xRotationCenter = object3D.xRotationCenter;
        this.yRotationCenter = object3D.yRotationCenter;
        this.zRotationCenter = object3D.zRotationCenter;
        this.centerX = object3D.centerX;
        this.centerY = object3D.centerY;
        this.centerZ = object3D.centerZ;
        this.hasBoundingBox = object3D.hasBoundingBox;
        this.addColorR = object3D.addColorR;
        this.addColorG = object3D.addColorG;
        this.addColorB = object3D.addColorB;
        this.addColorInstance = object3D.addColorInstance;
        this.rotationMatrix = object3D.rotationMatrix.cloneMatrix();
        this.translationMatrix = object3D.translationMatrix.cloneMatrix();
        this.originMatrix = object3D.originMatrix.cloneMatrix();
        this.doCulling = object3D.doCulling;
        this.anim = object3D.anim;
        this.userObj = object3D.userObj;
    }

    private void init(int n) {
        if (n != -1 && n != 0) {
            int n2 = 3 * n + 8;
            this.objMesh = new Mesh(n2);
            this.objVectors = new Vectors(n2, this.objMesh);
            this.texture = new int[n];
            this.basemap = new int[n];
            if (!Config.saveMemory) {
                this.bumpmap = new int[n];
                this.sector = new int[n];
            }
        } else {
            this.objMesh = new Mesh(1);
        }
        this.parent = new Object3D[Config.maxParentObjects];
        this.parentCnt = 0;
        this.object3DRendered = false;
        this.rotationMatrix.setIdentity();
        this.translationMatrix.setIdentity();
        this.originMatrix.setIdentity();
        this.xRotationCenter = 0.0f;
        this.yRotationCenter = 0.0f;
        this.zRotationCenter = 0.0f;
        this.xWs = new float[8];
        this.yWs = new float[8];
        this.zWs = new float[8];
        this.centerX = 0.0f;
        this.centerY = 0.0f;
        this.centerZ = 0.0f;
        this.envMapDir = 1;
        this.dynSectorDetect = false;
        this.dynSectorList = new int[Config.maxPortals];
        this.sectorCnt = 0;
        this.number = nextID++;
        this.name = "object" + this.number;
        this.objMesh.anzTri = 0;
        this.isPotentialCollider = false;
        this.mayCollide = false;
        this.isBillBoard = false;
        this.isFlatShaded = false;
        this.isLit = true;
        this.lazyTransforms = false;
        this.wasCollider = false;
        this.anim = null;
        this.oneSectorOnly = true;
        this.ocTree = null;
        if (n != 0) {
            this.sectorStartPoint = new int[Config.maxPortals];
            this.sectorEndPoint = new int[Config.maxPortals];
            this.sectorStartPoly = new int[Config.maxPortals];
            this.sectorEndPoly = new int[Config.maxPortals];
            this.isEnvmapped = false;
            this.useCSEnvmapping = false;
            this.isBlended = false;
            this.isBumpmapped = false;
            this.isMainWorld = false;
            this.isSelectable = true;
            this.alwaysFilter = false;
            this.transValue = 0;
            this.isTrans = false;
            this.isVisible = true;
            this.doCulling = true;
            this.doSpecularLighting = false;
            this.singleSectorNumber = 0;
            this.hasPortals = false;
            this.addColorR = 0;
            this.addColorG = 0;
            this.addColorB = 0;
            this.addColorInstance = Color.black;
            this.hasBoundingBox = false;
        }
        this.scaleFactor = 1.0f;
        this.invScaleFactor = 1.0f;
    }

    public void compile() {
        this.dynamic = false;
        this.preferDLOrVBO = true;
        this.indexed = true;
        this.batchSize = -1;
        this.staticUV = true;
        this.compileInternal();
    }

    public void compileAndStrip() {
        this.compile();
        this.strip();
    }

    public void compile(boolean bl) {
        this.dynamic = bl;
        this.preferDLOrVBO = true;
        this.indexed = true;
        this.staticUV = true;
        this.batchSize = -1;
        this.compileInternal();
    }

    public void compile(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this.dynamic = bl;
        this.preferDLOrVBO = bl3;
        this.indexed = bl4;
        this.batchSize = n;
        this.staticUV = bl2;
        this.compileInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompiled() {
        if (this.compiled == null) {
            return false;
        }
        Vector vector = this.compiled;
        synchronized (vector) {
            return this.compiled != null && this.compiled.size() > 0;
        }
    }

    public void shareCompiledData(Object3D object3D) {
        if (object3D.shareWith != null) {
            Logger.log("Can't enable share data with an object that shares data itself! Use the source object instead!", 0);
            return;
        }
        if (this.sharing) {
            Logger.log("This object already shares data with '" + object3D.getName() + "'", 0);
            return;
        }
        if (object3D.ocTree != null || this.ocTree != null) {
            Logger.log("No data sharing with octrees supported!", 0);
            return;
        }
        if (object3D.objMesh != this.objMesh) {
            Logger.log("Can't share data from different meshes!", 0);
            return;
        }
        object3D.isSharingSource = true;
        this.shareWith = object3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompile(FrameBuffer frameBuffer) {
        if (this.isSharingSource) {
            Logger.log("You can't decompile an object that is the source of data for another one!", 1);
            return;
        }
        Object object = null;
        object = frameBuffer != null ? frameBuffer.getLock() : this;
        Object object2 = object;
        synchronized (object2) {
            if (this.isCompiled()) {
                if (this.stripped) {
                    Logger.log("A stripped Object3D can't be decompiled!", 0);
                } else {
                    Vector vector = this.compiled;
                    synchronized (vector) {
                        this.compiled.clear();
                        this.compiled = null;
                        this.toStrip = false;
                    }
                }
            } else if (this.compiled != null) {
                Vector vector = this.compiled;
                synchronized (vector) {
                    this.compiled = null;
                    this.toStrip = false;
                }
            }
        }
    }

    public void touch() {
        if (this.dynamic) {
            this.modified = true;
        }
        if (this.lazyTransforms) {
            this.enableLazyTransformations();
        }
    }

    public void strip() {
        if (this.compiled != null) {
            if (this.dynamic) {
                Logger.log("An Object3D compiled as dynamic can't be stripped!", 0);
            } else {
                this.toStrip = true;
            }
        } else {
            Logger.log("An Object3D can't be stripped if it hasn't been compiled before!", 0);
        }
    }

    public void setAnimationSequence(Animation animation) {
        if (animation == null) {
            this.anim = null;
            return;
        }
        if (animation.aktFrames != 0) {
            if (animation.keyFrames[0].anzCoords == this.objMesh.anzCoords) {
                this.anim = animation;
                this.anim.validate(this);
            } else {
                Logger.log("The sizes of the Animation's Meshes (" + animation.keyFrames[0].anzCoords + ") and the object's Mesh (" + this.objMesh.anzCoords + ") don't match!", 0);
            }
        } else {
            Logger.log("This Animation is empty!", 0);
        }
    }

    public void clearAnimation() {
        this.anim = null;
    }

    public Animation getAnimationSequence() {
        return this.anim;
    }

    public void animate(float f, int n) {
        if ((this.compiled == null || this.dynamic) && this.anim != null) {
            this.modified = true;
            this.anim.doAnimation(this, n, f);
        }
    }

    public void animate(float f) {
        this.animate(f, 0);
    }

    public void setCollisionMode(int n) {
        if (n == 0) {
            this.isPotentialCollider = false;
            this.mayCollide = false;
        } else {
            this.isPotentialCollider = (n & 1) == 1;
            this.mayCollide = (n & 2) == 2;
        }
    }

    public void setCollisionOptimization(boolean bl) {
        if (this.largestPolygonSize == -1.0f) {
            this.largestPolygonSize = this.objMesh.getLargestCoveredDistance();
        }
        this.optimizeColDet = bl;
    }

    public void setVisibility(boolean bl) {
        this.isVisible = bl;
    }

    public boolean getVisibility() {
        return this.isVisible;
    }

    public void calcBoundingBox() {
        float[] fArray = this.objMesh.calcBoundingBox();
        this.setBoundingBox(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public void createTriangleStrips() {
        this.createTriangleStrips(50);
    }

    public void createTriangleStrips(int n) {
        Object3D object3D = this;
        Mesh mesh = object3D.objMesh;
        int n2 = object3D.objMesh.anzTri;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        if (!Config.useMultipassStriping) {
            n5 = n - 1;
        }
        if (this.ocTree != null) {
            Logger.log("Creating strips has destroyed the octree of this object!", 1);
            this.ocTree = null;
        }
        while (n3 != n4 && n5 < n) {
            ++n5;
            n3 = n4;
            n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n6 = 0;
                for (int j = i + 1; j < n2; ++j) {
                    int n7;
                    int n8 = i + n6;
                    if (object3D.texture[n8] != object3D.texture[j] || object3D.sector != null && object3D.sector[n8] != object3D.sector[j]) continue;
                    int n9 = j;
                    int n10 = mesh.points[n8][0];
                    int n11 = mesh.points[n8][1];
                    int n12 = mesh.points[n8][2];
                    int n13 = mesh.points[n9][0];
                    int n14 = mesh.points[n9][1];
                    int n15 = mesh.coords[n10];
                    int n16 = mesh.coords[n11];
                    int n17 = mesh.coords[n12];
                    int n18 = mesh.coords[n13];
                    int n19 = mesh.coords[n14];
                    float f = object3D.objVectors.nuOrg[n10];
                    float f2 = object3D.objVectors.nvOrg[n10];
                    float f3 = object3D.objVectors.nuOrg[n11];
                    float f4 = object3D.objVectors.nvOrg[n11];
                    float f5 = object3D.objVectors.nuOrg[n12];
                    float f6 = object3D.objVectors.nvOrg[n12];
                    float f7 = object3D.objVectors.nuOrg[n13];
                    float f8 = object3D.objVectors.nvOrg[n13];
                    float f9 = object3D.objVectors.nuOrg[n14];
                    float f10 = object3D.objVectors.nvOrg[n14];
                    int n20 = n6;
                    if ((n6 & 1) == 0 && n16 == n19 && n17 == n18 && f3 == f9 && f4 == f10 && f5 == f7 && f6 == f8) {
                        ++n6;
                        if (n8 + 1 != n9 && n8 + 1 < n2) {
                            this.switchTriangles(n9, n8 + 1);
                        }
                    } else if ((n6 & 1) == 1 && n15 == n18 && n17 == n19 && f == f7 && f2 == f8 && f5 == f9 && f6 == f10) {
                        ++n6;
                        if (n8 + 1 != n9 && n8 + 1 < n2) {
                            this.switchTriangles(n9, n8 + 1);
                        }
                    }
                    if (n20 != n6) continue;
                    n13 = mesh.points[n9][1];
                    n14 = mesh.points[n9][2];
                    n18 = mesh.coords[n13];
                    n19 = mesh.coords[n14];
                    f7 = object3D.objVectors.nuOrg[n13];
                    f8 = object3D.objVectors.nvOrg[n13];
                    f9 = object3D.objVectors.nuOrg[n14];
                    f10 = object3D.objVectors.nvOrg[n14];
                    n20 = n6;
                    if ((n6 & 1) == 0 && n16 == n19 && n17 == n18 && f3 == f9 && f4 == f10 && f5 == f7 && f6 == f8) {
                        n7 = mesh.points[n9][0];
                        mesh.points[n9][0] = mesh.points[n9][1];
                        mesh.points[n9][1] = mesh.points[n9][2];
                        mesh.points[n9][2] = n7;
                        ++n6;
                        if (n8 + 1 != n9 && n8 + 1 < n2) {
                            this.switchTriangles(n9, n8 + 1);
                        }
                    } else if ((n6 & 1) == 1 && n15 == n18 && n17 == n19 && f == f7 && f2 == f8 && f5 == f9 && f6 == f10) {
                        n7 = mesh.points[n9][0];
                        mesh.points[n9][0] = mesh.points[n9][1];
                        mesh.points[n9][1] = mesh.points[n9][2];
                        mesh.points[n9][2] = n7;
                        ++n6;
                        if (n8 + 1 != n9 && n8 + 1 < n2) {
                            this.switchTriangles(n9, n8 + 1);
                        }
                    }
                    if (n20 != n6) continue;
                    n13 = mesh.points[n9][2];
                    n14 = mesh.points[n9][0];
                    n18 = mesh.coords[n13];
                    n19 = mesh.coords[n14];
                    f7 = object3D.objVectors.nuOrg[n13];
                    f8 = object3D.objVectors.nvOrg[n13];
                    f9 = object3D.objVectors.nuOrg[n14];
                    f10 = object3D.objVectors.nvOrg[n14];
                    n20 = n6;
                    if ((n6 & 1) == 0 && n16 == n19 && n17 == n18 && f3 == f9 && f4 == f10 && f5 == f7 && f6 == f8) {
                        n7 = mesh.points[n9][0];
                        mesh.points[n9][0] = mesh.points[n9][1];
                        mesh.points[n9][1] = mesh.points[n9][2];
                        mesh.points[n9][2] = n7;
                        ++n6;
                        if (n8 + 1 == n9 || n8 + 1 >= n2) continue;
                        this.switchTriangles(n9, n8 + 1);
                        continue;
                    }
                    if ((n6 & 1) != 1 || n15 != n18 || n17 != n19 || f != f7 || f2 != f8 || f5 != f9 || f6 != f10) continue;
                    n7 = mesh.points[n9][0];
                    mesh.points[n9][0] = mesh.points[n9][1];
                    mesh.points[n9][1] = mesh.points[n9][2];
                    mesh.points[n9][2] = n7;
                    ++n6;
                    if (n8 + 1 == n9 || n8 + 1 >= n2) continue;
                    this.switchTriangles(n9, n8 + 1);
                }
                if (n6 != 0) {
                    ++n4;
                }
                i += n6;
            }
        }
        if (!Config.useMultipassStriping) {
            n5 = 2;
        }
        Logger.log("Created " + n4 + " triangle-strips for " + this.getName() + " in " + (n5 - 1) + " pass(es)", 2);
    }

    public void rebuild() {
        this.build();
    }

    public void build() {
        try {
            this.hasBeenBuild = true;
            if (!this.isMainWorld) {
                this.calcCenter();
                this.calcBoundingBox();
            } else {
                this.reorderSectors(1);
                this.myWorld.portals.calcAABoundingBox(this);
            }
            this.calcNormals();
            this.recreateTextureCoords();
            GLSLShader gLSLShader = null;
            if (this.renderHook != null && this.renderHook instanceof GLSLShader) {
                gLSLShader = (GLSLShader)this.renderHook;
            }
            if (gLSLShader != null && gLSLShader.needsTangents() && !this.objMesh.tangentsCalculated) {
                this.objMesh.calculateTangentVectors(this.objVectors);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.log("Couldn't build() object (" + this.name + "): " + exception.getClass().getName() + "/" + exception.getMessage(), 0);
        }
    }

    public void unbuild() {
        if (this.objMesh.obbStart != 0 || this.objMesh.obbEnd != 0) {
            this.objMesh.anzCoords = this.objMesh.obbStart;
            this.objMesh.obbStart = 0;
            this.objMesh.obbEnd = 0;
        }
    }

    public void disableVertexSharing() {
        this.neverOptimize = true;
    }

    public void reorderSectors(int n) {
        if (!this.oneSectorOnly) {
            int n2;
            int n3;
            int n4;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = this.objMesh.anzTri - 1;
            while (!bl) {
                bl = true;
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = this.sector[n4];
                    n2 = this.sector[n4 + 1];
                    boolean bl3 = bl2 = n3 > n2;
                    if (n != 1) {
                        if (n == 2) {
                            if (n3 == n2 && this.objMesh.zOrg[this.objMesh.coords[this.objMesh.points[n4][0]]] > this.objMesh.zOrg[this.objMesh.coords[this.objMesh.points[n4 + 1][0]]]) {
                                bl2 = true;
                            }
                        } else if (n == 3) {
                            if (n3 == n2 && this.objMesh.yOrg[this.objMesh.coords[this.objMesh.points[n4][0]]] > this.objMesh.yOrg[this.objMesh.coords[this.objMesh.points[n4 + 1][0]]]) {
                                bl2 = true;
                            }
                        } else if (n == 4 && n3 == n2 && this.objMesh.xOrg[this.objMesh.coords[this.objMesh.points[n4][0]]] > this.objMesh.xOrg[this.objMesh.coords[this.objMesh.points[n4 + 1][0]]]) {
                            bl2 = true;
                        }
                    } else if (n3 == n2 && this.texture[n4] > this.texture[n4 + 1]) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    this.switchTriangles(n4, n4 + 1);
                    bl = false;
                }
            }
            bl = false;
            n5 = this.objMesh.anzCoords - 1;
            while (!bl) {
                bl = true;
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = n4;
                    int n6 = this.objVectors.vertexSector[n3];
                    n2 = n4 + 1;
                    int n7 = this.objVectors.vertexSector[n2];
                    if (n6 <= n7) continue;
                    float f = this.objMesh.xOrg[n3];
                    this.objMesh.xOrg[n3] = this.objMesh.xOrg[n2];
                    this.objMesh.xOrg[n2] = f;
                    f = this.objMesh.yOrg[n3];
                    this.objMesh.yOrg[n3] = this.objMesh.yOrg[n2];
                    this.objMesh.yOrg[n2] = f;
                    f = this.objMesh.zOrg[n3];
                    this.objMesh.zOrg[n3] = this.objMesh.zOrg[n2];
                    this.objMesh.zOrg[n2] = f;
                    f = this.objMesh.nxOrg[n3];
                    this.objMesh.nxOrg[n3] = this.objMesh.nxOrg[n2];
                    this.objMesh.nxOrg[n2] = f;
                    f = this.objMesh.nyOrg[n3];
                    this.objMesh.nyOrg[n3] = this.objMesh.nyOrg[n2];
                    this.objMesh.nyOrg[n2] = f;
                    f = this.objMesh.nzOrg[n3];
                    this.objMesh.nzOrg[n3] = this.objMesh.nzOrg[n2];
                    this.objMesh.nzOrg[n2] = f;
                    int n8 = this.objVectors.vertexSector[n3];
                    this.objVectors.vertexSector[n3] = this.objVectors.vertexSector[n2];
                    this.objVectors.vertexSector[n2] = n8;
                    for (int i = 0; i < this.objMesh.anzVectors; ++i) {
                        if (this.objMesh.coords[i] == n4) {
                            this.objMesh.coords[i] = n4 + 1;
                            continue;
                        }
                        if (this.objMesh.coords[i] != n4 + 1) continue;
                        this.objMesh.coords[i] = n4;
                    }
                    bl = false;
                }
            }
            n4 = -99;
            n3 = 0;
            for (n3 = 0; n3 < this.objMesh.anzTri; ++n3) {
                if (this.sector[n3] != n4) {
                    this.sectorStartPoly[this.sector[n3]] = n3;
                    if (n4 != -99) {
                        this.sectorEndPoly[n4] = n3 - 1;
                    }
                }
                n4 = this.sector[n3];
            }
            if (n4 != -99) {
                this.sectorEndPoly[n4] = n3 - 1;
                n4 = -99;
            }
            for (n3 = 0; n3 < this.objMesh.anzCoords; ++n3) {
                if (this.objVectors.vertexSector[n3] != n4) {
                    this.sectorStartPoint[this.objVectors.vertexSector[n3]] = n3;
                    if (n4 != -99) {
                        this.sectorEndPoint[n4] = n3 - 1;
                    }
                }
                n4 = this.objVectors.vertexSector[n3];
            }
            if (n4 != -99) {
                this.sectorEndPoint[n4] = n3 - 1;
            }
            this.sectorStartPoint[n4 + 1] = this.objMesh.anzCoords + 1;
            this.sectorEndPoint[n4 + 1] = this.objMesh.anzCoords + 1;
            this.sectorStartPoly[n4 + 1] = this.objMesh.anzTri + 1;
        }
    }

    public void setSectorDetectionMode(boolean bl) {
        if (bl && !this.oneSectorOnly) {
            Logger.log("Autodection of sectors can't be used for a multi-sectored object. It has to use static sector definitions!", 0);
        } else {
            this.dynSectorDetect = bl;
        }
    }

    public boolean hasChild(Object3D object3D) {
        if (object3D != null) {
            return object3D.hasParent(this);
        }
        Logger.log("Testing a null-Object3D for being a child is rather senseless!", 1);
        return false;
    }

    public boolean hasParent(Object3D object3D) {
        boolean bl = false;
        if (object3D != null) {
            for (int i = 0; i < this.parentCnt; ++i) {
                if (this.parent[i].number != object3D.number) continue;
                bl = true;
                break;
            }
            return bl;
        }
        Logger.log("Testing a null-Object3D for being a parent is rather senseless!", 1);
        return false;
    }

    public void addChild(Object3D object3D) {
        if (object3D != null) {
            object3D.addParent(this);
        } else {
            Logger.log("Tried to assign a non-existent Object3D as child!", 0);
        }
    }

    public void removeChild(Object3D object3D) {
        if (object3D != null) {
            object3D.removeParent(this);
        } else {
            Logger.log("Tried to remove a non-existent Object3D from the child collection!", 0);
        }
    }

    public void removeParent(Object3D object3D) {
        if (object3D != null) {
            boolean bl = false;
            for (int i = 0; i < this.parentCnt; ++i) {
                if (this.parent[i].number != object3D.number) continue;
                bl = true;
                if (i != this.parentCnt - 1) {
                    for (int j = i; j < this.parentCnt - 1; ++j) {
                        this.parent[j] = this.parent[j + 1];
                    }
                }
                --this.parentCnt;
            }
            if (!bl) {
                Logger.log("Tried to remove an object from the parent collection that isn't part of it!", 0);
            }
        } else {
            Logger.log("Tried to remove a non-existent object from the parent collection!", 0);
        }
    }

    public void addParent(Object3D object3D) {
        if (object3D == this) {
            Logger.log("An object can't be its own parent!", 1);
            return;
        }
        if (object3D != null) {
            if (this.parentCnt < Config.maxParentObjects) {
                this.parent[this.parentCnt] = object3D;
                ++this.parentCnt;
            } else {
                Logger.log("Can't assign more than " + Config.maxParentObjects + " objects as parent objects in the current Configuration!", 0);
            }
        } else {
            Logger.log("Tried to assign a nonexistent object as parent!", 0);
        }
    }

    public Object3D[] getParents() {
        Object3D[] object3DArray = new Object3D[this.parentCnt];
        if (this.parentCnt != 0) {
            System.arraycopy(this.parent, 0, object3DArray, 0, this.parentCnt);
        }
        return object3DArray;
    }

    public int getID() {
        return this.number - 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.myWorld != null && this.myWorld.getInternalObjectByName(string) != null) {
            Logger.log("Object with name '" + string + "' already exists!", 0);
        } else {
            this.name = string;
        }
    }

    public void setSelectable(boolean bl) {
        this.isSelectable = bl;
    }

    public boolean isSelectable() {
        if (this.compiled != null) {
            return false;
        }
        return this.isSelectable;
    }

    public boolean wasVisible() {
        return this.object3DRendered;
    }

    public void setCulling(boolean bl) {
        this.doCulling = bl;
    }

    public boolean getCulling() {
        return this.doCulling;
    }

    public void setShadingMode(int n) {
        this.isFlatShaded = false;
        if (n == 1) {
            this.isFlatShaded = true;
        }
    }

    public void setLighting(int n) {
        if (n == 0) {
            this.isLit = true;
        }
        if (n == 1) {
            this.isLit = false;
        }
    }

    public int getLighting() {
        if (this.isLit) {
            return 0;
        }
        return 1;
    }

    public void setSpecularLighting(boolean bl) {
        this.doSpecularLighting = bl;
    }

    public void setFiltering(boolean bl) {
        this.alwaysFilter = bl;
    }

    public void setTransparency(int n) {
        this.transValue = n;
        this.isTrans = n >= 0;
    }

    public int getTransparency() {
        if (!this.isTrans) {
            return -1;
        }
        return this.transValue;
    }

    public boolean isTransparent() {
        return this.isTrans;
    }

    public void setTransparencyMode(int n) {
        this.transMode = n;
    }

    public int getTransparencyMode() {
        return this.transMode;
    }

    public boolean hasVertexAlpha() {
        return this.objVectors.hasAlpha;
    }

    public void setAdditionalColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.addColorInstance = color;
        if (n >= 0 && n < 256 && n2 >= 0 && n2 < 256 && n3 >= 0 && n3 < 256) {
            this.addColorR = n;
            this.addColorG = n2;
            this.addColorB = n3;
        } else {
            Logger.log("Color values need to be in the range of [0..255]!", 0);
        }
    }

    public Color getAdditionalColor() {
        return this.addColorInstance;
    }

    public void clearAdditionalColor() {
        this.addColorR = 0;
        this.addColorG = 0;
        this.addColorB = 0;
        this.addColorInstance = Color.black;
    }

    public void clearObject() {
        this.objMesh.obbStart = 0;
        this.objMesh.obbEnd = 0;
        this.objMesh.anzTri = 0;
        this.objMesh.anzCoords = 0;
        this.objMesh.anzVectors = 0;
    }

    public void setMatrixCacheUsage(boolean bl) {
        this.useMatrixCache = bl;
        if (!this.useMatrixCache) {
            this.matrixCache = null;
        } else if (this.matrixCache == null) {
            this.matrixCache = new Hashtable(3);
        }
    }

    public void setReNormalization(boolean bl) {
        this.reNormalize = bl;
    }

    public void setDepthBufferWrites(boolean bl) {
        this.writeToZbuffer = bl;
    }

    public void decoupleMesh() {
        this.objMesh = new Mesh(0);
        this.objVectors.setMesh(this.objMesh);
    }

    public void setBlending(boolean bl) {
        this.isEnvmapped = bl;
        this.isBlended = bl;
        this.isBumpmapped = bl;
        TextureManager textureManager = TextureManager.getInstance();
        if (bl) {
            this.checkBumpmap();
            if (!textureManager.textures[this.bumpmap[0]].isBumpmap) {
                textureManager.textures[this.bumpmap[0]].createBumpmap();
            }
            if (textureManager.textures[this.basemap[0]].height != textureManager.textures[this.bumpmap[0]].height || textureManager.textures[this.basemap[0]].width != textureManager.textures[this.bumpmap[0]].width) {
                Logger.log("Correct blending can only be applied, if texture- and bumpmap are equal in size!", 1);
            }
        }
    }

    public boolean getBlending() {
        return this.isBlended;
    }

    public void setBumpmapped(boolean bl) {
        this.isBumpmapped = bl;
        this.isEnvmapped = bl;
        TextureManager textureManager = TextureManager.getInstance();
        if (bl) {
            this.checkBumpmap();
            if (!textureManager.textures[this.bumpmap[0]].isBumpmap) {
                textureManager.textures[this.bumpmap[0]].createBumpmap();
            }
            if (textureManager.textures[this.texture[0]].height != 256 || textureManager.textures[this.texture[0]].height != 256) {
                Logger.log("The environment-map used for bumpmapping should be 256x256 pixels in size.", 1);
            }
        }
    }

    public void setBillboarding(boolean bl) {
        this.isBillBoard = bl;
    }

    public boolean isBumpmapped() {
        return this.isBumpmapped;
    }

    public boolean isEnvmapped() {
        return this.isEnvmapped;
    }

    public void setEnvmapped(boolean bl) {
        this.isEnvmapped = bl;
    }

    public void setEnvmapMode(boolean bl) {
        this.useCSEnvmapping = bl;
    }

    public void setEnvmapDirection(int n) {
        this.envMapDir = n;
    }

    public boolean getEnvmapMode() {
        return this.useCSEnvmapping;
    }

    public void rotateX(float f) {
        this.rotationMatrix.rotateX(f);
    }

    public void rotateY(float f) {
        this.rotationMatrix.rotateY(f);
    }

    public void rotateZ(float f) {
        this.rotationMatrix.rotateZ(f);
    }

    public void rotateAxis(SimpleVector simpleVector, float f) {
        this.rotationMatrix.rotateAxis(simpleVector, f);
    }

    public void translateMesh() {
        this.objMesh.translateMesh(this.translationMatrix, this.originMatrix);
        if (this.anim != null) {
            this.anim.translateMesh(this.translationMatrix, this.originMatrix);
        }
        this.calcBoundingBox();
    }

    public void translate(SimpleVector simpleVector) {
        this.translationMatrix.translate(simpleVector);
    }

    public void translate(float f, float f2, float f3) {
        this.translationMatrix.translate(f, f2, f3);
    }

    public void align(Camera camera) {
        float f = this.getScale();
        this.setScale(1.0f);
        this.rotationMatrix = camera.backMatrix.invert3x3();
        this.setScale(f);
    }

    public void align(Object3D object3D) {
        float f = this.getScale();
        this.setScale(1.0f);
        this.rotationMatrix = object3D.rotationMatrix.cloneMatrix();
        this.setScale(f);
    }

    public void setOrientation(SimpleVector simpleVector, SimpleVector simpleVector2) {
        this.rotationMatrix.setOrientation(simpleVector, simpleVector2);
    }

    public void enableLazyTransformations() {
        this.lazyTransforms = true;
        this.transCache = null;
        this.invCache = null;
    }

    public void disableLazyTransformations() {
        this.lazyTransforms = false;
        this.transCache = null;
        this.invCache = null;
    }

    public void scale(float f) {
        if (f > 0.0f) {
            this.scaleFactor *= f;
            this.invScaleFactor = 1.0f / this.scaleFactor;
            this.rotationMatrix.scalarMul(f);
        } else {
            Logger.log("Scale has to be greater than zero!", 0);
        }
    }

    public void setScale(float f) {
        if (this.scaleFactor != 0.0f && f > 0.0f) {
            this.scale(f / this.scaleFactor);
        } else {
            Logger.log("Invalid scale!", 0);
        }
    }

    public float getScale() {
        return this.scaleFactor;
    }

    public SimpleVector getTranslation() {
        return this.translationMatrix.getTranslation();
    }

    public SimpleVector getTranslation(SimpleVector simpleVector) {
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
        }
        simpleVector.set(this.translationMatrix.mat[3][0], this.translationMatrix.mat[3][1], this.translationMatrix.mat[3][2]);
        return simpleVector;
    }

    public SimpleVector getOrigin() {
        return this.originMatrix.getTranslation();
    }

    public SimpleVector getXAxis() {
        SimpleVector simpleVector = this.rotationMatrix.getXAxis();
        simpleVector.scalarMul(this.invScaleFactor);
        return simpleVector;
    }

    public SimpleVector getYAxis() {
        SimpleVector simpleVector = this.rotationMatrix.getYAxis();
        simpleVector.scalarMul(this.invScaleFactor);
        return simpleVector;
    }

    public SimpleVector getZAxis() {
        SimpleVector simpleVector = this.rotationMatrix.getZAxis();
        simpleVector.scalarMul(this.invScaleFactor);
        return simpleVector;
    }

    public Matrix getRotationMatrix() {
        return this.rotationMatrix;
    }

    public Matrix getTranslationMatrix() {
        return this.translationMatrix;
    }

    public Matrix getOriginMatrix() {
        return this.originMatrix;
    }

    public int getLightCount() {
        if (this.nearestLights == null) {
            return 0;
        }
        for (int i = 0; i < this.nearestLights.length; ++i) {
            if (this.nearestLights[i][0] != -9999.0f) continue;
            return i;
        }
        return this.nearestLights.length;
    }

    public void setRotationMatrix(Matrix matrix) {
        this.rotationMatrix = matrix;
    }

    public void setTextureMatrix(Matrix matrix) {
        this.textureMatrix = matrix;
    }

    public Matrix getTextureMatrix() {
        return this.textureMatrix;
    }

    public void clearRotation() {
        this.rotationMatrix.setIdentity();
    }

    public void clearTranslation() {
        this.translationMatrix.setIdentity();
    }

    public void rotateMesh() {
        this.objMesh.rotateMesh(this.rotationMatrix, this.xRotationCenter, this.yRotationCenter, this.zRotationCenter, this.scaleFactor);
        if (this.anim != null) {
            this.anim.rotateMesh(this.rotationMatrix, this.xRotationCenter, this.yRotationCenter, this.zRotationCenter, this.scaleFactor);
        }
        this.calcBoundingBox();
    }

    public void setTranslationMatrix(Matrix matrix) {
        this.translationMatrix = matrix;
    }

    public void setMesh(Mesh mesh) {
        this.objMesh = mesh;
        if (this.objVectors != null) {
            this.objVectors.setMesh(this.objMesh);
        }
    }

    public Mesh getMesh() {
        return this.objMesh;
    }

    public PolygonManager getPolygonManager() {
        if (this.polyManager == null) {
            this.polyManager = new PolygonManager(this);
        }
        return this.polyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoundingBox(float f, float f2, float f3, float f4, float f5, float f6) {
        Mesh mesh = this.objMesh;
        synchronized (mesh) {
            if (!this.isMainWorld && this.oneSectorOnly) {
                if (this.objMesh.obbStart != 0) {
                    this.objMesh.anzCoords = this.objMesh.obbStart;
                    this.objMesh.obbStart = 0;
                    this.objMesh.obbEnd = 0;
                }
                if (this.objVectors != null) {
                    this.objMesh.obbStart = this.objVectors.addVertex(f, f3, f5);
                    this.objVectors.addVertex(f, f3, f6);
                    this.objVectors.addVertex(f2, f3, f5);
                    this.objVectors.addVertex(f2, f3, f6);
                    this.objVectors.addVertex(f2, f4, f5);
                    this.objVectors.addVertex(f2, f4, f6);
                    this.objVectors.addVertex(f, f4, f5);
                    this.objMesh.obbEnd = this.objVectors.addVertex(f, f4, f6);
                    this.hasBoundingBox = true;
                }
            } else {
                Logger.log("Can't create a bounding box for a multi-sectored object!", 1);
            }
        }
    }

    public Object3D cloneObject() {
        return new Object3D(this, true);
    }

    void enlarge(int n) {
        int n2;
        int n3 = this.texture.length + n;
        if (n3 <= this.texture.length) {
            return;
        }
        Object3D object3D = new Object3D(n3);
        Vectors vectors = object3D.objVectors;
        Mesh mesh = object3D.objMesh;
        if (this.objVectors.sb != null) {
            vectors.createScreenColors();
        }
        if (this.objVectors.eu != null) {
            object3D.objVectors.createEnvmapCoords();
        }
        if (this.objVectors.alpha != null) {
            object3D.objVectors.createAlpha();
        }
        if (this.objVectors.bsu != null) {
            object3D.objVectors.createBumpmapCoords();
        }
        for (n2 = 0; n2 < this.objVectors.maxVectors; ++n2) {
            vectors.sbOrg[n2] = this.objVectors.sbOrg[n2];
            vectors.srOrg[n2] = this.objVectors.srOrg[n2];
            vectors.sgOrg[n2] = this.objVectors.sgOrg[n2];
            vectors.nuOrg[n2] = this.objVectors.nuOrg[n2];
            vectors.nvOrg[n2] = this.objVectors.nvOrg[n2];
            vectors.uOrg[n2] = this.objVectors.uOrg[n2];
            vectors.vOrg[n2] = this.objVectors.vOrg[n2];
            if (this.objVectors.eu != null) {
                vectors.eu[n2] = this.objVectors.eu[n2];
                vectors.ev[n2] = this.objVectors.ev[n2];
            }
            vectors.buOrg[n2] = this.objVectors.buOrg[n2];
            vectors.bvOrg[n2] = this.objVectors.bvOrg[n2];
            vectors.vertexSector[n2] = this.objVectors.vertexSector[n2];
            vectors.sx[n2] = this.objVectors.sx[n2];
            vectors.sy[n2] = this.objVectors.sy[n2];
            vectors.sz[n2] = this.objVectors.sz[n2];
            vectors.su[n2] = this.objVectors.su[n2];
            vectors.sv[n2] = this.objVectors.sv[n2];
            if (vectors.bsu != null) {
                vectors.bsu[n2] = this.objVectors.bsu[n2];
                vectors.bsv[n2] = this.objVectors.bsv[n2];
            }
            if (this.objVectors.sb != null) {
                vectors.sb[n2] = this.objVectors.sb[n2];
                vectors.sr[n2] = this.objVectors.sr[n2];
                vectors.sg[n2] = this.objVectors.sg[n2];
            }
            if (this.objVectors.alpha == null) continue;
            vectors.alpha[n2] = this.objVectors.alpha[n2];
        }
        this.objVectors.sbOrg = vectors.sbOrg;
        this.objVectors.srOrg = vectors.srOrg;
        this.objVectors.sgOrg = vectors.sgOrg;
        this.objVectors.nuOrg = vectors.nuOrg;
        this.objVectors.nvOrg = vectors.nvOrg;
        this.objVectors.uOrg = vectors.uOrg;
        this.objVectors.vOrg = vectors.vOrg;
        this.objVectors.eu = vectors.eu;
        this.objVectors.ev = vectors.ev;
        this.objVectors.buOrg = vectors.buOrg;
        this.objVectors.bvOrg = vectors.bvOrg;
        this.objVectors.vertexSector = vectors.vertexSector;
        this.objVectors.maxVectors = vectors.maxVectors;
        this.objVectors.sx = vectors.sx;
        this.objVectors.sy = vectors.sy;
        this.objVectors.sz = vectors.sz;
        this.objVectors.su = vectors.su;
        this.objVectors.sv = vectors.sv;
        this.objVectors.sb = vectors.sb;
        this.objVectors.sr = vectors.sr;
        this.objVectors.sg = vectors.sg;
        this.objVectors.bsu = vectors.bsu;
        this.objVectors.bsv = vectors.bsv;
        this.objVectors.setMesh(this.objMesh);
        this.objMesh.maxVectors = mesh.maxVectors;
        for (n2 = 0; n2 < this.objMesh.points.length; ++n2) {
            mesh.points[n2][0] = this.objMesh.points[n2][0];
            mesh.points[n2][1] = this.objMesh.points[n2][1];
            mesh.points[n2][2] = this.objMesh.points[n2][2];
        }
        this.objMesh.points = mesh.points;
        for (n2 = 0; n2 < this.objMesh.xOrg.length; ++n2) {
            mesh.xOrg[n2] = this.objMesh.xOrg[n2];
            mesh.yOrg[n2] = this.objMesh.yOrg[n2];
            mesh.zOrg[n2] = this.objMesh.zOrg[n2];
            mesh.nxOrg[n2] = this.objMesh.nxOrg[n2];
            mesh.nyOrg[n2] = this.objMesh.nyOrg[n2];
            mesh.nzOrg[n2] = this.objMesh.nzOrg[n2];
            mesh.coords[n2] = this.objMesh.coords[n2];
        }
        this.objMesh.xOrg = mesh.xOrg;
        this.objMesh.yOrg = mesh.yOrg;
        this.objMesh.zOrg = mesh.zOrg;
        this.objMesh.nxOrg = mesh.nxOrg;
        this.objMesh.nyOrg = mesh.nyOrg;
        this.objMesh.nzOrg = mesh.nzOrg;
        this.objMesh.coords = mesh.coords;
        System.arraycopy(this.texture, 0, object3D.texture, 0, this.texture.length);
        System.arraycopy(this.basemap, 0, object3D.basemap, 0, this.basemap.length);
        this.texture = object3D.texture;
        this.basemap = object3D.basemap;
        if (this.sector != null) {
            if (object3D.sector == null) {
                object3D.sector = new int[this.texture.length];
            }
            System.arraycopy(this.sector, 0, object3D.sector, 0, this.sector.length);
            this.sector = object3D.sector;
        }
        if (this.bumpmap != null) {
            if (object3D.bumpmap == null) {
                object3D.bumpmap = new int[this.texture.length];
            }
            System.arraycopy(this.bumpmap, 0, object3D.bumpmap, 0, this.bumpmap.length);
            this.bumpmap = object3D.bumpmap;
        }
    }

    public Matrix getWorldTransformation() {
        Matrix matrix;
        if (!this.lazyTransforms || this.transCache == null) {
            matrix = new Matrix();
            Matrix matrix2 = this.getCachedMatrix(0);
            matrix.mat[3][0] = -this.xRotationCenter;
            matrix.mat[3][1] = -this.yRotationCenter;
            matrix.mat[3][2] = -this.zRotationCenter;
            matrix2.mat[3][0] = this.xRotationCenter + this.translationMatrix.mat[3][0] + this.originMatrix.mat[3][0];
            matrix2.mat[3][1] = this.yRotationCenter + this.translationMatrix.mat[3][1] + this.originMatrix.mat[3][1];
            matrix2.mat[3][2] = this.zRotationCenter + this.translationMatrix.mat[3][2] + this.originMatrix.mat[3][2];
            if (!this.isBillBoard) {
                matrix.matMul(this.rotationMatrix);
            } else {
                this.mat2 = this.myWorld.camera.frontMatrix;
                if (this.myWorld.camera.billBoardMatrix != null) {
                    this.mat2 = this.myWorld.camera.billBoardMatrix;
                }
                Matrix matrix3 = this.mat2.invert();
                matrix3.scalarMul(this.scaleFactor);
                matrix.matMul(matrix3);
            }
            matrix.matMul(matrix2);
            if (this.parentCnt != 0) {
                matrix = this.isBillBoard && !Config.oldStyleBillBoarding ? this.recurseObjectsBillboarded(matrix) : this.recurseObjects(matrix);
            }
            if (this.lazyTransforms) {
                this.transCache = matrix.cloneMatrix();
            }
        } else {
            matrix = this.transCache.cloneMatrix();
        }
        return matrix;
    }

    public Matrix getWorldTransformation(Matrix matrix) {
        if (matrix == null) {
            matrix = new Matrix();
        }
        if (!this.lazyTransforms || this.transCache == null) {
            Matrix matrix2 = this.getWorldTransformation();
            matrix.setTo(matrix2);
        } else {
            matrix.setTo(this.transCache);
        }
        return matrix;
    }

    public synchronized void addCollisionListener(CollisionListener collisionListener) {
        if (this.collisionListener == null) {
            this.collisionListener = new Vector(2);
        }
        this.collisionListener.addElement(collisionListener);
        ++globalListenerCount;
    }

    public synchronized void removeCollisionListener(CollisionListener collisionListener) {
        if (this.collisionListener != null) {
            this.collisionListener.removeElement(collisionListener);
            --globalListenerCount;
            if (this.collisionListener.size() == 0) {
                this.collisionListener = null;
            }
        }
    }

    public void disableCollisionListeners() {
        this.disableListeners = true;
    }

    public void enableCollisionListeners() {
        this.disableListeners = false;
    }

    public Enumeration getCollisionListeners() {
        if (this.collisionListener != null) {
            return this.collisionListener.elements();
        }
        return new Vector(1).elements();
    }

    public void setRenderHook(IRenderHook iRenderHook) {
        this.renderHook = iRenderHook;
    }

    public int checkForCollision(SimpleVector simpleVector, float f) {
        this.checkWorld();
        return this.myWorld.checkObjCollision(this, simpleVector, f);
    }

    public SimpleVector checkForCollisionSpherical(SimpleVector simpleVector, float f) {
        this.checkWorld();
        return this.myWorld.checkObjCollisionSpherical(this, simpleVector, f);
    }

    public SimpleVector checkForCollisionEllipsoid(SimpleVector simpleVector, SimpleVector simpleVector2, int n) {
        if (n < 1) {
            n = 1;
        }
        this.checkWorld();
        return this.myWorld.checkObjCollisionEllipsoid(this, simpleVector, simpleVector2, n);
    }

    private void checkWorld() {
        if (this.myWorld == null) {
            Logger.log("Object has to be assigned to a world for collision detection!", 0);
        }
    }

    public void setEllipsoidMode(int n) {
        this.ellipsoidMode = n;
    }

    public int getEllipsoidMode() {
        return this.ellipsoidMode;
    }

    public boolean wasTargetOfLastCollision() {
        return this.wasCollider;
    }

    public void resetCollisionStatus() {
        this.wasCollider = false;
    }

    public float calcMinDistance(SimpleVector simpleVector, SimpleVector simpleVector2) {
        this.wasCollider = false;
        this.resetPolygonIDCount();
        float f = this.collide(new float[]{simpleVector.x, simpleVector.y, simpleVector.z}, new float[]{simpleVector2.x, simpleVector2.y, simpleVector2.z}, 0.0f, 1.0E12f, false);
        if (f != 1.0E12f) {
            SimpleVector simpleVector3 = new SimpleVector(simpleVector2.x, simpleVector2.y, simpleVector2.z);
            simpleVector3.scalarMul(f);
            simpleVector3.add(new SimpleVector(simpleVector.x, simpleVector.y, simpleVector.z));
            this.notifyCollisionListeners(0, 0, new Object3D[]{this}, simpleVector3);
            this.wasCollider = true;
        }
        return f;
    }

    public float calcMinDistance(SimpleVector simpleVector, SimpleVector simpleVector2, float f) {
        return this.calcMinDistance(simpleVector, simpleVector2, f, true);
    }

    float calcMinDistance(SimpleVector simpleVector, SimpleVector simpleVector2, float f, boolean bl) {
        this.wasCollider = false;
        this.resetPolygonIDCount();
        float f2 = Config.collideOffset;
        Config.collideOffset = f;
        float f3 = this.collide(new float[]{simpleVector.x, simpleVector.y, simpleVector.z}, new float[]{simpleVector2.x, simpleVector2.y, simpleVector2.z}, 0.0f, f, false);
        Config.collideOffset = f2;
        if (bl && f3 != 1.0E12f) {
            SimpleVector simpleVector3 = new SimpleVector(simpleVector2.x, simpleVector2.y, simpleVector2.z);
            simpleVector3.scalarMul(f3);
            simpleVector3.add(new SimpleVector(simpleVector.x, simpleVector.y, simpleVector.z));
            this.notifyCollisionListeners(0, 0, new Object3D[]{this}, simpleVector3);
            this.wasCollider = true;
        }
        return f3;
    }

    public void setCenter(SimpleVector simpleVector) {
        this.centerX = simpleVector.x;
        this.centerY = simpleVector.y;
        this.centerZ = simpleVector.z;
    }

    public SimpleVector getCenter() {
        return new SimpleVector(this.centerX, this.centerY, this.centerZ);
    }

    public SimpleVector getTransformedCenter() {
        return this.getTransformedCenter(new SimpleVector());
    }

    public SimpleVector getTransformedCenter(SimpleVector simpleVector) {
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
        }
        this.getProjectedPoint(this.centerX, this.centerY, this.centerZ, simpleVector, null);
        return simpleVector;
    }

    public void setRotationPivot(SimpleVector simpleVector) {
        this.xRotationCenter = simpleVector.x;
        this.yRotationCenter = simpleVector.y;
        this.zRotationCenter = simpleVector.z;
    }

    public SimpleVector getRotationPivot() {
        return new SimpleVector(this.xRotationCenter, this.yRotationCenter, this.zRotationCenter);
    }

    public void calcCenter() {
        SimpleVector simpleVector = this.objMesh.calcCenter();
        if (!this.skipPivot) {
            this.xRotationCenter = simpleVector.x;
            this.yRotationCenter = simpleVector.y;
            this.zRotationCenter = simpleVector.z;
        }
        this.centerX = simpleVector.x;
        this.centerY = simpleVector.y;
        this.centerZ = simpleVector.z;
    }

    public void setOcTree(OcTree ocTree) {
        if (!Config.doPortalHsr || ocTree == null) {
            this.ocTree = ocTree;
        } else {
            Logger.log("Octree is null or portal rendering is being used!", 1);
        }
    }

    public OcTree getOcTree() {
        return this.ocTree;
    }

    public void setSector(int n) {
        if (this.oneSectorOnly) {
            int n2 = Config.maxPortals - 1;
            if (this.myWorld != null) {
                n2 = this.myWorld.portals.anzSectors;
            }
            for (int i = 1; i <= n2; ++i) {
                if (i == n) {
                    this.sectorEndPoint[i] = this.objMesh.anzCoords;
                    this.sectorEndPoly[i] = this.objMesh.anzTri;
                } else {
                    this.sectorEndPoint[i] = 0;
                    this.sectorEndPoly[i] = 0;
                }
                this.sectorStartPoint[i] = 0;
                this.sectorStartPoly[i] = 0;
            }
            this.singleSectorNumber = n;
        } else {
            Logger.log("Multi-sectored objects can't be assigned to a single sector!", 0);
        }
    }

    public void setAsMultiSectored() {
        this.oneSectorOnly = false;
    }

    public void setOrigin(SimpleVector simpleVector) {
        this.originMatrix.setIdentity();
        this.originMatrix.translate(simpleVector.x, simpleVector.y, simpleVector.z);
    }

    public void invert() {
        for (int i = 0; i < this.objMesh.anzTri; ++i) {
            float f;
            int n;
            int n2 = this.objMesh.points[i][0];
            int n3 = this.objMesh.points[i][2];
            int n4 = this.objMesh.coords[n2];
            this.objMesh.coords[n2] = n = this.objMesh.coords[n3];
            this.objMesh.coords[n3] = n4;
            float f2 = this.objVectors.nuOrg[n2];
            this.objVectors.nuOrg[n2] = f = this.objVectors.nuOrg[n3];
            this.objVectors.nuOrg[n3] = f2;
            f2 = this.objVectors.nvOrg[n2];
            this.objVectors.nvOrg[n2] = f = this.objVectors.nvOrg[n3];
            this.objVectors.nvOrg[n3] = f2;
            f2 = this.objVectors.uOrg[n2];
            this.objVectors.uOrg[n2] = f = this.objVectors.uOrg[n3];
            this.objVectors.uOrg[n3] = f2;
            f2 = this.objVectors.vOrg[n2];
            this.objVectors.vOrg[n2] = f = this.objVectors.vOrg[n3];
            this.objVectors.vOrg[n3] = f2;
            f2 = this.objVectors.buOrg[n2];
            this.objVectors.buOrg[n2] = f = this.objVectors.buOrg[n3];
            this.objVectors.buOrg[n3] = f2;
            f2 = this.objVectors.bvOrg[n2];
            this.objVectors.bvOrg[n2] = f = this.objVectors.bvOrg[n3];
            this.objVectors.bvOrg[n3] = f2;
        }
    }

    public void invertCulling(boolean bl) {
        this.reverseCulling = bl;
    }

    public boolean cullingIsInverted() {
        return this.reverseCulling;
    }

    public void calcNormals() {
        this.objMesh.calcNormals();
    }

    public void calcTangentVectors() {
        this.objMesh.calculateTangentVectors(this.objVectors);
    }

    public void calcTextureWrap() {
        int n;
        int n2 = 256;
        int n3 = 256;
        int n4 = 256;
        int n5 = 256;
        int n6 = n2 >> 1;
        int n7 = n3 >> 1;
        --n2;
        --n3;
        int n8 = n5 >> 1;
        int n9 = n4 >> 1;
        --n5;
        --n4;
        Hashtable<Integer, Vector<Integer>> hashtable = new Hashtable<Integer, Vector<Integer>>();
        for (n = 0; n < this.objMesh.anzVectors; ++n) {
            Integer n10 = IntegerC.valueOf(this.objMesh.coords[n]);
            Vector<Integer> vector = (Vector<Integer>)hashtable.get(n10);
            if (vector == null) {
                vector = new Vector<Integer>();
                hashtable.put(n10, vector);
            }
            vector.addElement(IntegerC.valueOf(n));
        }
        for (n = 0; n < this.objMesh.anzCoords; ++n) {
            float f = this.objMesh.nxOrg[n];
            float f2 = this.objMesh.nyOrg[n];
            float f3 = (float)n6 + f * (float)n6;
            float f4 = (float)n7 + f2 * (float)n7;
            float f5 = (float)n8 + f * (float)n8;
            float f6 = (float)n9 + f2 * (float)n9;
            while (f3 > (float)n2 || f3 < 0.0f || f4 > (float)n3 || f4 < 0.0f) {
                if (f3 > (float)n2) {
                    f3 = -n2;
                } else if (f3 < 0.0f) {
                    f3 = n2;
                }
                if (f4 > (float)n3) {
                    f4 = -n3;
                    continue;
                }
                if (!(f4 < 0.0f)) continue;
                f4 = n3;
            }
            while (f5 > (float)n5 || f5 < 0.0f || f6 > (float)n4 || f6 < 0.0f) {
                if (f5 > (float)n5) {
                    f5 = -n5;
                } else if (f5 < 0.0f) {
                    f5 = n5;
                }
                if (f6 > (float)n4) {
                    f6 = -n4;
                    continue;
                }
                if (!(f6 < 0.0f)) continue;
                f6 = n4;
            }
            Vector vector = (Vector)hashtable.get(IntegerC.valueOf(n));
            if (vector == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                int n11 = (Integer)vector.elementAt(i);
                this.objVectors.uOrg[n11] = f3;
                this.objVectors.vOrg[n11] = f4;
                this.objVectors.buOrg[n11] = f5;
                this.objVectors.bvOrg[n11] = f6;
                this.objVectors.nuOrg[n11] = f3 / (float)n2;
                this.objVectors.nvOrg[n11] = f4 / (float)n3;
            }
        }
    }

    public void calcTextureWrapSpherical() {
        int n;
        int n2 = 256;
        int n3 = 256;
        int n4 = 256;
        int n5 = 256;
        this.calcCenter();
        double d = 1.0;
        double d2 = 1.0;
        Hashtable<Integer, Vector<Integer>> hashtable = new Hashtable<Integer, Vector<Integer>>();
        for (n = 0; n < this.objMesh.anzVectors; ++n) {
            Integer n6 = IntegerC.valueOf(this.objMesh.coords[n]);
            Vector<Integer> vector = (Vector<Integer>)hashtable.get(n6);
            if (vector == null) {
                vector = new Vector<Integer>();
                hashtable.put(n6, vector);
            }
            vector.addElement(IntegerC.valueOf(n));
        }
        for (n = 0; n < this.objMesh.anzCoords; ++n) {
            float f = this.objMesh.xOrg[n] - this.centerX;
            float f2 = this.objMesh.yOrg[n] - this.centerY;
            float f3 = this.objMesh.zOrg[n] - this.centerZ;
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            float f5 = (float)((Math.asin(f /= f4) / Math.PI + 0.5) * d);
            float f6 = (float)((Math.asin(f2 /= f4) / Math.PI + 0.5) * d2);
            float f7 = f5 * (float)n5;
            float f8 = f6 * (float)n4;
            f5 *= (float)n2;
            f6 *= (float)n3;
            while (f5 > (float)n2 || f5 < 0.0f || f6 > (float)n3 || f6 < 0.0f) {
                if (f5 > (float)n2) {
                    f5 = -n2;
                } else if (f5 < 0.0f) {
                    f5 = n2;
                }
                if (f6 > (float)n3) {
                    f6 = -n3;
                    continue;
                }
                if (!(f6 < 0.0f)) continue;
                f6 = n3;
            }
            while (f7 > (float)n5 || f7 < 0.0f || f8 > (float)n4 || f8 < 0.0f) {
                if (f7 > (float)n5) {
                    f7 = -n5;
                } else if (f7 < 0.0f) {
                    f7 = n5;
                }
                if (f8 > (float)n4) {
                    f8 = -n4;
                    continue;
                }
                if (!(f8 < 0.0f)) continue;
                f8 = n4;
            }
            Vector vector = (Vector)hashtable.get(IntegerC.valueOf(n));
            if (vector == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                int n7 = (Integer)vector.elementAt(i);
                this.objVectors.uOrg[n7] = f5;
                this.objVectors.vOrg[n7] = f6;
                this.objVectors.buOrg[n7] = f7;
                this.objVectors.bvOrg[n7] = f8;
                this.objVectors.nuOrg[n7] = f5 / (float)n2;
                this.objVectors.nvOrg[n7] = f6 / (float)n3;
            }
        }
    }

    public void recreateTextureCoords() {
        TextureManager textureManager = TextureManager.getInstance();
        for (int i = 0; i < this.objMesh.anzTri; ++i) {
            int n = textureManager.textures[this.texture[i]].width;
            int n2 = textureManager.textures[this.texture[i]].height;
            int n3 = 1;
            int n4 = 1;
            if (this.bumpmap != null) {
                n3 = textureManager.textures[this.bumpmap[i]].width;
                n4 = textureManager.textures[this.bumpmap[i]].height;
            }
            for (int j = 0; j < 3; ++j) {
                int n5 = this.objMesh.points[i][j];
                this.objVectors.buOrg[n5] = this.objVectors.nuOrg[n5] * (float)n3;
                this.objVectors.bvOrg[n5] = this.objVectors.nvOrg[n5] * (float)n4;
                this.objVectors.uOrg[n5] = this.objVectors.nuOrg[n5] * (float)n;
                this.objVectors.vOrg[n5] = this.objVectors.nvOrg[n5] * (float)n2;
            }
        }
    }

    public void setAllTextures(String string, String string2) {
        this.setAllTextures(string, string, string2);
    }

    public void setAllTextures(String string, String string2, String string3) {
        this.checkBumpmap();
        TextureManager textureManager = TextureManager.getInstance();
        int n = textureManager.getTextureID(string2);
        int n2 = textureManager.getTextureID(string);
        int n3 = textureManager.getTextureID(string3);
        if (n != -1 && n2 != -1 && n3 != -1) {
            for (int i = 0; i < this.objMesh.anzTri; ++i) {
                this.texture[i] = n;
                this.basemap[i] = n2;
                this.bumpmap[i] = n3;
            }
        } else {
            Logger.log("Tried to set an undefined texture!", 0);
        }
        if (!textureManager.textures[n3].isBumpmap) {
            textureManager.textures[n3].createBumpmap();
        }
    }

    public void setBaseTexture(String string) {
        TextureManager textureManager = TextureManager.getInstance();
        int n = textureManager.getTextureID(string);
        if (n != -1) {
            for (int i = 0; i < this.objMesh.anzTri; ++i) {
                this.basemap[i] = n;
            }
        } else {
            Logger.log("Tried to set an undefined texture as base!", 0);
        }
    }

    public void setTexture(String string) {
        TextureManager textureManager = TextureManager.getInstance();
        int n = textureManager.getTextureID(string);
        if (n != -1) {
            for (int i = 0; i < this.objMesh.anzTri; ++i) {
                this.texture[i] = n;
            }
        } else {
            Logger.log("Tried to set an undefined texture as default!", 0);
        }
    }

    public void setTexture(TextureInfo textureInfo) {
        if (this.texture != null) {
            int n;
            int n2;
            if (textureInfo.stageCnt > 1) {
                if (this.multiTex == null) {
                    this.multiTex = new int[Config.maxTextureLayers - 1][this.texture.length];
                    this.multiMode = new int[Config.maxTextureLayers - 1][this.texture.length];
                    for (n2 = 0; n2 < this.texture.length; ++n2) {
                        for (n = 0; n < Config.maxTextureLayers - 1; ++n) {
                            this.multiTex[n][n2] = -1;
                        }
                    }
                }
                this.objVectors.createMultiCoords();
                this.usesMultiTexturing = true;
            } else {
                this.usesMultiTexturing = false;
            }
            n2 = textureInfo.textures[0];
            if (n2 != -1) {
                for (n = 0; n < this.objMesh.anzTri; ++n) {
                    this.texture[n] = n2;
                }
            } else {
                Logger.log("Tried to set an undefined texture as default!", 0);
            }
            for (n = 1; n < textureInfo.stageCnt; ++n) {
                int n3;
                int n4 = textureInfo.textures[n];
                int n5 = textureInfo.mode[n];
                int n6 = n - 1;
                for (n3 = 0; n3 < this.objMesh.anzTri; ++n3) {
                    this.multiTex[n6][n3] = n4;
                    this.multiMode[n6][n3] = n5;
                }
                for (n3 = 0; n3 < this.objVectors.nuOrg.length; ++n3) {
                    this.objVectors.uMul[n6][n3] = this.objVectors.nuOrg[n3];
                    this.objVectors.vMul[n6][n3] = this.objVectors.nvOrg[n3];
                }
            }
            this.maxStagesUsed = textureInfo.stageCnt;
        }
    }

    public void setBumpmapTexture(String string) {
        this.checkBumpmap();
        TextureManager textureManager = TextureManager.getInstance();
        int n = textureManager.getTextureID(string);
        if (n != -1) {
            for (int i = 0; i < this.objMesh.anzTri; ++i) {
                this.bumpmap[i] = n;
            }
            if (!textureManager.textures[n].isBumpmap) {
                textureManager.textures[n].createBumpmap();
            }
        } else {
            Logger.log("Tried to set an undefined texture as bumpmap!", 0);
        }
    }

    public void removeMultiTexturing() {
        this.maxStagesUsed = 1;
        this.usesMultiTexturing = false;
        this.multiMode = null;
        this.multiTex = null;
    }

    public void invertTextureCoords(boolean bl, boolean bl2) {
        for (int i = 0; i < this.objVectors.nuOrg.length; ++i) {
            if (bl) {
                this.objVectors.nuOrg[i] = 1.0f - this.objVectors.nuOrg[i];
            }
            if (bl2) {
                this.objVectors.nvOrg[i] = 1.0f - this.objVectors.nvOrg[i];
            }
            if (this.objVectors.uMul == null) continue;
            for (int j = 0; j < this.objVectors.uMul.length; ++j) {
                if (bl) {
                    this.objVectors.uMul[j][i] = 1.0f - this.objVectors.uMul[j][i];
                }
                if (!bl2) continue;
                this.objVectors.vMul[j][i] = 1.0f - this.objVectors.vMul[j][i];
            }
        }
        this.recreateTextureCoords();
    }

    public float rayIntersectsAABB(SimpleVector simpleVector, SimpleVector simpleVector2, boolean bl) {
        return this.rayIntersectsAABB(new float[]{simpleVector.x, simpleVector.y, simpleVector.z}, new float[]{simpleVector2.x, simpleVector2.y, simpleVector2.z}, bl);
    }

    public float rayIntersectsAABB(SimpleVector simpleVector, SimpleVector simpleVector2) {
        return this.rayIntersectsAABB(new float[]{simpleVector.x, simpleVector.y, simpleVector.z}, new float[]{simpleVector2.x, simpleVector2.y, simpleVector2.z}, false);
    }

    final float rayIntersectsAABB(float[] fArray, float[] fArray2, boolean bl) {
        float f;
        float f2;
        if (!this.hasBoundingBox) {
            return 1.0E12f;
        }
        Matrix matrix = this.getInverseWorldTransformation();
        float f3 = matrix.mat[0][0];
        float f4 = matrix.mat[1][0];
        float f5 = matrix.mat[1][1];
        float f6 = matrix.mat[2][1];
        float f7 = matrix.mat[2][0];
        float f8 = matrix.mat[0][1];
        float f9 = matrix.mat[2][2];
        float f10 = matrix.mat[1][2];
        float f11 = matrix.mat[0][2];
        float f12 = matrix.mat[3][0];
        float f13 = matrix.mat[3][1];
        float f14 = matrix.mat[3][2];
        float f15 = fArray2[0] * f3 + fArray2[1] * f4 + fArray2[2] * f7;
        float f16 = fArray2[0] * f8 + fArray2[1] * f5 + fArray2[2] * f6;
        float f17 = fArray2[0] * f11 + fArray2[1] * f10 + fArray2[2] * f9;
        float f18 = fArray[0] * f3 + fArray[1] * f4 + fArray[2] * f7 + f12;
        float f19 = fArray[0] * f8 + fArray[1] * f5 + fArray[2] * f6 + f13;
        float f20 = fArray[0] * f11 + fArray[1] * f10 + fArray[2] * f9 + f14;
        float f21 = -1.0E11f;
        float f22 = -1.0E11f;
        float f23 = -1.0E11f;
        float f24 = 1.0E11f;
        float f25 = 1.0E11f;
        float f26 = 1.0E11f;
        if (!bl) {
            float f27 = (float)Math.sqrt(f15 * f15 + f16 * f16 + f17 * f17);
            f15 /= f27;
            f16 /= f27;
            f17 /= f27;
        }
        int n = this.objMesh.obbStart;
        float f28 = this.objMesh.xOrg[n];
        float f29 = this.objMesh.yOrg[n];
        float f30 = this.objMesh.zOrg[n];
        float f31 = f28;
        float f32 = f29;
        float f33 = f30;
        for (int i = 1; i < 8; ++i) {
            f2 = this.objMesh.xOrg[i + n];
            float f34 = this.objMesh.zOrg[i + n];
            float f35 = this.objMesh.yOrg[i + n];
            if (f2 < f28) {
                f28 = f2;
            } else if (f2 > f31) {
                f31 = f2;
            }
            if (f35 < f29) {
                f29 = f35;
            } else if (f35 > f32) {
                f32 = f35;
            }
            if (f34 < f30) {
                f30 = f34;
                continue;
            }
            if (!(f34 > f33)) continue;
            f33 = f34;
        }
        if (Math.abs(f15) > 1.0E-9f && (f21 = (f28 - f18) / f15) > (f24 = (f31 - f18) / f15)) {
            float f36 = f21;
            f21 = f24;
            f24 = f36;
        }
        if (Math.abs(f16) > 1.0E-9f && (f22 = (f29 - f19) / f16) > (f25 = (f32 - f19) / f16)) {
            float f37 = f22;
            f22 = f25;
            f25 = f37;
        }
        if (Math.abs(f17) > 1.0E-9f && (f23 = (f30 - f20) / f17) > (f26 = (f33 - f20) / f17)) {
            float f38 = f23;
            f23 = f26;
            f26 = f38;
        }
        if ((f = f21) < f22) {
            f = f22;
        }
        if (f < f23) {
            f = f23;
        }
        if ((f2 = f24) > f25) {
            f2 = f25;
        }
        if (f2 > f26) {
            f2 = f26;
        }
        if (f <= f2 && f2 > 0.0f) {
            return f;
        }
        return 1.0E12f;
    }

    public boolean ellipsoidIntersectsAABB(SimpleVector simpleVector, SimpleVector simpleVector2) {
        if (!Config.useFastCollisionDetection) {
            return true;
        }
        if (!this.hasBoundingBox) {
            return false;
        }
        boolean bl = true;
        Matrix matrix = this.getInverseWorldTransformation();
        float f = matrix.mat[0][0];
        float f2 = matrix.mat[1][0];
        float f3 = matrix.mat[1][1];
        float f4 = matrix.mat[2][1];
        float f5 = matrix.mat[2][0];
        float f6 = matrix.mat[0][1];
        float f7 = matrix.mat[2][2];
        float f8 = matrix.mat[1][2];
        float f9 = matrix.mat[0][2];
        float f10 = matrix.mat[3][0];
        float f11 = matrix.mat[3][1];
        float f12 = matrix.mat[3][2];
        float f13 = simpleVector.x * f + simpleVector.y * f2 + simpleVector.z * f5 + f10;
        float f14 = simpleVector.x * f6 + simpleVector.y * f3 + simpleVector.z * f4 + f11;
        float f15 = simpleVector.x * f9 + simpleVector.y * f8 + simpleVector.z * f7 + f12;
        float f16 = Math.abs(simpleVector2.x * f + simpleVector2.y * f2 + simpleVector2.z * f5);
        float f17 = Math.abs(simpleVector2.x * f6 + simpleVector2.y * f3 + simpleVector2.z * f4);
        float f18 = Math.abs(simpleVector2.x * f9 + simpleVector2.y * f8 + simpleVector2.z * f7);
        f13 /= f16;
        f14 /= f17;
        f15 /= f18;
        int n = this.objMesh.obbStart;
        float f19 = 1.0f / f16;
        float f20 = 1.0f / f17;
        float f21 = 1.0f / f18;
        float f22 = this.objMesh.xOrg[n] * f19;
        float f23 = this.objMesh.yOrg[n] * f20;
        float f24 = this.objMesh.zOrg[n] * f21;
        float f25 = f22;
        float f26 = f23;
        float f27 = f24;
        int n2 = 1 + n;
        int n3 = 8 + n;
        for (int i = n2; i < n3; ++i) {
            float f28 = this.objMesh.xOrg[i] * f19;
            float f29 = this.objMesh.yOrg[i] * f20;
            float f30 = this.objMesh.zOrg[i] * f21;
            if (f28 < f22) {
                f22 = f28;
            } else if (f28 > f25) {
                f25 = f28;
            }
            if (f29 < f23) {
                f23 = f29;
            } else if (f29 > f26) {
                f26 = f29;
            }
            if (f30 < f24) {
                f24 = f30;
                continue;
            }
            if (!(f30 > f27)) continue;
            f27 = f30;
        }
        if (f13 + 1.0f < f22 || f13 - 1.0f > f25 || f14 + 1.0f < f23 || f14 - 1.0f > f26 || f15 + 1.0f < f24 || f15 - 1.0f > f27) {
            bl = false;
        }
        return bl;
    }

    public boolean sphereIntersectsAABB(SimpleVector simpleVector, float f) {
        return this.sphereIntersectsAABB(simpleVector.toArray(), f);
    }

    final boolean sphereIntersectsAABB(float[] fArray, float f) {
        if (!Config.useFastCollisionDetection) {
            return true;
        }
        if (!this.hasBoundingBox) {
            return false;
        }
        boolean bl = true;
        Matrix matrix = this.getInverseWorldTransformation();
        float f2 = matrix.mat[0][0];
        float f3 = matrix.mat[1][0];
        float f4 = matrix.mat[1][1];
        float f5 = matrix.mat[2][1];
        float f6 = matrix.mat[2][0];
        float f7 = matrix.mat[0][1];
        float f8 = matrix.mat[2][2];
        float f9 = matrix.mat[1][2];
        float f10 = matrix.mat[0][2];
        float f11 = matrix.mat[3][0];
        float f12 = matrix.mat[3][1];
        float f13 = matrix.mat[3][2];
        float f14 = fArray[0] * f2 + fArray[1] * f3 + fArray[2] * f6 + f11;
        float f15 = fArray[0] * f7 + fArray[1] * f4 + fArray[2] * f5 + f12;
        float f16 = fArray[0] * f10 + fArray[1] * f9 + fArray[2] * f8 + f13;
        int n = this.objMesh.obbStart;
        float f17 = this.objMesh.xOrg[n];
        float f18 = this.objMesh.yOrg[n];
        float f19 = this.objMesh.zOrg[n];
        float f20 = f17;
        float f21 = f18;
        float f22 = f19;
        for (int i = 1; i < 8; ++i) {
            float f23 = this.objMesh.xOrg[i + n];
            float f24 = this.objMesh.zOrg[i + n];
            float f25 = this.objMesh.yOrg[i + n];
            if (f23 < f17) {
                f17 = f23;
            } else if (f23 > f20) {
                f20 = f23;
            }
            if (f25 < f18) {
                f18 = f25;
            } else if (f25 > f21) {
                f21 = f25;
            }
            if (f24 < f19) {
                f19 = f24;
                continue;
            }
            if (!(f24 > f22)) continue;
            f22 = f24;
        }
        if (f14 + f < f17 || f14 - f > f20 || f15 + f < f18 || f15 - f > f21 || f16 + f < f19 || f16 - f > f22) {
            bl = false;
        }
        return bl;
    }

    final float collide(float[] fArray, float[] fArray2, float f, float f2) {
        return this.collide(fArray, fArray2, f, f2, true);
    }

    private final float collide(float[] fArray, float[] fArray2, float f, float f2, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        float f3;
        float f4;
        float f5;
        float f6;
        Object[] objectArray3;
        float f7;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        float[] fArray7 = new float[3];
        float[] fArray8 = new float[3];
        float[] fArray9 = new float[3];
        float f8 = Config.collideOffset;
        if (this.optimizeColDet && this.largestPolygonSize != -1.0f && bl && (f7 = this.largestPolygonSize + 2.0f + f) < f8) {
            f8 = f7;
        }
        int[] nArray = null;
        int n = 0;
        if (!this.isMainWorld) {
            Matrix matrix = this.getWorldTransformation();
            objectArray3 = this.getInverseWorldTransformation();
            f6 = objectArray3.mat[0][0];
            float f9 = objectArray3.mat[1][0];
            float f10 = objectArray3.mat[1][1];
            float f11 = objectArray3.mat[2][1];
            float f12 = objectArray3.mat[2][0];
            float f13 = objectArray3.mat[0][1];
            float f14 = objectArray3.mat[2][2];
            float f15 = objectArray3.mat[1][2];
            float f16 = objectArray3.mat[0][2];
            float f17 = objectArray3.mat[3][0];
            float f18 = objectArray3.mat[3][1];
            float f19 = objectArray3.mat[3][2];
            fArray3[0] = fArray2[0] * f6 + fArray2[1] * f9 + fArray2[2] * f12;
            fArray3[1] = fArray2[0] * f13 + fArray2[1] * f10 + fArray2[2] * f11;
            fArray3[2] = fArray2[0] * f16 + fArray2[1] * f15 + fArray2[2] * f14;
            f5 = fArray[0] * f6 + fArray[1] * f9 + fArray[2] * f12 + f17;
            f4 = fArray[0] * f13 + fArray[1] * f10 + fArray[2] * f11 + f18;
            f3 = fArray[0] * f16 + fArray[1] * f15 + fArray[2] * f14 + f19;
            fArray4[0] = f5;
            fArray4[1] = f4;
            fArray4[2] = f3;
            if (Config.doPortalHsr && this.dynSectorDetect && !this.hasPortals && this.objMesh.obbEnd - this.objMesh.obbStart == 7) {
                objectArray2 = new float[8];
                float[] fArray10 = new float[8];
                objectArray = new float[8];
                f6 = matrix.mat[0][0];
                f9 = matrix.mat[1][0];
                f10 = matrix.mat[1][1];
                f11 = matrix.mat[2][1];
                f12 = matrix.mat[2][0];
                f13 = matrix.mat[0][1];
                f14 = matrix.mat[2][2];
                f15 = matrix.mat[1][2];
                f16 = matrix.mat[0][2];
                f17 = matrix.mat[3][0];
                f18 = matrix.mat[3][1];
                f19 = matrix.mat[3][2];
                for (int i = 0; i < 8; ++i) {
                    float f20 = this.objMesh.zOrg[i + this.objMesh.obbStart];
                    float f21 = this.objMesh.xOrg[i + this.objMesh.obbStart];
                    float f22 = this.objMesh.yOrg[i + this.objMesh.obbStart];
                    objectArray2[i] = (int)(f21 * f6 + f22 * f9 + f20 * f12 + f17);
                    fArray10[i] = f21 * f13 + f22 * f10 + f20 * f11 + f18;
                    objectArray[i] = (int)(f21 * f16 + f22 * f15 + f20 * f14 + f19);
                }
                nArray = new int[Config.maxPortals];
                nArray = this.myWorld.portals.detectAllCoveredSectors(nArray, (float[])objectArray2, fArray10, (float[])objectArray);
                n = nArray[0];
            }
        } else {
            fArray3[0] = fArray2[0];
            fArray3[1] = fArray2[1];
            fArray3[2] = fArray2[2];
            fArray4[0] = fArray[0];
            fArray4[1] = fArray[1];
            fArray4[2] = fArray[2];
            f5 = fArray4[0];
            f4 = fArray4[1];
            f3 = fArray4[2];
        }
        int n2 = 0;
        objectArray3 = null;
        if (this.ocTree != null && !Config.doPortalHsr && this.ocTree.getCollisionUse() && (n2 = ((Integer)(objectArray3 = this.ocTree.getColliderLeafs(fArray4[0], fArray4[1], fArray4[2], (f6 = f2 + f) * this.ocTree.getRadiusMultiplier()))[0]).intValue()) == 0) {
            return 1.0E12f;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        float f23 = 1.0E12f;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        int[] nArray2 = new int[Math.max(Config.maxPortals, 1)];
        int n9 = 0;
        if (this.myWorld != null) {
            for (int i = 1; i <= this.myWorld.portals.anzSectors; ++i) {
                if (f2 != 1.0E12f && (!(fArray[0] >= this.myWorld.portals.bounding[i][0] - f2) || !(fArray[0] <= this.myWorld.portals.bounding[i][1] + f2) || !(fArray[1] >= this.myWorld.portals.bounding[i][2] - f2) || !(fArray[1] <= this.myWorld.portals.bounding[i][3] + f2) || !(fArray[2] >= this.myWorld.portals.bounding[i][4] - f2) || !(fArray[2] <= this.myWorld.portals.bounding[i][5] + f2))) continue;
                nArray2[n9] = i;
                ++n9;
            }
        }
        if (n9 == 0) {
            n9 = 1;
            nArray2[0] = 0;
        }
        for (int i = 0; i < n9; ++i) {
            block26: {
                block28: {
                    block27: {
                        block25: {
                            n7 = 0;
                            n8 = 0;
                            if (!this.isMainWorld && this.oneSectorOnly) break block25;
                            n7 = this.sectorStartPoly[nArray2[i]];
                            n8 = this.sectorEndPoly[nArray2[i]] + 1;
                            if (n7 + 1 != n8) break block26;
                            n8 = 0;
                            n7 = 0;
                            break block26;
                        }
                        if ((this.dynSectorDetect || nArray2[i] != this.singleSectorNumber) && this.singleSectorNumber != 0) break block27;
                        n7 = 0;
                        n8 = this.objMesh.anzTri;
                        i = n9;
                        break block26;
                    }
                    if (!this.dynSectorDetect) break block26;
                    if (n != true) break block28;
                    if (nArray[1] != nArray2[i]) break block26;
                    n7 = 0;
                    n8 = this.objMesh.anzTri;
                    i = n9;
                    break block26;
                }
                for (int j = 1; j <= n; ++j) {
                    if (nArray[j] != nArray2[i]) continue;
                    n7 = 0;
                    n8 = this.objMesh.anzTri;
                    i = n9;
                    break;
                }
            }
            boolean bl3 = false;
            OcTreeNode[] ocTreeNodeArray = null;
            objectArray2 = null;
            int n10 = 0;
            if (this.ocTree != null && !Config.doPortalHsr && this.ocTree.getCollisionUse()) {
                ocTreeNodeArray = (OcTreeNode[])objectArray3[1];
                bl3 = true;
            }
            objectArray = this.objMesh.coords;
            float[] fArray11 = this.objMesh.xOrg;
            float[] fArray12 = this.objMesh.yOrg;
            float[] fArray13 = this.objMesh.zOrg;
            block4: do {
                if (bl3) {
                    objectArray2 = ocTreeNodeArray[n10].getPolygons();
                    n7 = 0;
                    n8 = ocTreeNodeArray[n10].getPolyCount();
                    ++n10;
                }
                for (int j = n7; j < n8; ++j) {
                    int n11 = j;
                    if (bl3) {
                        n11 = objectArray2[j];
                    }
                    int n12 = objectArray[this.objMesh.points[n11][0]];
                    float f24 = fArray11[n12];
                    float f25 = fArray12[n12];
                    float f26 = fArray13[n12];
                    if (f2 == 1.0E12f || Math.abs(f24 - f5) <= f8 && Math.abs(f25 - f4) <= f8 && Math.abs(f26 - f3) <= f8) {
                        int n13 = objectArray[this.objMesh.points[n11][2]];
                        int n14 = objectArray[this.objMesh.points[n11][1]];
                        fArray8[0] = fArray11[n14] - f24;
                        fArray8[1] = fArray12[n14] - f25;
                        fArray8[2] = fArray13[n14] - f26;
                        fArray9[0] = fArray11[n13] - f24;
                        fArray9[1] = fArray12[n13] - f25;
                        fArray9[2] = fArray13[n13] - f26;
                        Vectors.calcCross(fArray5, fArray3, fArray9);
                        float f27 = Vectors.calcDot(fArray8, fArray5);
                        if (f27 >= 1.0E-9f) {
                            float f28 = 1.0f / f27;
                            fArray6[0] = f5 - f24;
                            fArray6[1] = f4 - f25;
                            fArray6[2] = f3 - f26;
                            float f29 = Vectors.calcDot(fArray6, fArray5) * f28;
                            if ((double)f29 >= 0.0 && f29 <= 1.0f) {
                                Vectors.calcCross(fArray7, fArray6, fArray8);
                                float f30 = Vectors.calcDot(fArray3, fArray7) * f28;
                                if ((double)f30 >= 0.0 && (double)(f29 + f30) <= 1.0) {
                                    float f31 = Vectors.calcDot(fArray9, fArray7) * f28;
                                    if (f31 < f && f31 >= 0.0f) {
                                        bl2 = true;
                                        f23 = f31;
                                        n6 = n11;
                                    } else {
                                        bl2 = false;
                                        if (f31 < f23 && f31 >= 0.0f) {
                                            f23 = f31;
                                            n6 = n11;
                                        }
                                    }
                                    ++n3;
                                }
                            }
                        }
                    } else {
                        ++n4;
                    }
                    ++n5;
                    if (!bl2) continue;
                    n11 = n8;
                    i = n9;
                    continue block4;
                }
            } while (bl3 && n10 < n2);
        }
        if (n6 != -1) {
            this.addPolygonID(n6);
        }
        return f23;
    }

    final float[] collideSpherical(float[] fArray, float f, float f2, boolean[] blArray, boolean bl) {
        float f3;
        float f4;
        int n;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float[] fArray2 = new float[3];
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int[] nArray = null;
        int n2 = 0;
        Matrix matrix = null;
        float f14 = Config.collideOffset;
        if (this.optimizeColDet && this.largestPolygonSize != -1.0f && (f13 = this.largestPolygonSize + f + 1.0f) < f14) {
            f14 = f13;
        }
        if (!this.isMainWorld) {
            matrix = this.getWorldTransformation();
            Matrix matrix2 = this.getInverseWorldTransformation();
            float f15 = matrix2.mat[0][0];
            float f16 = matrix2.mat[1][0];
            float f17 = matrix2.mat[1][1];
            float f18 = matrix2.mat[2][1];
            float f19 = matrix2.mat[2][0];
            float f20 = matrix2.mat[0][1];
            float f21 = matrix2.mat[2][2];
            f12 = matrix2.mat[1][2];
            f11 = matrix2.mat[0][2];
            f10 = matrix2.mat[3][0];
            f9 = matrix2.mat[3][1];
            f8 = matrix2.mat[3][2];
            f7 = fArray[0] * f15 + fArray[1] * f16 + fArray[2] * f19 + f10;
            f6 = fArray[0] * f20 + fArray[1] * f17 + fArray[2] * f18 + f9;
            f5 = fArray[0] * f11 + fArray[1] * f12 + fArray[2] * f21 + f8;
            fArray2[0] = f7;
            fArray2[1] = f6;
            fArray2[2] = f5;
            if (Config.doPortalHsr && this.dynSectorDetect && !this.hasPortals && this.objMesh.obbEnd - this.objMesh.obbStart == 7) {
                float[] fArray3 = new float[8];
                float[] fArray4 = new float[8];
                float[] fArray5 = new float[8];
                f15 = matrix.mat[0][0];
                f16 = matrix.mat[1][0];
                f17 = matrix.mat[1][1];
                f18 = matrix.mat[2][1];
                f19 = matrix.mat[2][0];
                f20 = matrix.mat[0][1];
                f21 = matrix.mat[2][2];
                f12 = matrix.mat[1][2];
                f11 = matrix.mat[0][2];
                f10 = matrix.mat[3][0];
                f9 = matrix.mat[3][1];
                f8 = matrix.mat[3][2];
                for (n = 0; n < 8; ++n) {
                    int n3 = n + this.objMesh.obbStart;
                    f4 = this.objMesh.zOrg[n3];
                    f3 = this.objMesh.xOrg[n3];
                    float f22 = this.objMesh.yOrg[n3];
                    fArray3[n] = f3 * f15 + f22 * f16 + f4 * f19 + f10;
                    fArray4[n] = f3 * f20 + f22 * f17 + f4 * f18 + f9;
                    fArray5[n] = f3 * f11 + f22 * f12 + f4 * f21 + f8;
                }
                nArray = new int[Config.maxPortals];
                nArray = this.myWorld.portals.detectAllCoveredSectors(nArray, fArray3, fArray4, fArray5);
                n2 = nArray[0];
            }
        } else {
            fArray2[0] = fArray[0];
            fArray2[1] = fArray[1];
            fArray2[2] = fArray[2];
            f7 = fArray2[0];
            f6 = fArray2[1];
            f5 = fArray2[2];
        }
        int n4 = 0;
        Object[] objectArray = null;
        if (this.ocTree != null && !Config.doPortalHsr && this.ocTree.getCollisionUse() && (n4 = ((Integer)(objectArray = this.ocTree.getColliderLeafs(fArray2[0], fArray2[1], fArray2[2], f * this.ocTree.getRadiusMultiplier()))[0]).intValue()) == 0) {
            fArray2[0] = fArray[0];
            fArray2[1] = fArray[1];
            fArray2[2] = fArray[2];
            return fArray2;
        }
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = new int[Math.max(Config.maxPortals, 1)];
        int n7 = 0;
        if (this.myWorld != null && Config.doPortalHsr) {
            for (int i = 1; i <= this.myWorld.portals.anzSectors; ++i) {
                if (f2 != 1.0E12f && (!(fArray[0] >= this.myWorld.portals.bounding[i][0] - f2) || !(fArray[0] <= this.myWorld.portals.bounding[i][1] + f2) || !(fArray[1] >= this.myWorld.portals.bounding[i][2] - f2) || !(fArray[1] <= this.myWorld.portals.bounding[i][3] + f2) || !(fArray[2] >= this.myWorld.portals.bounding[i][4] - f2) || !(fArray[2] <= this.myWorld.portals.bounding[i][5] + f2))) continue;
                nArray2[n7] = i;
                ++n7;
            }
        }
        if (n7 == 0) {
            n7 = 1;
            nArray2[0] = 0;
        }
        for (int i = 0; i < n7; ++i) {
            block28: {
                block30: {
                    block29: {
                        block27: {
                            n5 = 0;
                            n6 = 0;
                            if (!this.isMainWorld && this.oneSectorOnly) break block27;
                            n5 = this.sectorStartPoly[nArray2[i]];
                            n6 = this.sectorEndPoly[nArray2[i]] + 1;
                            if (n5 + 1 != n6) break block28;
                            n6 = 0;
                            n5 = 0;
                            break block28;
                        }
                        if ((this.dynSectorDetect || nArray2[i] != this.singleSectorNumber) && this.singleSectorNumber != 0) break block29;
                        n5 = 0;
                        n6 = this.objMesh.anzTri;
                        i = n7;
                        break block28;
                    }
                    if (!this.dynSectorDetect) break block28;
                    if (n2 != true) break block30;
                    if (nArray[1] != nArray2[i]) break block28;
                    n5 = 0;
                    n6 = this.objMesh.anzTri;
                    i = n7;
                    break block28;
                }
                for (int j = 1; j <= n2; ++j) {
                    if (nArray[j] != nArray2[i]) continue;
                    n5 = 0;
                    n6 = this.objMesh.anzTri;
                    i = n7;
                    break;
                }
            }
            double d = 0.0;
            boolean bl3 = false;
            OcTreeNode[] ocTreeNodeArray = null;
            int[] nArray3 = null;
            int n8 = 0;
            if (this.ocTree != null && !Config.doPortalHsr && this.ocTree.getCollisionUse()) {
                ocTreeNodeArray = (OcTreeNode[])objectArray[1];
                bl3 = true;
            }
            do {
                if (bl3) {
                    nArray3 = ocTreeNodeArray[n8].getPolygons();
                    n5 = 0;
                    n6 = ocTreeNodeArray[n8].getPolyCount();
                    ++n8;
                }
                for (int j = n5; j < n6; ++j) {
                    int n9;
                    float f23;
                    float f24;
                    float f25;
                    int n10;
                    int n11;
                    double d2;
                    double d3;
                    int n12 = j;
                    if (bl3) {
                        n12 = nArray3[j];
                    }
                    n = this.objMesh.coords[this.objMesh.points[n12][0]];
                    float f26 = this.objMesh.xOrg[n];
                    f4 = this.objMesh.yOrg[n];
                    f3 = this.objMesh.zOrg[n];
                    boolean bl4 = false;
                    if (f2 != 1.0E12f && (!(Math.abs(f26 - f7) <= f14) || !(Math.abs(f4 - f6) <= f14) || !(Math.abs(f3 - f5) <= f14))) continue;
                    int n13 = this.objMesh.coords[this.objMesh.points[n12][2]];
                    int n14 = this.objMesh.coords[this.objMesh.points[n12][1]];
                    double d4 = this.objMesh.xOrg[n14] - f26;
                    double d5 = this.objMesh.yOrg[n14] - f4;
                    double d6 = this.objMesh.zOrg[n14] - f3;
                    double d7 = this.objMesh.xOrg[n13] - f26;
                    double d8 = this.objMesh.yOrg[n13] - f4;
                    double d9 = this.objMesh.zOrg[n13] - f3;
                    double d10 = d5 * d9 - d6 * d8;
                    double d11 = d6 * d7 - d4 * d9;
                    double d12 = d4 * d8 - d5 * d7;
                    if (!(Math.abs(d3 = (d10 /= (d2 = Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12))) * (double)fArray2[0] + (d11 /= d2) * (double)fArray2[1] + (d12 /= d2) * (double)fArray2[2] - (d10 * (double)f26 + d11 * (double)f4 + d12 * (double)f3)) < (double)f)) continue;
                    double d13 = (double)fArray2[0] - d10 * d3;
                    double d14 = (double)fArray2[1] - d11 * d3;
                    double d15 = (double)fArray2[2] - d12 * d3;
                    double d16 = 0.0;
                    for (n11 = 0; n11 < 3; ++n11) {
                        double d17;
                        double d18;
                        double d19;
                        n10 = this.objMesh.coords[this.objMesh.points[n12][n11]];
                        f25 = this.objMesh.xOrg[n10];
                        f24 = this.objMesh.yOrg[n10];
                        f23 = this.objMesh.zOrg[n10];
                        dArray[0] = (double)f25 - d13;
                        dArray[1] = (double)f24 - d14;
                        dArray[2] = (double)f23 - d15;
                        n9 = (n11 + 1) % 3;
                        n10 = this.objMesh.coords[this.objMesh.points[n12][n9]];
                        f25 = this.objMesh.xOrg[n10];
                        f24 = this.objMesh.yOrg[n10];
                        f23 = this.objMesh.zOrg[n10];
                        dArray2[0] = (double)f25 - d13;
                        dArray2[1] = (double)f24 - d14;
                        dArray2[2] = (double)f23 - d15;
                        double d20 = Vectors.calcDot(dArray, dArray2);
                        double d21 = Math.acos(d20 / (d19 = (d18 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2])) * (d17 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]))));
                        if (Double.isNaN(d21)) {
                            d21 = 0.0;
                        }
                        if ((d16 += d21) >= 6.220353454107791) break;
                    }
                    if (d16 >= 6.220353454107791) {
                        bl4 = true;
                    } else {
                        for (n11 = 0; n11 < 3; ++n11) {
                            n10 = this.objMesh.coords[this.objMesh.points[n12][n11]];
                            f25 = this.objMesh.xOrg[n10];
                            f24 = this.objMesh.yOrg[n10];
                            f23 = this.objMesh.zOrg[n10];
                            dArray[0] = fArray2[0] - f25;
                            dArray[1] = fArray2[1] - f24;
                            dArray[2] = fArray2[2] - f23;
                            n9 = (n11 + 1) % 3;
                            n10 = this.objMesh.coords[this.objMesh.points[n12][n9]];
                            float f27 = this.objMesh.xOrg[n10];
                            float f28 = this.objMesh.yOrg[n10];
                            float f29 = this.objMesh.zOrg[n10];
                            dArray2[0] = f27 - f25;
                            dArray2[1] = f28 - f24;
                            dArray2[2] = f29 - f23;
                            d2 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
                            dArray2[0] = dArray2[0] / d2;
                            dArray2[1] = dArray2[1] / d2;
                            dArray2[2] = dArray2[2] / d2;
                            double d22 = Vectors.calcDot(dArray, dArray2);
                            if (d22 <= 0.0) {
                                d13 = f25;
                                d14 = f24;
                                d15 = f23;
                            } else {
                                d = Math.sqrt((f25 - f27) * (f25 - f27) + (f24 - f28) * (f24 - f28) + (f23 - f29) * (f23 - f29));
                                if (d22 >= d) {
                                    d13 = f27;
                                    d14 = f28;
                                    d15 = f29;
                                } else {
                                    dArray[0] = dArray2[0] * d22;
                                    dArray[1] = dArray2[1] * d22;
                                    dArray[2] = dArray2[2] * d22;
                                    d13 = (double)f25 + dArray[0];
                                    d14 = (double)f24 + dArray[1];
                                    d15 = (double)f23 + dArray[2];
                                }
                            }
                            d = Math.sqrt((d13 - (double)fArray2[0]) * (d13 - (double)fArray2[0]) + (d14 - (double)fArray2[1]) * (d14 - (double)fArray2[1]) + (d15 - (double)fArray2[2]) * (d15 - (double)fArray2[2]));
                            float f30 = f;
                            if (bl) {
                                f30 *= Config.collideEdgeMul;
                            }
                            if (!(d < (double)f30)) continue;
                            bl4 = true;
                            break;
                        }
                    }
                    if (!bl4) continue;
                    this.addPolygonID(n12);
                    double d23 = (double)f - d3;
                    bl2 = true;
                    fArray2[0] = (float)((double)fArray2[0] + d10 * d23);
                    fArray2[1] = (float)((double)fArray2[1] + d11 * d23);
                    fArray2[2] = (float)((double)fArray2[2] + d12 * d23);
                }
            } while (bl3 && n8 < n4);
        }
        if (!this.isMainWorld) {
            float f31 = matrix.mat[0][0];
            f12 = matrix.mat[1][0];
            f11 = matrix.mat[1][1];
            f10 = matrix.mat[2][1];
            f9 = matrix.mat[2][0];
            f8 = matrix.mat[0][1];
            float f32 = matrix.mat[2][2];
            float f33 = matrix.mat[1][2];
            float f34 = matrix.mat[0][2];
            float f35 = matrix.mat[3][0];
            float f36 = matrix.mat[3][1];
            f4 = matrix.mat[3][2];
            f7 = fArray2[0] * f31 + fArray2[1] * f12 + fArray2[2] * f9 + f35;
            f6 = fArray2[0] * f8 + fArray2[1] * f11 + fArray2[2] * f10 + f36;
            f5 = fArray2[0] * f34 + fArray2[1] * f33 + fArray2[2] * f32 + f4;
            fArray2[0] = f7;
            fArray2[1] = f6;
            fArray2[2] = f5;
        }
        blArray[0] = blArray[0] | bl2;
        return fArray2;
    }

    final void collideEllipsoid(CollisionInfo collisionInfo, float f) {
        int n;
        int n2;
        Object[] objectArray;
        boolean bl;
        Serializable serializable;
        Matrix matrix = null;
        if (collisionInfo.addTransMat != null) {
            matrix = collisionInfo.addTransMat.cloneMatrix();
        }
        Object[] objectArray2 = null;
        Matrix matrix2 = null;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        int[] nArray = null;
        int n3 = 0;
        Matrix matrix3 = null;
        if (matrix != null) {
            bl2 = true;
            objectArray2 = matrix.invert();
            serializable = this.getWorldTransformation();
            ((Matrix)serializable).matMul((Matrix)objectArray2);
            matrix2 = collisionInfo.addRotMat.invert3x3();
            f2 = ((Matrix)serializable).mat[0][0];
            f3 = ((Matrix)serializable).mat[1][0];
            f4 = ((Matrix)serializable).mat[1][1];
            f5 = ((Matrix)serializable).mat[2][1];
            f6 = ((Matrix)serializable).mat[2][0];
            f7 = ((Matrix)serializable).mat[0][1];
            f8 = ((Matrix)serializable).mat[2][2];
            f9 = ((Matrix)serializable).mat[1][2];
            f10 = ((Matrix)serializable).mat[0][2];
            f11 = ((Matrix)serializable).mat[3][0];
            f12 = ((Matrix)serializable).mat[3][1];
            f13 = ((Matrix)serializable).mat[3][2];
        }
        serializable = new SimpleVector(collisionInfo.r3Pos);
        SimpleVector simpleVector = new SimpleVector((SimpleVector)serializable);
        SimpleVector simpleVector2 = new SimpleVector(collisionInfo.r3Velocity);
        SimpleVector simpleVector3 = new SimpleVector();
        SimpleVector simpleVector4 = new SimpleVector();
        SimpleVector simpleVector5 = null;
        SimpleVector simpleVector6 = null;
        SimpleVector simpleVector7 = null;
        boolean bl3 = bl = this.ocTree != null && !Config.doPortalHsr && this.ocTree.getCollisionUse();
        if (!this.isMainWorld || bl2) {
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            float f19;
            float f20;
            float f21;
            float f22;
            float f23;
            float f24;
            float f25;
            float f26;
            float f27;
            float f28;
            Object var31_31 = null;
            objectArray = null;
            if (!bl2 || bl) {
                matrix3 = this.getWorldTransformation();
                objectArray = this.getInverseWorldTransformation();
                f28 = objectArray.mat[0][0];
                f27 = objectArray.mat[1][0];
                f26 = objectArray.mat[1][1];
                f25 = objectArray.mat[2][1];
                f24 = objectArray.mat[2][0];
                f23 = objectArray.mat[0][1];
                f22 = objectArray.mat[2][2];
                f21 = objectArray.mat[1][2];
                f20 = objectArray.mat[0][2];
                f19 = objectArray.mat[3][0];
                f18 = objectArray.mat[3][1];
                f17 = objectArray.mat[3][2];
                simpleVector.x = ((SimpleVector)serializable).x * f28 + ((SimpleVector)serializable).y * f27 + ((SimpleVector)serializable).z * f24 + f19;
                simpleVector.y = ((SimpleVector)serializable).x * f23 + ((SimpleVector)serializable).y * f26 + ((SimpleVector)serializable).z * f25 + f18;
                simpleVector.z = ((SimpleVector)serializable).x * f20 + ((SimpleVector)serializable).y * f21 + ((SimpleVector)serializable).z * f22 + f17;
                f16 = simpleVector2.x * f28 + simpleVector2.y * f27 + simpleVector2.z * f24;
                f15 = simpleVector2.x * f23 + simpleVector2.y * f26 + simpleVector2.z * f25;
                f14 = simpleVector2.x * f20 + simpleVector2.y * f21 + simpleVector2.z * f22;
                simpleVector2.x = f16;
                simpleVector2.y = f15;
                simpleVector2.z = f14;
                if (bl2) {
                    simpleVector6 = new SimpleVector(simpleVector);
                    simpleVector7 = new SimpleVector(simpleVector2);
                } else {
                    simpleVector6 = simpleVector;
                    simpleVector7 = simpleVector2;
                }
            }
            if (bl2) {
                objectArray = objectArray2;
                simpleVector2 = new SimpleVector(collisionInfo.r3Velocity);
                f28 = objectArray.mat[0][0];
                f27 = objectArray.mat[1][0];
                f26 = objectArray.mat[1][1];
                f25 = objectArray.mat[2][1];
                f24 = objectArray.mat[2][0];
                f23 = objectArray.mat[0][1];
                f22 = objectArray.mat[2][2];
                f21 = objectArray.mat[1][2];
                f20 = objectArray.mat[0][2];
                f19 = objectArray.mat[3][0];
                f18 = objectArray.mat[3][1];
                f17 = objectArray.mat[3][2];
                simpleVector.x = ((SimpleVector)serializable).x * f28 + ((SimpleVector)serializable).y * f27 + ((SimpleVector)serializable).z * f24 + f19;
                simpleVector.y = ((SimpleVector)serializable).x * f23 + ((SimpleVector)serializable).y * f26 + ((SimpleVector)serializable).z * f25 + f18;
                simpleVector.z = ((SimpleVector)serializable).x * f20 + ((SimpleVector)serializable).y * f21 + ((SimpleVector)serializable).z * f22 + f17;
                simpleVector2.matMul(matrix2);
            }
            if (!this.isMainWorld && Config.doPortalHsr && this.dynSectorDetect && !this.hasPortals && this.objMesh.obbEnd - this.objMesh.obbStart == 7) {
                float[] fArray = new float[8];
                float[] fArray2 = new float[8];
                float[] fArray3 = new float[8];
                f25 = matrix3.mat[0][0];
                f24 = matrix3.mat[1][0];
                f23 = matrix3.mat[1][1];
                f22 = matrix3.mat[2][1];
                f21 = matrix3.mat[2][0];
                f20 = matrix3.mat[0][1];
                f19 = matrix3.mat[2][2];
                f18 = matrix3.mat[1][2];
                f17 = matrix3.mat[0][2];
                f16 = matrix3.mat[3][0];
                f15 = matrix3.mat[3][1];
                f14 = matrix3.mat[3][2];
                for (n2 = 0; n2 < 8; ++n2) {
                    n = n2 + this.objMesh.obbStart;
                    float f29 = this.objMesh.zOrg[n];
                    float f30 = this.objMesh.xOrg[n];
                    float f31 = this.objMesh.yOrg[n];
                    fArray[n2] = f30 * f25 + f31 * f24 + f29 * f21 + f16;
                    fArray2[n2] = f30 * f20 + f31 * f23 + f29 * f22 + f15;
                    fArray3[n2] = f30 * f17 + f31 * f18 + f29 * f19 + f14;
                }
                nArray = new int[Config.maxPortals];
                nArray = this.myWorld.portals.detectAllCoveredSectors(nArray, fArray, fArray2, fArray3);
                n3 = nArray[0];
            }
        } else {
            simpleVector.x = ((SimpleVector)serializable).x;
            simpleVector.y = ((SimpleVector)serializable).y;
            simpleVector.z = ((SimpleVector)serializable).z;
            simpleVector6 = simpleVector;
            simpleVector7 = simpleVector2;
        }
        int n4 = 0;
        objectArray = null;
        if (bl) {
            float f32 = (float)Math.sqrt(simpleVector7.x * simpleVector7.x + simpleVector7.y * simpleVector7.y + simpleVector7.z * simpleVector7.z);
            objectArray = this.ocTree.getColliderLeafs(simpleVector6.x, simpleVector6.y, simpleVector6.z, (collisionInfo.getMaxRadius() + f32) * this.ocTree.getRadiusMultiplier());
            n4 = (Integer)objectArray[0];
            if (n4 == 0) {
                return;
            }
        }
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = new int[Math.max(Config.maxPortals, 1)];
        int n7 = 0;
        if (this.myWorld != null && Config.doPortalHsr) {
            for (int i = 1; i <= this.myWorld.portals.anzSectors; ++i) {
                if (f != 1.0E12f && (!(((SimpleVector)serializable).x >= this.myWorld.portals.bounding[i][0] - f) || !(((SimpleVector)serializable).x <= this.myWorld.portals.bounding[i][1] + f) || !(((SimpleVector)serializable).y >= this.myWorld.portals.bounding[i][2] - f) || !(((SimpleVector)serializable).y <= this.myWorld.portals.bounding[i][3] + f) || !(((SimpleVector)serializable).z >= this.myWorld.portals.bounding[i][4] - f) || !(((SimpleVector)serializable).z <= this.myWorld.portals.bounding[i][5] + f))) continue;
                nArray2[n7] = i;
                ++n7;
            }
        }
        if (n7 == 0) {
            n7 = 1;
            nArray2[0] = 0;
        }
        for (int i = 0; i < n7; ++i) {
            block50: {
                block52: {
                    block51: {
                        block49: {
                            n5 = 0;
                            n6 = 0;
                            if (!this.isMainWorld && this.oneSectorOnly) break block49;
                            n5 = this.sectorStartPoly[nArray2[i]];
                            n6 = this.sectorEndPoly[nArray2[i]] + 1;
                            if (n5 + 1 != n6) break block50;
                            n6 = 0;
                            n5 = 0;
                            break block50;
                        }
                        if ((this.dynSectorDetect || nArray2[i] != this.singleSectorNumber) && this.singleSectorNumber != 0) break block51;
                        n5 = 0;
                        n6 = this.objMesh.anzTri;
                        i = n7;
                        break block50;
                    }
                    if (!this.dynSectorDetect) break block50;
                    if (n3 != true) break block52;
                    if (nArray[1] != nArray2[i]) break block50;
                    n5 = 0;
                    n6 = this.objMesh.anzTri;
                    i = n7;
                    break block50;
                }
                for (int j = 1; j <= n3; ++j) {
                    if (nArray[j] != nArray2[i]) continue;
                    n5 = 0;
                    n6 = this.objMesh.anzTri;
                    i = n7;
                    break;
                }
            }
            OcTreeNode[] ocTreeNodeArray = null;
            int[] nArray3 = null;
            int n8 = 0;
            if (bl) {
                ocTreeNodeArray = (OcTreeNode[])objectArray[1];
            }
            simpleVector4.x = simpleVector.x * collisionInfo.invERadius.x;
            simpleVector4.y = simpleVector.y * collisionInfo.invERadius.y;
            simpleVector4.z = simpleVector.z * collisionInfo.invERadius.z;
            simpleVector3.x = simpleVector2.x * collisionInfo.invERadius.x;
            simpleVector3.y = simpleVector2.y * collisionInfo.invERadius.y;
            simpleVector3.z = simpleVector2.z * collisionInfo.invERadius.z;
            simpleVector5 = simpleVector3.normalize();
            SimpleVector simpleVector8 = new SimpleVector();
            SimpleVector simpleVector9 = new SimpleVector();
            SimpleVector simpleVector10 = new SimpleVector();
            SimpleVector simpleVector11 = new SimpleVector();
            Plane plane = new Plane();
            float[] fArray = new float[1];
            do {
                if (bl) {
                    nArray3 = ocTreeNodeArray[n8].getPolygons();
                    n5 = 0;
                    n6 = ocTreeNodeArray[n8].getPolyCount();
                    ++n8;
                }
                for (int j = n5; j < n6; ++j) {
                    SimpleVector simpleVector12;
                    float f33;
                    float f34;
                    float f35;
                    n2 = j;
                    if (bl) {
                        n2 = nArray3[j];
                    }
                    n = this.objMesh.coords[this.objMesh.points[n2][0]];
                    int n9 = this.objMesh.coords[this.objMesh.points[n2][1]];
                    int n10 = this.objMesh.coords[this.objMesh.points[n2][2]];
                    if (bl2) {
                        float f36 = this.objMesh.xOrg[n];
                        f35 = this.objMesh.yOrg[n];
                        f34 = this.objMesh.zOrg[n];
                        float f37 = f36 * f2 + f35 * f3 + f34 * f6 + f11;
                        f33 = f36 * f7 + f35 * f4 + f34 * f5 + f12;
                        float f38 = f36 * f10 + f35 * f9 + f34 * f8 + f13;
                        simpleVector8.x = f37 * collisionInfo.invERadius.x;
                        simpleVector8.y = f33 * collisionInfo.invERadius.y;
                        simpleVector8.z = f38 * collisionInfo.invERadius.z;
                        f36 = this.objMesh.xOrg[n9];
                        f35 = this.objMesh.yOrg[n9];
                        f34 = this.objMesh.zOrg[n9];
                        f37 = f36 * f2 + f35 * f3 + f34 * f6 + f11;
                        f33 = f36 * f7 + f35 * f4 + f34 * f5 + f12;
                        f38 = f36 * f10 + f35 * f9 + f34 * f8 + f13;
                        simpleVector9.x = f37 * collisionInfo.invERadius.x;
                        simpleVector9.y = f33 * collisionInfo.invERadius.y;
                        simpleVector9.z = f38 * collisionInfo.invERadius.z;
                        f36 = this.objMesh.xOrg[n10];
                        f35 = this.objMesh.yOrg[n10];
                        f34 = this.objMesh.zOrg[n10];
                        f37 = f36 * f2 + f35 * f3 + f34 * f6 + f11;
                        f33 = f36 * f7 + f35 * f4 + f34 * f5 + f12;
                        f38 = f36 * f10 + f35 * f9 + f34 * f8 + f13;
                        simpleVector10.x = f37 * collisionInfo.invERadius.x;
                        simpleVector10.y = f33 * collisionInfo.invERadius.y;
                        simpleVector10.z = f38 * collisionInfo.invERadius.z;
                    } else {
                        simpleVector8.x = this.objMesh.xOrg[n] * collisionInfo.invERadius.x;
                        simpleVector8.y = this.objMesh.yOrg[n] * collisionInfo.invERadius.y;
                        simpleVector8.z = this.objMesh.zOrg[n] * collisionInfo.invERadius.z;
                        simpleVector9.x = this.objMesh.xOrg[n9] * collisionInfo.invERadius.x;
                        simpleVector9.y = this.objMesh.yOrg[n9] * collisionInfo.invERadius.y;
                        simpleVector9.z = this.objMesh.zOrg[n9] * collisionInfo.invERadius.z;
                        simpleVector10.x = this.objMesh.xOrg[n10] * collisionInfo.invERadius.x;
                        simpleVector10.y = this.objMesh.yOrg[n10] * collisionInfo.invERadius.y;
                        simpleVector10.z = this.objMesh.zOrg[n10] * collisionInfo.invERadius.z;
                    }
                    plane.setTo(simpleVector8, simpleVector9, simpleVector10);
                    boolean bl4 = true;
                    if (!plane.isFrontFacingTo(simpleVector5)) continue;
                    f35 = 0.0f;
                    f34 = 0.0f;
                    boolean bl5 = false;
                    f33 = plane.distanceTo(simpleVector4);
                    SimpleVector simpleVector13 = plane.normal;
                    float f39 = simpleVector13.x * simpleVector3.x + simpleVector13.y * simpleVector3.y + simpleVector13.z * simpleVector3.z;
                    if (f39 == 0.0f) {
                        if (Math.abs(f33) >= 1.0f) {
                            bl4 = false;
                        } else {
                            bl5 = true;
                            f35 = 0.0f;
                            f34 = 1.0f;
                        }
                    } else {
                        f35 = (-1.0f - f33) / f39;
                        f34 = (1.0f - f33) / f39;
                        if (f35 > f34) {
                            float f40 = f35;
                            f35 = f34;
                            f34 = f40;
                        }
                        if (f35 > 1.0f || f34 < 0.0f) {
                            bl4 = false;
                        }
                        if (f35 < -1.0f) {
                            f35 = 0.0f;
                        }
                        if (f34 < 0.0f) {
                            f34 = 0.0f;
                        }
                        if (f35 > 1.0f) {
                            f35 = 1.0f;
                        }
                        if (f34 > 1.0f) {
                            f34 = 1.0f;
                        }
                    }
                    if (!bl4) continue;
                    SimpleVector simpleVector14 = null;
                    boolean bl6 = false;
                    float f41 = 1.0f;
                    if (!bl5) {
                        simpleVector12 = new SimpleVector(simpleVector3);
                        simpleVector12.scalarMul(f35);
                        SimpleVector simpleVector15 = simpleVector4.calcSub(plane.normal);
                        simpleVector15.add(simpleVector12);
                        SimpleVector simpleVector16 = simpleVector15.calcSub(simpleVector4);
                        if (this.checkPointInTriangle(simpleVector16, simpleVector4, simpleVector8, simpleVector9, simpleVector10)) {
                            bl6 = true;
                            f41 = f35;
                            simpleVector14 = simpleVector15;
                        }
                    }
                    if (!bl6) {
                        int n11;
                        simpleVector12 = simpleVector4;
                        float f42 = simpleVector3.x * simpleVector3.x + simpleVector3.y * simpleVector3.y + simpleVector3.z * simpleVector3.z;
                        float f43 = 0.0f;
                        float f44 = 0.0f;
                        float f45 = 0.0f;
                        float f46 = 0.0f;
                        float f47 = 0.0f;
                        float f48 = 0.0f;
                        SimpleVector simpleVector17 = null;
                        for (n11 = 0; n11 < 3; ++n11) {
                            switch (n11) {
                                case 0: {
                                    f46 = simpleVector8.x;
                                    f47 = simpleVector8.y;
                                    f48 = simpleVector8.z;
                                    simpleVector17 = simpleVector8;
                                    break;
                                }
                                case 1: {
                                    f46 = simpleVector9.x;
                                    f47 = simpleVector9.y;
                                    f48 = simpleVector9.z;
                                    simpleVector17 = simpleVector9;
                                    break;
                                }
                                case 2: {
                                    f46 = simpleVector10.x;
                                    f47 = simpleVector10.y;
                                    f48 = simpleVector10.z;
                                    simpleVector17 = simpleVector10;
                                }
                            }
                            simpleVector11.x = simpleVector12.x - f46;
                            simpleVector11.y = simpleVector12.y - f47;
                            simpleVector11.z = simpleVector12.z - f48;
                            f43 = f42;
                            f44 = 2.0f * (simpleVector3.x * simpleVector11.x + simpleVector3.y * simpleVector11.y + simpleVector3.z * simpleVector11.z);
                            simpleVector11.x = f46 - simpleVector12.x;
                            simpleVector11.y = f47 - simpleVector12.y;
                            simpleVector11.z = f48 - simpleVector12.z;
                            f45 = simpleVector11.x * simpleVector11.x + simpleVector11.y * simpleVector11.y + simpleVector11.z * simpleVector11.z - 1.0f;
                            if (!this.getLowestRoot(f43, f44, f45, f41, fArray)) continue;
                            f41 = fArray[0];
                            bl6 = true;
                            simpleVector14 = new SimpleVector(simpleVector17);
                        }
                        for (n11 = 0; n11 < 3; ++n11) {
                            float f49;
                            switch (n11) {
                                case 0: {
                                    simpleVector11.x = simpleVector9.x - simpleVector8.x;
                                    simpleVector11.y = simpleVector9.y - simpleVector8.y;
                                    simpleVector11.z = simpleVector9.z - simpleVector8.z;
                                    simpleVector17 = simpleVector8;
                                    break;
                                }
                                case 1: {
                                    simpleVector11.x = simpleVector10.x - simpleVector9.x;
                                    simpleVector11.y = simpleVector10.y - simpleVector9.y;
                                    simpleVector11.z = simpleVector10.z - simpleVector9.z;
                                    simpleVector17 = simpleVector9;
                                    break;
                                }
                                case 2: {
                                    simpleVector11.x = simpleVector8.x - simpleVector10.x;
                                    simpleVector11.y = simpleVector8.y - simpleVector10.y;
                                    simpleVector11.z = simpleVector8.z - simpleVector10.z;
                                    simpleVector17 = simpleVector10;
                                }
                            }
                            SimpleVector simpleVector18 = simpleVector11;
                            SimpleVector simpleVector19 = simpleVector17.calcSub(simpleVector12);
                            float f50 = simpleVector18.x * simpleVector18.x + simpleVector18.y * simpleVector18.y + simpleVector18.z * simpleVector18.z;
                            float f51 = simpleVector18.x * simpleVector3.x + simpleVector18.y * simpleVector3.y + simpleVector18.z * simpleVector3.z;
                            float f52 = simpleVector18.x * simpleVector19.x + simpleVector18.y * simpleVector19.y + simpleVector18.z * simpleVector19.z;
                            f43 = f50 * -f42 + f51 * f51;
                            f44 = f50 * (2.0f * (simpleVector3.x * simpleVector19.x + simpleVector3.y * simpleVector19.y + simpleVector3.z * simpleVector19.z)) - 2.0f * f51 * f52;
                            f45 = f50 * (1.0f - (simpleVector19.x * simpleVector19.x + simpleVector19.y * simpleVector19.y + simpleVector19.z * simpleVector19.z)) + f52 * f52;
                            if (!this.getLowestRoot(f43, f44, f45, f41, fArray) || !((f49 = (f51 * fArray[0] - f52) / f50) >= 0.0f) || !(f49 <= 1.0f)) continue;
                            f41 = fArray[0];
                            bl6 = true;
                            simpleVector14 = new SimpleVector(simpleVector18);
                            simpleVector14.scalarMul(f49);
                            simpleVector14.add(simpleVector17);
                        }
                    }
                    if (!bl6) continue;
                    this.addPolygonID(n2);
                    float f53 = f41;
                    if (collisionInfo.foundCollision && !(f53 <= collisionInfo.nearestDistance)) continue;
                    collisionInfo.nearestDistance = f53;
                    collisionInfo.intersectionPoint = simpleVector14;
                    collisionInfo.foundCollision = true;
                    collisionInfo.collision = true;
                    collisionInfo.eSpaceBasePoint = simpleVector4;
                    collisionInfo.eSpaceVelocity = simpleVector3;
                    collisionInfo.collisionObject = this;
                    collisionInfo.isPartOfCollision = true;
                }
            } while (bl && n8 < n4);
        }
    }

    private final boolean checkPointInTriangle(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, SimpleVector simpleVector4, SimpleVector simpleVector5) {
        if (this.pvecPoint == null) {
            this.pvecPoint = new float[3];
        }
        float[] fArray = this.pvecPoint;
        float f = simpleVector3.x;
        float f2 = simpleVector3.y;
        float f3 = simpleVector3.z;
        float f4 = simpleVector4.x - f;
        float f5 = simpleVector4.y - f2;
        float f6 = simpleVector4.z - f3;
        float f7 = simpleVector5.x - f;
        float f8 = simpleVector5.y - f2;
        float f9 = simpleVector5.z - f3;
        Vectors.calcCross(fArray, simpleVector.x, simpleVector.y, simpleVector.z, f7, f8, f9);
        float f10 = Vectors.calcDot(f4, f5, f6, fArray);
        if (f10 >= 1.0E-17f) {
            float f11 = 1.0f / f10;
            f7 = simpleVector2.x - f;
            f8 = simpleVector2.y - f2;
            f9 = simpleVector2.z - f3;
            float f12 = Vectors.calcDot(f7, f8, f9, fArray) * f11;
            if ((double)f12 >= 0.0 && f12 <= 1.0f) {
                Vectors.calcCross(fArray, f7, f8, f9, f4, f5, f6);
                float f13 = Vectors.calcDot(simpleVector.x, simpleVector.y, simpleVector.z, fArray) * f11;
                if ((double)f13 >= 0.0 && (double)(f12 + f13) <= 1.0) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean getLowestRoot(float f, float f2, float f3, float f4, float[] fArray) {
        float f5;
        float f6 = f2 * f2 - 4.0f * f * f3;
        if (f6 < 0.0f) {
            return false;
        }
        float f7 = (float)Math.sqrt(f6);
        float f8 = (-f2 - f7) / (2.0f * f);
        if (f8 > (f5 = (-f2 + f7) / (2.0f * f))) {
            float f9 = f5;
            f5 = f8;
            f8 = f9;
        }
        if (f8 > 0.0f && f8 < f4) {
            fArray[0] = f8;
            return true;
        }
        if (f5 > 0.0f && f5 < f4) {
            fArray[0] = f5;
            return true;
        }
        return false;
    }

    final SimpleVector reverseTransform(SimpleVector simpleVector, boolean bl) {
        Matrix matrix = this.getWorldTransformation();
        if (!this.isMainWorld) {
            float f = matrix.mat[0][0];
            float f2 = matrix.mat[1][0];
            float f3 = matrix.mat[1][1];
            float f4 = matrix.mat[2][1];
            float f5 = matrix.mat[2][0];
            float f6 = matrix.mat[0][1];
            float f7 = matrix.mat[2][2];
            float f8 = matrix.mat[1][2];
            float f9 = matrix.mat[0][2];
            float f10 = matrix.mat[3][0];
            float f11 = matrix.mat[3][1];
            float f12 = matrix.mat[3][2];
            float f13 = simpleVector.x * f + simpleVector.y * f2 + simpleVector.z * f5;
            float f14 = simpleVector.x * f6 + simpleVector.y * f3 + simpleVector.z * f4;
            float f15 = simpleVector.x * f9 + simpleVector.y * f8 + simpleVector.z * f7;
            if (bl) {
                f13 += f10;
                f14 += f11;
                f15 += f12;
            }
            return new SimpleVector(f13, f14, f15);
        }
        return new SimpleVector(simpleVector);
    }

    public int addTriangle(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, 0.0f, 0.0f, simpleVector2.x, simpleVector2.y, simpleVector2.z, 0.0f, 0.0f, simpleVector3.x, simpleVector3.y, simpleVector3.z, 0.0f, 0.0f, -1, 0, false);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return this.addTriangle(f, f2, f3, 0.0f, 0.0f, f4, f5, f6, 0.0f, 0.0f, f7, f8, f9, 0.0f, 0.0f, -1, 0, false);
    }

    public int addTriangle(SimpleVector simpleVector, float f, float f2, SimpleVector simpleVector2, float f3, float f4, SimpleVector simpleVector3, float f5, float f6) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, f, f2, simpleVector2.x, simpleVector2.y, simpleVector2.z, f3, f4, simpleVector3.x, simpleVector3.y, simpleVector3.z, f5, f6, -1, 0, false);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        return this.addTriangle(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, -1, 0, false);
    }

    public int addTriangle(SimpleVector simpleVector, float f, float f2, SimpleVector simpleVector2, float f3, float f4, SimpleVector simpleVector3, float f5, float f6, int n) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, f, f2, simpleVector2.x, simpleVector2.y, simpleVector2.z, f3, f4, simpleVector3.x, simpleVector3.y, simpleVector3.z, f5, f6, n, 0, false);
    }

    public int addTriangle(SimpleVector simpleVector, float f, float f2, SimpleVector simpleVector2, float f3, float f4, SimpleVector simpleVector3, float f5, float f6, int n, SimpleVector simpleVector4) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, f, f2, simpleVector2.x, simpleVector2.y, simpleVector2.z, f3, f4, simpleVector3.x, simpleVector3.y, simpleVector3.z, f5, f6, n, 0, false, null, null, simpleVector4.x, simpleVector4.y, simpleVector4.z);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n) {
        return this.addTriangle(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, n, 0, false);
    }

    public int addTriangle(SimpleVector simpleVector, float f, float f2, SimpleVector simpleVector2, float f3, float f4, SimpleVector simpleVector3, float f5, float f6, int n, int n2) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, f, f2, simpleVector2.x, simpleVector2.y, simpleVector2.z, f3, f4, simpleVector3.x, simpleVector3.y, simpleVector3.z, f5, f6, n, n2, true);
    }

    public int addTriangle(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, TextureInfo textureInfo, SimpleVector simpleVector4) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, 0.0f, 0.0f, simpleVector2.x, simpleVector2.y, simpleVector2.z, 0.0f, 0.0f, simpleVector3.x, simpleVector3.y, simpleVector3.z, 0.0f, 0.0f, 0, 0, false, null, textureInfo, simpleVector4.x, simpleVector4.y, simpleVector4.z);
    }

    public int addTriangle(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, TextureInfo textureInfo) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, 0.0f, 0.0f, simpleVector2.x, simpleVector2.y, simpleVector2.z, 0.0f, 0.0f, simpleVector3.x, simpleVector3.y, simpleVector3.z, 0.0f, 0.0f, 0, 0, false, null, textureInfo);
    }

    public int addTriangle(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3, TextureInfo textureInfo, int n) {
        return this.addTriangle(simpleVector.x, simpleVector.y, simpleVector.z, 0.0f, 0.0f, simpleVector2.x, simpleVector2.y, simpleVector2.z, 0.0f, 0.0f, simpleVector3.x, simpleVector3.y, simpleVector3.z, 0.0f, 0.0f, 0, n, true, null, textureInfo);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, int n2, boolean bl) {
        return this.addTriangle(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, n, n2, bl, null);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, int n2, boolean bl, int[] nArray) {
        return this.addTriangle(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, n, n2, bl, nArray, null);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, int n2, boolean bl, int[] nArray, TextureInfo textureInfo) {
        return this.addTriangle(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, n, n2, bl, nArray, textureInfo, -1.0f, -1.0f, -1.0f);
    }

    final int addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, int n2, boolean bl, int[] nArray, TextureInfo textureInfo, float f16, float f17, float f18) {
        try {
            int n3;
            if (f16 != -1.0f) {
                this.objVectors.createAlpha();
            }
            if (textureInfo != null) {
                if (this.multiTex == null && textureInfo.stageCnt > 1) {
                    this.multiTex = new int[Config.maxTextureLayers - 1][this.texture.length];
                    this.multiMode = new int[Config.maxTextureLayers - 1][this.texture.length];
                    for (n3 = 0; n3 < this.texture.length; ++n3) {
                        for (int i = 0; i < Config.maxTextureLayers - 1; ++i) {
                            this.multiTex[i][n3] = -1;
                        }
                    }
                    this.objVectors.createMultiCoords();
                    this.usesMultiTexturing = true;
                }
                f4 = textureInfo.u0[0];
                f5 = textureInfo.v0[0];
                f9 = textureInfo.u1[0];
                f10 = textureInfo.v1[0];
                f14 = textureInfo.u2[0];
                f15 = textureInfo.v2[0];
                n = textureInfo.textures[0];
                if (this.maxStagesUsed < textureInfo.stageCnt) {
                    this.maxStagesUsed = textureInfo.stageCnt;
                }
            }
            n3 = this.usesMultiTexturing && textureInfo != null ? 1 : 0;
            TextureManager textureManager = TextureManager.getInstance();
            if (bl && this.sector == null) {
                this.sector = new int[this.texture.length];
            }
            float f19 = 2.0f;
            float f20 = 2.0f;
            if (n != -1) {
                f19 = textureManager.textures[n].width;
                f20 = textureManager.textures[n].height;
            } else {
                n = 0;
            }
            float f21 = f4;
            float f22 = f5;
            float f23 = f9;
            float f24 = f10;
            float f25 = f14;
            float f26 = f15;
            f4 *= f19;
            f5 *= f20;
            f9 *= f19;
            f10 *= f20;
            f14 *= f19;
            f15 *= f20;
            if (this.objMesh.anzVectors + 3 < this.objMesh.maxVectors) {
                int n4;
                int n5 = this.objMesh.anzVectors;
                int n6 = this.objMesh.anzTri;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                n7 = -1;
                if (!this.neverOptimize) {
                    n7 = this.objVectors.checkCoords(f, f2, f3, n2);
                } else if (nArray != null) {
                    n7 = nArray[0];
                }
                if (n7 == -1) {
                    n7 = this.objVectors.addVertex(f, f2, f3, n2);
                }
                n9 = n7;
                this.objMesh.coords[n5] = n7;
                this.objVectors.uOrg[n5] = f4;
                this.objVectors.vOrg[n5] = f5;
                if (n3 != 0) {
                    for (n4 = 0; n4 < textureInfo.stageCnt - 1; ++n4) {
                        this.objVectors.uMul[n4][n5] = textureInfo.u0[n4 + 1];
                        this.objVectors.vMul[n4][n5] = textureInfo.v0[n4 + 1];
                    }
                }
                this.objVectors.buOrg[n5] = f4;
                this.objVectors.bvOrg[n5] = f5;
                this.objVectors.nuOrg[n5] = f21;
                this.objVectors.nvOrg[n5] = f22;
                if (f16 != -1.0f) {
                    this.objVectors.alpha[n5] = f16;
                }
                ++this.objMesh.anzVectors;
                this.objMesh.points[n6][0] = n5;
                n5 = this.objMesh.anzVectors;
                n7 = -1;
                if (!this.neverOptimize) {
                    n7 = this.objVectors.checkCoords(f6, f7, f8, n2);
                } else if (nArray != null) {
                    n7 = nArray[1];
                }
                if (n7 == -1) {
                    n7 = this.objVectors.addVertex(f6, f7, f8, n2);
                }
                n8 = n7;
                this.objMesh.coords[n5] = n7;
                this.objVectors.uOrg[n5] = f9;
                this.objVectors.vOrg[n5] = f10;
                if (n3 != 0) {
                    for (n4 = 0; n4 < textureInfo.stageCnt - 1; ++n4) {
                        this.objVectors.uMul[n4][n5] = textureInfo.u1[n4 + 1];
                        this.objVectors.vMul[n4][n5] = textureInfo.v1[n4 + 1];
                    }
                }
                this.objVectors.buOrg[n5] = f9;
                this.objVectors.bvOrg[n5] = f10;
                this.objVectors.nuOrg[n5] = f23;
                this.objVectors.nvOrg[n5] = f24;
                if (f17 != -1.0f) {
                    this.objVectors.alpha[n5] = f17;
                }
                ++this.objMesh.anzVectors;
                this.objMesh.points[n6][1] = n5;
                n5 = this.objMesh.anzVectors;
                n7 = -1;
                if (!this.neverOptimize) {
                    n7 = this.objVectors.checkCoords(f11, f12, f13, n2);
                } else if (nArray != null) {
                    n7 = nArray[2];
                }
                if (n7 == -1) {
                    n7 = this.objVectors.addVertex(f11, f12, f13, n2);
                }
                this.objMesh.coords[n5] = n7;
                this.objVectors.uOrg[n5] = f14;
                this.objVectors.vOrg[n5] = f15;
                if (n3 != 0) {
                    for (n4 = 0; n4 < textureInfo.stageCnt - 1; ++n4) {
                        this.objVectors.uMul[n4][n5] = textureInfo.u2[n4 + 1];
                        this.objVectors.vMul[n4][n5] = textureInfo.v2[n4 + 1];
                    }
                }
                this.objVectors.buOrg[n5] = f14;
                this.objVectors.bvOrg[n5] = f15;
                this.objVectors.nuOrg[n5] = f25;
                this.objVectors.nvOrg[n5] = f26;
                if (f17 != -1.0f) {
                    this.objVectors.alpha[n5] = f18;
                }
                ++this.objMesh.anzVectors;
                if (nArray != null) {
                    nArray[0] = n9;
                    nArray[1] = n8;
                    nArray[2] = n7;
                }
                if (n7 != n9 && n7 != n8 && n8 != n9) {
                    if (n7 < this.lowestPos) {
                        this.lowestPos = n7;
                    }
                    if (n8 < this.lowestPos) {
                        this.lowestPos = n8;
                    }
                    if (n9 < this.lowestPos) {
                        this.lowestPos = n9;
                    }
                    if (n7 > this.highestPos) {
                        this.highestPos = n7;
                    }
                    if (n8 > this.highestPos) {
                        this.highestPos = n8;
                    }
                    if (n9 > this.highestPos) {
                        this.highestPos = n9;
                    }
                    this.objMesh.points[n6][2] = n5;
                    if (this.sector != null) {
                        this.sector[n6] = n2;
                    }
                    this.texture[n6] = n;
                    this.basemap[n6] = n;
                    if (this.bumpmap != null) {
                        this.bumpmap[n6] = n;
                    }
                    if (n3 != 0) {
                        for (n4 = 0; n4 < textureInfo.stageCnt - 1; ++n4) {
                            this.multiTex[n4][n6] = textureInfo.textures[n4 + 1];
                            this.multiMode[n4][n6] = textureInfo.mode[n4 + 1];
                        }
                    }
                    ++this.objMesh.anzTri;
                }
            } else {
                Logger.log("Polygon index out of range - object is too large!", 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.log("Polygon index out of range - object is too large!", 0);
        }
        return this.objMesh.anzTri - 1;
    }

    final int addMD2Triangle(int n, float f, float f2, int n2, float f3, float f4, int n3, float f5, float f6) {
        int n4 = 0;
        int n5 = 0;
        float f7 = 2.0f;
        float f8 = 2.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        float f13 = f5;
        float f14 = f6;
        f *= f7;
        f2 *= f8;
        f3 *= f7;
        f4 *= f8;
        f5 *= f7;
        f6 *= f8;
        if (this.objMesh.anzVectors + 3 < this.objMesh.maxVectors) {
            int n6 = this.objMesh.anzVectors++;
            int n7 = this.objMesh.anzTri;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            n10 = n8 = n;
            this.objMesh.coords[n6] = n8;
            this.objVectors.uOrg[n6] = f;
            this.objVectors.vOrg[n6] = f2;
            this.objVectors.buOrg[n6] = f;
            this.objVectors.bvOrg[n6] = f2;
            this.objVectors.nuOrg[n6] = f9;
            this.objVectors.nvOrg[n6] = f10;
            this.objMesh.points[n7][0] = n6;
            n6 = this.objMesh.anzVectors++;
            n8 = n2;
            n9 = n6;
            this.objMesh.coords[n6] = n8;
            this.objVectors.uOrg[n6] = f3;
            this.objVectors.vOrg[n6] = f4;
            this.objVectors.buOrg[n6] = f3;
            this.objVectors.bvOrg[n6] = f4;
            this.objVectors.nuOrg[n6] = f11;
            this.objVectors.nvOrg[n6] = f12;
            this.objMesh.points[n7][1] = n6;
            n6 = this.objMesh.anzVectors++;
            this.objMesh.coords[n6] = n8 = n3;
            this.objVectors.uOrg[n6] = f5;
            this.objVectors.vOrg[n6] = f6;
            this.objVectors.buOrg[n6] = f5;
            this.objVectors.bvOrg[n6] = f6;
            this.objVectors.nuOrg[n6] = f13;
            this.objVectors.nvOrg[n6] = f14;
            if (n8 < this.lowestPos) {
                this.lowestPos = n8;
            }
            if (n9 < this.lowestPos) {
                this.lowestPos = n9;
            }
            if (n10 < this.lowestPos) {
                this.lowestPos = n10;
            }
            if (n8 > this.highestPos) {
                this.highestPos = n8;
            }
            if (n9 > this.highestPos) {
                this.highestPos = n9;
            }
            if (n10 > this.highestPos) {
                this.highestPos = n10;
            }
            this.objMesh.points[n7][2] = n6;
            if (this.sector != null) {
                this.sector[n7] = n4;
            }
            this.texture[n7] = n5;
            this.basemap[n7] = n5;
            if (this.bumpmap != null) {
                this.bumpmap[n7] = n5;
            }
            ++this.objMesh.anzTri;
        } else {
            Logger.log("Polygon index out of range - object is too large!", 0);
        }
        return this.objMesh.anzTri - 1;
    }

    private final Matrix recurseObjectsBillboarded(Matrix matrix) {
        Matrix matrix2 = matrix.cloneMatrix();
        matrix = this.recurseObjects(matrix);
        float f = this.recurseScaling(this.getScale());
        Matrix matrix3 = matrix.cloneMatrix().invert3x3();
        matrix3.mat[3][0] = 0.0f;
        matrix3.mat[3][1] = 0.0f;
        matrix3.mat[3][2] = 0.0f;
        matrix3.mat[3][3] = 1.0f;
        Matrix matrix4 = new Matrix();
        matrix4.mat[3][0] = -matrix.mat[3][0];
        matrix4.mat[3][1] = -matrix.mat[3][1];
        matrix4.mat[3][2] = -matrix.mat[3][2];
        matrix.matMul(matrix4);
        matrix.matMul(matrix3);
        matrix2.mat[3][0] = 0.0f;
        matrix2.mat[3][1] = 0.0f;
        matrix2.mat[3][2] = 0.0f;
        matrix2.mat[3][3] = 1.0f;
        matrix.matMul(matrix2);
        matrix4.mat[3][0] = -matrix4.mat[3][0];
        matrix4.mat[3][1] = -matrix4.mat[3][1];
        matrix4.mat[3][2] = -matrix4.mat[3][2];
        matrix.matMul(matrix4);
        matrix.scalarMul(1.0f / (f * this.getScale()));
        return matrix;
    }

    private final Matrix recurseObjects(Matrix matrix) {
        Matrix matrix2 = this.getCachedMatrix(1);
        for (int i = 0; i < this.parentCnt; ++i) {
            Object3D object3D = this.parent[i];
            matrix2.setIdentity();
            float f = object3D.originMatrix.mat[3][0];
            float f2 = object3D.originMatrix.mat[3][1];
            float f3 = object3D.originMatrix.mat[3][2];
            matrix2.mat[3][0] = -object3D.xRotationCenter - f;
            matrix2.mat[3][1] = -object3D.yRotationCenter - f2;
            matrix2.mat[3][2] = -object3D.zRotationCenter - f3;
            matrix.matMul(matrix2);
            matrix.matMul(object3D.rotationMatrix);
            matrix2.mat[3][0] = object3D.xRotationCenter + object3D.translationMatrix.mat[3][0] + f;
            matrix2.mat[3][1] = object3D.yRotationCenter + object3D.translationMatrix.mat[3][1] + f2;
            matrix2.mat[3][2] = object3D.zRotationCenter + object3D.translationMatrix.mat[3][2] + f3;
            matrix.matMul(matrix2);
            if (object3D.parentCnt == 0) continue;
            matrix = object3D.recurseObjects(matrix);
        }
        return matrix;
    }

    private final float recurseScaling(float f) {
        for (int i = 0; i < this.parentCnt; ++i) {
            Object3D object3D = this.parent[i];
            f *= object3D.getScale();
            if (object3D.parentCnt == 0) continue;
            f = object3D.recurseScaling(f);
        }
        return f;
    }

    final boolean transformVertices(FrameBuffer frameBuffer) {
        int n;
        int n2;
        int n3;
        boolean bl;
        Object object;
        if (Config.autoBuild && !this.hasBeenBuild) {
            Logger.log("Auto building object '" + this.getName() + "'!", 2);
            this.build();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.someSectorVisible = true;
        boolean bl2 = frameBuffer.hasRenderTarget && frameBuffer.renderTarget.isShadowMap;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.myWorld.portals.viewSector;
        float f16 = this.myWorld.camera.divx;
        float f17 = this.myWorld.camera.divy;
        float f18 = this.myWorld.camera.scaleX;
        float f19 = this.myWorld.camera.scaleY;
        float f20 = Config.nearPlane;
        float f21 = 0.0f;
        float f22 = frameBuffer.middleX;
        float f23 = frameBuffer.middleY;
        if (Config.useLocking) {
            this.myWorld.lockMatrices();
        }
        this.mat2 = this.myWorld.camera.frontMatrix;
        this.mat3.setIdentity();
        this.mat3.mat[3][0] = -this.myWorld.camera.frontBx;
        this.mat3.mat[3][1] = -this.myWorld.camera.frontBy;
        this.mat3.mat[3][2] = -this.myWorld.camera.frontBz;
        this.visComplete = false;
        float[] fArray = this.objMesh.zOrg;
        float[] fArray2 = this.objMesh.xOrg;
        float[] fArray3 = this.objMesh.yOrg;
        float[] fArray4 = this.objVectors.xTr;
        float[] fArray5 = this.objVectors.yTr;
        float[] fArray6 = this.objVectors.zTr;
        if (this.lazyTransforms && !this.isBillBoard) {
            this.getWorldTransformation(this.mat5);
        } else {
            this.mat5.setIdentity();
            this.mat6.setIdentity();
            this.mat5.mat[3][0] = -this.xRotationCenter;
            this.mat5.mat[3][1] = -this.yRotationCenter;
            this.mat5.mat[3][2] = -this.zRotationCenter;
            this.mat6.mat[3][0] = this.xRotationCenter + this.translationMatrix.mat[3][0] + this.originMatrix.mat[3][0];
            this.mat6.mat[3][1] = this.yRotationCenter + this.translationMatrix.mat[3][1] + this.originMatrix.mat[3][1];
            this.mat6.mat[3][2] = this.zRotationCenter + this.translationMatrix.mat[3][2] + this.originMatrix.mat[3][2];
            if (!this.isBillBoard) {
                this.mat5.matMul(this.rotationMatrix);
            } else {
                Matrix matrix = this.mat2;
                if (this.myWorld.camera.billBoardMatrix != null) {
                    matrix = this.myWorld.camera.billBoardMatrix;
                }
                object = matrix.invert();
                ((Matrix)object).scalarMul(this.scaleFactor);
                this.mat5.matMul((Matrix)object);
            }
            this.mat5.matMul(this.mat6);
            if (this.parentCnt != 0) {
                this.mat5 = this.isBillBoard && !Config.oldStyleBillBoarding ? this.recurseObjectsBillboarded(this.mat5) : this.recurseObjects(this.mat5);
            }
        }
        boolean bl3 = this.isCompiled();
        this.transBuffer = new Matrix(this.mat5);
        this.cullingInvertedBuffer = this.reverseCulling ^ this.myWorld.invertCulling;
        if (Config.useLocking) {
            this.myWorld.unlockMatrices();
        }
        object = this.mat5.mat;
        if (!bl3 || Config.doPortalHsr) {
            f4 = object[0][0];
            f5 = object[1][0];
            f8 = object[1][1];
            f9 = object[2][1];
            f6 = object[2][0];
            f7 = object[0][1];
            f12 = object[2][2];
            f11 = object[1][2];
            f10 = object[0][2];
            f14 = object[3][0];
            f15 = object[3][1];
            f13 = object[3][2];
        }
        this.mat5.matMul(this.mat3);
        this.mat5.matMul(this.mat2);
        float f24 = object[0][0];
        float f25 = object[1][0];
        float f26 = object[1][1];
        float f27 = object[2][1];
        float f28 = object[2][2];
        float f29 = object[1][2];
        float f30 = object[2][0];
        float f31 = object[0][2];
        float f32 = object[0][1];
        float f33 = object[3][0];
        float f34 = object[3][1];
        float f35 = object[3][2];
        int n12 = 1;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        float[][] fArray7 = this.myWorld.getWorldProcessor().getArrays(this.getMesh().getVertexCount() + 8);
        float[] fArray8 = fArray7[0];
        boolean bl4 = bl = this.ocTree != null && !Config.doPortalHsr && this.ocTree.getRenderingUse();
        if (bl) {
            n15 = this.ocTree.getVisibleLeafs(this.mat5, f16, f17);
            if (n15 == 0) {
                return true;
            }
            if (!this.isCompiled()) {
                if (n15 == this.ocTree.getTotalLeafs()) {
                    for (n3 = 0; n3 < this.objMesh.anzCoords; ++n3) {
                        fArray8[n3] = -1.0f;
                    }
                } else {
                    OcTreeNode[] ocTreeNodeArray = this.ocTree.getLeafList();
                    n2 = this.ocTree.getLeafCount();
                    for (n = 0; n < n2; ++n) {
                        OcTreeNode ocTreeNode = ocTreeNodeArray[n];
                        int n16 = ocTreeNode.getPointCount();
                        int[] nArray = ocTreeNode.getPoints();
                        for (int i = 0; i < n16; ++i) {
                            fArray8[nArray[i]] = -1.0f;
                        }
                    }
                }
            }
        }
        n3 = this.myWorld.portals.anzVisSectors;
        if (this.oneSectorOnly || this.hasPortals || !Config.doPortalHsr) {
            n3 = 1;
        }
        if (Config.doPortalHsr && this.dynSectorDetect && !this.hasPortals && this.objMesh.obbEnd - this.objMesh.obbStart == 7) {
            for (n2 = 0; n2 < 8; ++n2) {
                n = n2 + this.objMesh.obbStart;
                f2 = fArray[n];
                f = fArray2[n];
                f3 = fArray3[n];
                this.xWs[n2] = f * f4 + f3 * f5 + f2 * f6 + f14;
                this.yWs[n2] = f * f7 + f3 * f8 + f2 * f9 + f15;
                this.zWs[n2] = f * f10 + f3 * f11 + f2 * f12 + f13;
            }
            this.dynSectorList = this.myWorld.portals.detectAllCoveredSectors(this.dynSectorList, this.xWs, this.yWs, this.zWs);
            this.sectorCnt = this.dynSectorList[0];
            if (this.sectorCnt != 0) {
                n2 = 0;
                for (n = 1; n <= this.sectorCnt; ++n) {
                    if (this.myWorld.portals.viewSector == this.dynSectorList[n]) {
                        n2 = 1;
                        this.someSectorVisible = true;
                        n3 = 1;
                        n = this.sectorCnt + 1;
                        continue;
                    }
                    for (int i = 0; i < this.myWorld.portals.anzVisSectors; ++i) {
                        if (this.myWorld.portals.visSectors[i] != this.dynSectorList[n]) continue;
                        n2 = 1;
                        this.someSectorVisible = true;
                        n3 = 1;
                        n = this.sectorCnt + 1;
                        i = this.myWorld.portals.anzVisSectors;
                    }
                }
                if (n2 == 0) {
                    this.someSectorVisible = false;
                    n3 = 0;
                }
            } else {
                this.someSectorVisible = false;
                n3 = 0;
            }
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            boolean bl5;
            if (!this.oneSectorOnly && !this.hasPortals && Config.doPortalHsr && !this.dynSectorDetect) {
                n12 = this.myWorld.portals.visSectors[n];
                n14 = this.sectorStartPoint[n12];
                n13 = this.sectorEndPoint[n12] + 1;
                if (n14 + 1 == n13) {
                    n13 = 0;
                    n14 = 0;
                }
            } else {
                n14 = 0;
                n13 = this.objMesh.anzCoords;
            }
            if (Config.useBB && this.hasBoundingBox && Config.useFrustumCulling || bl && this.hasBoundingBox) {
                int n17;
                for (n17 = this.objMesh.obbStart; n17 <= this.objMesh.obbEnd; ++n17) {
                    f2 = fArray[n17];
                    f = fArray2[n17];
                    f3 = fArray3[n17];
                    float f36 = f * f24 + f3 * f25 + f2 * f30 + f33;
                    float f37 = f * f32 + f3 * f26 + f2 * f27 + f34;
                    float f38 = f * f31 + f3 * f29 + f2 * f28 + f35;
                    fArray4[n17] = f36;
                    fArray5[n17] = f37;
                    fArray6[n17] = f38;
                    if (!Config.useFrustumCulling) continue;
                    if (this.dynSectorDetect) {
                        if (this.sectorCnt == 1 && this.dynSectorList[1] == n11) {
                            ++n10;
                        }
                    } else if (!this.oneSectorOnly) {
                        if (this.objVectors.vertexSector[n17] == n11) {
                            ++n10;
                        }
                    } else if (this.singleSectorNumber == n11 || this.singleSectorNumber == 0) {
                        ++n10;
                    }
                    bl5 = false;
                    if (f38 < f20) {
                        ++n8;
                        bl5 = true;
                    } else if (f38 > Config.farPlane) {
                        ++n9;
                        bl5 = true;
                    }
                    f21 = f38 * f16;
                    if (f36 < -f21) {
                        ++n5;
                        bl5 = true;
                    } else if (f36 > f21) {
                        ++n4;
                        bl5 = true;
                    }
                    f21 = f38 * f17;
                    if (f37 < -f21) {
                        ++n6;
                        bl5 = true;
                    } else if (f37 > f21) {
                        ++n7;
                        bl5 = true;
                    }
                    if (bl3 && !bl5) break;
                }
                if (n7 == (n17 = this.objMesh.obbEnd + 1 - this.objMesh.obbStart) || n4 == n17 || n6 == n17 || n5 == n17 || n8 == n17 || n9 == n17) {
                    n2 = 1;
                } else {
                    n2 = Config.doPortalHsr && n10 != n17 ? (!this.myWorld.portals.testObbAgainstPortals(this, f22, f23, f18, f19) ? 1 : 0) : 0;
                    if (n2 == 0 && n7 == 0 && n4 == 0 && n6 == 0 && n5 == 0 && n8 == 0 && n9 == 0) {
                        this.visComplete = true;
                    }
                }
                if (this.objMesh.obbEnd + 1 == n13) {
                    n13 = this.objMesh.obbStart;
                }
            }
            if (n2 == 0) {
                boolean bl6;
                if (bl3) {
                    OcTreeNode[] ocTreeNodeArray = null;
                    if (bl) {
                        if (this.sectors == null) {
                            this.sectors = new Hashtable();
                        }
                        this.sectors.clear();
                        ocTreeNodeArray = this.ocTree.getLeafList();
                        for (int i = 0; i < n15; ++i) {
                            Integer n18 = IntegerC.valueOf(ocTreeNodeArray[i].getID());
                            this.sectors.put(n18, n18);
                        }
                    }
                    float f39 = this.centerX * f31 + this.centerY * f29 + this.centerZ * f28 + f35;
                    for (int i = 0; i < this.compiled.size(); ++i) {
                        ICompiledInstance iCompiledInstance = null;
                        iCompiledInstance = this.shareWith != null ? (ICompiledInstance)this.shareWith.compiled.elementAt(i) : (ICompiledInstance)this.compiled.elementAt(i);
                        bl5 = true;
                        if (bl && iCompiledInstance.getTreeID() != -1) {
                            bl5 = this.sectors.containsKey(IntegerC.valueOf(iCompiledInstance.getTreeID()));
                        }
                        if (!bl5) continue;
                        int n19 = iCompiledInstance.getPolyIndex();
                        this.myWorld.visList.addToList(this, this, n19, n19, f39, i, iCompiledInstance.getStageCount() - 1, false);
                    }
                    return false;
                }
                float[] fArray9 = this.objVectors.sz;
                float[] fArray10 = this.objMesh.nzOrg;
                float[] fArray11 = this.objMesh.nxOrg;
                float[] fArray12 = this.objMesh.nyOrg;
                float[] fArray13 = fArray7[3];
                float[] fArray14 = fArray7[4];
                float[] fArray15 = fArray7[5];
                float[] fArray16 = fArray7[6];
                float[] fArray17 = fArray7[7];
                float[] fArray18 = fArray7[8];
                OcTreeNode[] ocTreeNodeArray = null;
                int[] nArray = null;
                int n20 = 0;
                boolean bl7 = false;
                if (bl) {
                    ocTreeNodeArray = this.ocTree.getLeafList();
                    bl7 = true;
                }
                boolean bl8 = bl6 = this.isEnvmapped && !this.useCSEnvmapping;
                if (bl6) {
                    this.myWorld.createWSNormals();
                    fArray16 = fArray7[6];
                    fArray17 = fArray7[7];
                    fArray18 = fArray7[8];
                }
                do {
                    if (bl7) {
                        nArray = ocTreeNodeArray[n20].getPoints();
                        n14 = 0;
                        n13 = ocTreeNodeArray[n20].getPointCount();
                        ++n20;
                    }
                    for (int i = n14; i < n13; ++i) {
                        int n21 = i;
                        if (bl7) {
                            n21 = nArray[i];
                        }
                        if (bl7 && fArray8[n21] != -1.0f) continue;
                        f2 = fArray[n21];
                        f = fArray2[n21];
                        f3 = fArray3[n21];
                        fArray4[n21] = f * f24 + f3 * f25 + f2 * f30 + f33;
                        fArray5[n21] = f * f32 + f3 * f26 + f2 * f27 + f34;
                        fArray6[n21] = bl2 ? f * f31 + f3 * f29 + f2 * f28 + f35 + Config.glShadowZBias : f * f31 + f3 * f29 + f2 * f28 + f35;
                        fArray9[n21] = -1.01f;
                        f2 = fArray10[n21];
                        f = fArray11[n21];
                        f3 = fArray12[n21];
                        fArray13[n21] = f * f24 + f3 * f25 + f2 * f30;
                        fArray14[n21] = f * f32 + f3 * f26 + f2 * f27;
                        fArray15[n21] = f * f31 + f3 * f29 + f2 * f28;
                        if (bl6) {
                            fArray16[n21] = f * f4 + f3 * f5 + f2 * f6;
                            fArray17[n21] = f * f7 + f3 * f8 + f2 * f9;
                            fArray18[n21] = f * f10 + f3 * f11 + f2 * f12;
                        }
                        if (this.reNormalize) {
                            float f40 = (float)Math.sqrt(fArray13[n21] * fArray13[n21] + fArray14[n21] * fArray14[n21] + fArray15[n21] * fArray15[n21]);
                            if (f40 != 0.0f) {
                                int n22 = n21;
                                fArray13[n22] = fArray13[n22] / f40;
                                int n23 = n21;
                                fArray14[n23] = fArray14[n23] / f40;
                                int n24 = n21;
                                fArray15[n24] = fArray15[n24] / f40;
                            }
                            if (bl6 && (f40 = (float)Math.sqrt(fArray16[n21] * fArray16[n21] + fArray17[n21] * fArray17[n21] + fArray18[n21] * fArray18[n21])) != 0.0f) {
                                int n25 = n21;
                                fArray16[n25] = fArray16[n25] / f40;
                                int n26 = n21;
                                fArray17[n26] = fArray17[n26] / f40;
                                int n27 = n21;
                                fArray18[n27] = fArray18[n27] / f40;
                            }
                        }
                        fArray8[n21] = 1.2345671E7f;
                    }
                } while (bl7 && n20 < n15);
                continue;
            }
            ++cullCount;
        }
        return n2 != 0;
    }

    final void addClippedPoly(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30) {
        Object3D object3D = this.myWorld.clippedPolys;
        if (object3D.objMesh.anzVectors + 2 + 8 >= object3D.objMesh.maxVectors) {
            this.myWorld.rescaleClippedPolys();
        }
        Vectors vectors = object3D.objVectors;
        Mesh mesh = object3D.objMesh;
        int n2 = mesh.anzVectors;
        int n3 = mesh.anzCoords;
        object3D.texture[mesh.anzTri] = this.texture[n];
        object3D.basemap[mesh.anzTri] = this.basemap[n];
        if (this.bumpmap != null) {
            object3D.bumpmap[mesh.anzTri] = this.bumpmap[n];
        }
        vectors.sx[n3] = f;
        vectors.sy[n3] = f2;
        vectors.sz[n3] = f3;
        mesh.coords[n2] = n3;
        vectors.su[n3] = f4;
        vectors.sv[n3] = f5;
        vectors.sb[n3] = f8;
        vectors.sr[n3] = f6;
        vectors.sg[n3] = f7;
        if (vectors.bsu != null) {
            vectors.bsu[n3] = f25;
            vectors.bsv[n3] = f26;
        }
        mesh.points[mesh.anzTri][0] = n3++;
        vectors.sx[n3] = f9;
        vectors.sy[n3] = f10;
        vectors.sz[n3] = f11;
        mesh.coords[++n2] = n3;
        vectors.su[n3] = f12;
        vectors.sv[n3] = f13;
        vectors.sb[n3] = f16;
        vectors.sr[n3] = f14;
        vectors.sg[n3] = f15;
        if (vectors.bsu != null) {
            vectors.bsu[n3] = f27;
            vectors.bsv[n3] = f28;
        }
        mesh.points[mesh.anzTri][1] = n3++;
        vectors.sx[n3] = f17;
        vectors.sy[n3] = f18;
        vectors.sz[n3] = f19;
        mesh.coords[++n2] = n3;
        vectors.su[n3] = f20;
        vectors.sv[n3] = f21;
        vectors.sb[n3] = f24;
        vectors.sr[n3] = f22;
        vectors.sg[n3] = f23;
        if (vectors.bsu != null) {
            vectors.bsu[n3] = f29;
            vectors.bsv[n3] = f30;
        }
        mesh.points[mesh.anzTri][2] = n3++;
        mesh.anzCoords = n3;
        mesh.anzVectors = ++n2;
        ++mesh.anzTri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addCompiled(ICompiledInstance iCompiledInstance) {
        Vector vector = this.compiled;
        synchronized (vector) {
            this.compiled.addElement(iCompiledInstance);
        }
    }

    final void render(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, boolean bl2) {
        Lights lights = !this.isLit ? DUMMY_LIGHTS : this.myWorld.lights;
        int n = lights.lightCnt;
        VisList visList = this.myWorld.visList;
        float[][] fArray = this.myWorld.getWorldProcessor().getArrays(this.getMesh().getVertexCount() + 8);
        if (this.isCompiled()) {
            if (this.nearestLights == null) {
                this.nearestLights = new float[8][7];
            }
            for (int i = 0; i < 8; ++i) {
                this.nearestLights[i][0] = -9999.0f;
            }
            if (this.isLit && n > 0) {
                int n2;
                SimpleVector simpleVector = null;
                Vector<float[]> vector = new Vector<float[]>(n);
                for (n2 = 0; n2 < n; ++n2) {
                    float f7;
                    if (!lights.isVisible[n2]) continue;
                    if (simpleVector == null) {
                        simpleVector = this.getTransformedCenter();
                    }
                    if (!((f7 = simpleVector.calcSub(new SimpleVector(lights.xOrg[n2], lights.yOrg[n2], lights.zOrg[n2])).length()) <= lights.discardDistance[n2]) && (!(lights.discardDistance[n2] < 0.0f) || !(Config.lightDiscardDistance < 0.0f) && !(Config.lightDiscardDistance > f7))) continue;
                    boolean bl3 = false;
                    if (n > 8) {
                        for (int i = 0; i < vector.size(); ++i) {
                            float[] fArray2 = (float[])vector.get(i);
                            if (!(f7 < fArray2[0])) continue;
                            vector.insertElementAt(new float[]{f7, n2}, i);
                            bl3 = true;
                            break;
                        }
                    }
                    if (bl3) continue;
                    vector.addElement(new float[]{f7, n2});
                }
                for (n2 = 0; n2 < 8 && n2 < vector.size(); ++n2) {
                    int n3 = (int)((float[])vector.elementAt(n2))[1];
                    float f8 = lights.getAttenuation(n3);
                    if (f8 != -1.0f && f8 < 0.0f && Config.fadeoutLight) {
                        f8 = Config.linearDiv;
                    }
                    this.nearestLights[n2][0] = f8;
                    this.nearestLights[n2][1] = lights.xTr[n3];
                    this.nearestLights[n2][2] = -lights.yTr[n3];
                    this.nearestLights[n2][3] = -lights.zTr[n3];
                    this.nearestLights[n2][4] = lights.rOrg[n3] / 255.0f;
                    this.nearestLights[n2][5] = lights.gOrg[n3] / 255.0f;
                    this.nearestLights[n2][6] = lights.bOrg[n3] / 255.0f;
                }
            }
            if (this.dynamic && this.modified) {
                visList.addToFill(this);
            }
            if (this.dynamic && this.shareWith != null && this.shareWith.modified) {
                visList.addToFill(this.shareWith);
            }
            return;
        }
        if (!bl2) {
            this.objVectors.createScreenColors();
        }
        TextureManager textureManager = TextureManager.getInstance();
        if (this.isBumpmapped && this.bumpmap != null && !textureManager.textures[this.bumpmap[0]].isBumpmap) {
            textureManager.textures[this.bumpmap[0]].createBumpmap();
        }
        int n4 = this.myWorld.lights.maxLightValue;
        float f9 = Config.farPlane;
        float f10 = Config.nearPlane;
        int n5 = this.myWorld.portals.viewSector;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = ((int)f << 1) - 1;
        int n14 = ((int)f2 << 1) - 1;
        float f11 = f + f * 2.0f * Config.viewportOffsetX;
        float f12 = f2 + f2 * 2.0f * Config.viewportOffsetY;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        float f24 = 0.0f;
        float f25 = 0.0f;
        float f26 = 0.0f;
        float f27 = 0.0f;
        float f28 = 0.0f;
        float f29 = 0.0f;
        float f30 = 0.0f;
        float f31 = 0.0f;
        float f32 = 0.0f;
        float f33 = 1.0f / Config.linearDiv;
        float f34 = Config.lightDiscardDistance;
        float f35 = f34 * f34;
        boolean bl4 = false;
        float f36 = 1.0E-4f;
        if (!bl4) {
            this.object3DRendered = true;
            float f37 = this.myWorld.ambientRed + this.addColorR;
            float f38 = this.myWorld.ambientGreen + this.addColorG;
            float f39 = this.myWorld.ambientBlue + this.addColorB;
            boolean bl5 = !Config.doPortalHsr && this.ocTree != null && this.ocTree.getRenderingUse();
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int[] nArray = null;
            if (bl5 && this.ocTree.getLeafCount() == 0) {
                return;
            }
            int[][] nArray2 = this.objMesh.points;
            int[] nArray3 = this.objMesh.coords;
            float[] fArray3 = this.objVectors.xTr;
            float[] fArray4 = this.objVectors.yTr;
            float[] fArray5 = this.objVectors.zTr;
            float[] fArray6 = this.objVectors.sz;
            float[] fArray7 = this.objVectors.sx;
            float[] fArray8 = this.objVectors.sy;
            float[] fArray9 = this.objVectors.su;
            float[] fArray10 = this.objVectors.sv;
            float[] fArray11 = this.objVectors.bsu;
            float[] fArray12 = this.objVectors.bsv;
            if (fArray11 == null) {
                fArray11 = this.objVectors.su;
                fArray12 = this.objVectors.sv;
            }
            float[] fArray13 = this.objVectors.uOrg;
            float[] fArray14 = this.objVectors.vOrg;
            float[] fArray15 = this.objVectors.sg;
            float[] fArray16 = this.objVectors.sr;
            float[] fArray17 = this.objVectors.sb;
            float[] fArray18 = this.objVectors.sgOrg;
            float[] fArray19 = this.objVectors.srOrg;
            float[] fArray20 = this.objVectors.sbOrg;
            float[] fArray21 = fArray[3];
            float[] fArray22 = fArray[4];
            float[] fArray23 = fArray[5];
            float[] fArray24 = fArray[6];
            float[] fArray25 = fArray[7];
            float[] fArray26 = fArray[8];
            do {
                boolean bl6 = this.visComplete;
                if (bl5) {
                    OcTreeNode[] ocTreeNodeArray = this.ocTree.getLeafList();
                    if (this.ocTree.isCompletelyVisible(n15)) {
                        bl6 = true;
                    }
                    nArray = ocTreeNodeArray[n15].getPolygons();
                    n17 = ocTreeNodeArray[n15].getPolyCount();
                    n16 = 0;
                    ++n15;
                }
                do {
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    int n24;
                    int n25;
                    if (bl5) {
                        n11 = nArray[n16];
                        ++n16;
                    }
                    boolean bl7 = true;
                    if (!this.oneSectorOnly && this.sector != null && n10 != this.sector[n11] && Config.doPortalHsr) {
                        bl7 = false;
                        n25 = 1;
                        n24 = 0;
                        while (n11 < this.objMesh.anzTri && !bl7) {
                            if (n24 == 0) {
                                bl7 = this.myWorld.portals.isSectorVisible(this, this.sector[n11]);
                            }
                            n24 = 0;
                            if (bl7) continue;
                            n23 = n11;
                            int n26 = this.sectorEndPoly[this.sector[n11] + n25];
                            if ((n11 = this.sectorStartPoly[this.sector[n11] + n25]) != n26) continue;
                            n11 = n23;
                            n24 = 1;
                            if (this.sector[n11] + ++n25 <= this.myWorld.portals.anzSectors) continue;
                            n11 = this.objMesh.anzTri;
                            bl7 = false;
                        }
                    }
                    if (n11 >= this.objMesh.anzTri) {
                        bl7 = false;
                    } else {
                        n10 = !this.oneSectorOnly && this.sector != null ? this.sector[n11] : this.singleSectorNumber;
                    }
                    if (!bl7) continue;
                    bl4 = false;
                    n25 = nArray3[nArray2[n11][0]];
                    n24 = nArray3[nArray2[n11][1]];
                    n23 = nArray3[nArray2[n11][2]];
                    f15 = fArray3[n23];
                    f16 = fArray4[n23];
                    f17 = fArray5[n23];
                    f18 = fArray3[n24];
                    f19 = fArray4[n24];
                    f20 = fArray5[n24];
                    f21 = fArray3[n25];
                    f22 = fArray4[n25];
                    f23 = fArray5[n25];
                    if (f17 < f10 && f20 < f10 && f23 < f10 || f17 > f9 && f20 > f9 && f23 > f9) {
                        bl4 = true;
                        f27 = 1.0f;
                    } else if (Config.useFrustumCulling && !bl6) {
                        float f40 = f17 * f5;
                        float f41 = f20 * f5;
                        float f42 = f23 * f5;
                        if (f15 < -f40 && f18 < -f41 && f21 < -f42 || f15 > f40 && f18 > f41 && f21 > f42) {
                            bl4 = true;
                            f27 = 1.0f;
                            ++n12;
                        } else {
                            f40 = f17 * f6;
                            f41 = f20 * f6;
                            f42 = f23 * f6;
                            if (f16 < -f40 && f19 < -f41 && f22 < -f42 || f16 > f40 && f19 > f41 && f22 > f42) {
                                bl4 = true;
                                f27 = 1.0f;
                                ++n12;
                            }
                        }
                    }
                    if (!bl4) {
                        if (this.doCulling) {
                            float f43 = f21 - f15;
                            float f44 = f22 - f16;
                            float f45 = f23 - f17;
                            float f46 = f18 - f15;
                            float f47 = f19 - f16;
                            float f48 = f20 - f17;
                            f24 = f44 * f48 - f45 * f47;
                            f25 = f45 * f46 - f43 * f48;
                            f26 = f43 * f47 - f44 * f46;
                            f27 = f24 * f15 + f25 * f16 + f26 * f17;
                            if (this.reverseCulling ^ this.myWorld.invertCulling) {
                                f27 *= -1.0f;
                            }
                        } else {
                            f27 = -1.0f;
                        }
                    }
                    if (!(f27 <= 0.0f)) continue;
                    f36 = (2.5f - (float)(n11 & 5)) * 1.0E-4f;
                    if (this.isFlatShaded) {
                        float f49 = (float)Math.sqrt(f24 * f24 + f25 * f25 + f26 * f26);
                        f24 /= f49;
                        f25 /= f49;
                        f26 /= f49;
                    }
                    if (!bl4) {
                        float f50;
                        float f51;
                        float f52;
                        float f53;
                        float f54;
                        float f55;
                        int n27;
                        float f56;
                        float f57;
                        float f58;
                        float f59;
                        float f60;
                        float f61;
                        float f62;
                        float f63;
                        float f64;
                        float f65;
                        float f66;
                        float f67;
                        float f68;
                        float f69;
                        float f70;
                        float f71;
                        float f72;
                        float f73;
                        float f74;
                        float f75;
                        float f76;
                        float f77;
                        float f78;
                        float f79;
                        int n28;
                        int n29;
                        int n30;
                        int n31 = 0;
                        n22 = -2;
                        n6 = 0;
                        n7 = 0;
                        n8 = 0;
                        n9 = 0;
                        n21 = textureManager.textures[this.texture[n11]].width;
                        n20 = textureManager.textures[this.texture[n11]].height;
                        n19 = n21 >> 1;
                        n18 = n20 >> 1;
                        --n21;
                        --n20;
                        for (n30 = 0; n30 < 3; ++n30) {
                            float f80;
                            n29 = nArray2[n11][n30];
                            n28 = nArray3[n29];
                            if (!this.isFlatShaded || n30 == 0) {
                                if (fArray[0][n28] == 1.2345671E7f || this.isFlatShaded) {
                                    float f81;
                                    float f82;
                                    float f83;
                                    float f84 = fArray3[n28];
                                    float f85 = fArray4[n28];
                                    f80 = fArray5[n28];
                                    if (!this.isFlatShaded) {
                                        if (this.invScaleFactor != 1.0f) {
                                            f83 = fArray21[n28] * this.invScaleFactor;
                                            f82 = fArray22[n28] * this.invScaleFactor;
                                            f81 = fArray23[n28] * this.invScaleFactor;
                                        } else {
                                            f83 = fArray21[n28];
                                            f82 = fArray22[n28];
                                            f81 = fArray23[n28];
                                        }
                                    } else {
                                        f83 = f24;
                                        f82 = f25;
                                        f81 = f26;
                                        int n32 = nArray3[nArray2[n11][0]];
                                        f84 = fArray3[n32];
                                        f85 = fArray4[n32];
                                        f80 = fArray5[n32];
                                    }
                                    float f86 = 0.0f;
                                    float f87 = 0.0f;
                                    float f88 = f37;
                                    f79 = f38;
                                    f78 = f39;
                                    for (int i = 0; i < n; ++i) {
                                        boolean bl8 = false;
                                        if (!lights.isVisible[i]) continue;
                                        if (Config.gouraud) {
                                            boolean bl9 = Config.fadeoutLight;
                                            f77 = lights.attenuation[i];
                                            f76 = f33;
                                            if (f77 == -1.0f) {
                                                bl9 = false;
                                            } else if (f77 != -2.0f) {
                                                bl9 = true;
                                                f76 = 1.0f / f77;
                                            }
                                            f75 = lights.discardDistance[i];
                                            f74 = 0.0f;
                                            if (f75 == -2.0f) {
                                                f75 = f34;
                                                f74 = f35;
                                            } else if (f75 != -1.0f) {
                                                f74 = f75 * f75;
                                            }
                                            f73 = lights.xTr[i] - f84;
                                            f72 = lights.yTr[i] - f85;
                                            f71 = lights.zTr[i] - f80;
                                            f28 = f73 * f73 + f72 * f72 + f71 * f71;
                                            if (f75 == -1.0f || f28 <= f74) {
                                                f28 = (float)Math.sqrt(f28);
                                                if (this.doSpecularLighting) {
                                                    f30 = lights.xTr[i] * 0.5f;
                                                    f31 = lights.yTr[i] * 0.5f;
                                                    f32 = lights.zTr[i] * 0.5f;
                                                    f29 = f30 * f30 + f31 * f31 + f32 * f32;
                                                    f86 = f29 != 0.0f ? (float)((double)(f30 * f83 + f31 * f82 + f32 * f81) / Math.sqrt(f29)) : -1.0f;
                                                    if (f86 < 0.0f) {
                                                        f86 = 0.0f;
                                                    } else {
                                                        f86 = !Config.useFastSpecular ? Config.specTerm * (float)Math.pow(f86, Config.specPow) : Config.specTerm * (f86 / (Config.specPow - Config.specPow * f86 + f86));
                                                        if (bl9) {
                                                            f86 -= f28 * f76;
                                                        }
                                                        if (f86 < 0.0f) {
                                                            f86 = 0.0f;
                                                        }
                                                    }
                                                } else {
                                                    f86 = 0.0f;
                                                }
                                                f87 = (float)Config.lightMul * (f83 * f73 + f82 * f72 + f81 * f71) / f28;
                                                if (bl9) {
                                                    f87 -= f28 * f76;
                                                }
                                                if (f87 < 0.0f) {
                                                    f87 = 0.0f;
                                                }
                                            } else {
                                                bl8 = true;
                                            }
                                        } else {
                                            f87 = 0.0f;
                                        }
                                        if (bl8) continue;
                                        f88 += lights.rOrg[i] * (f87 += f86);
                                        f79 += lights.gOrg[i] * f87;
                                        f78 += lights.bOrg[i] * f87;
                                    }
                                    if (f78 > (float)n4) {
                                        f78 = n4;
                                    }
                                    if (f88 > (float)n4) {
                                        f88 = n4;
                                    }
                                    if (f79 > (float)n4) {
                                        f79 = n4;
                                    }
                                    if (this.myWorld.useFogging && !this.myWorld.perPixelFogging) {
                                        float f89 = f80 / this.myWorld.fogDistance;
                                        if (f89 > 1.0f) {
                                            f89 = 1.0f;
                                        } else if (f89 < 0.0f) {
                                            f89 = 0.0f;
                                        }
                                        float f90 = 1.0f - f89;
                                        f88 = f88 * f90 + this.myWorld.fogColorR * f89;
                                        f79 = f79 * f90 + this.myWorld.fogColorG * f89;
                                        f78 = f78 * f90 + this.myWorld.fogColorB * f89;
                                    }
                                    fArray[2][n28] = f78;
                                    fArray[0][n28] = f88;
                                    fArray[1][n28] = f79;
                                    this.objVectors.sbOrg[n29] = f78;
                                    this.objVectors.srOrg[n29] = f88;
                                    this.objVectors.sgOrg[n29] = f79;
                                } else {
                                    this.objVectors.sbOrg[n29] = fArray[2][n28];
                                    this.objVectors.srOrg[n29] = fArray[0][n28];
                                    this.objVectors.sgOrg[n29] = fArray[1][n28];
                                }
                            } else {
                                int n33 = this.objMesh.points[n11][0];
                                int n34 = this.objMesh.points[n11][1];
                                this.objVectors.sbOrg[n34] = this.objVectors.sbOrg[n33];
                                this.objVectors.srOrg[n34] = this.objVectors.srOrg[n33];
                                this.objVectors.sgOrg[n34] = this.objVectors.sgOrg[n33];
                                n34 = this.objMesh.points[n11][2];
                                this.objVectors.sbOrg[n34] = this.objVectors.sbOrg[n33];
                                this.objVectors.srOrg[n34] = this.objVectors.srOrg[n33];
                                this.objVectors.sgOrg[n34] = this.objVectors.sgOrg[n33];
                            }
                            float f91 = this.objVectors.sz[n28];
                            if (this.objVectors.zTr[n28] > f10) {
                                if (f91 == -1.01f) {
                                    f91 = 1.0f / this.objVectors.zTr[n28];
                                    fArray7[n28] = f3 * (fArray3[n28] * f91) + f11;
                                    fArray8[n28] = f4 * (fArray4[n28] * f91) + f12;
                                    fArray6[n28] = f91;
                                }
                                if (fArray7[n28] < 0.0f) {
                                    ++n6;
                                } else if (fArray7[n28] > (float)n13) {
                                    ++n7;
                                }
                                if (fArray8[n28] < 0.0f) {
                                    ++n8;
                                } else if (fArray8[n28] > (float)n14) {
                                    ++n9;
                                }
                                if (n22 == -2) {
                                    n22 = -1;
                                }
                            } else {
                                ++n31;
                                if (n22 == -1) {
                                    n22 = n30;
                                }
                            }
                            if (!this.isEnvmapped || this.isBlended && bl2) {
                                if (!bl2 && fArray5[n28] > f10) {
                                    fArray9[n29] = fArray13[n29] * f91;
                                    fArray10[n29] = fArray14[n29] * f91;
                                }
                            } else {
                                if (!this.useCSEnvmapping) {
                                    switch (this.envMapDir) {
                                        case 1: {
                                            f13 = fArray24[n28];
                                            f14 = fArray25[n28];
                                            break;
                                        }
                                        case 2: {
                                            f13 = fArray24[n28];
                                            f14 = fArray26[n28];
                                            break;
                                        }
                                        case 3: {
                                            f13 = fArray25[n28];
                                            f14 = fArray26[n28];
                                        }
                                    }
                                } else {
                                    switch (this.envMapDir) {
                                        case 1: {
                                            f13 = fArray21[n28];
                                            f14 = fArray22[n28];
                                            break;
                                        }
                                        case 2: {
                                            f13 = fArray21[n28];
                                            f14 = fArray23[n28];
                                            break;
                                        }
                                        case 3: {
                                            f13 = fArray22[n28];
                                            f14 = fArray23[n28];
                                        }
                                    }
                                }
                                float f92 = (float)n19 + f13 * this.invScaleFactor * (float)n19;
                                f80 = (float)n18 + f14 * this.invScaleFactor * (float)n18;
                                if (f92 > (float)n21) {
                                    f92 = n21;
                                } else if (f92 < 0.0f) {
                                    f92 = 0.0f;
                                }
                                if (f80 > (float)n20) {
                                    f80 = n20;
                                } else if (f80 < 0.0f) {
                                    f80 = 0.0f;
                                }
                                if (fArray5[n28] > f10) {
                                    fArray9[n29] = f92 * f91;
                                    fArray10[n29] = f80 * f91;
                                    if (this.objVectors.bsu == null) {
                                        this.objVectors.createBumpmapCoords();
                                    }
                                    this.objVectors.bsu[n29] = this.objVectors.buOrg[n29] * f91;
                                    this.objVectors.bsv[n29] = this.objVectors.bvOrg[n29] * f91;
                                }
                                if (this.objVectors.eu == null) {
                                    this.objVectors.createEnvmapCoords();
                                }
                                this.objVectors.eu[n29] = f92;
                                this.objVectors.ev[n29] = f80;
                            }
                            if (bl2) continue;
                            fArray17[n29] = fArray20[n29] * f91;
                            fArray16[n29] = fArray19[n29] * f91;
                            fArray15[n29] = fArray18[n29] * f91;
                        }
                        if (bl2 && n31 != 0 && n31 < 3) {
                            n31 = 0;
                        }
                        if (n31 != 0 && n22 == -1) {
                            n22 = 0;
                        }
                        if (n31 == 2) {
                            n30 = n22;
                            n29 = n30 - 1;
                            if (n29 == -1) {
                                n29 = 2;
                            }
                            if ((n28 = n30 + 1) == 3) {
                                n28 = 0;
                            }
                            int n35 = nArray2[n11][n29];
                            int n36 = nArray3[n35];
                            int n37 = nArray2[n11][n30];
                            int n38 = nArray3[n37];
                            int n39 = nArray2[n11][n28];
                            int n40 = nArray3[n39];
                            if (this.isEnvmapped) {
                                f70 = this.objVectors.eu[n35];
                                f69 = this.objVectors.ev[n35];
                                f68 = this.objVectors.eu[n37];
                                f67 = this.objVectors.ev[n37];
                                f66 = this.objVectors.eu[n39];
                                f65 = this.objVectors.ev[n39];
                            } else {
                                f70 = fArray13[n35];
                                f69 = fArray14[n35];
                                f68 = fArray13[n37];
                                f67 = fArray14[n37];
                                f66 = fArray13[n39];
                                f65 = fArray14[n39];
                            }
                            f79 = (f10 - fArray5[n36]) / (fArray5[n38] - fArray5[n36]);
                            f78 = fArray3[n36] + f79 * (fArray3[n38] - fArray3[n36]);
                            float f93 = fArray4[n36] + f79 * (fArray4[n38] - fArray4[n36]);
                            float f94 = f70 + f79 * (f68 - f70);
                            f77 = f69 + f79 * (f67 - f69);
                            f76 = this.objVectors.buOrg[n35] + f79 * (this.objVectors.buOrg[n37] - this.objVectors.buOrg[n35]);
                            f75 = this.objVectors.bvOrg[n35] + f79 * (this.objVectors.bvOrg[n37] - this.objVectors.bvOrg[n35]);
                            f74 = fArray20[n35] + f79 * (fArray20[n37] - fArray20[n35]);
                            f73 = fArray18[n35] + f79 * (fArray18[n37] - fArray18[n35]);
                            f72 = fArray19[n35] + f79 * (fArray19[n37] - fArray19[n35]);
                            f71 = 1.0f / f10;
                            f64 = f3 * (f78 * f71) + f11;
                            f63 = f4 * (f93 * f71) + f12;
                            f62 = f94 * f71;
                            f61 = f77 * f71;
                            f60 = f76 * f71;
                            f59 = f75 * f71;
                            f58 = f74 * f71;
                            f57 = f73 * f71;
                            f56 = f72 * f71;
                            f79 = (f10 - fArray5[n36]) / (fArray5[n40] - fArray5[n36]);
                            f78 = fArray3[n36] + f79 * (fArray3[n40] - fArray3[n36]);
                            f93 = fArray4[n36] + f79 * (fArray4[n40] - fArray4[n36]);
                            float f95 = 1.0f / f10;
                            float f96 = f3 * (f78 * f95) + f11;
                            float f97 = f4 * (f93 * f95) + f12;
                            n27 = 0;
                            int n41 = 0;
                            int n42 = 0;
                            int n43 = 0;
                            if (fArray7[n36] < 0.0f) {
                                ++n27;
                            } else if (fArray7[n36] > (float)n13) {
                                ++n41;
                            }
                            if (fArray8[n36] < 0.0f) {
                                ++n42;
                            } else if (fArray8[n36] > (float)n14) {
                                ++n43;
                            }
                            if (f64 < 0.0f) {
                                ++n27;
                            } else if (f64 > (float)n13) {
                                ++n41;
                            }
                            if (f63 < 0.0f) {
                                ++n42;
                            } else if (f63 > (float)n14) {
                                ++n43;
                            }
                            if (f96 < 0.0f) {
                                ++n27;
                            } else if (f96 > (float)n13) {
                                ++n41;
                            }
                            if (f97 < 0.0f) {
                                ++n42;
                            } else if (f97 > (float)n14) {
                                ++n43;
                            }
                            if (n27 < 3 && n42 < 3 && n41 < 3 && n43 < 3) {
                                f94 = f70 + f79 * (f66 - f70);
                                f77 = f69 + f79 * (f65 - f69);
                                f76 = this.objVectors.buOrg[n35] + f79 * (this.objVectors.buOrg[n39] - this.objVectors.buOrg[n35]);
                                f75 = this.objVectors.bvOrg[n35] + f79 * (this.objVectors.bvOrg[n39] - this.objVectors.bvOrg[n35]);
                                f74 = fArray20[n35] + f79 * (fArray20[n39] - fArray20[n35]);
                                f73 = fArray18[n35] + f79 * (fArray18[n39] - fArray18[n35]);
                                f72 = fArray19[n35] + f79 * (fArray19[n39] - fArray19[n35]);
                                f55 = f94 * f95;
                                f54 = f77 * f95;
                                f53 = f76 * f95;
                                f52 = f75 * f95;
                                f51 = f74 * f95;
                                f50 = f73 * f95;
                                float f98 = f72 * f95;
                                visList.addToList(this.myWorld.clippedPolys, this, this.myWorld.clippedPolys.objMesh.anzTri, n11, (f17 + f20 + f23 + f36) * 0.33333334f, 99999999, bl);
                                this.addClippedPoly(n11, fArray7[n36], fArray8[n36], fArray6[n36], fArray9[n35], fArray10[n35], fArray16[n35], fArray15[n35], fArray17[n35], f64, f63, f71, f62, f61, f56, f57, f58, f96, f97, f95, f55, f54, f98, f50, f51, fArray11[n35], fArray12[n35], f60, f59, f53, f52);
                            }
                            bl4 = true;
                        } else if (n31 == 1) {
                            n30 = n22;
                            n29 = n30 - 1;
                            if (n29 == -1) {
                                n29 = 2;
                            }
                            if ((n28 = n30 + 1) == 3) {
                                n28 = 0;
                            }
                            int n44 = nArray2[n11][n29];
                            int n45 = nArray3[n44];
                            int n46 = nArray2[n11][n30];
                            int n47 = nArray3[n46];
                            int n48 = nArray2[n11][n28];
                            int n49 = nArray3[n48];
                            if (this.isEnvmapped) {
                                f70 = this.objVectors.eu[n44];
                                f69 = this.objVectors.ev[n44];
                                f68 = this.objVectors.eu[n46];
                                f67 = this.objVectors.ev[n46];
                                f66 = this.objVectors.eu[n48];
                                f65 = this.objVectors.ev[n48];
                            } else {
                                f70 = fArray13[n44];
                                f69 = fArray14[n44];
                                f68 = fArray13[n46];
                                f67 = fArray14[n46];
                                f66 = fArray13[n48];
                                f65 = fArray14[n48];
                            }
                            f79 = (f10 - fArray5[n45]) / (fArray5[n47] - fArray5[n45]);
                            f78 = fArray3[n45] + f79 * (fArray3[n47] - fArray3[n45]);
                            float f99 = fArray4[n45] + f79 * (fArray4[n47] - fArray4[n45]);
                            float f100 = f70 + f79 * (f68 - f70);
                            f77 = f69 + f79 * (f67 - f69);
                            f76 = this.objVectors.buOrg[n44] + f79 * (this.objVectors.buOrg[n46] - this.objVectors.buOrg[n44]);
                            f75 = this.objVectors.bvOrg[n44] + f79 * (this.objVectors.bvOrg[n46] - this.objVectors.bvOrg[n44]);
                            f74 = fArray20[n44] + f79 * (fArray20[n46] - fArray20[n44]);
                            f73 = fArray18[n44] + f79 * (fArray18[n46] - fArray18[n44]);
                            f72 = fArray19[n44] + f79 * (fArray19[n46] - fArray19[n44]);
                            f71 = 1.0f / f10;
                            f64 = f3 * (f78 * f71) + f11;
                            f63 = f4 * (f99 * f71) + f12;
                            f62 = f100 * f71;
                            f61 = f77 * f71;
                            f60 = f76 * f71;
                            f59 = f75 * f71;
                            f58 = f74 * f71;
                            f57 = f73 * f71;
                            f56 = f72 * f71;
                            int n50 = 0;
                            int n51 = 0;
                            int n52 = 0;
                            n27 = 0;
                            if (this.objVectors.sx[n45] < 0.0f) {
                                ++n50;
                            } else if (this.objVectors.sx[n45] > (float)n13) {
                                ++n51;
                            }
                            if (this.objVectors.sy[n45] < 0.0f) {
                                ++n52;
                            } else if (this.objVectors.sy[n45] > (float)n14) {
                                ++n27;
                            }
                            if (f64 < 0.0f) {
                                ++n50;
                            } else if (f64 > (float)n13) {
                                ++n51;
                            }
                            if (f63 < 0.0f) {
                                ++n52;
                            } else if (f63 > (float)n14) {
                                ++n27;
                            }
                            if (this.objVectors.sx[n49] < 0.0f) {
                                ++n50;
                            } else if (this.objVectors.sx[n49] > (float)n13) {
                                ++n51;
                            }
                            if (this.objVectors.sy[n49] < 0.0f) {
                                ++n52;
                            } else if (this.objVectors.sy[n49] > (float)n14) {
                                ++n27;
                            }
                            if (n50 < 3 && n52 < 3 && n51 < 3 && n27 < 3) {
                                visList.addToList(this.myWorld.clippedPolys, this, this.myWorld.clippedPolys.objMesh.anzTri, n11, (f17 + f20 + f23 + f36) * 0.33333334f, 99999999, bl);
                                this.addClippedPoly(n11, fArray7[n45], fArray8[n45], fArray6[n45], fArray9[n44], fArray10[n44], fArray16[n44], fArray15[n44], fArray17[n44], f64, f63, f71, f62, f61, f56, f57, f58, fArray7[n49], fArray8[n49], fArray6[n49], fArray9[n48], fArray10[n48], fArray16[n48], fArray15[n48], fArray17[n48], fArray11[n44], fArray12[n44], f60, f59, fArray11[n48], fArray12[n48]);
                            }
                            f79 = (f10 - fArray5[n49]) / (fArray5[n47] - fArray5[n49]);
                            f78 = this.objVectors.xTr[n49] + f79 * (fArray3[n47] - fArray3[n49]);
                            f99 = this.objVectors.yTr[n49] + f79 * (fArray4[n47] - fArray4[n49]);
                            float f101 = f3 * (f78 * f71) + f11;
                            float f102 = f4 * (f99 * f71) + f12;
                            n50 = 0;
                            n51 = 0;
                            n52 = 0;
                            n27 = 0;
                            if (f101 < 0.0f) {
                                ++n50;
                            } else if (f101 > (float)n13) {
                                ++n51;
                            }
                            if (f102 < 0.0f) {
                                ++n52;
                            } else if (f102 > (float)n14) {
                                ++n27;
                            }
                            if (f64 < 0.0f) {
                                ++n50;
                            } else if (f64 > (float)n13) {
                                ++n51;
                            }
                            if (f63 < 0.0f) {
                                ++n52;
                            } else if (f63 > (float)n14) {
                                ++n27;
                            }
                            if (fArray7[n49] < 0.0f) {
                                ++n50;
                            } else if (fArray7[n49] > (float)n13) {
                                ++n51;
                            }
                            if (fArray8[n49] < 0.0f) {
                                ++n52;
                            } else if (fArray8[n49] > (float)n14) {
                                ++n27;
                            }
                            if (n50 < 3 && n52 < 3 && n51 < 3 && n27 < 3) {
                                f100 = f66 + f79 * (f68 - f66);
                                f77 = f65 + f79 * (f67 - f65);
                                f76 = this.objVectors.buOrg[n48] + f79 * (this.objVectors.buOrg[n46] - this.objVectors.buOrg[n48]);
                                f75 = this.objVectors.bvOrg[n48] + f79 * (this.objVectors.bvOrg[n46] - this.objVectors.bvOrg[n48]);
                                f74 = fArray20[n48] + f79 * (fArray20[n46] - fArray20[n48]);
                                f73 = this.objVectors.sgOrg[n48] + f79 * (fArray18[n46] - fArray18[n48]);
                                f72 = this.objVectors.srOrg[n48] + f79 * (fArray19[n46] - fArray19[n48]);
                                float f103 = f100 * f71;
                                f55 = f77 * f71;
                                f54 = f76 * f71;
                                f53 = f75 * f71;
                                f52 = f74 * f71;
                                f51 = f73 * f71;
                                f50 = f72 * f71;
                                visList.addToList(this.myWorld.clippedPolys, this, this.myWorld.clippedPolys.objMesh.anzTri, n11, (f17 + f20 + f23 + f36) * 0.33333334f, 99999999, bl);
                                this.addClippedPoly(n11, f64, f63, f71, f62, f61, f56, f57, f58, f101, f102, f71, f103, f55, f50, f51, f52, fArray7[n49], fArray8[n49], fArray6[n49], fArray9[n48], fArray10[n48], fArray16[n48], fArray15[n48], fArray17[n48], f60, f59, f54, f53, fArray11[n48], fArray12[n48]);
                            }
                            bl4 = true;
                        } else if (n31 != 0) {
                            bl4 = true;
                        }
                    }
                    if (bl4 || n6 >= 3 || n8 >= 3 || n7 >= 3 || n9 >= 3) continue;
                    int n53 = 0;
                    if (!this.dynSectorDetect) {
                        n53 = !this.oneSectorOnly && this.sector != null ? this.sector[n11] : this.singleSectorNumber;
                    } else if (this.sectorCnt == 1) {
                        n53 = this.dynSectorList[1];
                    } else {
                        for (n22 = 1; n22 <= this.sectorCnt; ++n22) {
                            if (this.dynSectorList[n22] != n5) continue;
                            n53 = n5;
                            break;
                        }
                    }
                    n22 = 99999999;
                    if (Config.doPortalHsr && n53 != n5 && n53 != 0) {
                        n22 = this.myWorld.portals.testAgainstPortals(this, n25, n24, n23, n11);
                    }
                    if (n22 == -1) continue;
                    if (!bl2) {
                        visList.addToList(this, this, n11, n11, (f17 + f20 + f23 + f36) * 0.33333334f, n22, 0, bl);
                        continue;
                    }
                    if (this.isTrans && !this.isBumpmapped) {
                        n21 = 0;
                        if (this.usesMultiTexturing) {
                            for (n20 = 0; n20 < this.maxStagesUsed - 1 && this.multiTex[n20][n11] != -1; ++n20) {
                                ++n21;
                            }
                        }
                        visList.addToList(this, this, n11, n11, (f17 + f20 + f23 + f36) * 0.33333334f, n22, n21, bl);
                        continue;
                    }
                    n21 = this.texture[n11];
                    n20 = 0;
                    if (this.usesMultiTexturing) {
                        for (n19 = 0; n19 < this.maxStagesUsed - 1 && (n18 = this.multiTex[n19][n11]) != -1; ++n19) {
                            n21 += n18 << this.multiMode[n19][n11];
                            ++n20;
                        }
                    }
                    visList.addToList(this, this, n11, n11, 99999 - n21, n22, n20, bl);
                } while (!bl5 && ++n11 < this.objMesh.anzTri || bl5 && n16 < n17);
            } while (bl5 && n15 < this.ocTree.getLeafCount());
        }
    }

    boolean getLazyTransformationState() {
        return this.lazyTransforms;
    }

    public Matrix getInverseWorldTransformation() {
        Matrix matrix;
        Matrix matrix2 = this.getWorldTransformation();
        if (!this.lazyTransforms || this.invCache == null) {
            matrix = matrix2.invert();
            if (this.lazyTransforms) {
                this.invCache = matrix.cloneMatrix();
            }
        } else {
            matrix = this.invCache.cloneMatrix();
        }
        return matrix;
    }

    public Matrix getInverseWorldTransformation(Matrix matrix) {
        if (matrix == null) {
            matrix = new Matrix();
        }
        Matrix matrix2 = this.getWorldTransformation(matrix);
        if (!this.lazyTransforms || this.invCache == null) {
            matrix2 = matrix2.invert(matrix);
            if (this.lazyTransforms) {
                this.invCache = matrix2.cloneMatrix();
            }
            if (matrix != matrix2) {
                matrix.setTo(matrix2);
            }
        } else {
            matrix.setTo(this.invCache);
        }
        return matrix;
    }

    final void setThisAsMain() {
        if (this.myWorld != null) {
            for (int i = 0; i < this.myWorld.objectList.size(); ++i) {
                this.myWorld.objectList.elementAt((int)i).isMainWorld = false;
                this.myWorld.objectList.elementAt((int)i).oneSectorOnly = true;
            }
            this.isMainWorld = true;
            this.oneSectorOnly = false;
            this.singleSectorNumber = -1;
        } else {
            Logger.log("Error: An object that isn't part of the world can't be assigned as main. Add the object to the world before performing this operation.", 0);
        }
    }

    private final void appendToObject(Object3D object3D) {
        int n;
        int n2;
        int n3;
        Object3D object3D2 = object3D;
        int n4 = object3D2.objMesh.anzVectors;
        int n5 = object3D2.objMesh.anzCoords;
        int n6 = object3D2.objMesh.anzTri;
        int n7 = object3D2.sectorCnt;
        if (this.objVectors != null && this.objVectors.uMul != null) {
            object3D2.usesMultiTexturing = true;
            object3D2.maxStagesUsed = Math.max(object3D2.maxStagesUsed, this.maxStagesUsed);
            object3D2.objVectors.createMultiCoords();
            for (n3 = 0; n3 < Config.maxTextureLayers - 1; ++n3) {
                for (n2 = 0; n2 < this.objMesh.anzVectors; ++n2) {
                    n = n2 + n4;
                    object3D2.objVectors.uMul[n3][n] = this.objVectors.uMul[n3][n2];
                    object3D2.objVectors.vMul[n3][n] = this.objVectors.vMul[n3][n2];
                }
            }
        }
        if (this.multiTex != null) {
            for (n3 = 0; n3 < Config.maxTextureLayers - 1; ++n3) {
                if (object3D2.multiTex == null) {
                    object3D2.multiTex = new int[Config.maxTextureLayers - 1][object3D2.texture.length];
                    object3D2.multiMode = new int[Config.maxTextureLayers - 1][object3D2.texture.length];
                }
                System.arraycopy(this.multiTex[n3], 0, object3D2.multiTex[n3], n6, this.objMesh.anzTri);
                System.arraycopy(this.multiMode[n3], 0, object3D2.multiMode[n3], n6, this.objMesh.anzTri);
            }
        }
        if (this.objMesh.anzVectors > 0 && this.objVectors.eu != null) {
            object3D2.objVectors.createEnvmapCoords();
        }
        for (n3 = 0; n3 < this.objMesh.anzVectors; ++n3) {
            n2 = n3 + n4;
            object3D2.objVectors.sbOrg[n2] = this.objVectors.sbOrg[n3];
            object3D2.objVectors.srOrg[n2] = this.objVectors.srOrg[n3];
            object3D2.objVectors.sgOrg[n2] = this.objVectors.sgOrg[n3];
            object3D2.objVectors.nuOrg[n2] = this.objVectors.nuOrg[n3];
            object3D2.objVectors.nvOrg[n2] = this.objVectors.nvOrg[n3];
            object3D2.objVectors.uOrg[n2] = this.objVectors.uOrg[n3];
            object3D2.objVectors.vOrg[n2] = this.objVectors.vOrg[n3];
            if (this.objVectors.eu != null) {
                object3D2.objVectors.eu[n2] = this.objVectors.eu[n3];
                object3D2.objVectors.ev[n2] = this.objVectors.ev[n3];
            }
            if (this.objVectors.alpha != null) {
                object3D2.objVectors.alpha[n2] = this.objVectors.alpha[n3];
            }
            object3D2.objVectors.buOrg[n2] = this.objVectors.buOrg[n3];
            object3D2.objVectors.bvOrg[n2] = this.objVectors.bvOrg[n3];
            object3D2.objVectors.vertexSector[n2] = this.objVectors.vertexSector[n3];
            object3D2.objMesh.coords[n2] = this.objMesh.coords[n3] + n5;
        }
        for (n3 = 0; n3 < this.objMesh.anzTri; ++n3) {
            n2 = n3 + n6;
            object3D2.objMesh.points[n2][0] = this.objMesh.points[n3][0] + n4;
            object3D2.objMesh.points[n2][1] = this.objMesh.points[n3][1] + n4;
            object3D2.objMesh.points[n2][2] = this.objMesh.points[n3][2] + n4;
        }
        n3 = this.objMesh.anzCoords;
        if (this.objMesh.obbStart != 0) {
            n3 = this.objMesh.obbStart;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2 + n5;
            object3D2.objMesh.xOrg[n] = this.objMesh.xOrg[n2];
            object3D2.objMesh.yOrg[n] = this.objMesh.yOrg[n2];
            object3D2.objMesh.zOrg[n] = this.objMesh.zOrg[n2];
            object3D2.objMesh.nxOrg[n] = this.objMesh.nxOrg[n2];
            object3D2.objMesh.nyOrg[n] = this.objMesh.nyOrg[n2];
            object3D2.objMesh.nzOrg[n] = this.objMesh.nzOrg[n2];
        }
        n2 = this.objMesh.anzTri;
        if (this.texture != null) {
            System.arraycopy(this.texture, 0, object3D2.texture, n6, n2);
        }
        if (this.sector != null) {
            System.arraycopy(this.sector, 0, object3D2.sector, n6, n2);
        }
        if (this.bumpmap != null) {
            System.arraycopy(this.bumpmap, 0, object3D2.bumpmap, n6, n2);
        }
        if (this.basemap != null) {
            System.arraycopy(this.basemap, 0, object3D2.basemap, n6, n2);
        }
        if (this.sectorStartPoint != null) {
            System.arraycopy(this.sectorStartPoint, 0, object3D2.sectorStartPoint, n7, this.sectorCnt);
        }
        if (this.sectorEndPoint != null) {
            System.arraycopy(this.sectorEndPoint, 0, object3D2.sectorEndPoint, n7, this.sectorCnt);
        }
        if (this.sectorStartPoly != null) {
            System.arraycopy(this.sectorStartPoly, 0, object3D2.sectorStartPoly, n7, this.sectorCnt);
        }
        if (this.sectorEndPoly != null) {
            System.arraycopy(this.sectorEndPoly, 0, object3D2.sectorEndPoly, n7, this.sectorCnt);
        }
        object3D2.objMesh.anzTri += this.objMesh.anzTri;
        object3D2.objMesh.anzCoords += n3;
        object3D2.objMesh.anzVectors += this.objMesh.anzVectors;
    }

    private final void switchTriangles(int n, int n2) {
        int n3;
        if (this.sector != null) {
            n3 = this.sector[n];
            this.sector[n] = this.sector[n2];
            this.sector[n2] = n3;
        }
        n3 = this.texture[n];
        this.texture[n] = this.texture[n2];
        this.texture[n2] = n3;
        if (this.usesMultiTexturing) {
            for (int i = 0; i < this.maxStagesUsed - 1; ++i) {
                n3 = this.multiTex[i][n];
                this.multiTex[i][n] = this.multiTex[i][n2];
                this.multiTex[i][n2] = n3;
                n3 = this.multiMode[i][n];
                this.multiMode[i][n] = this.multiMode[i][n2];
                this.multiMode[i][n2] = n3;
            }
        }
        n3 = this.basemap[n];
        this.basemap[n] = this.basemap[n2];
        this.basemap[n2] = n3;
        if (this.bumpmap != null) {
            n3 = this.bumpmap[n];
            this.bumpmap[n] = this.bumpmap[n2];
            this.bumpmap[n2] = n3;
        }
        int[] nArray = this.objMesh.points[n];
        this.objMesh.points[n] = this.objMesh.points[n2];
        this.objMesh.points[n2] = nArray;
    }

    final void getProjectedPoint(float f, float f2, float f3, SimpleVector simpleVector, float[] fArray) {
        Matrix matrix = this.getWorldTransformation();
        float f4 = matrix.mat[0][0];
        float f5 = matrix.mat[1][0];
        float f6 = matrix.mat[1][1];
        float f7 = matrix.mat[2][1];
        float f8 = matrix.mat[2][0];
        float f9 = matrix.mat[0][1];
        float f10 = matrix.mat[2][2];
        float f11 = matrix.mat[1][2];
        float f12 = matrix.mat[0][2];
        float f13 = matrix.mat[3][0];
        float f14 = matrix.mat[3][1];
        float f15 = matrix.mat[3][2];
        float f16 = f * f4 + f2 * f5 + f3 * f8 + f13;
        float f17 = f * f9 + f2 * f6 + f3 * f7 + f14;
        float f18 = f * f12 + f2 * f11 + f3 * f10 + f15;
        if (simpleVector != null) {
            simpleVector.x = f16;
            simpleVector.y = f17;
            simpleVector.z = f18;
        }
        if (fArray != null) {
            fArray[0] = f16;
            fArray[1] = f17;
            fArray[2] = f18;
        }
    }

    void notifyCollisionListeners(int n, int n2, Object3D[] object3DArray, SimpleVector simpleVector) {
        this.notifyCollisionListeners(null, n, n2, object3DArray, simpleVector);
    }

    void notifyCollisionListeners(Object3D object3D, int n, int n2, Object3D[] object3DArray, SimpleVector simpleVector) {
        if (this.collisionListener == null || this.disableListeners) {
            return;
        }
        CollisionEvent collisionEvent = new CollisionEvent(this, object3D, n, n2, object3DArray, simpleVector);
        int n3 = this.collisionListener.size();
        for (int i = 0; i < n3; ++i) {
            CollisionListener collisionListener = (CollisionListener)this.collisionListener.elementAt(i);
            if (collisionListener.requiresPolygonIDs() && collisionEvent.getPolygonIDs() == null) {
                collisionEvent.setPolygonIDs(this.polygonIDs, this.pIDCount);
            }
            collisionListener.collision(collisionEvent);
        }
    }

    void reallyStrip() {
        this.stripped = true;
        this.toStrip = false;
        this.objVectors.strip();
        this.objMesh.strongStrip(this.myWorld, this);
    }

    void resetPolygonIDCount() {
        this.pIDCount = 0;
        this.lastAddedID = -1;
    }

    private void addPolygonID(int n) {
        if (this.collisionListener == null || this.disableListeners) {
            return;
        }
        if (this.polygonIDs == null) {
            this.polygonIDs = new int[Config.polygonIDLimit];
            this.pIDCount = 0;
        }
        if (this.pIDCount < this.polygonIDs.length) {
            if (n == this.lastAddedID) {
                return;
            }
            for (int i = 0; i < this.pIDCount; ++i) {
                if (this.polygonIDs[i] != n) continue;
                return;
            }
            this.polygonIDs[this.pIDCount] = n;
            this.lastAddedID = n;
            ++this.pIDCount;
        }
    }

    private Matrix getCachedMatrix(int n) {
        if (!this.useMatrixCache) {
            return new Matrix();
        }
        Matrix[] matrixArray = (Matrix[])this.matrixCache.get(Thread.currentThread());
        if (matrixArray == null) {
            matrixArray = new Matrix[]{new Matrix(), new Matrix()};
            this.matrixCache.put(Thread.currentThread(), matrixArray);
        }
        if (this.matrixCache.size() > 50) {
            this.matrixCache.clear();
        }
        matrixArray[n].setIdentity();
        return matrixArray[n];
    }

    private void checkBumpmap() {
        if (this.bumpmap == null) {
            this.bumpmap = new int[this.texture.length];
        }
    }

    private void compileInternal() {
        if (this.compiled == null) {
            this.compiled = new Vector();
        }
        if (!this.hasBeenBuild && Config.autoBuild) {
            this.build();
        }
        Config.lightMul = 1;
        Config.glVertexArrays = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mat2 = new Matrix();
        this.mat3 = new Matrix();
        this.mat5 = new Matrix();
        this.mat6 = new Matrix();
        this.matrixCache = new Hashtable(3);
        this.transBuffer = new Matrix();
        this.xWs = new float[8];
        this.yWs = new float[8];
        this.zWs = new float[8];
    }
}

