/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Object3D;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

final class Object3DList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object3D[] objList = null;
    private int SIZE = 100;
    private int count = 0;

    Object3DList() {
        this.objList = new Object3D[this.SIZE];
    }

    Object3DList(int n) {
        this.SIZE = n;
        this.objList = new Object3D[n];
    }

    int size() {
        return this.count;
    }

    void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.objList[i] = null;
        }
        if (this.objList.length > 1000) {
            this.objList = new Object3D[this.SIZE];
        }
        this.count = 0;
    }

    Object3D[] toArray() {
        Object3D[] object3DArray = new Object3D[this.count];
        System.arraycopy(this.objList, 0, object3DArray, 0, this.count);
        return object3DArray;
    }

    synchronized void addElement(Object3D object3D) {
        if (this.count >= this.objList.length) {
            Object3D[] object3DArray = new Object3D[this.SIZE + this.objList.length];
            System.arraycopy(this.objList, 0, object3DArray, 0, this.objList.length);
            this.objList = object3DArray;
        }
        this.objList[this.count] = object3D;
        ++this.count;
    }

    Object3D elementAt(int n) {
        return this.objList[n];
    }

    void removeElementAt(int n) {
        if (n + 1 < this.count) {
            System.arraycopy(this.objList, n + 1, this.objList, n, this.count - n - 1);
        }
        --this.count;
        this.objList[this.count] = null;
    }

    boolean contains(Object3D object3D) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.objList[i].equals(object3D)) continue;
            return true;
        }
        return false;
    }

    boolean removeElement(Object3D object3D) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.objList[i].equals(object3D)) continue;
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    Enumeration elements() {
        return new Enumeration(){
            int cnt = 0;

            public boolean hasMoreElements() {
                return this.cnt < Object3DList.this.count;
            }

            public Object nextElement() {
                if (this.cnt < Object3DList.this.count) {
                    return Object3DList.this.objList[this.cnt++];
                }
                throw new NoSuchElementException("ObjList Enumeration");
            }
        };
    }
}

