/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLBase;
import com.threed.jpct.GLRenderer;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Texture;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class TextureManager {
    public static final int TEXTURE_NOTFOUND = -1;
    static final String DUMMY_NAME = "--dummy--";
    Texture[] textures;
    private Texture dummy;
    private static TextureManager myInstance = null;
    private int textureCount;
    private Hashtable textureList;
    private int lastID = -1;
    private String lastName = null;

    private TextureManager() {
        this.flush();
    }

    public static synchronized TextureManager getInstance() {
        if (myInstance == null) {
            myInstance = new TextureManager();
        }
        return myInstance;
    }

    public Vector getState() {
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < this.textureCount; ++i) {
            Texture texture = this.textures[i];
            String string = this.getNameByID(i);
            Object[] objectArray = new Object[]{string, texture};
            vector.addElement(objectArray);
        }
        return vector;
    }

    public void setState(Vector vector) {
        this.flush();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray = (Object[])vector.elementAt(i);
                String string = (String)objectArray[0];
                Texture texture = (Texture)objectArray[1];
                if (string.equals(DUMMY_NAME)) continue;
                this.addTexture(string, texture);
            }
        }
        catch (Exception exception) {
            Logger.log("Not a valid dump!", 0);
        }
    }

    public long getMemoryUsage(boolean bl) {
        long l = 0L;
        for (int i = 0; i < this.textureCount; ++i) {
            int[] nArray = this.textures[i].texels;
            int[] nArray2 = this.textures[i].alpha;
            if (nArray != null) {
                l += (long)(nArray.length << 2);
            }
            if (nArray2 != null) {
                l += (long)(nArray2.length << 2);
            }
            if (bl || nArray != null) continue;
            l += (long)(this.textures[i].width * this.textures[i].height << 2);
        }
        return l;
    }

    public void addTexture(String string) {
        this.addTexture(string, this.dummy);
    }

    public synchronized void addTexture(String string, Texture texture) {
        if (this.textureCount >= this.textures.length) {
            Texture[] textureArray = new Texture[this.textures.length * 2];
            System.arraycopy(this.textures, 0, textureArray, 0, this.textures.length);
            this.textures = textureArray;
        }
        if (!this.textureList.containsKey(string)) {
            this.textures[this.textureCount] = texture;
            this.textureList.put(string, IntegerC.valueOf(this.textureCount));
            ++this.textureCount;
        } else {
            Logger.log("A texture with the name '" + string + "' has been declared twice!", 0);
        }
    }

    public void unloadTexture(FrameBuffer frameBuffer, Texture texture) {
        if (frameBuffer.glRend != null) {
            ((GLBase)((Object)frameBuffer.glRend)).addForUnload(texture);
        }
    }

    public synchronized void removeTexture(String string) {
        Texture texture = this.getTexture(string);
        for (int i = 0; i < this.textureCount; ++i) {
            if (texture != this.textures[i]) continue;
            this.textureList.remove(string);
            this.textures[i] = this.dummy;
            if (i != this.textureCount - 1) continue;
            --this.textureCount;
        }
    }

    public void removeAndUnload(String string, FrameBuffer frameBuffer) {
        this.unloadTexture(frameBuffer, this.getTexture(string));
        this.removeTexture(string);
    }

    Texture[] getTextures() {
        return this.textures;
    }

    public synchronized void replaceTexture(String string, Texture texture) {
        int n = this.getTextureID(string);
        if (n != -1) {
            this.textures[n] = texture;
        } else {
            Logger.log("Texture '" + string + "' not found!", 0);
        }
    }

    public synchronized void replaceTexture(int n, Texture texture) {
        if (n != -1 && n < this.textures.length) {
            this.textures[n] = texture;
        } else {
            Logger.log("Texture '" + n + "' not found!", 0);
        }
    }

    public void flush() {
        this.textureList = new Hashtable();
        this.textures = new Texture[Config.maxTextures];
        this.dummy = new Texture();
        this.textureCount = 0;
        this.addTexture(DUMMY_NAME, this.dummy);
    }

    public void preWarm(FrameBuffer frameBuffer) {
        Texture texture;
        boolean bl = false;
        if (frameBuffer.usesRenderer(1)) {
            for (int i = 0; i < this.textureCount; ++i) {
                Texture texture2 = this.textures[i];
                if (texture2 == null) continue;
                texture = texture2.getMipMappedTexture(1);
                bl = true;
            }
        }
        if (frameBuffer.usesRenderer(2) && frameBuffer.glRend != null && frameBuffer.glRend instanceof GLRenderer) {
            GLRenderer gLRenderer = (GLRenderer)frameBuffer.glRend;
            for (int i = 0; i < this.textureCount; ++i) {
                texture = this.textures[i];
                if (texture == null) continue;
                gLRenderer.upload(texture);
                bl = true;
            }
        }
        if (bl) {
            Logger.log("Pre-warming done!");
        }
    }

    public void setDummyTexture(Texture texture) {
        if (texture != null) {
            this.dummy = texture;
            this.replaceTexture(DUMMY_NAME, texture);
        } else {
            Logger.log("Texture can't be null!", 0);
        }
    }

    public Texture getDummyTexture() {
        return this.dummy;
    }

    public boolean containsTexture(String string) {
        return this.textureList.containsKey(string);
    }

    public int getTextureCount() {
        return this.textureList.size();
    }

    public synchronized int getTextureID(String string) {
        if (string.equals(this.lastName)) {
            return this.lastID;
        }
        Object v = this.textureList.get(string);
        if (v != null) {
            this.lastID = (Integer)v;
            this.lastName = string;
            return this.lastID;
        }
        return -1;
    }

    public Texture getTextureByID(int n) {
        return this.getTexture(this.getNameByID(n));
    }

    public synchronized Texture getTexture(String string) {
        int n;
        if (string != null && (n = this.getTextureID(string)) != -1) {
            return this.textures[n];
        }
        Logger.log("Requested texture (" + string + ") not found!", 0);
        return null;
    }

    public Enumeration getNames() {
        return this.textureList.keys();
    }

    synchronized void flushOpenGLIDs(int n) {
        Enumeration enumeration = this.textureList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Texture texture = this.getTexture(string);
            if (texture != null) {
                texture.clearIDs(n);
                continue;
            }
            Logger.log("Texture '" + string + "' is supposed to be there, but couldn't be found!?", 1);
        }
    }

    public synchronized String getNameByID(int n) {
        Enumeration enumeration = this.textureList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = (Integer)this.textureList.get(string);
            if (n2 != n) continue;
            return string;
        }
        return null;
    }
}

