/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Mesh;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

final class Vectors
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient float[] xTr;
    transient float[] yTr;
    transient float[] zTr;
    transient float[] sx;
    transient float[] sy;
    transient float[] sz;
    transient float[] sb;
    transient float[] sr;
    transient float[] sg;
    float[] sbOrg;
    float[] srOrg;
    float[] sgOrg;
    float[] nuOrg;
    float[] nvOrg;
    float[] uOrg;
    float[] vOrg;
    float[][] uMul;
    float[][] vMul;
    transient float[] su;
    transient float[] sv;
    transient float[] eu;
    transient float[] ev;
    float[] buOrg;
    float[] bvOrg;
    float[] alpha;
    transient float[] bsu;
    transient float[] bsv;
    int[] vertexSector;
    int maxVectors;
    boolean hasAlpha = false;
    private Mesh baseMesh;

    Vectors(int n, Mesh mesh) {
        this.baseMesh = mesh;
        this.maxVectors = n;
        this.vertexSector = new int[this.maxVectors];
        this.xTr = new float[this.maxVectors];
        this.yTr = new float[this.maxVectors];
        this.zTr = new float[this.maxVectors];
        this.sx = new float[this.maxVectors];
        this.sy = new float[this.maxVectors];
        this.sz = new float[this.maxVectors];
        this.sbOrg = new float[this.maxVectors];
        this.sgOrg = new float[this.maxVectors];
        this.srOrg = new float[this.maxVectors];
        this.uOrg = new float[this.maxVectors];
        this.vOrg = new float[this.maxVectors];
        this.nuOrg = new float[this.maxVectors];
        this.nvOrg = new float[this.maxVectors];
        this.su = new float[this.maxVectors];
        this.sv = new float[this.maxVectors];
        if (!Config.saveMemory) {
            this.sb = new float[this.maxVectors];
            this.sg = new float[this.maxVectors];
            this.sr = new float[this.maxVectors];
            this.eu = new float[this.maxVectors];
            this.ev = new float[this.maxVectors];
            this.bsu = new float[this.maxVectors];
            this.bsv = new float[this.maxVectors];
        }
        this.buOrg = new float[this.maxVectors];
        this.bvOrg = new float[this.maxVectors];
    }

    void createMultiCoords() {
        if (this.uMul == null) {
            this.uMul = new float[Config.maxTextureLayers - 1][this.maxVectors];
            this.vMul = new float[Config.maxTextureLayers - 1][this.maxVectors];
        }
    }

    void createAlpha() {
        if (this.alpha == null) {
            this.alpha = new float[this.maxVectors];
            for (int i = 0; i < this.maxVectors; ++i) {
                this.alpha[i] = 1.0f;
            }
            this.hasAlpha = true;
        }
    }

    void killMultiCoords() {
        this.uMul = null;
        this.vMul = null;
    }

    void createScreenColors() {
        if (this.sb == null) {
            this.sb = new float[this.maxVectors];
            this.sg = new float[this.maxVectors];
            this.sr = new float[this.maxVectors];
        }
    }

    void createEnvmapCoords() {
        if (this.eu == null) {
            this.eu = new float[this.maxVectors];
            this.ev = new float[this.maxVectors];
        }
    }

    void createBumpmapCoords() {
        if (this.bsu == null) {
            this.bsu = new float[this.maxVectors];
            this.bsv = new float[this.maxVectors];
        }
    }

    int checkCoords(float f, float f2, float f3, int n) {
        float[] fArray = this.baseMesh.xOrg;
        float[] fArray2 = this.baseMesh.yOrg;
        float[] fArray3 = this.baseMesh.zOrg;
        for (int i = this.baseMesh.anzCoords - 1; i >= 0; --i) {
            if (fArray[i] != f || fArray2[i] != f2 || fArray3[i] != f3 || n != 0 && n != this.vertexSector[i]) continue;
            return i;
        }
        return -1;
    }

    int addVertex(float f, float f2, float f3) {
        return this.addVertex(f, f2, f3, 0);
    }

    int addVertex(float f, float f2, float f3, int n) {
        int n2 = this.baseMesh.anzCoords++;
        this.baseMesh.xOrg[n2] = f;
        this.baseMesh.yOrg[n2] = f2;
        this.baseMesh.zOrg[n2] = f3;
        this.vertexSector[n2] = n;
        return n2;
    }

    void setMesh(Mesh mesh) {
        this.baseMesh = mesh;
    }

    void strip() {
        this.sx = null;
        this.sy = null;
        this.sz = null;
        this.sr = null;
        this.sg = null;
        this.sb = null;
        this.sbOrg = null;
        this.sgOrg = null;
        this.srOrg = null;
        this.nuOrg = null;
        this.nvOrg = null;
        this.uOrg = null;
        this.vOrg = null;
        this.su = null;
        this.sv = null;
        this.buOrg = null;
        this.bvOrg = null;
        this.bsu = null;
        this.bsv = null;
        this.uMul = null;
        this.vMul = null;
        this.alpha = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.xTr = new float[this.maxVectors];
        this.yTr = new float[this.maxVectors];
        this.zTr = new float[this.maxVectors];
        if (!Config.saveMemory) {
            this.sb = new float[this.maxVectors];
            this.sg = new float[this.maxVectors];
            this.sr = new float[this.maxVectors];
        }
        this.sx = new float[this.maxVectors];
        this.sy = new float[this.maxVectors];
        this.sz = new float[this.maxVectors];
        this.su = new float[this.maxVectors];
        this.sv = new float[this.maxVectors];
        if (!Config.saveMemory) {
            this.eu = new float[this.maxVectors];
            this.ev = new float[this.maxVectors];
            this.bsu = new float[this.maxVectors];
            this.bsv = new float[this.maxVectors];
        }
    }

    static final void calcCross(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[1] * fArray3[2] - fArray2[2] * fArray3[1];
        fArray[1] = fArray2[2] * fArray3[0] - fArray2[0] * fArray3[2];
        fArray[2] = fArray2[0] * fArray3[1] - fArray2[1] * fArray3[0];
    }

    static final float[] calcCross(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[1] * fArray2[2] - fArray[2] * fArray2[1], fArray[2] * fArray2[0] - fArray[0] * fArray2[2], fArray[0] * fArray2[1] - fArray[1] * fArray2[0]};
        return fArray3;
    }

    static final float calcDot(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
    }

    static final double calcDot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    static final float[] calcSub(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[0] - fArray2[0], fArray[1] - fArray2[1], fArray[2] - fArray2[2]};
        return fArray3;
    }

    static final void calcCross(float[] fArray, float f, float f2, float f3, float f4, float f5, float f6) {
        fArray[0] = f2 * f6 - f3 * f5;
        fArray[1] = f3 * f4 - f * f6;
        fArray[2] = f * f5 - f2 * f4;
    }

    static final float calcDot(float f, float f2, float f3, float[] fArray) {
        return f * fArray[0] + f2 * fArray[1] + f3 * fArray[2];
    }
}

