/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.ITextureEffect;
import com.threed.jpct.Texture;
import java.io.Serializable;

public class WaterTextureEffect
implements ITextureEffect,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] buffer1;
    private int[] buffer2;
    private int width = 0;
    private int height = 0;
    private byte shifter = 0;
    private int ripples = 0;

    public WaterTextureEffect(int n) {
        this.ripples = n;
    }

    public void init(Texture texture) {
        this.buffer1 = new int[texture.getArraySize()];
        this.buffer2 = new int[texture.getArraySize()];
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        this.shifter = texture.shifter;
    }

    public void apply(int[] nArray, int[] nArray2) {
        int n;
        int n2 = (int)(Math.random() * (double)this.width * (double)this.height);
        this.buffer1[n2] = this.ripples;
        int n3 = this.height << this.shifter - this.width;
        for (n = this.width; n < n3; ++n) {
            n2 = (this.buffer1[n - 1] + this.buffer1[n + 1] + this.buffer1[n - this.width] + this.buffer1[n + this.width] >> 1) - this.buffer2[n];
            this.buffer2[n] = n2 - (n2 >> 5);
        }
        n = this.width * this.height;
        for (int i = this.width; i < n; ++i) {
            int n4 = this.buffer2[i - 1] - this.buffer2[i + 1];
            int n5 = this.buffer2[i - this.width] - this.buffer2[i + this.width];
            int n6 = i + n4 + (n5 << this.shifter);
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > n) {
                n6 = n;
            }
            nArray[i] = nArray2[n6];
        }
        int[] nArray3 = this.buffer1;
        this.buffer1 = this.buffer2;
        this.buffer2 = nArray3;
    }

    public boolean containsAlpha() {
        return false;
    }
}

