/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.threading;

import com.threed.jpct.Logger;
import com.threed.jpct.threading.WorkLoad;
import java.util.Hashtable;
import java.util.Vector;

public class Worker {
    private static int maxProcessorsUsed = -1;
    private Thread[] threads;
    private Vector[] queues;
    private Vector enqueued;
    private Hashtable types = new Hashtable();
    private Vector waitingFor = new Vector();
    private boolean stop = false;

    public Worker(int n) {
        if (n < 0) {
            n = 1;
        }
        this.threads = new Thread[n];
        this.queues = new Vector[n];
        this.enqueued = new Vector();
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                Thread thread = new Thread(new WorkerThread(i));
                thread.setDaemon(true);
                this.threads[i] = thread;
                this.queues[i] = new Vector();
                thread.start();
            }
        }
        Logger.log("Worker created using " + n + " queue" + (n > 1 ? "s" : "") + "!", 2);
    }

    public boolean isDone(WorkLoad workLoad) {
        if (this.scpu()) {
            return true;
        }
        return !this.enqueued.contains(workLoad);
    }

    public int getQueueCount() {
        return this.queues.length;
    }

    public void waitForAll() {
        if (this.scpu()) {
            return;
        }
        this.waitingFor.addElement(Thread.currentThread());
        int n = this.types.size();
        while (n > 0 && !this.stop) {
            try {
                if (!Thread.interrupted()) {
                    Thread.sleep(20L);
                }
                n = this.types.size();
            }
            catch (Exception exception) {
                n = this.types.size();
            }
        }
        this.waitingFor.removeElement(Thread.currentThread());
    }

    public void waitFor(Class clazz) {
        if (this.scpu()) {
            return;
        }
        this.waitingFor.addElement(Thread.currentThread());
        boolean bl = this.types.containsKey(clazz);
        while (bl && !this.stop) {
            try {
                if (!Thread.interrupted()) {
                    Thread.sleep(20L);
                }
                bl = this.types.containsKey(clazz);
            }
            catch (Exception exception) {
                bl = this.types.containsKey(clazz);
            }
        }
        this.waitingFor.removeElement(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WorkLoad workLoad, int n) {
        int n2 = n % this.queues.length;
        if (this.scpu() || this.threads[n2] == Thread.currentThread()) {
            try {
                workLoad.doWork();
            }
            catch (Exception exception) {
                workLoad.error(exception);
            }
            workLoad.done();
            return;
        }
        Vector[] vectorArray = this.queues;
        synchronized (this.queues) {
            this.enqueued.addElement(workLoad);
            this.addType(workLoad.getClass());
            this.queues[n2].addElement(workLoad);
            try {
                this.threads[n2].interrupt();
            }
            catch (Exception exception) {
                Logger.log("Unable to interrupt thread!", 1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WorkLoad workLoad) {
        if (this.scpu()) {
            try {
                workLoad.doWork();
            }
            catch (Exception exception) {
                workLoad.error(exception);
            }
            workLoad.done();
            return;
        }
        int n = 0;
        Vector[] vectorArray = this.queues;
        synchronized (this.queues) {
            this.enqueued.addElement(workLoad);
            this.addType(workLoad.getClass());
            int n2 = 99999999;
            for (int i = 0; i < this.queues.length; ++i) {
                Vector vector = this.queues[i];
                if (vector.size() >= n2) continue;
                n2 = vector.size();
                n = i;
                if (n2 == 0) break;
            }
            if (this.threads[n] == Thread.currentThread()) {
                this.enqueued.removeElement(workLoad);
                try {
                    workLoad.doWork();
                }
                catch (Exception exception) {
                    workLoad.error(exception);
                }
                workLoad.done();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            this.queues[n].addElement(workLoad);
            try {
                this.threads[n].interrupt();
            }
            catch (Exception exception) {
                Logger.log("Unable to interrupt thread!", 1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType(Class clazz) {
        Hashtable hashtable = this.types;
        synchronized (hashtable) {
            Integer n = (Integer)this.types.get(clazz);
            if (n == null) {
                this.types.put(clazz, new Integer(1));
            } else {
                n = new Integer(n + 1);
                this.types.put(clazz, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subType(Class clazz) {
        Hashtable hashtable = this.types;
        synchronized (hashtable) {
            Integer n = (Integer)this.types.get(clazz);
            if (n == null) {
                throw new RuntimeException("No entry found for class " + clazz.getName());
            }
            if ((n = new Integer(n - 1)) == 0) {
                Vector vector = this.waitingFor;
                synchronized (vector) {
                    this.types.remove(clazz);
                    for (int i = 0; i < this.waitingFor.size(); ++i) {
                        try {
                            ((Thread)this.waitingFor.elementAt(i)).interrupt();
                            continue;
                        }
                        catch (Exception exception) {
                            Logger.log("Unable to interrupt thread!", 1);
                        }
                    }
                }
            } else {
                this.types.put(clazz, n);
            }
        }
    }

    private boolean scpu() {
        return this.queues.length == 1;
    }

    public void dispose() {
        if (!this.stop) {
            int n;
            this.stop = true;
            for (n = 0; n < this.threads.length; ++n) {
                if (this.threads[n] == null) continue;
                try {
                    this.threads[n].interrupt();
                    continue;
                }
                catch (Exception exception) {
                    Logger.log("Unable to interrupt thread!", 1);
                }
            }
            n = 1;
            int n2 = 0;
            do {
                n = 1;
                for (int i = 0; i < this.threads.length; ++i) {
                    if (this.threads[i] == null) continue;
                    n &= !this.threads[i].isAlive() ? 1 : 0;
                }
                if (n != 0) continue;
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n == 0 && ++n2 <= 250);
        }
    }

    public void finalize() {
        this.dispose();
    }

    private class WorkerThread
    implements Runnable {
        private int num = -1;

        public WorkerThread(int n) {
            this.num = n;
            Thread.currentThread().setPriority(9);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Worker.this.stop) {
                Vector[] vectorArray;
                if (Worker.this.queues[this.num].size() != 0) {
                    WorkLoad workLoad = null;
                    vectorArray = Worker.this.queues;
                    synchronized (vectorArray) {
                        workLoad = (WorkLoad)Worker.this.queues[this.num].elementAt(0);
                        Worker.this.queues[this.num].removeElementAt(0);
                    }
                    try {
                        workLoad.doWork();
                    }
                    catch (Exception exception) {
                        workLoad.error(exception);
                    }
                    Worker.this.enqueued.removeElement(workLoad);
                    Worker.this.subType(workLoad.getClass());
                    workLoad.done();
                    continue;
                }
                try {
                    boolean bl = false;
                    vectorArray = Worker.this.queues;
                    synchronized (vectorArray) {
                        bl = !Thread.interrupted() && Worker.this.queues[this.num].size() == 0;
                    }
                    if (!bl) continue;
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
            Logger.log("Worker thread stopped!", 2);
        }
    }
}

