/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.Camera;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Interact2D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.awt.Color;

public class LensFlare {
    private Texture burst = null;
    private Texture halo1 = null;
    private Texture halo2 = null;
    private Texture halo3 = null;
    private SimpleVector sunPos = null;
    private Texture[] types = new Texture[7];
    private float[][] scales = new float[7][2];
    private float globalScale = 1.0f;
    private int trans = 1;
    private boolean cover = true;
    private float maxDistance = -1.0f;
    private boolean revertDirection = false;
    private boolean visible = false;
    private SimpleVector light2D = null;

    public LensFlare(SimpleVector simpleVector, String string, String string2, String string3, String string4) {
        TextureManager textureManager = TextureManager.getInstance();
        this.burst = textureManager.getTexture(string);
        this.halo1 = textureManager.getTexture(string2);
        this.halo2 = textureManager.getTexture(string3);
        this.halo3 = textureManager.getTexture(string4);
        this.sunPos = new SimpleVector(simpleVector);
        this.types[0] = this.burst;
        this.types[1] = this.halo1;
        this.types[2] = this.burst;
        this.types[3] = this.halo2;
        this.types[4] = this.burst;
        this.types[5] = this.halo3;
        this.types[6] = this.burst;
        this.scales[0][0] = 1.0f;
        this.scales[0][1] = 1.0f;
        this.scales[1][0] = 2.0f;
        this.scales[1][1] = 0.5f;
        this.scales[2][0] = 3.0f;
        this.scales[2][1] = 0.25f;
        this.scales[3][0] = 8.0f;
        this.scales[3][1] = 1.0f;
        this.scales[4][0] = -2.0f;
        this.scales[4][1] = 0.5f;
        this.scales[5][0] = -4.0f;
        this.scales[5][1] = 0.25f;
        this.scales[6][0] = -5.5f;
        this.scales[6][1] = 0.25f;
    }

    public void setTransparency(int n) {
        this.trans = n;
    }

    public void setLightPosition(SimpleVector simpleVector) {
        this.sunPos.set(simpleVector);
    }

    public void setGlobalScale(float f) {
        this.globalScale = f;
    }

    public void setHiding(boolean bl) {
        this.cover = bl;
    }

    public void setMaximumDistance(float f) {
        this.maxDistance = f;
    }

    public void setDirection(boolean bl) {
        this.revertDirection = bl;
    }

    public void update(FrameBuffer frameBuffer, World world) {
        Camera camera = world.getCamera();
        this.light2D = Interact2D.project3D2D(camera, frameBuffer, this.sunPos);
        this.visible = true;
        if (this.cover) {
            SimpleVector simpleVector = camera.getPosition();
            if (!this.revertDirection) {
                SimpleVector simpleVector2 = this.sunPos.calcSub(simpleVector);
                float f = simpleVector2.length();
                float f2 = world.calcMinDistance(simpleVector, simpleVector2.normalize(), this.maxDistance != -1.0f ? Math.min(this.maxDistance, f * 1.05f) : f * 1.05f);
                this.visible = f2 == 1.0E12f || f2 > f - 5.0f;
            } else {
                SimpleVector simpleVector3 = simpleVector.calcSub(this.sunPos);
                float f = simpleVector3.length();
                float f3 = world.calcMinDistance(this.sunPos, simpleVector3.normalize(), this.maxDistance != -1.0f ? Math.min(this.maxDistance, f * 1.05f) : f * 1.05f);
                this.visible = f3 == 1.0E12f || f3 > f - 5.0f;
            }
        }
    }

    public void render(FrameBuffer frameBuffer) {
        if (this.light2D != null && this.visible) {
            SimpleVector simpleVector = new SimpleVector(this.light2D);
            float f = frameBuffer.getMiddleX();
            float f2 = frameBuffer.getMiddleY();
            simpleVector.z = 0.0f;
            SimpleVector simpleVector2 = new SimpleVector(f, f2, 0.0f);
            SimpleVector simpleVector3 = simpleVector.calcSub(simpleVector2);
            float f3 = simpleVector3.length();
            simpleVector3 = simpleVector3.normalize();
            SimpleVector simpleVector4 = new SimpleVector();
            for (int i = 0; i < this.types.length; ++i) {
                simpleVector4.set(simpleVector3);
                Texture texture = this.types[i];
                float f4 = this.scales[i][0];
                float f5 = this.scales[i][1] * this.globalScale;
                simpleVector4.scalarMul(1.0f / f4 * f3);
                int n = texture.getWidth();
                int n2 = texture.getHeight();
                int n3 = (int)(simpleVector4.x - (float)(n >> 1) * f5);
                int n4 = (int)(simpleVector4.y - (float)(n2 >> 1) * f5);
                frameBuffer.blit(texture, 0, 0, n3 + (int)f, n4 + (int)f2, n, n2, (int)((float)n * f5), (int)((float)n2 * f5), this.trans, true, Color.WHITE);
            }
        }
    }
}

