uniform float t;
uniform float t_scene;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform vec3 lightpos;
uniform float lightradius;
uniform float falloff;

uniform mat4 matrix;

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 ppos, pnor;
smooth out vec3 lightdir;

void rY(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x + s * q.z;
	p.z = -s * q.x + c * q.z;
}

void main()
{
	//float syncdistort = 1.0;
	//vec3 lightpos = vec3(0.0, 0.0, 0.0);
	float distort = 0.0;
	float wavespeed = (t_scene-20.0)/32.0;
	float saw_distort = syncdistort * 1.8;	// beats with the kick drum
	
	float mayhem = 0.0;
	
	distort = 0.0;
		
	//distort += syncdistort * 0.4;	
		
	ppos = pos;
	vec3 newpos = pos;
	//rY(newpos, newpos.y * mayhem * 0.04);
	//newpos.y += sin(0.1f*newpos.x + 0.1f*newpos.y + 0.1f*newpos.z + t) * 3.0f;
	//newpos = pos * mix(1.0, saw, 0.1f);
	//float dist = sin(0.5f * length(pos) - t*wavespeed + saw*0.2*saw_distort) * distort + saw*0.4*saw_distort;
	//newpos.y += dist * distort;
	ppos = newpos;
	//pnor = -nor * mix(1.0, dist, distort);
	pnor = -nor;
	lightdir = lightpos - pos.xyz;
	gl_Position = matrix*vec4(newpos, 1.0);
}

#endif

#ifdef fragmentcompile

smooth in vec3 pnor, ppos, lightdir;
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	//float l = dot(normalize(pnor),normalize(vec3(1.0,1.0,.5)))*.5+.5;
	float ambient = 0.05;
	float l = dot(normalize(pnor),normalize(lightdir))*.5+.5;
	float specular = pow(dot(normalize(pnor*pnor),normalize(lightdir))*.5+.5, 3.0);
	float dist = distance(lightpos, ppos);
	vec4 mossen = texture2D(moss, ppos.xz*.1);
	vec4 ys = l*pnor.y*texture2D(tex, ppos.xz*.1);
	if(pnor.y<.0)
		ys = -l*pnor.y*mossen;
	outcol = l*abs(pnor.x)*texture2D(tex, ppos.yz*.1)+ys+l*abs(pnor.z)*texture2D(tex, ppos.xy*.1)+vec4(vec3(.0),1.0);
	outcol.rgb *= ambient + specular*0.1 +(lightradius/pow(dist, falloff));
}
#endif
