// mog
/*jslint devel: true, browser: true */
var Credits = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx,
        _greetings,
        RULE;

    function init(duration, model) {

        console.log("CHANGE_ME - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--
        _greetings = document.createElement('div');
        _greetings.setAttribute("class", "greetings");
        _holder.appendChild(_greetings);
        
        //yay scaling
        for (var i = 0; i < document.styleSheets[0].rules.length; i++) {
            RULE = document.styleSheets[0].rules[i];
            if (RULE.selectorText === '.greetings') {
                RULE.style.fontSize = (56 / 1920 * _width) + 'px';
                RULE.style.width = (1000 / 1920 * _width) + 'px';
                RULE.style.top = (200 / 1080 * _height) + 'px';
                RULE.style.left = (40 / 1920 * _width) + 'px';
                break;
            }
        }
    }
var _sceneTime;
    function render(sceneTime, floatBeat, frameDelta) {

        _ctx.fillStyle = "#296d92";
        _ctx.fillRect(0,0,_width,_height);

        if(sceneTime > 2000)
            _ctx.drawImage(Meat.den, 0, 0, _width, _height);

        if(sceneTime > 4000)
            _ctx.drawImage(Meat.mog, 0, 0, _width, _height);

        if(sceneTime > 7000)
            _ctx.drawImage(Meat.greetings, 0, 0, _width, _height);

        _sceneTime = sceneTime;

        if(sceneTime > 47000){
            _greetings.innerText = "";

            _ctx.drawImage(Meat.pew, 0, 0, _width, _height);
        }
        
        if(sceneTime > 54000){
            _greetings.innerText = "";

            _ctx.drawImage(Meat.meh, 0, 0, _width, _height);
        }
    }

    var list = ["PoPsY TeAm", "LNX", "dreamdealers","FRequency", "punkfloyd",'#modulez', 'alcatraz', 'dacapo',  'haujobb',
                'inque', 'kakiarts', 'moodsplateau', 'nuance', 'outracks', 'peisik', 'rbbs', 'gargaj',
                'ske', 'titan', 'ppl at main', 'ppl at outline', 'pouet', "next time I'll start coding earlier", "so I don't have to annoy you", "with stupid waiting times :3", 'anybody not in this array', 'mum'].reverse();

    var colors = ["#b08e76", "#daaa9d"];
    var pew = 0;
    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {


        if((_sceneTime > 9000) && (_sceneTime < 47000)) {

            if(minorBeat == 4 && list.length > 0){
                _greetings.innerHTML += ' <span style="color:' + colors[pew] + '">' + list.pop() +'</span>';

                if(pew == 0)
                    pew = 1;
                else
                    pew = 0;
            }
        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());