// mog
/*jslint devel: true, browser: true */
var Intro = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _letterArray = [],
        _letterHolder,
        _lastMajorBeat,
        RULE = {style:{}},
        _ctx = [],
        SPRITE_WIDTH = 64,
        SPRITE_HEIGHT = 64,
        SPRITE_FRAMES = 6 - 1,
        AMOUNT = 10,
        KEEP_ALIVE = 1,
        _p = [],
        _minorBeat,
        _majorBeat;


    function init(duration, model) {

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');

        for (var c = 0; c < 4; c++) {
            var canvas = document.createElement('canvas'),
                ctx = canvas.getContext('2d');

            canvas.width = _width;
            canvas.height = _height;

            canvas.style.cssText = 'position:absolute;z-index:' + _ctx.length + ';';
            _holder.appendChild(canvas);

            _ctx.push(ctx);
        }

        _letterHolder = document.createElement('div');
        _letterHolder.style.cssText = 'position:absolute;z-index:' + _ctx.length + ';';
        _holder.appendChild(_letterHolder);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--

        //yay scaling
        for (var i = 0; i < document.styleSheets[0].rules.length; i++) {
            RULE = document.styleSheets[0].rules[i];
            if (RULE.selectorText === '.letter') {
                RULE.style.width = (180 / 1920 * _width) + 'px';
                RULE.style.height = (165 / 1080 * _height) + 'px';
                break;
            }
        }
    }

    var offsetY = 0,
        offsetYMoon = 0;

    var _startTime,
        _lastFrame,
        _blinked = [];

    function starShenanigans(sceneTime, amount, blinkIndex) {

        var twinkleDuration = 750;

        KEEP_ALIVE = 0;

        if (_startTime == undefined) {
            AMOUNT = amount;
            _p = [];
            createParticles();
            _startTime = sceneTime;
        }

        var frame = Math.round(5 / twinkleDuration * (sceneTime - _startTime));

        if (frame <= 5) {

            if (_lastFrame != frame) {
                _lastFrame = frame;
                animateStars();
            } else {
                animateStars(false);
            }
        } else {
            _blinked[blinkIndex] = true;
            _lastFrame = undefined;
            _startTime = undefined;
        }
    }

    function render(sceneTime, floatBeat, frameDelta) {

        var startAt = 5000;

        if (sceneTime > startAt) {

            //city
            if (sceneTime <= startAt + 5000) {
                //offsetY = -(_height / 5000 * (sceneTime - startAt));
                offsetY = -Math.easeOutQuad(sceneTime - startAt, 0, _height, 5000);
            } else {
                offsetY = -_height;
            }

            //moon
            if (sceneTime <= startAt + 7000) {
                //offsetYMoon = -(_height / 6000 * (sceneTime - startAt));
                offsetYMoon = -Math.easeOutQuad(sceneTime - startAt, 0, _height, 7000);
            } else {
                offsetYMoon = -_height;
            }
        }

        //bg
        _ctx[0].fillStyle = '#296c95';
        _ctx[0].fillRect(0, 0, _width, _height);

        //--sterne
        if ((_majorBeat == 7 && _minorBeat >= 1) && (_blinked[0] !== true)) {
            starShenanigans(sceneTime, 5, 0);
        }

        if ((_majorBeat == 9 && _minorBeat >= 1) && (_blinked[1] !== true)) {
            starShenanigans(sceneTime, 6, 1);
        }

        if ((_majorBeat == 11 && _minorBeat >= 1) && (_blinked[2] !== true)) {
            starShenanigans(sceneTime, 7, 2);
        }

        if ((_majorBeat == 13 && _minorBeat >= 1) && (_blinked[3] !== true)) {
            starShenanigans(sceneTime, 8, 3);
        }
        if ((_majorBeat == 15 && _minorBeat >= 1) && (_blinked[4] !== true)) {
            starShenanigans(sceneTime, 9, 4);
        }

        if ((_majorBeat == 17 && _minorBeat >= 1) && (_blinked[5] !== true)) {
            starShenanigans(sceneTime, 10, 5);
        }

        if ((_majorBeat == 19 && _minorBeat >= 1) && (_blinked[6] !== true)) {
            starShenanigans(sceneTime, 11, 6);
        }
        //-----the quick and dirty way

        //moon
        _ctx[1].clearRect(0, 0, _width, _height);
        _ctx[1].drawImage(Meat.moon, 0, offsetYMoon, _width, _height * 2);

        //house
        _ctx[2].clearRect(0, 0, _width, _height);
        _ctx[2].drawImage(Meat.house, 0, offsetY, _width, _height * 2);

        //letters
        _ctx[_ctx.length - 1].clearRect(0, 0, _width, _height);
        for (var i = 0; i < _letterArray.length; i++) {
            _letterArray[i].render();
        }

        //blende
        _ctx[_ctx.length - 1].fillStyle = 'rgba(236,233,214,' + (1 - (1 / 1200 * sceneTime)) + ')'; //white
        _ctx[_ctx.length - 1].fillRect(0, 0, _width, _height);
    }

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {

        _majorBeat = majorBeat;
        _minorBeat = minorBeat;

        if ((majorBeat >= 21) && (_letterArray.length < 9) && (_lastMajorBeat != majorBeat)) {

            _lastMajorBeat = majorBeat;

            var introTextWidth = (1090 / 1920 * _width),
                letterElement = document.createElement('div');

            letterElement.setAttribute('class', 'letter l' + _letterArray.length);
            letterElement.width = parseInt(RULE.style.width, 10);

            _letterHolder.appendChild(letterElement);

            var verlet = new Verlet();
            verlet.setContext(_ctx[_ctx.length - 1]); //always nearest to the viewer
            verlet.setDiv(letterElement);

            verlet.init({color:'#c1d5d4',
                rows          :16,
                stickLength   :Math.round(20 / 1080 * _height),
                startX        :((_width - introTextWidth) / 2) + (_letterArray.length * introTextWidth / 8),
                startY        :-11});

            _letterArray.push(verlet);
        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;

        RULE.style.width = 180 / 1920 * _width + 'px';
        RULE.style.height = 165 / 1080 * _height + 'px';
    }

    function createParticles() {

        for (var i = 0; i < AMOUNT; i++) {

            _p.push({
                "i"   :(KEEP_ALIVE ? Math.floor(Random.float() * SPRITE_FRAMES) : 1),
                "dir" :1,
                "life":0,
                "x"   :Math.round(Random.float() * _width - 60) + 30,
                "y"   :Math.round(Random.float() * _height - 60) + 30
            });
        }
    }

    function animateStars(updateParticle) {

        for (var i = 0; i < _p.length; i++) {

            if (updateParticle !== false) {

                if ((_p[i].i >= SPRITE_FRAMES) || (_p[i].i == 0)) {
                    _p[i].dir *= -1;
                    _p[i].life++;

                    if ((_p[i].life >= 2) && KEEP_ALIVE) {

                        _p[i].x = Math.round(Random.float() * _width - 60) + 30;
                        _p[i].y = Math.round(Random.float() * _height - 60) + 30;
                        _p[i].life = 0;
                    }
                }

                _p[i].i += _p[i].dir;
            }

            drawStar(_p[i].x, _p[i].y, _p[i].i);
        }
    }

    function drawStar(x, y, index) {

        _ctx[0].drawImage(Meat.star, index *
            SPRITE_WIDTH, 0, SPRITE_WIDTH, SPRITE_HEIGHT, x, y, SPRITE_WIDTH, SPRITE_HEIGHT);
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());