
#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
}; 

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};

struct PSIn
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};
  
struct PSOut
{
	float4 c0 : SV_TARGET0;
};

Texture2D g_texture;

float4  g_XYWH = float4(0,0,1,1);

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float2 xy = IN.Pos.xy * 0.5f + 0.5f;
	xy = g_XYWH.xy + xy * g_XYWH.zw;
	xy = xy * 2.0f - 1.0f;

	OUT.Pos	= float4(xy.x, xy.y, 0, 1);
    OUT.Tex	= IN.Tex.xyxy;

	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(PSIn IN)
{
	PSOut OUT;

	float4 pixel = g_texture.Sample(SamplerPointClamp, IN.Tex.xy );
	OUT.c0 = pixel;
	// OUT.c0 = float4(1,0,0,1);
	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}
