#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut 
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};
 
struct PSIn
{
	float4 Pos			: SV_POSITION;
	float4 Tex			: TEXCOORD0;
};
  
struct PSOut
{
	float4 c0 : SV_TARGET0;
};

Texture2D g_texInput;
float4 g_Offsets[16];
float4 g_Weights[16];

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xyxy;

	return OUT;
}

//--------------------------------------------------------------------------------------
PSOut PS(PSIn IN)
{
	PSOut OUT;

	float4 rgba = 0;

    for( int i = 0; i < 15; i++ )
    {
        float2 uv = IN.Tex.xy + g_Offsets[i].xy;
        rgba += g_Weights[i] * g_texInput.Sample(SamplerLinearClamp, uv.xy);
    }
    
    OUT.c0 = rgba;
	return OUT;
}

//--------------------------------------------------------------------------------------
technique11 Blur
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}