
#include "Constant.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};

Texture2D	g_texInput;
float		Exposure;

//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------
Texture3D ColorGradingLookUp < string ResourceType = "3DLut"; >;

float3 doColorGrading(float3 rgb)
{
	rgb *= 15.0f / 16.0f;
	float texelOffset = 0.5f / 16.0f;
	rgb = ColorGradingLookUp.Sample(SamplerLinearClamp, rgb.xyz + texelOffset.xxx).rgb;
	return rgb;
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float3 rgb  = g_texInput.Sample(SamplerPointClamp, IN.Tex.xy ).rgb;
	rgb = doColorGrading(rgb);	
	return float4(rgb, 1);
}

//--------------------------------------------------------------------------------------
technique11 ColorGrading
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}