//--------------------------------------------------------------------------------------
SamplerState SamplerLinearWrap
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

SamplerState SamplerLinearClamp
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

SamplerState SamplerPointClamp
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

SamplerState SamplerPointWrap
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};

SamplerComparisonState SamplerShadow
{
   Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
   AddressU = Clamp;
   AddressV = Clamp;
   ComparisonFunc = LESS;
};


//--------------------------------------------------------------------------------------
DepthStencilState DisableDepth
{
	DepthEnable = false;
	DepthWriteMask = 0;
	StencilEnable = false;
};

DepthStencilState DisableDepthWrite
{
	DepthEnable = true;
	DepthWriteMask = 0;
	DepthFunc = Less_Equal;
	StencilEnable = false;
};

DepthStencilState EnableDepth
{
    DepthEnable = true;
    DepthWriteMask = 1;
	DepthFunc = Less_Equal;
	StencilEnable = false;
};

//--------------------------------------------------------------------------------------
RasterizerState CullNone
{
	FillMode = Solid;
    CullMode = NONE;
	ScissorEnable = TRUE;
};

RasterizerState CullFront
{
	FillMode = Solid;
    CullMode = Front;
	ScissorEnable = TRUE;
};

RasterizerState CullBack
{
	FillMode = Solid;
    CullMode = Back;
	ScissorEnable = TRUE;
};

RasterizerState Wireframe
{
	FillMode = WIREFRAME;
    CullMode = NONE;
	ScissorEnable = TRUE;
};

//--------------------------------------------------------------------------------------
BlendState AdditivBlending
{
	BlendEnable[0] = true;
	SrcBlend = One;
	DestBlend = One;
};

//--------------------------------------------------------------------------------------
BlendState AlphaBlending
{
	BlendEnable[0] = true;
	SrcBlend = Src_Alpha;
	DestBlend = Inv_Src_Alpha;
};

//--------------------------------------------------------------------------------------
BlendState DefaultBlending
{
	BlendEnable[0] = false;
};

//--------------------------------------------------------------------------------------
BlendState PreMultAlphaBlending
{
	BlendEnable[0] = true;
	SrcBlend = One;
	DestBlend = Inv_Src_Alpha;	
};