// 15.10.2010 Guillaume

#include "Constant.fx"
#include "ConstantBuffer.fx"
#include "HDR.fx"
#include "Deferred.fx"

//--------------------------------------------------------------------------------------
struct VSIn
{
	float4 Pos : POSITION;
};

struct VSOut
{
	float4 Pos : SV_POSITION;
	float4 Tex : TEXCOORD0;
};

float4 g_Center;
float4 g_Extends;
Texture3D g_VolumeXN;
Texture3D g_VolumeXP;
Texture3D g_VolumeYN;
Texture3D g_VolumeYP;
Texture3D g_VolumeZN;
Texture3D g_VolumeZP;

SamplerState SamplerVolume
{
    Filter		= MIN_MAG_MIP_LINEAR;
    AddressU	= Clamp;
    AddressV	= Clamp;
	AddressW	= Clamp;
};


//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	float3 Pos			= g_Center.xyz + IN.Pos.xyz * g_Extends.xyz * 2.0f;

	float4 WorldPos		= mul(float4(Pos,1), World);
	float4 ViewPos		= mul(WorldPos, View);
	float4 ProjPos		= mul(ViewPos, Proj);

	OUT.Pos	= ProjPos;
	OUT.Tex = ProjPos;

	return OUT;
}

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	float2 uv = IN.Tex.xy / IN.Tex.w;
	uv = uv * float2(0.5f,-0.5f) + 0.5f;
	
	GPixel g = FetchGBuffer(uv);

	float3 lowBound = g_Center.xyz - g_Extends.xyz;
	float3 volPos	= saturate( (g.WorldPos.xyz - lowBound.xyz) / (g_Extends.xyz * 2.0f) );


	float dotx		= dot(g.WorldNorm.xyz, float3(1,0,0));
	float doty		= dot(g.WorldNorm.xyz, float3(0,1,0));
	float dotz		= dot(g.WorldNorm.xyz, float3(0,0,1));

	float xn		= saturate( -dotx );
	float xp		= saturate( +dotx );
	float yn		= saturate( -doty );
	float yp		= saturate( +doty );
	float zn		= saturate( -dotz );
	float zp		= saturate( +dotz );

	float3 vol	= float3(0,0,0);

	vol	+= g_VolumeXN.Sample(SamplerVolume, volPos).xyz * xn;
	vol	+= g_VolumeXP.Sample(SamplerVolume, volPos).xyz * xp;
	vol	+= g_VolumeYN.Sample(SamplerVolume, volPos).xyz * yn;
	vol	+= g_VolumeYP.Sample(SamplerVolume, volPos).xyz * yp;
	vol	+= g_VolumeZN.Sample(SamplerVolume, volPos).xyz * zn;
	vol	+= g_VolumeZP.Sample(SamplerVolume, volPos).xyz * zp;

	return float4(vol,1);
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState(CullBack);
		SetBlendState( AdditivBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}



