#include "GBuffer.fx"

//--------------------------------------------------------------------------------------
Texture2D Diffuse		
<
	string UIName = "Diffuse";
	string Default = "DefaultWhite.png";	
>;
Texture2D Specular		
< 
	string UIName = "Specular";
	string Default = "DefaultWhite.png";	
>;

float SpecularLevel
<
	string UIName = "SpecularLevel";
	string Default = "1";
>;

Texture2D Normal		
< 
	string UIName = "Normal";
	string Default = "DefaultNormal.png"; 
>;

Texture2D SelfIllum		
< 
	string UIName = "SelfIllum";
	string Default = "DefaultBlack.png";	
>;

float Glossiness 
< 
	string UIName = "Glossiness";
	string Default = "64";
>;

//--------------------------------------------------------------------------------------
void PS(VSOut IN, inout GBufferOut OUT)
{
	float3 normalMap = normalize(Normal.Sample(SamplerLinearWrap, IN.Tex.xy).rgb * 2.0f - 1.0f);
	float3 worldNorm = TangentToWorld(normalMap, IN).rgb;
	float3 Kd = Diffuse.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
	float3 Ks = Specular.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
	float3 Ksi = SelfIllum.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;

	OUT.Diffuse		= Kd.rgb * float3(1,0,0);
	OUT.Specular	= Ks * SpecularLevel;
	OUT.SelfIllum	= Ksi;
	OUT.WorldNorm	= worldNorm;
	OUT.Glossiness  = Glossiness;
}

#include "GBufferTechnique.fx"