
#include "Constant.fx"
#include "ConstantBuffer.fx"
#include "HDR.fx"
#include "Deferred.fx"

struct VSIn
{
    float3 Pos		: POSITION;
    float2 Tex		: TEXCOORD;
};

struct VSOut
{
	float4 Pos			: SV_POSITION;
	float2 Tex			: TEXCOORD0;
};


//--------------------------------------------------------------------------------------
VSOut VS(VSIn IN)
{
	VSOut OUT;

	OUT.Pos	= float4(IN.Pos.xyz,1);
    OUT.Tex	= IN.Tex.xy;

	return OUT;
}

//--------------------------------------------------------------------------------------
float SSAODepthScale;
float SSAOAngleBias;
float SSAOIntensity;
float SSAORadius;
Texture2D	g_texInput;

//-----------------------------------------------------------------------------
float3 getPosition(float2 uv)
{
	GPixel gpixel = FetchGBuffer(uv.xy);
	return gpixel.WorldPos.xyz;
}

//-----------------------------------------------------------------------------
float doAmbientOcclusion(in float2 tcoord, in float2 uv, in float3 p, in float3 cnorm) 
{ 
	float ssaoScale		= SSAODepthScale;
	float ssaoBias		= SSAOAngleBias;
	float ssaoIntensity = SSAOIntensity;

	float3 diff = getPosition(tcoord + uv) - p; 
	const float3 v = normalize(diff); 
	const float d = length(diff)*ssaoScale; 
	return max(0.0,dot(cnorm,v)-ssaoBias)*(1.0/(1.0+d))*ssaoIntensity; 
} 

//--------------------------------------------------------------------------------------
float4 PS(VSOut IN) : SV_TARGET0
{
	GPixel gbuffer = FetchGBuffer(IN.Tex);

	float3 worldPos		= gbuffer.WorldPos.xyz;
	float3 worldNorm	= gbuffer.WorldNorm.xyz;

	float ao = 0.0f; 
	float rad = SSAORadius;
	const float2 ssaoOffsets[4] = { float2(1,0), float2(-1,0), float2(0,1), float2(0,-1) }; 

	int iterations = 4; 
	for (int j = 0; j < iterations; ++j) 
	{ 
		float2 coord1 = ssaoOffsets[j] * rad;
		float2 coord2 = float2(coord1.x*0.707 - coord1.y*0.707, coord1.x*0.707 + coord1.y*0.707); 
		ao += doAmbientOcclusion(IN.Tex.xy,coord1*0.25, worldPos, worldNorm); 
		ao += doAmbientOcclusion(IN.Tex.xy,coord2*0.5,	worldPos, worldNorm); 
		ao += doAmbientOcclusion(IN.Tex.xy,coord1*0.75, worldPos, worldNorm); 
		ao += doAmbientOcclusion(IN.Tex.xy,coord2,		worldPos, worldNorm); 
	}

	ao /=(float)iterations*4.0; 
	ao = (1.0f - ao);

	float3 rgb = g_texInput.Sample(SamplerPointClamp, IN.Tex.xy).rgb;

// 	float2 uv = IN.Tex.xy;
// 	float2 screenXY	= (uv * 2.0f - 1.0f) * float2(1.0f, -1.0f);
// 	float2 proj		= float2(1.0f/Proj[0].x, 1.0f/Proj[1].y);
// 
//  	float cameraFar				= CameraNearFar.y;
//  	float cameraNearFar			= CameraNearFar.z;
//  	float cameraFarMinusNear	= CameraNearFar.w;
//               
// 	float z = g_texDepthBuffer.Sample(SamplerPointClamp, uv).r;
//  	float viewSpaceZ = -(cameraNearFar / (z * cameraFarMinusNear - cameraFar));
// 	float3 viewDir	= float3(-screenXY * proj, 1.0f);
// 
// 	float3 eyeToPos = viewSpaceZ * viewDir;
//  	float4 viewPos = float4(EyePos.xyz + eyeToPos, 1.0f);
//
//	return float4( abs(viewSpaceZ.xxx)/1000.0f, 1 );

	return float4(ao.xxx * rgb, 1.0f);
}

//--------------------------------------------------------------------------------------
technique11 SSAO
{
    pass p0 
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );        
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
		SetRasterizerState( CullNone );
		SetBlendState( DefaultBlending, float4(0,0,0,0), 0x0ffffffff );
		SetDepthStencilState( DisableDepth, 0 );
    }
}