//--------------------------------------------------------------------------------------
#include "Datas/Shaders/Constant.fx"
  
//--------------------------------------------------------------------------------------
float4x4 g_worldViewProj;
float4x4 g_worldView;
float3 g_EyePos;
 
//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos		: POSITION;
    float3 Norm		: NORMAL;
    float3 Tan		: TANGENT;
    float3 Bin		: BINORMAL;
    float2 Tex		: TEXCOORD;
};

struct PS_INPUT
{
    float4 Pos : SV_POSITION;
	float Depth : TEXCOORD0;
};

//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output = (PS_INPUT)0;
	output.Pos = mul(input.Pos, g_worldViewProj);
	float3 viewPos = mul(input.Pos, g_worldView).xyz;
	output.Depth = length(viewPos);
    return output;
}

//--------------------------------------------------------------------------------------	
float4 PS(PS_INPUT IN) : SV_TARGET0
{
	return IN.Depth.xxxx;
}

//--------------------------------------------------------------------------------------
technique11 t0
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );		
        SetPixelShader( CompileShader( ps_4_0, PS() ) );		
		SetDepthStencilState(EnableDepth, 0);
		SetBlendState(DefaultBlending, float4(0,0,0,0), 0xffffffff);
		SetRasterizerState(CullFront);
    }
}
