#include "GBuffer.fx"

//--------------------------------------------------------------------------------------
Texture2D Diffuse		
<
	string UIName = "Diffuse";
	string Default = "DefaultWhite.png";	
	string TextureType = "2D";
>;

Texture2D Specular		
< 
	string UIName = "Specular";
	string Default = "DefaultWhite.png";	
>;

float SpecularLevel
<
	string UIName = "SpecularLevel";
	string Default = "1";
>;

Texture2D Normal		
< 
	string UIName = "Normal";
	string Default = "DefaultNormal.png"; 
>;

Texture2D SelfIllum		
< 
	string UIName = "SelfIllum";
	string Default = "DefaultBlack.png";	
>;

Texture2D Glossiness		
< 
	string UIName = "Glossiness";
	string Default = "DefaultWhite.png";	
>;

float GlossinessLevel 
< 
	string UIName = "GlossinessLevel";
	string Default = "128";
>;

float4 SpecularColor
<
	string UIName = "SpecularColor";
	string Default = "1;1;1;1";
>;

Texture2D Opacity		
< 
	string UIName = "Opacity";
	string Default = "DefaultWhite.png"; 
>;

Texture2D SSS
< 
	string UIName = "SSS";
	string Default = "DefaultBlack.png"; 
>;

float SSSLevel
<
	string UIName = "SSSLevel";
	string Default = "1";
>;

Texture2D Displacement
< 
	string UIName = "Displacement";
	string Default = "DefaultWhite.png"; 
>;

float DisplacementDistance
<
	string UIName = "DisplacementDistance";
	string Default = "16";
>;

TextureCube ReflectionCube
< 
	string UIName = "ReflectionCubemap";
	string Default = "blackcubemap.dds";
>;

Texture2D ReflectionMask
< 
	string UIName = "ReflectionMask";
	string Default = "DefaultWhite.png"; 
>;

float ReflectionLevel
<
	string UIName = "ReflectionLevel";
	string Default = "1";
>;

float FresnelPower
<
	string UIName = "FresnelPower";
	string Default = "4";
>;

float FresnelBias
<
	string UIName = "FresnelBias";
	string Default = "0";
>;


//--------------------------------------------------------------------------------------
void PS(VSOut IN, inout GBufferOut OUT)
{
 	float3 normalMap	= normalize(Normal.Sample(SamplerLinearWrap, IN.Tex.xy).rgb * 2.0f - 1.0f);
 	float3 worldNorm	= TangentToWorld(normalMap, IN).rgb;
	float3 worldPos		= IN.WorldPos.xyz;
 	float  Ksss			= SSS.Sample(SamplerLinearWrap, IN.Tex.zw).r;
 	float3 Kd			= Diffuse.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
 	float3 Ks			= Specular.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
 	float3 Ksi			= SelfIllum.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
 	float3 Kg			= Glossiness.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
 	float3 Ko			= Opacity.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;


	float3 eyeVec		= normalize(worldPos.xyz - EyePos.xyz); 
	float3 reflVec		= reflect(eyeVec, worldNorm);

	float eyeDot		= dot(-eyeVec,worldNorm);
	float fres			= pow(1.0f - saturate(eyeDot-FresnelBias), FresnelPower);

	float3 Krefl		= ReflectionCube.Sample(SamplerLinearWrap, reflVec.xzy).rgb * ReflectionLevel * fres;
	float3 KreflMask	= ReflectionMask.Sample(SamplerLinearWrap, IN.Tex.xy).rgb;
 
	OUT.Diffuse		= Kd.rgb;
 	OUT.Specular	= Ks * SpecularLevel * SpecularColor.rgb;
 	OUT.SelfIllum	= Ksi + Krefl * KreflMask;
 	OUT.WorldNorm	= worldNorm * 0.5 + 0.5;
 	OUT.Glossiness  = (Kg.r * GlossinessLevel.x) / 1024.f ; 
	OUT.Ksss		= Ksss * SSSLevel;

	clip(Ko.r - 0.5f);
}

#define DISPLACEMENT_ENABLE

#include "GBufferTechnique.fx"