// mog
/*jslint devel: true, browser: true */
var Arrival = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx,
        _textFieldHis,
        _textFieldHers,
        RULE;

    function init(duration, model) {

        console.log("CHANGE_ME - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--

        _holder.setAttribute('class', 'holderFor3D');

        _textFieldHis = document.createElement('textfield');
        _textFieldHis.setAttribute('class', 'phone hisPhone');
        _holder.appendChild(_textFieldHis);

        _textFieldHers = document.createElement('textfield');
        _textFieldHers.setAttribute('class', 'phone herPhone');
        _holder.appendChild(_textFieldHers);
        
        for (var i = 0; i < document.styleSheets[0].rules.length; i++) {
            RULE = document.styleSheets[0].rules[i];
            if (RULE.selectorText === '.hisPhone') {
                RULE.style.width = (320 / 1920 * _width) + 'px';
                RULE.style.height = (600 / 1080 * _height) + 'px';
                RULE.style.top = (310 / 1920 * _width) + 'px';
                RULE.style.left = (334 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.herPhone') {
                RULE.style.width = (320 / 1920 * _width) + 'px';
                RULE.style.height = (600 / 1080 * _height) + 'px';
                RULE.style.left = (1328 / 1920 * _width) + 'px';
                RULE.style.top = (280 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.phone') {
                RULE.style.fontSize = (36 / 1920 * _width) + 'px';
                
            }
        }
    }

    function render(sceneTime, floatBeat, frameDelta) {

        _ctx.drawImage(Meat.arrival, 0, 0, _width, _height);
    }

    var chatLog = [
        ["him", ""],
        ["him", "Hey :)"],
        ["him", "I just arrived"],
        ["her", "Same :)"],
        ["him", "Let's meat!"],
        ["her", "Yes!"],
        ["him", "How do I find you?"],
        ["her", "I'm <i>THAT</i> girl at the party :P"],
        ["him", "hehe"]
    ];

    var letterIndex = 0,
        line = '';
    var startBeat,
        nextBeat,
        logIndex = 0,
        offset,
        whoseLine;

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {
        if (majorBeat >= 0) {

            if ((logIndex < chatLog.length) && ((nextBeat == undefined) || (nextBeat == majorBeat))) {

                letterIndex = 0;

                var color = "#b65755";

                if (chatLog[logIndex][0] == "him") {
                    color = '#296d92';
                }

                if (chatLog[logIndex][1] != "") {
                    _textFieldHis.innerHTML += '<span style="color:' + color + ';">&lt;' + chatLog[logIndex][0] +
                        '&gt;</span> ' + chatLog[logIndex][1] + '<br>';
                    _textFieldHers.innerHTML += '<span style="color:' + color + ';">&lt;' + chatLog[logIndex][0] +
                        '&gt;</span> ' + chatLog[logIndex][1] + '<br>';
                }

                logIndex++;

                if (logIndex < chatLog.length) {

                    line = (chatLog[logIndex][1]).split('');
                    whoseLine = (chatLog[logIndex][0]);

                    /*
                    _inputHers.innerText = '';
                    _inputHis.innerText = '';
                    */
                    var len = chatLog[logIndex][1].length;
                    offset = 0;

                    if (len < 10) {
                        offset = 1;
                    }
                    else if (len < 15) {
                        offset = 2;
                    }
                    else {
                        offset = 1;
                    }

                    startBeat = integerBeat;
                    nextBeat = majorBeat + offset;
                } else {
                    line = '';
                    /*
                    _inputHers.innerText = '';
                    _inputHis.innerText = '';
                    */
                }
            }
        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());