// mog
/*jslint devel: true, browser: true */
var Chat = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _ctx,
        _textFieldHis,
        _inputHis,
        _textFieldHers,
        _inputHers,
        RULE;

    function init(duration, model) {

        console.log("Intro - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');

        var canvas = document.createElement('canvas');
        _ctx = canvas.getContext('2d');

        canvas.width = _width;
        canvas.height = _height;

        _holder.appendChild(canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--

        _holder.setAttribute('class', 'holderFor3D');

        _textFieldHis = document.createElement('textfield');
        _textFieldHis.setAttribute('class', 'chat his');
        _holder.appendChild(_textFieldHis);

        _inputHis = document.createElement('div');
        _inputHis.setAttribute('class', 'chat hisInput');
        _holder.appendChild(_inputHis);

        //---

        _textFieldHers = document.createElement('textfield');
        _textFieldHers.setAttribute('class', 'chat hers');
        _holder.appendChild(_textFieldHers);

        _inputHers = document.createElement('div');
        _inputHers.setAttribute('class', 'chat herInput');
        _holder.appendChild(_inputHers);
        
        //yay scaling
        for (var i = 0; i < document.styleSheets[0].rules.length; i++) {
            RULE = document.styleSheets[0].rules[i];
            if (RULE.selectorText === '.his') {
                RULE.style.width = (688 / 1920 * _width) + 'px';
                RULE.style.height = (640 / 1080 * _height) + 'px';
                RULE.style.top = (210 / 1920 * _width) + 'px';
                RULE.style.left = (84 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.hers') {
                RULE.style.width = (720 / 1920 * _width) + 'px';
                RULE.style.height = (660 / 1080 * _height) + 'px';
                RULE.style.left = (1150 / 1920 * _width) + 'px';
                RULE.style.top = (300 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.hisInput') {
                RULE.style.width = (730 / 1920 * _width) + 'px';
                RULE.style.height = (60 / 1080 * _height) + 'px';
                RULE.style.left = (64 / 1920 * _width) + 'px';
                RULE.style.top = (980 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.herInput') {
                RULE.style.width = (600 / 1920 * _width) + 'px';
                RULE.style.height = (80 / 1080 * _height) + 'px';
                RULE.style.left = (1150 / 1920 * _width) + 'px';
                RULE.style.top = (926 / 1080 * _height) + 'px';
            }
            
            if (RULE.selectorText === '.chat') {
                RULE.style.fontSize = (36 / 1920 * _width) + 'px';
            }
        }
        
        var overlay = document.createElement('div');
        overlay.style.backgroundImage = "url(" + Meat.over1.src +")";
        overlay.setAttribute('class', 'overlay');
        
        if(Demo.isOutlineVersion){
        	overlay.style.left = _width / 2 +'px';	
    		_inputHers.style.display = "none";
        	_textFieldHers.style.display = "none";
    	} else {
    		
        	_inputHis.style.display = "none";
        	_textFieldHis.style.display = "none";
    	}
        overlay.style.width = _width +'px';
        overlay.style.height = _height +'px';	
        _holder.appendChild(overlay);
    }

    var chatLog = [
        ["him", ""],
        ["him", "hi!"],
        ["her", "hey!!!, how are you??"],
        ["him", "fine, and you?"],
        ["her", "bit bored right now :("],
        ["him", "hmm, any plans for tmr?"],
        ["her", "yeah, going to the demoparty"],
        ["him", "OH! me too o_O"],
        ["her", "nice!!1 let's meat there!!'"],
        ["him", "first time we meet in RL"],
        ["him", "scaaaaaaaary :3"],
        ["her", "haha, same here"],
        ["her", "g2g packing"],
        ["her", "see you tmr :3 <3"],
        ["him", "bye =)"]
    ];

    var letterIndex = 0,
        line = '';

    function render(sceneTime, floatBeat, frameDelta) {

        _ctx.drawImage(Meat.chatScreen, 0, 0, _width, _height);

        if ((line != '') && nextBeat) {
            var currentTime = floatBeat - startBeat,
                index = Math.round(line.length / offset * currentTime);

            if (whoseLine == 'him') {
                _inputHis.innerText = (line.slice(0, index)).join('');
            } else {
                _inputHers.innerText = (line.slice(0, index)).join('');
            }
        }
    }

    var startBeat,
        nextBeat,
        logIndex = 0,
        offset,
        whoseLine;

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {
//42
        if (majorBeat >= 42) {

            if ((logIndex < chatLog.length) && ((nextBeat == undefined) || (nextBeat == majorBeat))) {

                letterIndex = 0;

                var color = "#b65755";

                if (chatLog[logIndex][0] == "him") {
                    color = '#296d92';
                }

                if (chatLog[logIndex][1] != "") {
                    _textFieldHis.innerHTML += '<span style="color:' + color + ';">&lt;' + chatLog[logIndex][0] +
                        '&gt;</span> ' + chatLog[logIndex][1] + '<br>';
                    _textFieldHers.innerHTML += '<span style="color:' + color + ';">&lt;' + chatLog[logIndex][0] +
                        '&gt;</span> ' + chatLog[logIndex][1] + '<br>';
                }

                logIndex++;

                if (logIndex < chatLog.length) {

                    line = (chatLog[logIndex][1]).split('');
                    whoseLine = (chatLog[logIndex][0]);

                    _inputHers.innerText = '';
                    _inputHis.innerText = '';

                    var len = chatLog[logIndex][1].length;
                    offset = 0;

                    if (len < 10) {
                        offset = 1;
                    }
                    else if (len < 15) {
                        offset = 2;
                    }
                    else {
                        offset = 3;
                    }

                    startBeat = integerBeat;
                    nextBeat = majorBeat + offset;
                } else {
                    line = '';
                    _inputHers.innerText = '';
                    _inputHis.innerText = '';
                }
            }
        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());